/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.quality.measurement.ccp0102;

import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.quality.QualityServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.FlightCategoryComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PreparationGroupComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.TimestampPeriodComplete;
import ch.icit.pegasus.server.core.dtos.quality.ccp0102.CCP0102MeasurementComplete;
import ch.icit.pegasus.server.core.dtos.quality.ccp0102.CCP0102MeasurementLight;
import ch.icit.pegasus.server.core.dtos.quality.ccp0102.CCP0102MeasurementReference;
import ch.icit.pegasus.server.core.dtos.quality.ccp0102.CCP0102MeasurementStateE;
import ch.icit.pegasus.server.core.dtos.system.QualitySettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.DateUtil;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;
import java.sql.Timestamp;

public class CCP0102MeasurementModuleDataHandler
extends DefaultDataHandler<CCP0102MeasurementLight, CCP0102MeasurementComplete> {
    public CCP0102MeasurementModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return "Check Files";
    }

    @Override
    public void updateData(final Node<CCP0102MeasurementLight> node, final RemoteLoader model, ProgressListener l) {
        final QualitySettingsComplete settings = (QualitySettingsComplete)NodeToolkit.getAffixClass(QualitySettingsComplete.class).getValue();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                if (Boolean.TRUE.equals(settings.getUseCCP02Generator())) {
                    return new Node();
                }
                node.commit(CCP0102MeasurementComplete.class);
                CCP0102MeasurementComplete d = (CCP0102MeasurementComplete)node.getValue(CCP0102MeasurementComplete.class);
                d = (CCP0102MeasurementComplete)((QualityServiceManager)ServiceManagerRegistry.getService(QualityServiceManager.class)).updateMeasurement(d).getValue();
                node.removeExistingValues();
                node.setValue((Object)d, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void createNewData(Node<CCP0102MeasurementComplete> node, RemoteLoader model, boolean sameNode, ProgressListener l) {
        Node<CCP0102MeasurementComplete> n = node;
        this.updateData((Node<CCP0102MeasurementLight>)n, model, l);
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                CCP0102MeasurementModuleDataHandler.this.setCurrentLoadMaximum(7);
                CCP0102MeasurementModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getAllLocationsCached();
                CCP0102MeasurementModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(InternalCostCenterComplete.class);
                CCP0102MeasurementModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(FlightCategoryComplete.class);
                CCP0102MeasurementModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(PreparationGroupComplete.class);
                CCP0102MeasurementModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllSuperRecipeCategoriesCached();
                CCP0102MeasurementModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllCCPMeasurementStates();
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getQualitySettingsCached();
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return CCP0102MeasurementModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<CCP0102MeasurementComplete> resetData(Node<CCP0102MeasurementComplete> node) {
        return this.createEmptyNode();
    }

    @Override
    public Node<CCP0102MeasurementComplete> createEmptyNode() {
        CCP0102MeasurementComplete measurement = new CCP0102MeasurementComplete();
        measurement.setCcpState(CCP0102MeasurementStateE.Planned);
        measurement.setProductionDate(new Date(System.currentTimeMillis()));
        Date tomorrow = (Date)DateUtil.addDays((java.util.Date)new Date(System.currentTimeMillis()), (int)1);
        measurement.setPeriod(new TimestampPeriodComplete(new Timestamp(tomorrow.getTime()), new Timestamp(tomorrow.getTime())));
        measurement.setClientOId(Long.valueOf(ADTO.getNextId()));
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)measurement, false, false);
        INodeCreator.getDefaultImpl().initUpdate(n);
        return n;
    }

    @Override
    public Class<CCP0102MeasurementComplete> getCommittingClass() {
        return CCP0102MeasurementComplete.class;
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener progressListener) {
        this.showMessage(progressListener, Words.REFRESH_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                CCP0102MeasurementLight ccp = (CCP0102MeasurementLight)node.getValue(CCP0102MeasurementLight.class);
                CCP0102MeasurementComplete ccpComplete = (CCP0102MeasurementComplete)((QualityServiceManager)ServiceManagerRegistry.getService(QualityServiceManager.class)).getComplete(new CCP0102MeasurementReference(ccp.getId())).getValue();
                node.removeExistingValues();
                node.setValue((Object)ccpComplete, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public void doRemoteValidation(Node<CCP0102MeasurementLight> node, final RemoteLoader listener, ProgressListener l, boolean validateAll) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }
}

