/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.requisitionorder.manualcreator.details.utils;

import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.multiselection.MultiLocationComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderComplete;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderComplete_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemViewSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.sql.Time;
import java.util.List;

public class OrderConfigPopup
extends PopUpInsert {
    private static final long serialVersionUID = 1L;
    private TitledItem<ComboBox> orderDepartment;
    private TitledItem<DateChooser> deliveryDate;
    private TitledItem<TextField> deliveryTime;
    private TitledItem<MultiLocationComboBox> location;
    private SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
    private SystemViewSettingsComplete viewSettings = (SystemViewSettingsComplete)NodeToolkit.getAffixClass(SystemViewSettingsComplete.class).getValue();

    public OrderConfigPopup(Node<RequisitionOrderComplete> node) {
        java.util.Date d;
        if (node.getChildNamed(RequisitionOrderComplete_.requiredOn).getValue() == null) {
            d = new Date(System.currentTimeMillis() + 86400000L);
            node.getChildNamed(RequisitionOrderComplete_.requiredOn).setValue((Object)d, 0L);
        }
        if (node.getChildNamed(RequisitionOrderComplete_.requiredTime).getValue() == null) {
            d = new Time(System.currentTimeMillis());
            node.getChildNamed(RequisitionOrderComplete_.requiredTime).setValue((Object)d, 0L);
        }
        this.orderDepartment = new TitledItem<ComboBox>(new ComboBox(node.getChildNamed(RequisitionOrderComplete_.requiredBy), NodeToolkit.getAffixList(InternalCostCenterComplete.class), ConverterRegistry.getConverter(CostCenterConverter.class)), Words.REQUIRED_BY_DEPARTMENT, TitledItem.TitledItemOrientation.NORTH);
        this.deliveryDate = new TitledItem<DateChooser>(new DateChooser(node.getChildNamed(RequisitionOrderComplete_.requiredOn), true), Words.DELIVERY_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.deliveryTime = new TitledItem<TextField>(new TextField(node.getChildNamed(RequisitionOrderComplete_.requiredTime), TextFieldType.DAYTIME), Words.TIME, TitledItem.TitledItemOrientation.NORTH);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.location = new TitledItem<MultiLocationComboBox>(new MultiLocationComboBox(node.getChildNamed(RequisitionOrderComplete_.eligibleLocations), true), Words.LOCATION, TitledItem.TitledItemOrientation.NORTH);
        }
        this.setLayout(new Layout());
        this.add(this.deliveryDate);
        this.add(this.orderDepartment);
        this.add(this.deliveryDate);
        this.add(this.deliveryTime);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.add(this.location);
        }
    }

    @Override
    public boolean tryToGrabFocus() {
        return true;
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> a = this.deliveryDate.getFocusComponents();
        CheckedListAdder.addToList(a, this.orderDepartment);
        CheckedListAdder.addToList(a, this.deliveryDate);
        CheckedListAdder.addToList(a, this.deliveryTime);
        CheckedListAdder.addToList(a, this.location);
        return a;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            return null;
        }
        return new Object[1];
    }

    @Override
    public boolean isInnerComponent(Component c) {
        if (this.orderDepartment.getElement().getCurrentPopUp() != null) {
            for (Component currentC = c; currentC != null; currentC = currentC.getParent()) {
                if (!currentC.equals(this.orderDepartment.getElement().getCurrentPopUp())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.deliveryDate.kill();
        this.deliveryTime.kill();
        this.orderDepartment.kill();
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.location.kill();
        }
        this.deliveryDate = null;
        this.deliveryTime = null;
        this.orderDepartment = null;
        this.location = null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int border = 10;
            int h = 0;
            int w = 0;
            w += border;
            w = (int)((double)w + OrderConfigPopup.this.deliveryDate.getPreferredSize().getWidth());
            w += border;
            w = (int)((double)w + OrderConfigPopup.this.deliveryTime.getPreferredSize().getWidth());
            w += border;
            h += border;
            h = (int)((double)h + OrderConfigPopup.this.orderDepartment.getPreferredSize().getHeight());
            h += border;
            h = (int)((double)h + OrderConfigPopup.this.deliveryDate.getPreferredSize().getHeight());
            h += border;
            if (Boolean.TRUE.equals(OrderConfigPopup.this.viewSettings.getShowLocation())) {
                h = (int)((double)h + OrderConfigPopup.this.location.getPreferredSize().getHeight());
                h += border;
            }
            return new Dimension(w, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            OrderConfigPopup.this.orderDepartment.setLocation(border, border);
            OrderConfigPopup.this.orderDepartment.setSize(parent.getWidth() - 2 * border, (int)OrderConfigPopup.this.orderDepartment.getPreferredSize().getHeight());
            OrderConfigPopup.this.deliveryDate.setLocation(border, OrderConfigPopup.this.orderDepartment.getY() + OrderConfigPopup.this.orderDepartment.getHeight() + border);
            OrderConfigPopup.this.deliveryDate.setSize(OrderConfigPopup.this.deliveryDate.getPreferredSize());
            OrderConfigPopup.this.deliveryTime.setLocation(OrderConfigPopup.this.deliveryDate.getX() + OrderConfigPopup.this.deliveryDate.getWidth() + border, OrderConfigPopup.this.deliveryDate.getY());
            OrderConfigPopup.this.deliveryTime.setSize(OrderConfigPopup.this.deliveryTime.getPreferredSize());
            if (Boolean.TRUE.equals(OrderConfigPopup.this.viewSettings.getShowLocation())) {
                OrderConfigPopup.this.location.setLocation(border, OrderConfigPopup.this.deliveryDate.getY() + OrderConfigPopup.this.deliveryDate.getHeight() + border);
                OrderConfigPopup.this.location.setSize(100, (int)OrderConfigPopup.this.location.getPreferredSize().getWidth());
            }
        }
    }
}

