/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.retail.details;

import ch.icit.pegasus.client.converter.FlightCategoryConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.flight.details.utils.FlightProviderRule;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.commiter.RemoteCommitter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.LocationUtil;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ILocalizedDTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.masterdata.FlightCategoryComplete;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class NewRetailDetailsPanel
extends DefaultDetailsPanel<FlightLight>
implements NodeListener {
    private static final long serialVersionUID = 1L;
    private final boolean isSolarCompany = Boolean.TRUE.equals(((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getCompany().getSolarCompanyType());
    private TitledItem<SearchTextField2> customer;
    private HorizontalSeparator horizontalSeparator;
    private TitledItem<TextField> name;
    private TitledItem<RDComboBox> category;
    private boolean autoName = false;

    public NewRetailDetailsPanel(RowEditor<FlightLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.FLIGHT_DATA);
        this.setCustomLayouter(new Layout());
        this.customer = new TitledItem<SearchTextField2<CustomerLight>>(SearchTextField2Factory.getCustomerSearchField(true, null), WordsToolkit.toCapitalLetter((String)Words.CUSTOMER), TitledItem.TitledItemOrientation.NORTH);
        this.horizontalSeparator = new HorizontalSeparator();
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        this.autoName = settings.getRetailAutoName();
        if (!this.autoName) {
            this.name = new TitledItem<TextField>(new TextField(), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
        }
        if (!this.isSolarCompany) {
            this.category = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(FlightCategoryConverter.class), true), Words.CATEGORY, TitledItem.TitledItemOrientation.NORTH);
            this.addToView(this.category);
        }
        Node n2 = new Node();
        n2.setValue((Object)new Date(System.currentTimeMillis()), 0L);
        this.addToView(this.horizontalSeparator);
        this.addToView(this.customer);
        if (!this.autoName) {
            this.addToView(this.name);
        }
    }

    @Override
    public void setNode(Node<?> node) {
        Node fsNode;
        super.setNode(node);
        if (this.editor.getModel().isAddRow()) {
            FlightComplete dto = (FlightComplete)node.getValue();
            LocationUtil.ensureCurrentLocation((ILocalizedDTO)dto);
        }
        if (this.provider.getAdditionalRule() == null) {
            this.provider.setAdditionalRule(new FlightProviderRule((FlightComplete)node.getValue(FlightComplete.class)));
        }
        if ((fsNode = node.getChildNamed(DtoFieldConstants.NEW_FS)) == null) {
            fsNode = new DTOProxyNode();
            fsNode.setName(DtoFieldConstants.NEW_FS);
            node.addChild(fsNode, 0L);
        }
        if (!this.autoName) {
            this.name.getElement().setNode(node.getChildNamed(FlightLight_.outboundCode));
        }
        if (!this.isSolarCompany) {
            this.category.getElement().refreshPossibleValues(NodeToolkit.getAffixList(FlightCategoryComplete.class));
            this.category.getElement().setNode(node.getChildNamed(FlightLight_.category));
        }
        node.getChildNamed(FlightLight_.outboundCode).addNodeListener((NodeListener)this);
        Node staN = node.getChildNamed(FlightLight_.sta);
        Node stdN = node.getChildNamed(FlightLight_.std);
        Timestamp sta = (Timestamp)staN.getValue();
        Timestamp std = (Timestamp)stdN.getValue();
        if (sta == null) {
            staN.setValue((Object)new Timestamp(System.currentTimeMillis()), 0L);
            sta = (Timestamp)staN.getValue();
        }
        if (std == null) {
            stdN.setValue((Object)new Timestamp(System.currentTimeMillis()), 0L);
            std = (Timestamp)stdN.getValue();
        }
        node.getChildNamed(FlightLight_.std).addNodeListener((NodeListener)this);
        this.customer.getElement().setNode(node.getChildNamed(FlightLight_.customer));
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.customer.setEnabled(isEnabled);
        this.horizontalSeparator.setEnabled(isEnabled);
        if (!this.autoName) {
            this.name.setEnabled(isEnabled);
        }
        if (!this.isSolarCompany) {
            this.category.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.editor.getModel().getNode() != null) {
            Node currentNode = this.editor.getModel().getNode().getChildNamed(FlightLight_.outboundCode);
            if (currentNode != null) {
                currentNode.removeNodeListener((NodeListener)this);
            }
            if ((currentNode = this.editor.getModel().getNode().getChildNamed(FlightLight_.std)) != null) {
                currentNode.removeNodeListener((NodeListener)this);
            }
        }
        this.customer.kill();
        this.horizontalSeparator.kill();
        if (!this.autoName) {
            this.name.kill();
        }
        if (!this.isSolarCompany) {
            this.category.kill();
        }
        this.customer = null;
        this.horizontalSeparator = null;
        this.name = null;
        this.category = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.customer);
        CheckedListAdder.addToList(focusList, this.name);
        CheckedListAdder.addToList(focusList, this.category);
        return focusList;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.customer.requestFocusInWindowNow();
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.editor.getModel().getNode().getChildNamed(FlightComplete_.customer).getValue() == null) {
            this.customer.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_CUSTOMER));
        }
        if (this.editor.getModel().getNode().getChildNamed(FlightComplete_.std).getValue() == null) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_STD));
        }
        if (!this.autoName) {
            if (this.editor.getModel().getNode().getChildNamed(FlightComplete_.outboundCode).getValue() == null) {
                this.name.getElement().setInvalid();
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_OUTBOUND_CODE));
            } else if (this.editor.getModel().getNode().getChildNamed(FlightComplete_.outboundCode).getValue().equals("")) {
                this.name.getElement().setInvalid();
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_OUTBOUND_CODE));
            }
        }
        return validationObjects;
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public List<RemoteCommitter> commitParagraph() {
        return super.commitParagraph();
    }

    public void valueChanged(Node<?> node) {
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public boolean isSwingOnly() {
        return true;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = NewRetailDetailsPanel.this.verticalBorder;
            h = (int)((double)h + NewRetailDetailsPanel.this.customer.getPreferredSize().getHeight());
            h += NewRetailDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + NewRetailDetailsPanel.this.horizontalSeparator.getPreferredSize().getHeight());
            h += NewRetailDetailsPanel.this.inner_verticalBorder;
            if (!NewRetailDetailsPanel.this.autoName) {
                h = (int)((double)h + NewRetailDetailsPanel.this.name.getPreferredSize().getHeight());
            } else if (!NewRetailDetailsPanel.this.isSolarCompany) {
                h = (int)((double)h + NewRetailDetailsPanel.this.category.getPreferredSize().getHeight());
            }
            h += NewRetailDetailsPanel.this.inner_verticalBorder;
            return new Dimension(300, h += NewRetailDetailsPanel.this.verticalBorder);
        }

        @Override
        public void layoutContainer(Container parent) {
            int ww = (parent.getWidth() - (2 * NewRetailDetailsPanel.this.horizontalBorder + NewRetailDetailsPanel.this.inner_horizontalBorder)) / 2;
            NewRetailDetailsPanel.this.customer.setLocation(NewRetailDetailsPanel.this.horizontalBorder, NewRetailDetailsPanel.this.verticalBorder);
            NewRetailDetailsPanel.this.customer.setSize(parent.getWidth() - 2 * NewRetailDetailsPanel.this.horizontalBorder, (int)NewRetailDetailsPanel.this.customer.getPreferredSize().getHeight());
            NewRetailDetailsPanel.this.horizontalSeparator.setLocation(0, NewRetailDetailsPanel.this.customer.getY() + NewRetailDetailsPanel.this.customer.getHeight() + NewRetailDetailsPanel.this.verticalBorder);
            NewRetailDetailsPanel.this.horizontalSeparator.setSize(parent.getWidth(), (int)NewRetailDetailsPanel.this.horizontalSeparator.getPreferredSize().getHeight());
            if (!NewRetailDetailsPanel.this.autoName) {
                NewRetailDetailsPanel.this.name.setLocation(NewRetailDetailsPanel.this.horizontalBorder, NewRetailDetailsPanel.this.horizontalSeparator.getY() + NewRetailDetailsPanel.this.horizontalSeparator.getHeight() + NewRetailDetailsPanel.this.inner_verticalBorder);
                NewRetailDetailsPanel.this.name.setSize((parent.getWidth() - 3 * NewRetailDetailsPanel.this.horizontalBorder) / 2, (int)NewRetailDetailsPanel.this.name.getPreferredSize().getHeight());
                if (!NewRetailDetailsPanel.this.isSolarCompany) {
                    NewRetailDetailsPanel.this.category.setLocation(NewRetailDetailsPanel.this.name.getX() + NewRetailDetailsPanel.this.name.getWidth() + NewRetailDetailsPanel.this.horizontalBorder, NewRetailDetailsPanel.this.horizontalSeparator.getY() + NewRetailDetailsPanel.this.horizontalSeparator.getHeight() + NewRetailDetailsPanel.this.inner_verticalBorder);
                    NewRetailDetailsPanel.this.category.setSize((parent.getWidth() - 3 * NewRetailDetailsPanel.this.horizontalBorder) / 2, (int)NewRetailDetailsPanel.this.category.getPreferredSize().getHeight());
                }
            } else if (!NewRetailDetailsPanel.this.isSolarCompany) {
                NewRetailDetailsPanel.this.category.setLocation(NewRetailDetailsPanel.this.horizontalBorder, NewRetailDetailsPanel.this.horizontalSeparator.getY() + NewRetailDetailsPanel.this.horizontalSeparator.getHeight() + NewRetailDetailsPanel.this.inner_verticalBorder);
                NewRetailDetailsPanel.this.category.setSize((parent.getWidth() - 3 * NewRetailDetailsPanel.this.horizontalBorder) / 2, (int)NewRetailDetailsPanel.this.category.getPreferredSize().getHeight());
            }
        }
    }
}

