/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.serviceproduct;

import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.CalendarUtil;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.product.TaxRateComplete;
import ch.icit.pegasus.server.core.dtos.serviceproduct.ServiceProductComplete;
import ch.icit.pegasus.server.core.dtos.serviceproduct.ServiceProductComplete_;
import ch.icit.pegasus.server.core.dtos.serviceproduct.ServiceProductReference;
import ch.icit.pegasus.server.core.dtos.serviceproduct.ServiceProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.serviceproduct.ServiceProductVariantReference;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;
import java.util.ArrayList;

public class ServiceProductModuleDataHandler
extends DefaultDataHandler<ServiceProductReference, ServiceProductComplete> {
    public ServiceProductModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener pListener) {
        this.showMessage(pListener, "Refresh Service Product");
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ServiceProductComplete pc = (ServiceProductComplete)node.getValue(ServiceProductComplete.class);
                ServiceProductComplete npc = (ServiceProductComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getServiceProduct(new ServiceProductReference(pc.getId())).getValue();
                node.removeExistingValues();
                node.setValue((Object)npc, 0L);
                node.updateNode();
                ArrayList<ServiceProductVariantComplete> nv = new ArrayList<ServiceProductVariantComplete>();
                for (ServiceProductVariantReference ov : npc.getVariants()) {
                    ServiceProductVariantComplete cv = (ServiceProductVariantComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getServiceProductVariant(new ServiceProductVariantReference(ov.getId())).getValue();
                    nv.add(cv);
                }
                node.getChildNamed(ServiceProductComplete_.variants).removeExistingValues();
                node.getChildNamed(ServiceProductComplete_.variants).setValue(nv, 0L);
                node.getChildNamed(ServiceProductComplete_.variants).updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public void updateData(final Node<ServiceProductReference> node, final RemoteLoader model, final ProgressListener list) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ServiceProductModuleDataHandler.this.showMessage(list, Words.SAVE_DATA);
                Node n = node;
                node.commit(ServiceProductComplete.class);
                Object pp = node.getValue(ServiceProductComplete.class);
                ServiceProductComplete dto = (ServiceProductComplete)pp;
                ServiceProductComplete newDTO = (ServiceProductComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).updateServiceProduct(dto).getValue();
                n.getChildNamed(ServiceProductComplete_.variants).removeAllChilds();
                n.removeExistingValues();
                n.setValue((Object)newDTO, 0L);
                n.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void createNewData(final Node<ServiceProductComplete> node, final RemoteLoader model, boolean sameNode, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node n = node;
                n.getChildNamed(ServiceProductComplete_.currentVariant).commit(ServiceProductVariantComplete.class, true);
                ServiceProductComplete dto = (ServiceProductComplete)n.getValue(ServiceProductComplete.class);
                ServiceProductVariantComplete variant = (ServiceProductVariantComplete)n.getChildNamed(ServiceProductComplete_.currentVariant).getValue(ServiceProductVariantComplete.class);
                if (!dto.getVariants().contains(variant)) {
                    dto.getVariants().add(variant);
                }
                if (dto.getVariants().size() == 1) {
                    variant.getValidityPeriod().setStartDate(new Date(dto.getPeriod().getStartDate().getTime()));
                    variant.getValidityPeriod().setEndDate(new Date(dto.getPeriod().getEndDate().getTime()));
                } else {
                    dto.getVariants().clear();
                    dto.getVariants().add(variant);
                    variant.getValidityPeriod().setStartDate(new Date(dto.getPeriod().getStartDate().getTime()));
                    variant.getValidityPeriod().setEndDate(new Date(dto.getPeriod().getEndDate().getTime()));
                }
                if (dto.getEligibleLocations().isEmpty()) {
                    dto.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                }
                ServiceProductComplete newDTO = (ServiceProductComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).createServiceProduct(dto).getValue();
                n.getChildNamed(ServiceProductComplete_.variants).removeAllChilds();
                n.removeExistingValues();
                n.setValue((Object)newDTO, 0L);
                n.removeAllChilds();
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<ServiceProductComplete> createEmptyNode() {
        ServiceProductComplete p = new ServiceProductComplete();
        p.setClientOId(Long.valueOf(ADTO.getNextId()));
        p.setPeriod(new PeriodComplete(CalendarUtil.getDefaultStartDate((boolean)true), CalendarUtil.getInfinityDate()));
        PriceComplete pr = new PriceComplete();
        pr.setPrice(Double.valueOf(0.0));
        Node n = NodeToolkit.getAffixClass(SystemSettingsComplete.class);
        if (n != null) {
            SystemSettingsComplete s = (SystemSettingsComplete)n.getValue();
            pr.setCurrency(s.getCurrency());
        }
        ServiceProductVariantComplete v = new ServiceProductVariantComplete();
        v.setClientOId(Long.valueOf(ADTO.getNextId()));
        v.setSalesPrice(pr);
        v.setState(ModificationStateE.DRAFT);
        v.setValidityPeriod(new PeriodComplete(CalendarUtil.getDefaultStartDate((boolean)true), CalendarUtil.getInfinityDate()));
        v.setServiceProduct(p);
        p.setCurrentVariant(v);
        p.getVariants().add(v);
        Node nn = INodeCreator.getDefaultImpl().getNode4DTO((Object)p, false, false);
        return nn;
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public long getID() {
                return id;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ServiceProductModuleDataHandler.this.model;
            }

            @Override
            public Node<?> loadData() throws Exception {
                ServiceProductModuleDataHandler.this.setCurrentLoadMaximum(5);
                ServiceProductModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                ServiceProductModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(TaxRateComplete.class);
                ServiceProductModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllModificationStates();
                ServiceProductModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CurrencyComplete.class);
                ServiceProductModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getAllLocationsCached();
                return new Node();
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<ServiceProductComplete> resetData(Node<ServiceProductComplete> node) {
        ServiceProductComplete p = new ServiceProductComplete();
        p.setClientOId(Long.valueOf(ADTO.getNextId()));
        p.setPeriod(new PeriodComplete(CalendarUtil.getDefaultStartDate((boolean)true), CalendarUtil.getInfinityDate()));
        node.setValue((Object)p, System.currentTimeMillis());
        node.updateNode();
        return node;
    }

    @Override
    public Class<ServiceProductComplete> getCommittingClass() {
        return ServiceProductComplete.class;
    }

    @Override
    public void doRemoteValidation(Node<ServiceProductReference> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

