/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.weeklyplan;

import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.services.interfaces.weeklyplan.WeeklyPlanServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanComplete;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanLight;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanReference;
import ch.icit.pegasus.server.core.dtos.system.LocationComplete;
import ch.icit.pegasus.server.core.dtos.utils.DateUtil;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;

public class WeeklyPlanModuleDataHandler
extends DefaultDataHandler<WeeklyPlanLight, WeeklyPlanComplete> {
    public WeeklyPlanModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return Words.CHECK_CUSTOMER_CODE;
    }

    @Override
    public void updateData(final Node<WeeklyPlanLight> node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                node.commit();
                WeeklyPlanComplete oldDTO = (WeeklyPlanComplete)node.getValue();
                WeeklyPlanComplete dto = (WeeklyPlanComplete)((WeeklyPlanServiceManager)ServiceManagerRegistry.getService(WeeklyPlanServiceManager.class)).updateWeeklyPlan(oldDTO).getValue();
                node.removeExistingValues();
                node.setValue((Object)dto, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void createNewData(final Node<WeeklyPlanComplete> node, final RemoteLoader model, boolean sameNode, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                node.commit();
                WeeklyPlanComplete oldDTO = (WeeklyPlanComplete)node.getValue();
                if (oldDTO.getEligibleLocations().isEmpty()) {
                    oldDTO.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                }
                WeeklyPlanComplete dto = (WeeklyPlanComplete)((WeeklyPlanServiceManager)ServiceManagerRegistry.getService(WeeklyPlanServiceManager.class)).createWeeklyPlan(oldDTO).getValue();
                node.removeExistingValues();
                node.setValue((Object)dto, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                WeeklyPlanModuleDataHandler.this.setCurrentLoadMaximum(4);
                WeeklyPlanModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getAllLocationsCached();
                WeeklyPlanModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCustomersCached();
                WeeklyPlanModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(InternalCostCenterComplete.class);
                WeeklyPlanModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getWeeklyPlanSettingsCached();
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return WeeklyPlanModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<WeeklyPlanComplete> resetData(Node<WeeklyPlanComplete> node) {
        return this.createEmptyNode();
    }

    @Override
    public Node<WeeklyPlanComplete> createEmptyNode() {
        WeeklyPlanComplete newOne = new WeeklyPlanComplete();
        newOne.setClientOId(Long.valueOf(ADTO.getNextId()));
        newOne.setName("");
        newOne.setDescription("");
        Date date = new Date(System.currentTimeMillis());
        date = (Date)DateUtil.addDays((java.util.Date)date, (int)1);
        while (DateUtil.getDayOfWeek((java.util.Date)date) != 1) {
            date = (Date)DateUtil.addDays((java.util.Date)date, (int)1);
        }
        Date startDate = new Date(date.getTime());
        while (DateUtil.getDayOfWeek((java.util.Date)date) != 7) {
            date = (Date)DateUtil.addDays((java.util.Date)date, (int)1);
        }
        Date endDate = new Date(date.getTime());
        newOne.setPeriod(new PeriodComplete(startDate, endDate));
        LocationComplete loc = (LocationComplete)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue();
        newOne.getEligibleLocations().add(loc);
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)newOne, false, false);
        INodeCreator.getDefaultImpl().initUpdate(n);
        return n;
    }

    @Override
    public Class<WeeklyPlanComplete> getCommittingClass() {
        return WeeklyPlanComplete.class;
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener progressListener) {
        this.showMessage(progressListener, Words.REFRESH_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                WeeklyPlanLight fil = (WeeklyPlanLight)node.getValue(WeeklyPlanLight.class);
                WeeklyPlanComplete c = (WeeklyPlanComplete)((WeeklyPlanServiceManager)ServiceManagerRegistry.getService(WeeklyPlanServiceManager.class)).getComplete((WeeklyPlanReference)fil).getValue();
                node.removeExistingValues();
                node.setValue((Object)c, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public void doRemoteValidation(Node<WeeklyPlanLight> node, final RemoteLoader listener, ProgressListener l, boolean validateAll) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }
}

