/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.screentemplates.details.builder;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.builder.ComboSelectionProducer;
import ch.icit.pegasus.client.gui.screentemplates.details.builder.RenderItem;
import ch.icit.pegasus.client.gui.screentemplates.details.builder.ViewProducer;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDImageChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDMultiLocationComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchTextField2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextArea;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.general.IUniversal;
import ch.icit.pegasus.server.dtos.IDTO;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class DetailsParaphBuilder {
    private String name;
    private List<RenderItem<?>> renderItemList = new ArrayList();
    private int horizontalBorder;
    private int verticalBorder;
    private int inner_horizontalBorder;
    private int inner_verticalBorder;

    public DetailsParaphBuilder(String name) {
        this.name = name;
    }

    public RenderItem<?> addItem(RenderItem<?> item, RenderItem.ItemOrientation orientation, RenderItem<?> reference) {
        item.setOrientation(orientation);
        item.setReferenceItem(reference);
        this.renderItemList.add(item);
        return item;
    }

    public void layout(int w, int h) {
        RenderItem<?> firstItem = null;
        for (RenderItem<?> renderItem : this.renderItemList) {
            if (renderItem.getReferenceItem() != null) continue;
            firstItem = renderItem;
        }
        if (firstItem != null) {
            firstItem.setLocation(this.horizontalBorder, this.verticalBorder);
        }
    }

    public <T extends IUniversal> DefaultDetailsPanel<T> createParagraph() {
        return null;
    }

    public <T> RenderItem<T> create(RenderItem.ItemType itemType, DtoField<T> field) {
        return null;
    }

    public RenderItem<Integer> createItemNumberField(DtoField<Integer> field, String name) {
        return new RenderItem<Integer>(field, RenderItem.ItemType.ItemNumber, name, () -> {
            TextLabel textLabel = new TextLabel();
            textLabel.setReadOnlyTextField(true);
            return textLabel;
        });
    }

    public RenderItem<String> createStringField(RDProvider provider, DtoField<String> field, String name) {
        return new RenderItem<String>(field, RenderItem.ItemType.ItemNumber, name, () -> new RDTextField(provider, TextFieldType.NORMAL));
    }

    public <T extends IDTO> RenderItem<T> createItemSearchField(RDProvider provider, DtoField<T> field, String name, RDSearchTextField2.SearchTypes searchType, boolean deletable) {
        return new RenderItem<T>(field, RenderItem.ItemType.ItemNumber, name, () -> new RDSearchTextField2(provider, searchType, deletable));
    }

    public RenderItem<?> createComboBox(final RDProvider provider, DtoField<?> field, String name, final Class<? extends Converter> viewConverter, final ComboSelectionProducer selectionProducer, final boolean isNullable, final boolean isReference) {
        return new RenderItem(field, RenderItem.ItemType.ItemNumber, name, new ViewProducer(){

            public Component produce() {
                return new RDComboBox(provider, ConverterRegistry.getConverter((Class)viewConverter), isNullable, isReference);
            }

            public void updateComponent(Node node, DtoField field, Component component) {
                RDComboBox box = (RDComboBox)component;
                box.refreshPossibleValues(selectionProducer.createComboSelectionPossibilities());
                box.setNode(node.getChildNamed(field));
            }
        });
    }

    public RenderItem<?> createPeriodChooser(RDProvider provider, DtoField<?> field, String name, boolean showName, boolean startInfinity, boolean endInfinity) {
        return new RenderItem(field, RenderItem.ItemType.ItemNumber, name, () -> {
            TitledPeriodEditor editor = new TitledPeriodEditor(null, null, showName, provider, field);
            editor.enableInfinity(startInfinity, endInfinity);
            return editor;
        });
    }

    public RenderItem<?> createMultiLocationChooser(RDProvider provider, DtoField<?> field, String name) {
        return new RenderItem(field, RenderItem.ItemType.ItemNumber, name, () -> new RDMultiLocationComboBox(provider));
    }

    public RenderItem<?> createImageChooser(RDProvider provider, DtoField<?> field, String name) {
        return new RenderItem(field, RenderItem.ItemType.ItemNumber, name, () -> new RDImageChooser(provider));
    }

    public RenderItem<?> createTextArea(RDProvider provider, DtoField<?> field, String name) {
        return new RenderItem(field, RenderItem.ItemType.ItemNumber, name, () -> new RDTextArea(provider));
    }
}

