/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.flight.local.open;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.export.DefaultExportAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.FlightServiceManager;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightStateE;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.utils.ExcelRow;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OpenAllFlightsComponent
extends DefaultExportAnalysisComponent<FlightLight> {
    private static final long serialVersionUID = 1L;

    public OpenAllFlightsComponent(AnalysisSmartExternalOpenTool<FlightLight> defaultAnalysis) {
        super(defaultAnalysis);
    }

    @Override
    public void addOptionItems() {
    }

    @Override
    public boolean canExportAll() {
        return false;
    }

    @Override
    protected String getFinishedText() {
        return Words.SUCCESSFUL;
    }

    @Override
    protected String getProgressText() {
        return Words.OPEN_FLIGHTS;
    }

    @Override
    public String getPrefixText() {
        return Words.OPEN;
    }

    @Override
    public String getExportCurrentText() {
        return Words.OPEN_CURRENT;
    }

    @Override
    public String getExportFilteredText() {
        return Words.OPEN_FILTERED;
    }

    @Override
    public String getTitleText() {
        return Words.SELECT_FLIGHT_DATA;
    }

    @Override
    public boolean isFileBased() {
        return false;
    }

    @Override
    public void process(Iterator<FlightLight> sri, List<ExcelRow> rows) throws ClientServerCallException {
        while (sri.hasNext()) {
            this.updateItemCount();
            FlightLight f = sri.next();
            if (f == null || f.getId() != null) continue;
            ArrayList innerErrors = new ArrayList();
            try {
                FlightComplete fc = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getPlannedFlightComplete(f).getValue();
                fc.setFlightState(FlightStateE.OPEN);
                ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).create(fc, new ListWrapper(innerErrors), "");
            }
            catch (ClientServerCallException e) {
                InnerPopupFactory.showErrorDialog((Exception)((Object)e), (Component)this);
            }
        }
    }

    @Override
    protected List<ExcelRow> createRow(FlightLight product) throws ClientServerCallException {
        return null;
    }
}

