/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.flight.remote.dailyops;

import ch.icit.pegasus.client.converter.FlightCategoryConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.batch.impl.FlightPrintBatch;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooserPopup;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledDateTimePeriodChooser;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBox;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.FlightReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.DailyOpsSheetTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.IFlightReference;
import ch.icit.pegasus.server.core.dtos.masterdata.AirportComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.FlightCategoryComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.TimestampPeriodComplete;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.report.SearchReportConfiguration;
import ch.icit.pegasus.server.core.dtos.search.ADtoSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.FlightSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.TimeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;

public class PrintDailyOpsComponent<T extends IFlightReference>
extends DefaultScrollablePrintPopup2<T> {
    private static final long serialVersionUID = 1L;
    protected TextLabel options;
    protected TitledItem<CheckBox> includePlannedFlights;
    protected TitledItem<CheckBox> groupOutboundMeals;
    protected TitledItem<CheckBox> hideFromToNSDS;
    protected TitledItem<CheckBox> useChronology;
    protected TitledItem<CheckBox> addSpaces;
    protected TitledItem<CheckBox> includeAdditional;
    protected TitledItem<DateChooserPopup> dateChooser;
    protected TitledDateTimePeriodChooser dateTimeChooser;
    protected TitledItem<SearchComboBox> customer;
    protected TitledItem<ComboBox> category;
    private TitledItem<SearchTextField2<AirportComplete>> deliveryAirport;
    protected Date selectedDate;
    private final boolean withTime;

    public PrintDailyOpsComponent(Date date, boolean withTime) {
        super(true, true, false, false, ReportTypeE.FLIGHT);
        this.selectedDate = date;
        this.withTime = withTime;
    }

    @Override
    public void insertElements() {
        this.createComponents();
        Font tf = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_titled_item_font_type"));
        Color tfc = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_titled_item_foreground"));
        Font f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
        Color fb = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color"));
        this.options = new TextLabel(Words.OPTIONS);
        this.options.setFont(tf);
        this.options.setForeground(tfc);
        this.deliveryAirport = new TitledItem<SearchTextField2<AirportComplete>>(SearchTextField2Factory.getAirportSearchField(true, new DTOProxyNode()), Words.DELIVERY_AIRPORT, TitledItem.TitledItemOrientation.NORTH);
        this.deliveryAirport.setTitleFont(f);
        this.deliveryAirport.setTitleForeground(fb);
        this.includePlannedFlights = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_PLANNED_FLIGHTS, TitledItem.TitledItemOrientation.EAST);
        this.includePlannedFlights.setTitleFont(f);
        this.includePlannedFlights.setTitleForeground(fb);
        this.groupOutboundMeals = new TitledItem<CheckBox>(new CheckBox(), Words.GROUP_MEALS, TitledItem.TitledItemOrientation.EAST);
        this.groupOutboundMeals.setTitleFont(f);
        this.groupOutboundMeals.setTitleForeground(fb);
        this.hideFromToNSDS = new TitledItem<CheckBox>(new CheckBox(), Words.HIDE_FLIGHTS_FORM_NS_DS, TitledItem.TitledItemOrientation.EAST);
        this.hideFromToNSDS.setTitleFont(f);
        this.hideFromToNSDS.setTitleForeground(fb);
        this.useChronology = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_FLIGHTS_CHRONO, TitledItem.TitledItemOrientation.EAST);
        this.useChronology.setTitleFont(f);
        this.useChronology.setTitleForeground(fb);
        this.addSpaces = new TitledItem<CheckBox>(new CheckBox(), Words.ADD_ADDITIONAL_SPACE, TitledItem.TitledItemOrientation.EAST);
        this.addSpaces.setTitleFont(f);
        this.addSpaces.setTitleForeground(fb);
        this.includeAdditional = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_ADDITIONALS, TitledItem.TitledItemOrientation.EAST);
        this.includeAdditional.setTitleFont(f);
        this.includeAdditional.setTitleForeground(fb);
        if (this.withTime) {
            Calendar cal = TimeUtil.createCalendar();
            cal.setTime(this.selectedDate);
            cal.set(10, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            Timestamp s = new Timestamp(cal.getTimeInMillis());
            cal.add(5, 1);
            Timestamp e = new Timestamp(cal.getTimeInMillis());
            this.dateTimeChooser = new TitledDateTimePeriodChooser((Node<TimestampPeriodComplete>)INodeCreator.getDefaultImpl().getNode4DTO((Object)new TimestampPeriodComplete(s, e), false, false));
            this.getViewContainer().add(this.dateTimeChooser);
        } else {
            this.dateChooser = new TitledItem<DateChooserPopup>(new DateChooserPopup(this.selectedDate), Words.OPS_DATE, TitledItem.TitledItemOrientation.NORTH);
            this.dateChooser.getElement().enableSkin(true);
            this.getViewContainer().add(this.dateChooser);
        }
        this.customer = new TitledItem<SearchComboBox>(SearchComboBoxFactory.getCustomerSearchField(true, new DTOProxyNode()), Words.CUSTOMER, TitledItem.TitledItemOrientation.NORTH);
        this.category = new TitledItem<ComboBox>(new ComboBox((Node)new DTOProxyNode(), NodeToolkit.getAffixList(FlightCategoryComplete.class), ConverterRegistry.getConverter(FlightCategoryConverter.class), true), Words.CATEGORY, TitledItem.TitledItemOrientation.NORTH);
        this.getViewContainer().add(this.options);
        this.getViewContainer().add(this.includePlannedFlights);
        this.getViewContainer().add(this.groupOutboundMeals);
        this.getViewContainer().add(this.hideFromToNSDS);
        this.getViewContainer().add(this.useChronology);
        this.getViewContainer().add(this.addSpaces);
        this.getViewContainer().add(this.customer);
        this.getViewContainer().add(this.includeAdditional);
        this.getViewContainer().add(this.category);
        this.getViewContainer().add(this.deliveryAirport);
        this.getViewContainer().setLayout(new Layout());
    }

    @Override
    public String getPreferredSelection() {
        SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        boolean isLSGFC = CompanyUtil.isLSGFC((SystemSettingsComplete)s);
        if (isLSGFC) {
            return Words.DAILY_OPS_PLAN_OUTBOUND;
        }
        boolean isSCK = CompanyUtil.isSCK((SystemSettingsComplete)s);
        if (isSCK) {
            return Words.DAILY_OPS_PLAN_FLIGHTS;
        }
        return super.getPreferredSelection();
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String v = s[1];
            Boolean b = Boolean.valueOf(v);
            switch (n) {
                case "include_planned": {
                    this.includePlannedFlights.getElement().setChecked(b);
                    break;
                }
                case "group_outbound_meals": {
                    this.groupOutboundMeals.getElement().setChecked(b);
                    break;
                }
                case "hideNSDS": {
                    this.hideFromToNSDS.getElement().setChecked(b);
                    break;
                }
                case "use_chronology": {
                    this.useChronology.getElement().setChecked(b);
                    break;
                }
                case "addSpaces": {
                    this.addSpaces.getElement().setChecked(b);
                    break;
                }
                case "includeAdditional": {
                    this.includeAdditional.getElement().setChecked(b);
                }
            }
        }
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        conf.addProperty("include_planned", "" + this.includePlannedFlights.getElement().isChecked());
        conf.addProperty("group_outbound_meals", "" + this.groupOutboundMeals.getElement().isChecked());
        conf.addProperty("hideNSDS", "" + this.hideFromToNSDS.getElement().isChecked());
        conf.addProperty("use_chronology", "" + this.useChronology.getElement().isChecked());
        conf.addProperty("addSpaces", "" + this.addSpaces.getElement().isChecked());
        conf.addProperty("includeAdditional", "" + this.includeAdditional.getElement().isChecked());
        return conf;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        this.options.setVisible(true);
        this.customer.setVisible(true);
        if (this.withTime) {
            this.dateTimeChooser.setVisible(true);
        } else {
            this.dateChooser.setVisible(true);
        }
        this.groupOutboundMeals.setVisible(true);
        this.hideFromToNSDS.setVisible(true);
        this.useChronology.setVisible(true);
        this.includePlannedFlights.setVisible(true);
        this.addSpaces.setVisible(true);
        this.includeAdditional.setVisible(true);
        this.category.setVisible(true);
        this.deliveryAirport.setVisible(true);
    }

    @Override
    public String getTitleString() {
        return Words.DAILY_OPS;
    }

    @Override
    public String getTitleValue() {
        return Words.ALL_FLIGHTS;
    }

    @Override
    public boolean isClosableWithEnter() {
        return true;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[3];
        return o;
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> focusList = super.getFocusComponents();
        CheckedListAdder.addToList(focusList, this.includePlannedFlights);
        CheckedListAdder.addToList(focusList, this.groupOutboundMeals);
        CheckedListAdder.addToList(focusList, this.hideFromToNSDS);
        CheckedListAdder.addToList(focusList, this.useChronology);
        CheckedListAdder.addToList(focusList, this.addSpaces);
        CheckedListAdder.addToList(focusList, this.includeAdditional);
        CheckedListAdder.addToList(focusList, this.customer);
        if (this.withTime) {
            CheckedListAdder.addToList(focusList, this.dateTimeChooser);
        } else {
            CheckedListAdder.addToList(focusList, this.dateChooser);
        }
        CheckedListAdder.addToList(focusList, this.category);
        CheckedListAdder.addToList(focusList, this.deliveryAirport);
        return focusList;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.options != null) {
            this.options.kill();
            this.options = null;
            this.includePlannedFlights.kill();
            this.includePlannedFlights = null;
            this.groupOutboundMeals.kill();
            this.groupOutboundMeals = null;
            this.hideFromToNSDS.kill();
            this.hideFromToNSDS = null;
            this.useChronology.kill();
            this.useChronology = null;
            this.deliveryAirport.kill();
            this.deliveryAirport = null;
            if (this.withTime) {
                this.dateTimeChooser.kill();
                this.dateTimeChooser = null;
            } else {
                this.dateChooser.kill();
                this.dateChooser = null;
            }
            this.customer.kill();
            this.customer = null;
            this.addSpaces.kill();
            this.addSpaces = null;
            this.includeAdditional.kill();
            this.includeAdditional = null;
            this.category.kill();
            this.category = null;
        }
    }

    @Override
    public boolean isInnerComponent(Component c) {
        boolean innerComponent;
        if (this.customer != null && (innerComponent = this.customer.isInnerComponent(c))) {
            return true;
        }
        if (this.deliveryAirport != null && (innerComponent = this.deliveryAirport.isInnerComponent(c))) {
            return true;
        }
        if (this.category != null && (innerComponent = this.category.isInnerComponent(c))) {
            return true;
        }
        return super.isInnerComponent(c);
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        this.options.setVisible(false);
        this.includePlannedFlights.setVisible(false);
        this.groupOutboundMeals.setVisible(false);
        this.hideFromToNSDS.setVisible(false);
        this.useChronology.setVisible(false);
        this.addSpaces.setVisible(false);
        this.deliveryAirport.setVisible(false);
        this.includeAdditional.setVisible(false);
        this.category.setVisible(false);
        if (this.withTime) {
            this.dateTimeChooser.setVisible(false);
        } else {
            this.dateChooser.setVisible(false);
        }
        this.customer.setVisible(false);
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                boolean ipF = PrintDailyOpsComponent.this.includePlannedFlights.getElement().isChecked();
                boolean groupMeals = PrintDailyOpsComponent.this.groupOutboundMeals.getElement().isChecked();
                boolean hideNSDS = PrintDailyOpsComponent.this.hideFromToNSDS.getElement().isChecked();
                boolean isChronological = PrintDailyOpsComponent.this.useChronology.getElement().isChecked();
                boolean addSpa = PrintDailyOpsComponent.this.addSpaces.getElement().isChecked();
                boolean inclAdditional = PrintDailyOpsComponent.this.includeAdditional.getElement().isChecked();
                FlightCategoryComplete flightCat = (FlightCategoryComplete)PrintDailyOpsComponent.this.category.getElement().getNode().getValue();
                FlightSearchConfiguration f = new FlightSearchConfiguration();
                f.setCategory(flightCat);
                if (PrintDailyOpsComponent.this.withTime) {
                    f.setDayTimePeriod(PrintDailyOpsComponent.this.dateTimeChooser.getTimePeriod());
                } else {
                    Calendar a = PrintDailyOpsComponent.this.dateChooser.getElement().getSelectedDate();
                    PeriodComplete p = new PeriodComplete(new Date(a.getTimeInMillis()), new Date(a.getTimeInMillis()));
                    f.setDayPeriod(p);
                }
                f.setCustomer((CustomerLight)PrintDailyOpsComponent.this.customer.getElement().getNode().getValue());
                if (!ipF) {
                    f.setOnlyOpenFlights(Boolean.valueOf(true));
                }
                f.setDeliveryAirport((AirportComplete)((SearchTextField2)PrintDailyOpsComponent.this.deliveryAirport.getElement()).getNode().getValue());
                f.setNumResults(Integer.MAX_VALUE);
                f.setSortColumn((Enum)FlightSearchConfiguration.FLIGHT_COLUMN.PLANNED_ARRIVAL);
                ReportFileComplete file = PrintDailyOpsComponent.this.getSelectedReport();
                SearchReportConfiguration sc = new SearchReportConfiguration(ReportTypeE.FLIGHT, ReportingOutputFormatE.PDF, file);
                sc.setSearchConfig((ADtoSearchConfiguration)f);
                sc.setTitle(Words.DAILY_OPS);
                PegasusFileComplete report = (PegasusFileComplete)((FlightReportServiceManager)ServiceManagerRegistry.getService(FlightReportServiceManager.class)).createFlightDailyOpsReport(sc, groupMeals, hideNSDS, isChronological, false, inclAdditional, null, DailyOpsSheetTypeE.PAX_BASED, addSpa, !PrintDailyOpsComponent.this.withTime).getValue();
                PrintDailyOpsComponent.this.processFile(report);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintDailyOpsComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<T> getCurrentNode() {
        return null;
    }

    @Override
    public BatchJob<T> createBatchJob(Node<T> value, ThreadSafeExecutable job) {
        return new FlightPrintBatch<T>(job, value, this.getPrintProcessor(), false);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintDailyOpsComponent.this.getInheritedComponentsHeight();
            if (PrintDailyOpsComponent.this.animation != null) {
                return new Dimension((int)PrintDailyOpsComponent.this.animation.getPreferredSize().getWidth() + 2 * PrintDailyOpsComponent.this.border, (int)(PrintDailyOpsComponent.this.animation.getPreferredSize().getHeight() + (double)(2 * PrintDailyOpsComponent.this.border)));
            }
            h = (int)((double)h + PrintDailyOpsComponent.this.options.getPreferredSize().getHeight());
            h += PrintDailyOpsComponent.this.border;
            h = (int)((double)h + PrintDailyOpsComponent.this.includePlannedFlights.getPreferredSize().getHeight());
            h += PrintDailyOpsComponent.this.border / 2;
            h = (int)((double)h + PrintDailyOpsComponent.this.groupOutboundMeals.getPreferredSize().getHeight());
            h += PrintDailyOpsComponent.this.border / 2;
            h = (int)((double)h + PrintDailyOpsComponent.this.hideFromToNSDS.getPreferredSize().getHeight());
            h += PrintDailyOpsComponent.this.border / 2;
            h = (int)((double)h + PrintDailyOpsComponent.this.useChronology.getPreferredSize().getHeight());
            h += PrintDailyOpsComponent.this.border / 2;
            h = (int)((double)h + PrintDailyOpsComponent.this.addSpaces.getPreferredSize().getHeight());
            h += PrintDailyOpsComponent.this.border / 2;
            h = (int)((double)h + PrintDailyOpsComponent.this.includeAdditional.getPreferredSize().getHeight());
            h += PrintDailyOpsComponent.this.border;
            h = PrintDailyOpsComponent.this.withTime ? (int)((double)h + PrintDailyOpsComponent.this.dateTimeChooser.getPreferredSize().getHeight()) : (int)((double)h + PrintDailyOpsComponent.this.dateChooser.getPreferredSize().getHeight());
            h += PrintDailyOpsComponent.this.border;
            h = (int)((double)h + PrintDailyOpsComponent.this.customer.getPreferredSize().getHeight());
            h += PrintDailyOpsComponent.this.border / 2;
            h = (int)((double)h + PrintDailyOpsComponent.this.category.getPreferredSize().getHeight());
            h += PrintDailyOpsComponent.this.border / 2;
            h = (int)((double)h + PrintDailyOpsComponent.this.deliveryAirport.getPreferredSize().getHeight());
            return new Dimension(0, h += PrintDailyOpsComponent.this.border);
        }

        @Override
        public void layoutContainer(Container parent) {
            int h = PrintDailyOpsComponent.this.layoutInheritedComponents(parent);
            PrintDailyOpsComponent.this.options.setLocation(PrintDailyOpsComponent.this.border, h += PrintDailyOpsComponent.this.border);
            PrintDailyOpsComponent.this.options.setSize(PrintDailyOpsComponent.this.options.getPreferredSize());
            PrintDailyOpsComponent.this.includePlannedFlights.setLocation(PrintDailyOpsComponent.this.border, PrintDailyOpsComponent.this.options.getY() + PrintDailyOpsComponent.this.options.getHeight() + PrintDailyOpsComponent.this.border);
            PrintDailyOpsComponent.this.includePlannedFlights.setSize(PrintDailyOpsComponent.this.includePlannedFlights.getPreferredSize());
            PrintDailyOpsComponent.this.groupOutboundMeals.setLocation(PrintDailyOpsComponent.this.border, PrintDailyOpsComponent.this.includePlannedFlights.getY() + PrintDailyOpsComponent.this.includePlannedFlights.getHeight() + PrintDailyOpsComponent.this.border / 2);
            PrintDailyOpsComponent.this.groupOutboundMeals.setSize(PrintDailyOpsComponent.this.groupOutboundMeals.getPreferredSize());
            PrintDailyOpsComponent.this.hideFromToNSDS.setLocation(PrintDailyOpsComponent.this.border, PrintDailyOpsComponent.this.groupOutboundMeals.getY() + PrintDailyOpsComponent.this.groupOutboundMeals.getHeight() + PrintDailyOpsComponent.this.border / 2);
            PrintDailyOpsComponent.this.hideFromToNSDS.setSize(PrintDailyOpsComponent.this.hideFromToNSDS.getPreferredSize());
            PrintDailyOpsComponent.this.useChronology.setLocation(PrintDailyOpsComponent.this.border, PrintDailyOpsComponent.this.hideFromToNSDS.getY() + PrintDailyOpsComponent.this.hideFromToNSDS.getHeight() + PrintDailyOpsComponent.this.border / 2);
            PrintDailyOpsComponent.this.useChronology.setSize(PrintDailyOpsComponent.this.useChronology.getPreferredSize());
            PrintDailyOpsComponent.this.addSpaces.setLocation(PrintDailyOpsComponent.this.border, PrintDailyOpsComponent.this.useChronology.getY() + PrintDailyOpsComponent.this.useChronology.getHeight() + PrintDailyOpsComponent.this.border / 2);
            PrintDailyOpsComponent.this.addSpaces.setSize(PrintDailyOpsComponent.this.addSpaces.getPreferredSize());
            PrintDailyOpsComponent.this.includeAdditional.setLocation(PrintDailyOpsComponent.this.border, PrintDailyOpsComponent.this.addSpaces.getY() + PrintDailyOpsComponent.this.addSpaces.getHeight() + PrintDailyOpsComponent.this.border / 2);
            PrintDailyOpsComponent.this.includeAdditional.setSize(PrintDailyOpsComponent.this.includeAdditional.getPreferredSize());
            int y = PrintDailyOpsComponent.this.includeAdditional.getY() + PrintDailyOpsComponent.this.includeAdditional.getHeight() + PrintDailyOpsComponent.this.border;
            if (PrintDailyOpsComponent.this.withTime) {
                PrintDailyOpsComponent.this.dateTimeChooser.setLocation(PrintDailyOpsComponent.this.border, y);
                PrintDailyOpsComponent.this.dateTimeChooser.setSize(PrintDailyOpsComponent.this.dateTimeChooser.getPreferredSize());
                y = (int)((double)y + PrintDailyOpsComponent.this.dateTimeChooser.getPreferredSize().getHeight());
            } else {
                PrintDailyOpsComponent.this.dateChooser.setLocation(PrintDailyOpsComponent.this.border, y);
                PrintDailyOpsComponent.this.dateChooser.setSize(PrintDailyOpsComponent.this.dateChooser.getPreferredSize());
                y = (int)((double)y + PrintDailyOpsComponent.this.dateChooser.getPreferredSize().getHeight());
            }
            PrintDailyOpsComponent.this.deliveryAirport.setLocation(PrintDailyOpsComponent.this.border, y + PrintDailyOpsComponent.this.border / 2);
            PrintDailyOpsComponent.this.deliveryAirport.setSize(parent.getWidth() - 2 * PrintDailyOpsComponent.this.border, (int)PrintDailyOpsComponent.this.deliveryAirport.getPreferredSize().getHeight());
            y = PrintDailyOpsComponent.this.deliveryAirport.getY() + PrintDailyOpsComponent.this.deliveryAirport.getHeight();
            PrintDailyOpsComponent.this.customer.setLocation(PrintDailyOpsComponent.this.border, y + PrintDailyOpsComponent.this.border);
            PrintDailyOpsComponent.this.customer.setSize(parent.getWidth() - 2 * PrintDailyOpsComponent.this.border, (int)PrintDailyOpsComponent.this.customer.getPreferredSize().getHeight());
            y = PrintDailyOpsComponent.this.customer.getY() + PrintDailyOpsComponent.this.customer.getHeight();
            PrintDailyOpsComponent.this.category.setLocation(PrintDailyOpsComponent.this.border, y + PrintDailyOpsComponent.this.border / 2);
            PrintDailyOpsComponent.this.category.setSize(parent.getWidth() - 2 * PrintDailyOpsComponent.this.border, (int)PrintDailyOpsComponent.this.category.getPreferredSize().getHeight());
        }
    }
}

