/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.flight.remote.dutyfreedailyops.retailinmotion;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.CheckBoxAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.DateChooserAnalysisItem;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.FlightReportServiceManager;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.DateWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import java.sql.Date;

public class DF_Rim_DailyOpsExportAnalysisComponent
extends DefaultServerSideAnalysisComponent<FlightLight, FlightReference> {
    private static final long serialVersionUID = 1L;
    private TitledItem<DateChooser> dueDate;
    private TitledItem<CheckBox> includeStock;

    public DF_Rim_DailyOpsExportAnalysisComponent(AnalysisSmartExternalOpenTool<FlightLight> subProv) {
        super(subProv, false, false, false);
    }

    @Override
    public void addOptionItems() {
        Node dateNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)new Date(System.currentTimeMillis()), false, false);
        this.dueDate = new TitledItem<DateChooser>(new DateChooser(dateNode), Words.DUE_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.includeStock = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_STOCK, TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new DateChooserAnalysisItem(this.dueDate, "period"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeStock, "stock"));
    }

    @Override
    public String getTitleString() {
        return Words.DUTY_FREE_DAILY_OPS;
    }

    @Override
    public FlightReference createReference(FlightLight item) {
        if (item.getId() != null) {
            return new FlightReference(item.getId());
        }
        return null;
    }

    @Override
    public PegasusFileComplete createReport() throws ServiceException {
        Date selectedDate = (Date)this.dueDate.getElement().getNode().getValue();
        PegasusFileComplete file = (PegasusFileComplete)((FlightReportServiceManager)ServiceManagerRegistry.getService(FlightReportServiceManager.class)).getDutyFreeRetailInMotionDailyOps(new DateWrapper(selectedDate), this.includeStock.getElement().isChecked()).getValue();
        return file;
    }
}

