/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.flight.remote.kitchenforecast;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.panels.KitchenForecastConfigPanel_ComboStyle;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.KitchenForecastPanel_Combo_AnalysisItem;
import ch.icit.pegasus.client.gui.utils.print.PrintPopupToolkit;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.KitchenreportServiceManager;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.report.KitchenForecastReportConfiguration;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class AnalysisKitchenForecastComponent
extends DefaultServerSideAnalysisComponent<FlightLight, FlightReference> {
    private static final long serialVersionUID = 1L;
    private KitchenForecastConfigPanel_ComboStyle configPanel;

    public AnalysisKitchenForecastComponent(AnalysisSmartExternalOpenTool<FlightLight> defaultAnalysis) {
        super(defaultAnalysis);
    }

    @Override
    public void addOptionItems() {
        this.configPanel = new KitchenForecastConfigPanel_ComboStyle(null, false);
        this.configPanel.loadComboData();
        this.addOptionsItem(new KitchenForecastPanel_Combo_AnalysisItem(this.configPanel, "config"));
    }

    @Override
    public boolean canExportAll() {
        return false;
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> a = super.getFocusComponents();
        CheckedListAdder.addToList(a, this.configPanel);
        return a;
    }

    @Override
    protected String getProgressText() {
        return Words.PROCESS;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.configPanel.setEnabled(isEnabled);
    }

    @Override
    public String getTitleString() {
        return Words.KITCHEN_FORECAST;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public String getTitleValue() {
        return Words.FLIGHTS;
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.animation != null) {
            this.animation.kill();
        }
        this.animation = null;
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.configPanel != null) {
            this.configPanel.setVisible(false);
        }
    }

    @Override
    public PegasusFileComplete createReport() throws ServiceException {
        List s = this.loadItemReferences();
        KitchenForecastReportConfiguration config = this.configPanel.getConfig();
        config.getFlights().addAll(s);
        ArrayList warnings = new ArrayList();
        config.setCustomers(new ArrayList());
        List ref = ((KitchenreportServiceManager)ServiceManagerRegistry.getService(KitchenreportServiceManager.class)).createKitchenForecastReport(config, new ListWrapper(warnings)).getList();
        for (PegasusFileComplete pf : ref) {
            try {
                File f = FileTransferUtil.download((PegasusFileComplete)pf, (FileTransferListener[])new FileTransferListener[0]);
                PrintPopupToolkit.previewFile(f);
            }
            catch (Exception e) {
                InnerPopupFactory.showErrorDialog(e, (Component)this);
            }
        }
        return null;
    }

    @Override
    public FlightReference createReference(FlightLight item) {
        return new FlightReference(item.getId());
    }
}

