/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.flight.remote.manualseallabel;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.panels.ManualSealLabelPanel;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.ManualFlightSealPanelAnalysisItem;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.FlightReportServiceManager;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.masterdata.ColorComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.MapWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import java.util.List;
import java.util.Map;

public class AnalysisFlightSealLabelComponent
extends DefaultServerSideAnalysisComponent<FlightLight, FlightReference> {
    private static final long serialVersionUID = 1L;
    private ManualSealLabelPanel sealsPanel;

    public AnalysisFlightSealLabelComponent(AnalysisSmartExternalOpenTool<FlightLight> defaultAnalysis) {
        super(defaultAnalysis);
    }

    @Override
    public void addOptionItems() {
        this.sealsPanel = new ManualSealLabelPanel();
        this.addOptionsItem(new ManualFlightSealPanelAnalysisItem(this.sealsPanel, "seals"));
    }

    @Override
    public boolean canExportAll() {
        return false;
    }

    @Override
    public String getFileEnding() {
        return ".pdf";
    }

    @Override
    public String getTitleString() {
        return Words.SEALS;
    }

    @Override
    public FlightReference createReference(FlightLight item) {
        if (item.getId() != null) {
            return new FlightReference(item.getId());
        }
        return item;
    }

    @Override
    public PegasusFileComplete createReport() throws ServiceException {
        List s = this.loadItemReferences();
        boolean autoGenerate = false;
        boolean useEquipmentLabels = false;
        Map<ColorComplete, Integer> seals = null;
        if (this.sealsPanel.getUseFlightSeals()) {
            autoGenerate = true;
        } else {
            autoGenerate = false;
            seals = this.sealsPanel.getSealsCount();
        }
        useEquipmentLabels = this.sealsPanel.getUseEquipmentLabels();
        PegasusFileComplete file = (PegasusFileComplete)((FlightReportServiceManager)ServiceManagerRegistry.getService(FlightReportServiceManager.class)).generateManualSealLabels(new ListWrapper(s), autoGenerate, useEquipmentLabels, new MapWrapper(seals)).getValue();
        return file;
    }
}

