/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.flight.remote.printallcustoms;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.flight.remote.printall.AnalysisPrintAllSheetsComponent;
import ch.icit.pegasus.client.node.ServiceReturn;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.FlightServiceManager;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.report.AGenericReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.FlightCustomsSupplySheetReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.report.analysis.FlightAnalysisCustomsSupplySheetsConfiguration;
import ch.icit.pegasus.server.core.dtos.report.generic.GenericAnalysisReportType;
import ch.icit.pegasus.server.core.i18n.Words;
import java.util.Collections;
import java.util.List;

public class AnalysisPrintFlightCustomsSheetComponent
extends AnalysisPrintAllSheetsComponent {
    private static final long serialVersionUID = 1L;

    public AnalysisPrintFlightCustomsSheetComponent(AnalysisSmartExternalOpenTool<FlightLight> defaultAnalysis, ReportTypeE reportType) {
        super(defaultAnalysis, reportType);
    }

    @Override
    public List<PegasusFileComplete> processSingleFile(FlightLight flight, AGenericReportConfiguration flightConfig) throws ClientServerCallException {
        ReportFileComplete file = this.getSelectedReport();
        FlightCustomsSupplySheetReportConfiguration config = new FlightCustomsSupplySheetReportConfiguration();
        config.setFlight(new FlightReference(flight.getId()));
        config.setStylesheet(file);
        ServiceReturn t = ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).printFlightCustomsSupplySheet(config);
        PegasusFileComplete fileComplete = (PegasusFileComplete)t.getObject();
        return Collections.singletonList(fileComplete);
    }

    @Override
    public boolean canExportAll() {
        return false;
    }

    @Override
    public String getTitleString() {
        return Words.FLIGHT;
    }

    @Override
    public String getTitleValue() {
        return Words.ALL + " " + Words.SELECTED;
    }

    @Override
    protected AGenericReportConfiguration getReportConfiguration() {
        FlightAnalysisCustomsSupplySheetsConfiguration config = new FlightAnalysisCustomsSupplySheetsConfiguration();
        config.setReportType(this.getReportType());
        ReportingOutputFormatE format = ReportingOutputFormatE.PDF;
        config.setReportFormatType(format);
        return config;
    }

    @Override
    public GenericAnalysisReportType getReportType() {
        return GenericAnalysisReportType.AnalysisCustomsSupplySheets;
    }
}

