/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.flight.remote.printallstowing;

import ch.icit.pegasus.client.converter.ColorConverter;
import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.flight.remote.printall.AnalysisPrintAllSheetsComponent;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.CheckBoxAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.ComboBoxAnalysisItem;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.FlightReportServiceManager;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.masterdata.ColorComplete;
import ch.icit.pegasus.server.core.dtos.report.AGenericReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.report.StowingListReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.analysis.FlightAnalysisStowingListConfiguration;
import ch.icit.pegasus.server.core.dtos.report.generic.GenericAnalysisReportType;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import ch.icit.pegasus.server.dtos.IDTO;
import java.util.Collections;
import java.util.List;

public class AnalysisPrintFlightStowingListComponent
extends AnalysisPrintAllSheetsComponent {
    private static final long serialVersionUID = 1L;
    private boolean isHideNSDSActive = false;
    private TitledItem<CheckBox> finalizeFlight;
    private TitledItem<CheckBox> includeGalleyMap;
    private TitledItem<CheckBox> includeCrewClasses;
    private TitledItem<CheckBox> summarizeCrew;
    private TitledItem<CheckBox> hideNSDSFlights;
    private TitledItem<CheckBox> includeSealList;
    private TitledItem<ComboBox> department;
    private TitledItem<ComboBox> colors;

    public AnalysisPrintFlightStowingListComponent(AnalysisSmartExternalOpenTool<FlightLight> defaultAnalysis, ReportTypeE reportType) {
        super(defaultAnalysis, reportType);
    }

    @Override
    public List<PegasusFileComplete> processSingleFile(FlightLight flight, AGenericReportConfiguration flightConfig) throws ClientServerCallException {
        FlightAnalysisStowingListConfiguration aconfig = (FlightAnalysisStowingListConfiguration)flightConfig;
        ReportFileComplete file = this.getSelectedReport();
        StowingListReportConfiguration config = aconfig.getConfiguration();
        config.setDto((IDTO)new FlightReference(flight.getId()));
        config.setStylesheet(file);
        PegasusFileComplete fileComplete = (PegasusFileComplete)((FlightReportServiceManager)ServiceManagerRegistry.getService(FlightReportServiceManager.class)).createFlightStowingListReportWithSealOption(config, new ListWrapper(), Boolean.valueOf(this.includeSealList.getElement().isChecked())).getValue();
        return Collections.singletonList(fileComplete);
    }

    @Override
    public boolean canExportAll() {
        return false;
    }

    @Override
    public void addOptionItems() {
        super.addOptionItems();
        this.finalizeFlight = new TitledItem<CheckBox>(new CheckBox(), Words.SET_PAX_TO_FINAL, TitledItem.TitledItemOrientation.EAST);
        this.includeSealList = new TitledItem<CheckBox>(new CheckBox(), "Include Seal List", TitledItem.TitledItemOrientation.EAST);
        this.includeGalleyMap = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_GALLEY_MAP, TitledItem.TitledItemOrientation.EAST);
        this.includeCrewClasses = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_CREW_PAX, TitledItem.TitledItemOrientation.EAST);
        this.summarizeCrew = new TitledItem<CheckBox>(new CheckBox(), Words.SUMMARIZE_CREW, TitledItem.TitledItemOrientation.EAST);
        if (this.isHideNSDSActive) {
            this.hideNSDSFlights = new TitledItem<CheckBox>(new CheckBox(), Words.HIDE_FLIGHTS_FROMTO_NS_DS, TitledItem.TitledItemOrientation.EAST);
        }
        this.department = new TitledItem<ComboBox>(new ComboBox((Node)new DTOProxyNode(), NodeToolkit.getAffixList(CostCenterComplete.class), ConverterRegistry.getConverter(CostCenterConverter.class), true, true), WordsToolkit.toCapitalLetter((String)Words.DEPARTMENT), TitledItem.TitledItemOrientation.NORTH);
        this.colors = new TitledItem<ComboBox>(new ComboBox((Node)new DTOProxyNode(), NodeToolkit.getAffixList(ColorComplete.class), ConverterRegistry.getConverter(ColorConverter.class), true, true), WordsToolkit.toCapitalLetter((String)Words.LABEL_COLOR, (boolean)true), TitledItem.TitledItemOrientation.NORTH);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.finalizeFlight, "finalizeFlight"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeGalleyMap, "includeGalleyMap"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeSealList, "includeSealList"));
        CheckBoxAnalysisItem includeCrewClasses = new CheckBoxAnalysisItem(this.includeCrewClasses, "includeCrewClasses");
        includeCrewClasses.setSubItem(new CheckBoxAnalysisItem(this.summarizeCrew, "summarizeCrew"));
        this.addOptionsItem(includeCrewClasses);
        if (this.hideNSDSFlights != null) {
            this.addOptionsItem(new CheckBoxAnalysisItem(this.hideNSDSFlights, "hideNSDSFlights"));
        }
        this.addOptionsItem(new ComboBoxAnalysisItem(this.department, "department"));
        this.addOptionsItem(new ComboBoxAnalysisItem(this.colors, "colors"));
        ((CheckBox)((TitledItem)includeCrewClasses.getElement()).getElement()).addButtonListener(new ButtonListener(){

            @Override
            public void buttonPressed(Button source, int x, int y) {
                boolean checked = AnalysisPrintFlightStowingListComponent.this.getIncludeCrewClasses().getElement().isChecked();
                TitledItem<CheckBox> summarizeCrew = AnalysisPrintFlightStowingListComponent.this.getSummarizeCrew();
                summarizeCrew.setEnabled(checked);
                if (!checked) {
                    summarizeCrew.getElement().setChecked(checked);
                }
            }
        });
    }

    @Override
    public String getTitleValue() {
        return Words.ALL + " " + Words.SELECTED;
    }

    @Override
    public GenericAnalysisReportType getReportType() {
        return GenericAnalysisReportType.AnalysisStowingLists;
    }

    @Override
    protected AGenericReportConfiguration getReportConfiguration() {
        FlightAnalysisStowingListConfiguration config = new FlightAnalysisStowingListConfiguration();
        config.setReportType(this.getReportType());
        config.setFinalizePaxType(Boolean.valueOf(this.finalizeFlight.getElement().isChecked()));
        config.setIncludeGalleyMap(Boolean.valueOf(this.includeGalleyMap.getElement().isChecked()));
        config.setIncludeCrewPax(Boolean.valueOf(this.includeCrewClasses.getElement().isChecked()));
        config.setSummarizeCrew(Boolean.valueOf(this.summarizeCrew.getElement().isChecked()));
        config.setIncludeSealList(Boolean.valueOf(this.includeSealList.getElement().isChecked()));
        if (this.colors.getElement().getSelectedItem() instanceof Node) {
            Node c = (Node)this.colors.getElement().getSelectedItem();
            config.setLabelColor((ColorComplete)c.getValue());
        } else {
            config.setLabelColor(null);
        }
        if (this.department.getElement().getSelectedItem() instanceof Node) {
            Node d = (Node)this.department.getElement().getSelectedItem();
            config.setDepartment((CostCenterComplete)d.getValue());
        } else {
            config.setDepartment(null);
        }
        ReportingOutputFormatE format = ReportingOutputFormatE.PDF;
        config.setReportFormatType(format);
        return config;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.summarizeCrew.setEnabled(enabled && this.includeCrewClasses.getElement().isChecked());
    }

    public TitledItem<CheckBox> getIncludeCrewClasses() {
        return this.includeCrewClasses;
    }

    public TitledItem<CheckBox> getSummarizeCrew() {
        return this.summarizeCrew;
    }

    @Override
    public String getFileEnding() {
        return ".pdf";
    }
}

