/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.product.remote.salesforecast;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.product.remote.salesforecast.ProductForecastFactorTable;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.AsynchronusAnalysisPopupInsert;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.PeriodEditorAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.TableAnalysisItem;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.ListNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.search.SearchResultIterator;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.report.AGenericReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.analysis.product.ProductSalesForecastAnalysisReportConfiguration;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import java.sql.Date;
import java.util.Iterator;

public class ProductSalesForecastAnalysisComponent
extends AsynchronusAnalysisPopupInsert<ProductComplete> {
    private static final long serialVersionUID = 1L;
    private TitledPeriodEditor foreCastPeriod;
    private ProductForecastFactorTable productTable;
    ListNode productListNode;

    public ProductSalesForecastAnalysisComponent(AnalysisSmartExternalOpenTool<ProductComplete> subProv) {
        super(subProv);
        this.getLoadBeforeShowing().add(() -> {
            try {
                SearchResultIterator sri = new SearchResultIterator(subProv.getFilteredConfig());
                while (sri.hasNext()) {
                    ProductComplete next = (ProductComplete)sri.next();
                    Node node = new Node();
                    DTOProxyNode pNode = new DTOProxyNode();
                    pNode.setName("product");
                    pNode.setValue((Object)next, 0L);
                    Node fNode = new Node();
                    fNode.setName("factor");
                    fNode.setValue((Object)1.0, 0L);
                    node.addChild((Node)pNode, 0L);
                    node.addChild(fNode, 0L);
                    this.productListNode.addChild(node, 0L);
                }
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public void addOptionItems() {
        PeriodComplete period = new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis()));
        Node periodNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)period, false, false);
        this.foreCastPeriod = new TitledPeriodEditor((Node<PeriodComplete>)periodNode, true, null, "Forecast Period");
        this.productTable = new ProductForecastFactorTable();
        this.productListNode = new ListNode();
        this.productTable.setNode((Node<?>)this.productListNode);
        this.addOptionsItem(new PeriodEditorAnalysisItem(this.foreCastPeriod, "foreCastPeriod"));
        this.addOptionsItem(new TableAnalysisItem(this.productTable, "products"));
    }

    @Override
    protected AGenericReportConfiguration getReportConfiguration() {
        ProductSalesForecastAnalysisReportConfiguration conf = new ProductSalesForecastAnalysisReportConfiguration();
        conf.setForecastPeriod(this.foreCastPeriod.getPeriod());
        Iterator it = this.productTable.getModel().getNode().getFailSafeChildIterator();
        while (it.hasNext()) {
            Node next = (Node)it.next();
            ProductComplete product = (ProductComplete)next.getChildNamed(new String[]{"product"}).getValue();
            Double factor = (Double)next.getChildNamed(new String[]{"factor"}).getValue();
            conf.getFactorMap().put(product, factor);
        }
        return conf;
    }
}

