/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.product.remote.transaction;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.PeriodEditorAnalysisItem;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.ProductReportServiceManager;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Iterator;

public class ProductTransactionsAnalysisComponent
extends DefaultServerSideAnalysisComponent<ProductComplete, ProductReference> {
    private static final long serialVersionUID = 1L;
    private TitledPeriodEditor period;

    public ProductTransactionsAnalysisComponent(AnalysisSmartExternalOpenTool<ProductComplete> defaultAnalysis) {
        super(defaultAnalysis, false, true);
    }

    @Override
    public void addOptionItems() {
        PeriodComplete p = new PeriodComplete();
        p.setStartDate(new Date(System.currentTimeMillis()));
        p.setEndDate(new Date(System.currentTimeMillis()));
        Node periodNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)p, false, false);
        this.period = new TitledPeriodEditor((Node<Date>)periodNode.getChildNamed(PeriodComplete_.startDate), (Node<Date>)periodNode.getChildNamed(PeriodComplete_.endDate), true, null);
        this.addOptionsItem(new PeriodEditorAnalysisItem(this.period, "period"));
    }

    @Override
    public String getTitleString() {
        return Words.TRANSACTIONS;
    }

    @Override
    public String getTitleValue() {
        return Words.PRODUCT;
    }

    @Override
    public ProductReference createReference(ProductComplete item) {
        return new ProductReference(item.getId());
    }

    @Override
    public PegasusFileComplete createReport() throws Exception {
        PeriodComplete selectedPeriod = this.period.getPeriod();
        ArrayList<ProductReference> references = new ArrayList<ProductReference>();
        Iterator s = this.getIterator();
        while (s.hasNext()) {
            references.add(this.createReference((ProductComplete)s.next()));
        }
        PegasusFileComplete file = (PegasusFileComplete)((ProductReportServiceManager)ServiceManagerRegistry.getService(ProductReportServiceManager.class)).createTransactionReport(new ListWrapper(references), selectedPeriod).getValue();
        return file;
    }
}

