/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.product.remote.usage;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.DateChooserAnalysisItem;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyReportServiceManager;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TimestampWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Iterator;

public class AnalysisProductUsageDetailsComponent
extends DefaultServerSideAnalysisComponent<ProductComplete, ProductReference> {
    private static final long serialVersionUID = 1L;
    private TitledItem<DateChooser> validityDate;

    public AnalysisProductUsageDetailsComponent(AnalysisSmartExternalOpenTool<ProductComplete> defaultAnalysis) {
        super(defaultAnalysis);
    }

    @Override
    public void addOptionItems() {
        Node dateNode = new Node();
        dateNode.setValue((Object)new Date(System.currentTimeMillis()), 0L);
        this.validityDate = new TitledItem<DateChooser>(new DateChooser(dateNode), Words.DUE_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.addOptionsItem(new DateChooserAnalysisItem(this.validityDate, "dueDate"));
    }

    @Override
    public String getTitleString() {
        return Words.PRODUCT_USAGE;
    }

    @Override
    public String getTitleValue() {
        return Words.PRODUCT;
    }

    @Override
    public ProductReference createReference(ProductComplete item) {
        return new ProductReference(item.getId());
    }

    @Override
    public PegasusFileComplete createReport() throws Exception {
        Date date = (Date)this.validityDate.getElement().getNode().getValue();
        ArrayList<ProductReference> references = new ArrayList<ProductReference>();
        Iterator s = this.getIterator();
        while (s.hasNext()) {
            ProductReference v = (ProductReference)s.next();
            references.add(new ProductReference(v.getId()));
        }
        return (PegasusFileComplete)((SupplyReportServiceManager)ServiceManagerRegistry.getService(SupplyReportServiceManager.class)).getProductUsageDetailedReport(new ListWrapper(references), new TimestampWrapper(date.getTime())).getValue();
    }
}

