/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.purchaseorder.label;

import ch.icit.pegasus.client.converter.StandaloneContactConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.OrderReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.masterdata.ContactComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight;
import ch.icit.pegasus.server.core.dtos.report.PurchaseOrderOpenPositionReportConfiguration;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.List;

public class PrintOrderArticleLabelComponent
extends DefaultScrollablePrintPopup2<PurchaseOrderLight> {
    private static final long serialVersionUID = 1L;
    private TitledItem<DateChooser> selectedDate;
    private TitledItem<ComboBox> deliveryAddresses;
    private TitledItem<CheckBox> includeBarCode;
    private TitledItem<TextField> startPosition;
    private TitledItem<CheckBox> printSuppliersSeparately;

    public PrintOrderArticleLabelComponent() {
        super(false, false, ReportTypeE.ARTICLE_STORE_INFO_SHEET);
    }

    @Override
    public void insertElements() {
        this.createComponents();
        this.selectedDate = new TitledItem<DateChooser>(new DateChooser(INodeCreator.getDefaultImpl().getNode4DTO((Object)new Date(System.currentTimeMillis()), false, false)), Words.DATE_SCHED_DELIVERY, TitledItem.TitledItemOrientation.NORTH);
        this.deliveryAddresses = new TitledItem<ComboBox>(new ComboBox((Node)new DTOProxyNode(), NodeToolkit.getAffixClass(SystemSettingsComplete.class).getChildNamed(SystemSettingsComplete_.deliveryAddresses), ConverterRegistry.getConverter(StandaloneContactConverter.class)), Words.DELIVERY_ADDRESS, TitledItem.TitledItemOrientation.NORTH);
        this.printSuppliersSeparately = new TitledItem<CheckBox>(new CheckBox(), Words.PRINT_SUPPLIERS_SEPARATELY, TitledItem.TitledItemOrientation.EAST);
        this.printSuppliersSeparately.getElement().addButtonListener(new ButtonListener(){

            @Override
            public void buttonPressed(Button source, int x, int y) {
                if (((CheckBox)PrintOrderArticleLabelComponent.this.printSuppliersSeparately.getElement()).isChecked()) {
                    PrintOrderArticleLabelComponent.this.startPosition.setEnabled(false);
                } else {
                    PrintOrderArticleLabelComponent.this.startPosition.setEnabled(true);
                }
            }
        });
        this.includeBarCode = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_BAR_CODE, TitledItem.TitledItemOrientation.EAST);
        this.startPosition = new TitledItem<TextField>(new TextField(null, TextFieldType.INT), Words.START_POSITION, TitledItem.TitledItemOrientation.NORTH);
        this.startPosition.getElement().setText("1");
        this.selectedDate.setVisible(true);
        this.deliveryAddresses.setVisible(true);
        this.printSuppliersSeparately.setVisible(true);
        this.includeBarCode.setVisible(true);
        this.getViewContainer().setLayout(new Layout());
        this.getViewContainer().add(this.selectedDate);
        this.getViewContainer().add(this.deliveryAddresses);
        this.getViewContainer().add(this.printSuppliersSeparately);
        this.getViewContainer().add(this.includeBarCode);
        this.getViewContainer().add(this.startPosition);
    }

    @Override
    public boolean isReportAllowed(ReportFileComplete reportFile) {
        return reportFile.getDescription().contains("Label");
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        return null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        this.selectedDate.setVisible(true);
        this.deliveryAddresses.setVisible(true);
        this.printSuppliersSeparately.setVisible(true);
        this.includeBarCode.setVisible(true);
        this.startPosition.setVisible(true);
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        this.selectedDate.setVisible(false);
        this.deliveryAddresses.setVisible(false);
        this.printSuppliersSeparately.setVisible(false);
        this.includeBarCode.setVisible(false);
        this.startPosition.setVisible(false);
    }

    @Override
    public boolean isInnerComponent(Component c) {
        if (super.isInnerComponent(c)) {
            return true;
        }
        if (this.deliveryAddresses != null && this.deliveryAddresses.getElement().getCurrentPopUp() != null) {
            for (Component currentC = c; currentC != null; currentC = currentC.getParent()) {
                if (!currentC.equals(this.deliveryAddresses.getElement().getCurrentPopUp())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                PurchaseOrderOpenPositionReportConfiguration p = new PurchaseOrderOpenPositionReportConfiguration();
                p.setStylesheet(PrintOrderArticleLabelComponent.this.getSelectedReport());
                if (((ComboBox)PrintOrderArticleLabelComponent.this.deliveryAddresses.getElement()).getNode().getValue() != null) {
                    p.setDeliveryAddress((ContactComplete)((ComboBox)PrintOrderArticleLabelComponent.this.deliveryAddresses.getElement()).getNode().getValue());
                }
                if (((DateChooser)PrintOrderArticleLabelComponent.this.selectedDate.getElement()).getSelectedDate() != null) {
                    p.setSelectedDate(new Date(((DateChooser)PrintOrderArticleLabelComponent.this.selectedDate.getElement()).getSelectedDate().getTime()));
                }
                if (PrintOrderArticleLabelComponent.this.printSuppliersSeparately.getElement() != null) {
                    p.setPrintSuppliersSeparately(((CheckBox)PrintOrderArticleLabelComponent.this.printSuppliersSeparately.getElement()).isChecked());
                }
                if (p.getSelectedDate() != null) {
                    p.setSelectedDate(new PeriodComplete(new Date(p.getSelectedDate().getTime()), new Date(p.getSelectedDate().getTime())).getStartDate());
                }
                p.setIncludeBarCode(((CheckBox)PrintOrderArticleLabelComponent.this.includeBarCode.getElement()).isChecked());
                if (!((TextField)PrintOrderArticleLabelComponent.this.startPosition.getElement()).getText().isEmpty()) {
                    try {
                        p.setStartPosition(Integer.valueOf(((TextField)PrintOrderArticleLabelComponent.this.startPosition.getElement()).getText()).intValue());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        p.setStartPosition(1);
                    }
                } else {
                    p.setStartPosition(1);
                }
                PegasusFileComplete t = (PegasusFileComplete)((OrderReportServiceManager)ServiceManagerRegistry.getService(OrderReportServiceManager.class)).createDailyLabels(p).getValue();
                PrintOrderArticleLabelComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintOrderArticleLabelComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<PurchaseOrderLight> getCurrentNode() {
        return null;
    }

    @Override
    public BatchJob<PurchaseOrderLight> createBatchJob(Node<PurchaseOrderLight> value, ThreadSafeExecutable job) {
        return null;
    }

    @Override
    public String getTitleString() {
        return Words.LABELS;
    }

    @Override
    public String getTitleValue() {
        return Words.ALL;
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> focusList = super.getFocusComponents();
        CheckedListAdder.addToList(focusList, this.selectedDate);
        CheckedListAdder.addToList(focusList, this.deliveryAddresses);
        CheckedListAdder.addToList(focusList, this.includeBarCode);
        CheckedListAdder.addToList(focusList, this.startPosition);
        CheckedListAdder.addToList(focusList, this.printSuppliersSeparately);
        return focusList;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.selectedDate.kill();
        this.deliveryAddresses.kill();
        this.includeBarCode.kill();
        this.startPosition.kill();
        this.printSuppliersSeparately.kill();
        this.selectedDate = null;
        this.deliveryAddresses = null;
        this.includeBarCode = null;
        this.startPosition = null;
        this.printSuppliersSeparately = null;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int y = PrintOrderArticleLabelComponent.this.getInheritedComponentsHeight();
            y += PrintOrderArticleLabelComponent.this.border;
            y = (int)((double)y + PrintOrderArticleLabelComponent.this.selectedDate.getPreferredSize().getHeight());
            y += PrintOrderArticleLabelComponent.this.border / 2;
            y = (int)((double)y + PrintOrderArticleLabelComponent.this.deliveryAddresses.getPreferredSize().getHeight());
            y += PrintOrderArticleLabelComponent.this.border;
            y = (int)((double)y + PrintOrderArticleLabelComponent.this.includeBarCode.getPreferredSize().getHeight());
            y += PrintOrderArticleLabelComponent.this.border;
            y = (int)((double)y + PrintOrderArticleLabelComponent.this.startPosition.getPreferredSize().getHeight());
            y += PrintOrderArticleLabelComponent.this.border;
            y = (int)((double)y + PrintOrderArticleLabelComponent.this.printSuppliersSeparately.getPreferredSize().getHeight());
            return new Dimension(0, y += PrintOrderArticleLabelComponent.this.border);
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintOrderArticleLabelComponent.this.layoutInheritedComponents(parent);
            PrintOrderArticleLabelComponent.this.selectedDate.setLocation(PrintOrderArticleLabelComponent.this.border, y += PrintOrderArticleLabelComponent.this.border);
            PrintOrderArticleLabelComponent.this.selectedDate.setSize(PrintOrderArticleLabelComponent.this.selectedDate.getPreferredSize());
            PrintOrderArticleLabelComponent.this.deliveryAddresses.setLocation(PrintOrderArticleLabelComponent.this.border, PrintOrderArticleLabelComponent.this.selectedDate.getY() + PrintOrderArticleLabelComponent.this.selectedDate.getHeight() + PrintOrderArticleLabelComponent.this.border / 2);
            PrintOrderArticleLabelComponent.this.deliveryAddresses.setSize(parent.getWidth() - 2 * PrintOrderArticleLabelComponent.this.border, (int)PrintOrderArticleLabelComponent.this.deliveryAddresses.getPreferredSize().getHeight());
            PrintOrderArticleLabelComponent.this.printSuppliersSeparately.setLocation(PrintOrderArticleLabelComponent.this.border, PrintOrderArticleLabelComponent.this.deliveryAddresses.getY() + PrintOrderArticleLabelComponent.this.deliveryAddresses.getHeight() + PrintOrderArticleLabelComponent.this.border);
            PrintOrderArticleLabelComponent.this.printSuppliersSeparately.setSize(parent.getWidth() - 2 * PrintOrderArticleLabelComponent.this.border, (int)PrintOrderArticleLabelComponent.this.printSuppliersSeparately.getPreferredSize().getHeight());
            PrintOrderArticleLabelComponent.this.includeBarCode.setLocation(PrintOrderArticleLabelComponent.this.border, PrintOrderArticleLabelComponent.this.printSuppliersSeparately.getY() + PrintOrderArticleLabelComponent.this.printSuppliersSeparately.getHeight() + PrintOrderArticleLabelComponent.this.border);
            PrintOrderArticleLabelComponent.this.includeBarCode.setSize(parent.getWidth() - 2 * PrintOrderArticleLabelComponent.this.border, (int)PrintOrderArticleLabelComponent.this.includeBarCode.getPreferredSize().getHeight());
            PrintOrderArticleLabelComponent.this.startPosition.setLocation(PrintOrderArticleLabelComponent.this.border, PrintOrderArticleLabelComponent.this.includeBarCode.getY() + PrintOrderArticleLabelComponent.this.includeBarCode.getHeight() + PrintOrderArticleLabelComponent.this.border);
            PrintOrderArticleLabelComponent.this.startPosition.setSize(parent.getWidth() - 2 * PrintOrderArticleLabelComponent.this.border, (int)PrintOrderArticleLabelComponent.this.startPosition.getPreferredSize().getHeight());
        }
    }
}

