/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.recipe.content;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.DateChooserAnalysisItem;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.RecipeReportServiceManager;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TimestampWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;

public class AnalysisRecipeInRecipeComponent
extends DefaultServerSideAnalysisComponent<RecipeComplete, RecipeComplete> {
    private static final long serialVersionUID = 1L;
    private TitledItem<DateChooser> dueDate;

    public AnalysisRecipeInRecipeComponent(AnalysisSmartExternalOpenTool<RecipeComplete> defaultAnalysis) {
        super(defaultAnalysis);
    }

    @Override
    public void addOptionItems() {
        Node node = INodeCreator.getDefaultImpl().getNode4DTO((Object)new Date(System.currentTimeMillis()), false, false);
        this.dueDate = new TitledItem<DateChooser>(new DateChooser(node), Words.DUE_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.dueDate.setIgnorePrefHeight(true);
        this.addOptionsItem(new DateChooserAnalysisItem(this.dueDate, "dueDate"));
    }

    @Override
    public String getTitleString() {
        return Words.RECIPE_CONTENT;
    }

    @Override
    public RecipeComplete createReference(RecipeComplete item) {
        return item;
    }

    @Override
    public PegasusFileComplete createReport() throws ServiceException {
        List recipes = this.loadItemReferences();
        Date date = (Date)this.dueDate.getElement().getNode().getValue();
        Timestamp ts = new Timestamp(date.getTime());
        PegasusFileComplete file = (PegasusFileComplete)((RecipeReportServiceManager)ServiceManagerRegistry.getService(RecipeReportServiceManager.class)).getRecipeContentReport(new ListWrapper(recipes), new TimestampWrapper(ts)).getValue();
        return file;
    }
}

