/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.export.mealplan.specification;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.ProductReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanLight;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanLight_;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanReference;
import ch.icit.pegasus.server.core.dtos.report.MealPlanReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.sql.Date;
import java.sql.Timestamp;

public class ExportMealPlanComponent
extends DefaultScrollablePrintPopup2<MealPlanLight>
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private final Node<MealPlanLight> currentMealPlan;
    protected TextLabel printOptionTitle;
    private TitledItem<DateChooser> dueDate;
    private TitledItem<CheckBox> includeDeletedServices;
    private TitledItem<CheckBox> includeLoadingGroupDetails;

    public ExportMealPlanComponent(Node<MealPlanLight> node) {
        super(false, false, false, false, ReportTypeE.PRODUCT);
        this.currentMealPlan = node;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        Font f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
        Color fb = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color"));
        this.printOptionTitle = new TextLabel(Words.OPTIONS);
        this.printOptionTitle.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_titled_item_font_type")));
        this.printOptionTitle.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_titled_item_foreground")));
        this.dueDate = new TitledItem<DateChooser>(new DateChooser(), Words.DUE_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.dueDate.getElement().setNode(INodeCreator.getDefaultImpl().getNode4DTO((Object)new Date(System.currentTimeMillis()), false, false));
        this.includeDeletedServices = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_DELETED_SERVICES, TitledItem.TitledItemOrientation.EAST);
        this.includeDeletedServices.setTitleFont(f);
        this.includeDeletedServices.setTitleForeground(fb);
        this.includeLoadingGroupDetails = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_LOADING_GROUP_DETAILS, TitledItem.TitledItemOrientation.EAST);
        this.includeLoadingGroupDetails.setTitleFont(f);
        this.includeLoadingGroupDetails.setTitleForeground(fb);
        this.getViewContainer().add(this.printOptionTitle);
        this.getViewContainer().add(this.dueDate);
        this.getViewContainer().add(this.includeDeletedServices);
        this.getViewContainer().add(this.includeLoadingGroupDetails);
        this.setEnabled(true);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.dueDate.setEnabled(isEnabled);
        this.includeDeletedServices.setEnabled(isEnabled);
        this.includeLoadingGroupDetails.setEnabled(isEnabled);
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String v = s[1];
            Boolean b = Boolean.valueOf(v);
            if (n.equals("include_deleted_services")) {
                this.includeDeletedServices.getElement().setChecked(b);
            }
            if (!n.equals("include_loading_group_details")) continue;
            this.includeLoadingGroupDetails.getElement().setChecked(b);
        }
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        conf.addProperty("include_deleted_services", "" + this.includeDeletedServices.getElement().isChecked());
        conf.addProperty("include_loading_group_details", "" + this.includeLoadingGroupDetails.getElement().isChecked());
        return conf;
    }

    @Override
    public String getTitleString() {
        return Words.MEALPLAN;
    }

    @Override
    public String getTitleValue() {
        return (String)this.currentMealPlan.getChildNamed(MealPlanLight_.name).getValue();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.printOptionTitle != null) {
            this.printOptionTitle.kill();
        }
        if (this.dueDate != null) {
            this.dueDate.kill();
        }
        this.includeDeletedServices.kill();
        this.includeLoadingGroupDetails.kill();
        this.printOptionTitle = null;
        this.dueDate = null;
        this.includeDeletedServices = null;
        this.includeLoadingGroupDetails = null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.printOptionTitle != null) {
            this.printOptionTitle.setVisible(true);
        }
        if (this.dueDate != null) {
            this.dueDate.setVisible(true);
        }
        if (this.includeDeletedServices != null) {
            this.includeDeletedServices.setVisible(true);
        }
        if (this.includeLoadingGroupDetails != null) {
            this.includeLoadingGroupDetails.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.printOptionTitle != null) {
            this.printOptionTitle.setVisible(false);
        }
        if (this.dueDate != null) {
            this.dueDate.setVisible(false);
        }
        if (this.includeDeletedServices != null) {
            this.includeDeletedServices.setVisible(false);
        }
        if (this.includeLoadingGroupDetails != null) {
            this.includeLoadingGroupDetails.setVisible(false);
        }
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                MealPlanReportConfiguration conf = new MealPlanReportConfiguration();
                conf.setDueDate(new Timestamp(((Date)((DateChooser)ExportMealPlanComponent.this.dueDate.getElement()).getNode().getValue()).getTime()));
                conf.setIncludeDeletedServices(((CheckBox)ExportMealPlanComponent.this.includeDeletedServices.getElement()).isChecked());
                conf.setIncludeLoadingGroupDetails(((CheckBox)ExportMealPlanComponent.this.includeLoadingGroupDetails.getElement()).isChecked());
                conf.setMealPlanNumber(((MealPlanLight)ExportMealPlanComponent.this.currentMealPlan.getValue()).getNumber());
                conf.setReportFormatType(ReportingOutputFormatE.XLSX);
                PegasusFileComplete t = (PegasusFileComplete)((ProductReportServiceManager)ServiceManagerRegistry.getService(ProductReportServiceManager.class)).exportMealPlanSpecification((MealPlanReference)ExportMealPlanComponent.this.currentMealPlan.getValue(), conf).getValue();
                ExportMealPlanComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ExportMealPlanComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<MealPlanLight> getCurrentNode() {
        return this.currentMealPlan;
    }

    @Override
    public BatchJob<MealPlanLight> createBatchJob(Node<MealPlanLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = ExportMealPlanComponent.this.layoutInheritedComponents(parent);
            if (ExportMealPlanComponent.this.printOptionTitle != null) {
                ExportMealPlanComponent.this.printOptionTitle.setLocation(ExportMealPlanComponent.this.border, y + ExportMealPlanComponent.this.border);
                ExportMealPlanComponent.this.printOptionTitle.setSize(parent.getWidth() - 2 * ExportMealPlanComponent.this.border, (int)ExportMealPlanComponent.this.printOptionTitle.getPreferredSize().getHeight());
                y = ExportMealPlanComponent.this.printOptionTitle.getY() + ExportMealPlanComponent.this.printOptionTitle.getHeight() + ExportMealPlanComponent.this.border;
            }
            if (ExportMealPlanComponent.this.dueDate != null) {
                ExportMealPlanComponent.this.dueDate.setLocation(ExportMealPlanComponent.this.border, y + ExportMealPlanComponent.this.border);
                ExportMealPlanComponent.this.dueDate.setSize((int)ExportMealPlanComponent.this.dueDate.getPreferredSize().getWidth(), (int)ExportMealPlanComponent.this.dueDate.getPreferredSize().getHeight());
                y = ExportMealPlanComponent.this.dueDate.getY() + ExportMealPlanComponent.this.dueDate.getHeight() + ExportMealPlanComponent.this.border;
            }
            if (ExportMealPlanComponent.this.includeDeletedServices != null) {
                ExportMealPlanComponent.this.includeDeletedServices.setLocation(ExportMealPlanComponent.this.border, y + ExportMealPlanComponent.this.border / 2);
                ExportMealPlanComponent.this.includeDeletedServices.setSize(parent.getWidth() - 2 * ExportMealPlanComponent.this.border, (int)ExportMealPlanComponent.this.includeDeletedServices.getPreferredSize().getHeight());
                y = ExportMealPlanComponent.this.includeDeletedServices.getY() + ExportMealPlanComponent.this.includeDeletedServices.getHeight();
            }
            if (ExportMealPlanComponent.this.includeLoadingGroupDetails != null) {
                ExportMealPlanComponent.this.includeLoadingGroupDetails.setLocation(ExportMealPlanComponent.this.border, y + ExportMealPlanComponent.this.border / 2);
                ExportMealPlanComponent.this.includeLoadingGroupDetails.setSize(parent.getWidth() - 2 * ExportMealPlanComponent.this.border, (int)ExportMealPlanComponent.this.includeLoadingGroupDetails.getPreferredSize().getHeight());
                y = ExportMealPlanComponent.this.includeLoadingGroupDetails.getY() + ExportMealPlanComponent.this.includeLoadingGroupDetails.getHeight();
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = ExportMealPlanComponent.this.getInheritedComponentsHeight();
            int w = 250;
            h += ExportMealPlanComponent.this.border;
            if (ExportMealPlanComponent.this.printOptionTitle != null) {
                h = (int)((double)h + ExportMealPlanComponent.this.printOptionTitle.getPreferredSize().getHeight());
                h += ExportMealPlanComponent.this.border;
            }
            if (ExportMealPlanComponent.this.dueDate != null) {
                h = (int)((double)h + ExportMealPlanComponent.this.dueDate.getPreferredSize().getHeight());
                h += ExportMealPlanComponent.this.border;
            }
            if (ExportMealPlanComponent.this.includeDeletedServices != null) {
                h = (int)((double)h + ExportMealPlanComponent.this.includeDeletedServices.getPreferredSize().getHeight());
                h += ExportMealPlanComponent.this.border;
            }
            if (ExportMealPlanComponent.this.includeLoadingGroupDetails != null) {
                h = (int)((double)h + ExportMealPlanComponent.this.includeLoadingGroupDetails.getPreferredSize().getHeight());
                h += ExportMealPlanComponent.this.border;
            }
            return new Dimension(w, h);
        }
    }
}

