/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.export.stowinglist;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.ProductReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLight_;
import ch.icit.pegasus.server.core.dtos.report.GenericStowingListReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Collections;

public class ExportStowingListComponent
extends DefaultScrollablePrintPopup2<StowingListTemplateComplete>
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private final Node<StowingListTemplateComplete> currentStowingList;
    protected TextLabel printOptionTitle;
    private TitledItem<CheckBox> includeMealPlan;
    private TitledItem<CheckBox> includeStowingListConfig;
    private TitledItem<DateChooser> dueDate;
    private TitledItem<CheckBox> includeAllVariants;

    public ExportStowingListComponent(Node<StowingListTemplateComplete> node) {
        super(false, false, false, false, ReportTypeE.PRODUCT);
        this.currentStowingList = node;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        Font f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
        Color fb = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color"));
        this.printOptionTitle = new TextLabel(Words.OPTIONS);
        this.printOptionTitle.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_titled_item_font_type")));
        this.printOptionTitle.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_titled_item_foreground")));
        this.includeStowingListConfig = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_STOWING_LIST_CONFIG, TitledItem.TitledItemOrientation.EAST);
        this.includeStowingListConfig.setTitleFont(f);
        this.includeStowingListConfig.setTitleForeground(fb);
        this.includeMealPlan = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_MEAL_PLAN, TitledItem.TitledItemOrientation.EAST);
        this.includeMealPlan.setTitleFont(f);
        this.includeMealPlan.setTitleForeground(fb);
        this.includeAllVariants = new TitledItem<CheckBox>(new CheckBox(), "Include all Variants", TitledItem.TitledItemOrientation.EAST);
        this.dueDate = new TitledItem<DateChooser>(new DateChooser(), Words.DUE_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.dueDate.getElement().setNode(INodeCreator.getDefaultImpl().getNode4DTO((Object)new Date(System.currentTimeMillis()), false, false));
        this.getViewContainer().add(this.printOptionTitle);
        this.getViewContainer().add(this.dueDate);
        this.getViewContainer().add(this.includeStowingListConfig);
        this.getViewContainer().add(this.includeMealPlan);
        this.getViewContainer().add(this.includeAllVariants);
        this.setEnabled(true);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.printOptionTitle.setEnabled(isEnabled);
        this.dueDate.setEnabled(isEnabled);
        this.includeStowingListConfig.setEnabled(isEnabled);
        this.includeMealPlan.setEnabled(isEnabled);
        this.includeAllVariants.setEnabled(isEnabled);
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String v = s[1];
            Boolean b = Boolean.valueOf(v);
            if (n.equals("include_stowing_list_config")) {
                this.includeStowingListConfig.getElement().setChecked(b);
            }
            if (n.equals("include_deleted_services")) {
                this.includeMealPlan.getElement().setChecked(b);
            }
            if (!n.equals("include_all_variants")) continue;
            this.includeAllVariants.getElement().setChecked(b);
        }
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        conf.addProperty("include_stowing_list_config", "" + this.includeStowingListConfig.getElement().isChecked());
        conf.addProperty("include_deleted_services", "" + this.includeMealPlan.getElement().isChecked());
        conf.addProperty("include_all_variants", "" + this.includeAllVariants.getElement().isChecked());
        return conf;
    }

    @Override
    public String getTitleString() {
        return Words.STOWING_LIST;
    }

    @Override
    public String getTitleValue() {
        return (String)this.currentStowingList.getChildNamed(new DtoField[]{StowingListTemplateComplete_.currentVariant, StowingListTemplateVariantLight_.name}).getValue();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.printOptionTitle != null) {
            this.printOptionTitle.kill();
        }
        if (this.includeStowingListConfig != null) {
            this.includeStowingListConfig.kill();
        }
        if (this.includeMealPlan != null) {
            this.includeMealPlan.kill();
        }
        if (this.dueDate != null) {
            this.dueDate.kill();
        }
        if (this.includeAllVariants != null) {
            this.includeAllVariants.kill();
        }
        this.printOptionTitle = null;
        this.dueDate = null;
        this.includeStowingListConfig = null;
        this.includeMealPlan = null;
        this.includeAllVariants = null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.printOptionTitle != null) {
            this.printOptionTitle.setVisible(true);
        }
        if (this.dueDate != null) {
            this.dueDate.setVisible(true);
        }
        if (this.includeStowingListConfig != null) {
            this.includeStowingListConfig.setVisible(true);
        }
        if (this.includeMealPlan != null) {
            this.includeMealPlan.setVisible(true);
        }
        if (this.includeAllVariants != null) {
            this.includeAllVariants.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.printOptionTitle != null) {
            this.printOptionTitle.setVisible(false);
        }
        if (this.dueDate != null) {
            this.dueDate.setVisible(false);
        }
        if (this.includeStowingListConfig != null) {
            this.includeStowingListConfig.setVisible(false);
        }
        if (this.includeMealPlan != null) {
            this.includeMealPlan.setVisible(false);
        }
        if (this.includeAllVariants != null) {
            this.includeAllVariants.setVisible(false);
        }
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                GenericStowingListReportConfiguration conf = new GenericStowingListReportConfiguration();
                conf.setDueDate(new Timestamp(((Date)((DateChooser)ExportStowingListComponent.this.dueDate.getElement()).getNode().getValue()).getTime()));
                conf.setIncludeStowingListConfiguration(Boolean.valueOf(((CheckBox)ExportStowingListComponent.this.includeStowingListConfig.getElement()).isChecked()));
                conf.setIncludeMealPlan(Boolean.valueOf(((CheckBox)ExportStowingListComponent.this.includeMealPlan.getElement()).isChecked()));
                conf.setStowingListNumber(((StowingListTemplateComplete)ExportStowingListComponent.this.currentStowingList.getValue()).getNumber());
                conf.setIncludeAllVariants(Boolean.valueOf(((CheckBox)ExportStowingListComponent.this.includeAllVariants.getElement()).isChecked()));
                conf.setReportFormatType(ReportingOutputFormatE.XLSX);
                PegasusFileComplete t = (PegasusFileComplete)((ProductReportServiceManager)ServiceManagerRegistry.getService(ProductReportServiceManager.class)).exportStowingListSpecification(new ListWrapper(Collections.singletonList(ExportStowingListComponent.this.currentStowingList.getValue())), conf).getValue();
                ExportStowingListComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ExportStowingListComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<StowingListTemplateComplete> getCurrentNode() {
        return this.currentStowingList;
    }

    @Override
    public BatchJob<StowingListTemplateComplete> createBatchJob(Node<StowingListTemplateComplete> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = ExportStowingListComponent.this.layoutInheritedComponents(parent);
            if (ExportStowingListComponent.this.printOptionTitle != null) {
                ExportStowingListComponent.this.printOptionTitle.setLocation(ExportStowingListComponent.this.border, y + ExportStowingListComponent.this.border);
                ExportStowingListComponent.this.printOptionTitle.setSize(parent.getWidth() - 2 * ExportStowingListComponent.this.border, (int)ExportStowingListComponent.this.printOptionTitle.getPreferredSize().getHeight());
                y = ExportStowingListComponent.this.printOptionTitle.getY() + ExportStowingListComponent.this.printOptionTitle.getHeight() + ExportStowingListComponent.this.border;
            }
            if (ExportStowingListComponent.this.dueDate != null) {
                ExportStowingListComponent.this.dueDate.setLocation(ExportStowingListComponent.this.border, y + ExportStowingListComponent.this.border);
                ExportStowingListComponent.this.dueDate.setSize((int)ExportStowingListComponent.this.dueDate.getPreferredSize().getWidth(), (int)ExportStowingListComponent.this.dueDate.getPreferredSize().getHeight());
                y = ExportStowingListComponent.this.dueDate.getY() + ExportStowingListComponent.this.dueDate.getHeight() + ExportStowingListComponent.this.border;
            }
            if (ExportStowingListComponent.this.includeStowingListConfig != null) {
                ExportStowingListComponent.this.includeStowingListConfig.setLocation(ExportStowingListComponent.this.border, y + ExportStowingListComponent.this.border / 2);
                ExportStowingListComponent.this.includeStowingListConfig.setSize(parent.getWidth() - 2 * ExportStowingListComponent.this.border, (int)ExportStowingListComponent.this.includeStowingListConfig.getPreferredSize().getHeight());
                y = ExportStowingListComponent.this.includeStowingListConfig.getY() + ExportStowingListComponent.this.includeStowingListConfig.getHeight();
            }
            if (ExportStowingListComponent.this.includeMealPlan != null) {
                ExportStowingListComponent.this.includeMealPlan.setLocation(ExportStowingListComponent.this.border, y + ExportStowingListComponent.this.border / 2);
                ExportStowingListComponent.this.includeMealPlan.setSize(parent.getWidth() - 2 * ExportStowingListComponent.this.border, (int)ExportStowingListComponent.this.includeMealPlan.getPreferredSize().getHeight());
                y = ExportStowingListComponent.this.includeMealPlan.getY() + ExportStowingListComponent.this.includeMealPlan.getHeight();
            }
            if (ExportStowingListComponent.this.includeAllVariants != null) {
                ExportStowingListComponent.this.includeAllVariants.setLocation(ExportStowingListComponent.this.border, y + ExportStowingListComponent.this.border / 2);
                ExportStowingListComponent.this.includeAllVariants.setSize(parent.getWidth() - 2 * ExportStowingListComponent.this.border, (int)ExportStowingListComponent.this.includeAllVariants.getPreferredSize().getHeight());
                y = ExportStowingListComponent.this.includeAllVariants.getY() + ExportStowingListComponent.this.includeAllVariants.getHeight();
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = ExportStowingListComponent.this.getInheritedComponentsHeight();
            int w = 250;
            h += ExportStowingListComponent.this.border;
            if (ExportStowingListComponent.this.printOptionTitle != null) {
                h = (int)((double)h + ExportStowingListComponent.this.printOptionTitle.getPreferredSize().getHeight());
                h += ExportStowingListComponent.this.border;
            }
            if (ExportStowingListComponent.this.dueDate != null) {
                h = (int)((double)h + ExportStowingListComponent.this.dueDate.getPreferredSize().getHeight());
                h += ExportStowingListComponent.this.border;
            }
            if (ExportStowingListComponent.this.includeStowingListConfig != null) {
                h = (int)((double)h + ExportStowingListComponent.this.includeStowingListConfig.getPreferredSize().getHeight());
                h += ExportStowingListComponent.this.border;
            }
            if (ExportStowingListComponent.this.includeMealPlan != null) {
                h = (int)((double)h + ExportStowingListComponent.this.includeMealPlan.getPreferredSize().getHeight());
                h += ExportStowingListComponent.this.border;
            }
            if (ExportStowingListComponent.this.includeAllVariants != null) {
                h = (int)((double)h + ExportStowingListComponent.this.includeAllVariants.getPreferredSize().getHeight());
                h += ExportStowingListComponent.this.border;
            }
            return new Dimension(w, h);
        }
    }
}

