/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.export.twm.order;

import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.file.FileChooserUtil;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.DefaultScrollablePrintPopupInsert;
import ch.icit.pegasus.client.gui.utils.print.APrintConfigurationComplete;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferState;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.DefaultServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.ThreeWayMatchServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.DownloadState;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.report.twm.TWMOrdersExportConfiguration;
import ch.icit.pegasus.server.core.dtos.threewaymatch.ThreeWayMatchLight;
import ch.icit.pegasus.server.core.dtos.threewaymatch.ThreeWayMatchLight_;
import ch.icit.pegasus.server.core.dtos.threewaymatch.ThreeWayMatchReference;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.util.List;

public class ExportTWMOrderComponent
extends DefaultScrollablePrintPopupInsert
implements FileTransferListener {
    private static final long serialVersionUID = 1L;
    private Node<ThreeWayMatchLight> currentNode;
    private DownloadState downloaded;
    private File sourceFile;
    private File destinationFile;
    private boolean isOverride;
    private TextLabel options;
    private TitledItem<CheckBox> includeSummary;
    private TitledItem<CheckBox> includeSupplierOverview;
    private TitledItem<CheckBox> includeAllOrders;
    private TitledItem<CheckBox> useOnlyAttachedOrders;
    private TitledItem<CheckBox> includeApprovedOrders;
    private TitledItem<CheckBox> includeNotApprovedOrders;
    private TitledItem<CheckBox> includeNotCheckedOrders;
    private TitledItem<CheckBox> ignoreUncheckedOrders;
    private TitledItem<ComboBox> sortBy;

    public ExportTWMOrderComponent(Node<ThreeWayMatchLight> currentNode) {
        super(false, false);
        this.currentNode = currentNode;
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
    }

    private void readConfiguration() {
        FilterChainConfiguration config = FilterChainConfiguration.loadConfiguration(this.getClass().getSimpleName(), (UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser(), ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getServerName(), ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getCustomerCode());
        if (config != null) {
            for (String[] s : config.getProperties()) {
                String n = s[0];
                String v = s[1];
                Boolean b = Boolean.valueOf(v);
                switch (n) {
                    case "includeSummary": {
                        this.includeSummary.getElement().setChecked(b);
                        break;
                    }
                    case "includeSupplierOverview": {
                        this.includeSupplierOverview.getElement().setChecked(b);
                        break;
                    }
                    case "includeAllOrders": {
                        this.includeAllOrders.getElement().setChecked(b);
                        break;
                    }
                    case "includeApprovedOrders": {
                        this.includeApprovedOrders.getElement().setChecked(b);
                        break;
                    }
                    case "includeNotApprovedOrders": {
                        this.includeNotApprovedOrders.getElement().setChecked(b);
                        break;
                    }
                    case "includeNotCheckedOrders": {
                        this.includeNotCheckedOrders.getElement().setChecked(b);
                        break;
                    }
                    case "useOnlyAttachedOrders": {
                        this.useOnlyAttachedOrders.getElement().setChecked(b);
                        break;
                    }
                    case "ignoreUncheckedOrders": {
                        this.ignoreUncheckedOrders.getElement().setChecked(b);
                    }
                }
            }
        }
    }

    private void writeConfiguration() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        conf.addProperty("includeSummary", "" + this.includeSummary.getElement().isChecked());
        conf.addProperty("includeSupplierOverview", "" + this.includeSupplierOverview.getElement().isChecked());
        conf.addProperty("includeAllOrders", "" + this.includeAllOrders.getElement().isChecked());
        conf.addProperty("includeApprovedOrders", "" + this.includeApprovedOrders.getElement().isChecked());
        conf.addProperty("includeNotApprovedOrders", "" + this.includeNotApprovedOrders.getElement().isChecked());
        conf.addProperty("includeNotCheckedOrders", "" + this.includeNotCheckedOrders.getElement().isChecked());
        conf.addProperty("useOnlyAttachedOrders", "" + this.useOnlyAttachedOrders.getElement().isChecked());
        conf.addProperty("ignoreUncheckedOrders", "" + this.ignoreUncheckedOrders.getElement().isChecked());
        FilterChainConfiguration.saveConfiguration(this.getClass().getSimpleName(), (UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser(), conf, ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getServerName(), ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getCustomerCode());
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        this.options.setVisible(false);
        this.includeSummary.setVisible(false);
        this.includeSupplierOverview.setVisible(false);
        this.includeAllOrders.setVisible(false);
        this.includeApprovedOrders.setVisible(false);
        this.includeNotApprovedOrders.setVisible(false);
        this.includeNotCheckedOrders.setVisible(false);
        this.useOnlyAttachedOrders.setVisible(false);
        this.ignoreUncheckedOrders.setVisible(false);
        this.sortBy.setVisible(false);
    }

    @Override
    public void showInheritedComponents() {
        super.showInheritedComponents();
        this.options.setVisible(true);
        this.includeSummary.setVisible(true);
        this.includeSupplierOverview.setVisible(true);
        this.includeAllOrders.setVisible(true);
        this.includeApprovedOrders.setVisible(true);
        this.includeNotApprovedOrders.setVisible(true);
        this.includeNotCheckedOrders.setVisible(true);
        this.useOnlyAttachedOrders.setVisible(true);
        this.ignoreUncheckedOrders.setVisible(true);
        this.sortBy.setVisible(true);
    }

    @Override
    public void createComponents() {
        super.createComponents();
        this.options = new TextLabel(Words.OPTIONS);
        this.includeSummary = new TitledItem<CheckBox>(new CheckBox(), "Include Summary Sheet", TitledItem.TitledItemOrientation.EAST);
        this.includeSupplierOverview = new TitledItem<CheckBox>(new CheckBox(), "Include Supplier Summery Sheet", TitledItem.TitledItemOrientation.EAST);
        this.includeAllOrders = new TitledItem<CheckBox>(new CheckBox(), "Include all Orders Sheet", TitledItem.TitledItemOrientation.EAST);
        this.includeApprovedOrders = new TitledItem<CheckBox>(new CheckBox(), "Include approved Orders Sheet", TitledItem.TitledItemOrientation.EAST);
        this.includeNotApprovedOrders = new TitledItem<CheckBox>(new CheckBox(), "Include not approved Orders Sheet", TitledItem.TitledItemOrientation.EAST);
        this.includeNotCheckedOrders = new TitledItem<CheckBox>(new CheckBox(), "Include not checked Orders Sheet", TitledItem.TitledItemOrientation.EAST);
        this.ignoreUncheckedOrders = new TitledItem<CheckBox>(new CheckBox(), Words.IGNORE_ORDER_STATE_CHECK, TitledItem.TitledItemOrientation.EAST);
        this.useOnlyAttachedOrders = new TitledItem<CheckBox>(new CheckBox(), Words.USE_ONLY_ATTACHED_ORDERS, TitledItem.TitledItemOrientation.EAST);
        this.sortBy = new TitledItem<ComboBox>(new ComboBox(), Words.SORT_BY, TitledItem.TitledItemOrientation.NORTH);
        this.sortBy.getElement().addItem(Words.SUPPLIER);
        this.sortBy.getElement().addItem(Words.DATE);
        this.sortBy.getElement().addItem(Words.NONE);
        this.readConfiguration();
        this.getViewContainer().add(this.options);
        this.getViewContainer().add(this.includeSummary);
        this.getViewContainer().add(this.includeSupplierOverview);
        this.getViewContainer().add(this.includeAllOrders);
        this.getViewContainer().add(this.includeApprovedOrders);
        this.getViewContainer().add(this.includeNotApprovedOrders);
        this.getViewContainer().add(this.includeNotCheckedOrders);
        this.getViewContainer().add(this.useOnlyAttachedOrders);
        this.getViewContainer().add(this.ignoreUncheckedOrders);
        this.getViewContainer().add(this.sortBy);
    }

    @Override
    public List<Component> getFocusComponents() {
        return super.getFocusComponents();
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.options != null) {
            this.options.kill();
        }
        this.options = null;
        if (this.includeSummary != null) {
            this.includeSummary.kill();
        }
        this.includeSummary = null;
        if (this.includeSupplierOverview != null) {
            this.includeSupplierOverview.kill();
        }
        this.includeSupplierOverview = null;
        if (this.includeAllOrders != null) {
            this.includeAllOrders.kill();
        }
        this.includeAllOrders = null;
        if (this.includeApprovedOrders != null) {
            this.includeApprovedOrders.kill();
        }
        this.includeApprovedOrders = null;
        if (this.includeNotApprovedOrders != null) {
            this.includeNotApprovedOrders.kill();
        }
        this.includeNotApprovedOrders = null;
        if (this.includeNotCheckedOrders != null) {
            this.includeNotCheckedOrders.kill();
        }
        this.includeNotCheckedOrders = null;
        if (this.sortBy != null) {
            this.sortBy.kill();
        }
        this.sortBy = null;
        if (this.useOnlyAttachedOrders != null) {
            this.useOnlyAttachedOrders.kill();
        }
        this.useOnlyAttachedOrders = null;
        if (this.ignoreUncheckedOrders != null) {
            this.ignoreUncheckedOrders.kill();
        }
        this.ignoreUncheckedOrders = null;
    }

    @Override
    public APrintConfigurationComplete<?> getPrintConfiguration() {
        return null;
    }

    public void downloadFile(PegasusFileComplete fileReference) throws Exception {
        FileTransferUtil.download((PegasusFileComplete)fileReference, (FileTransferListener[])new FileTransferListener[]{this});
    }

    @Override
    public String getTitleString() {
        return "Three Way Match No";
    }

    @Override
    public String getTitleValue() {
        String t = "???";
        if (this.currentNode.getChildNamed(new String[]{"number"}).getValue() != null) {
            t = "" + this.currentNode.getChildNamed(ThreeWayMatchLight_.number).getValue() + " - " + (String)this.currentNode.getChildNamed(ThreeWayMatchLight_.name).getValue();
        }
        return t;
    }

    @Override
    protected String getProgressText() {
        return "Create Purchase Orders Export";
    }

    @Override
    protected String getFinishedText() {
        return "Export finished";
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean withSecondSeparator() {
        return true;
    }

    @Override
    protected void startPrinting() {
        super.startPrinting();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ExportTWMOrderComponent.this.writeConfiguration();
                ThreeWayMatchReference r = (ThreeWayMatchReference)ExportTWMOrderComponent.this.currentNode.getValue(ThreeWayMatchReference.class);
                TWMOrdersExportConfiguration config = new TWMOrdersExportConfiguration();
                config.setIncludeAllOrders(((CheckBox)ExportTWMOrderComponent.this.includeAllOrders.getElement()).isChecked());
                config.setIncludeApprovedOrders(((CheckBox)ExportTWMOrderComponent.this.includeApprovedOrders.getElement()).isChecked());
                config.setIncludeNotApprovedOrders(((CheckBox)ExportTWMOrderComponent.this.includeNotApprovedOrders.getElement()).isChecked());
                config.setIncludeNotCheckedOrders(((CheckBox)ExportTWMOrderComponent.this.includeNotCheckedOrders.getElement()).isChecked());
                config.setIncludeSummary(((CheckBox)ExportTWMOrderComponent.this.includeSummary.getElement()).isChecked());
                config.setIncludeSupplierOverview(((CheckBox)ExportTWMOrderComponent.this.includeSupplierOverview.getElement()).isChecked());
                config.setShowOnlyAttachedOrders(((CheckBox)ExportTWMOrderComponent.this.useOnlyAttachedOrders.getElement()).isChecked());
                config.setIgnoreUncheckedOrders(((CheckBox)ExportTWMOrderComponent.this.ignoreUncheckedOrders.getElement()).isChecked());
                if (((ComboBox)ExportTWMOrderComponent.this.sortBy.getElement()).getSelectedItem().equals(Words.SUPPLIER)) {
                    config.setSortBySupplier(true);
                } else if (((ComboBox)ExportTWMOrderComponent.this.sortBy.getElement()).getSelectedItem().equals(Words.DATE)) {
                    config.setSortByDate(true);
                } else if (((ComboBox)ExportTWMOrderComponent.this.sortBy.getElement()).getSelectedItem().equals(Words.NONE)) {
                    config.setSortByNone(true);
                }
                PegasusFileComplete file = (PegasusFileComplete)((ThreeWayMatchServiceManager)ServiceManagerRegistry.getService(ThreeWayMatchServiceManager.class)).createOrderExportByReference(r, config).getValue();
                ExportTWMOrderComponent.this.downloadFile(file);
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ExportTWMOrderComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        this.removeAnimation(false);
        if (this.downloaded == DownloadState.DOWNLOADED) {
            if (this.errorMSG != null) {
                this.showMessage(this.errorMSG);
                this.popup.setOkButtonText("CLOSE");
                this.popup.hideCancelButton();
            } else {
                super.remoteObjectLoaded(node);
            }
        } else if (this.downloaded != DownloadState.NOT_SAVED) {
            this.showMessage("Exported");
        }
        this.popup.enableCancelButton(true);
    }

    public void statusChanged(File file, FileTransferState state) {
        if (state.getState() == FileTransferState.State.FINISHED) {
            this.downloaded = DownloadState.DOWNLOADED;
            this.showSaveDialog(file);
        } else if (state.getState() != FileTransferState.State.NEW) {
            double d = (double)state.getTransferred() / (double)state.getSize();
            int i = (int)(d *= 100.0);
            this.animation.stateChanged("Download " + i + "%");
        }
    }

    @Override
    public void enterPressed(PopupAction isOK) {
        if (!this.isOverride) {
            super.enterPressed(isOK);
        } else {
            this.isOverride = false;
            if (this.destinationFile.exists()) {
                this.destinationFile.delete();
            }
            this.moveFile(this.sourceFile, this.destinationFile);
            this.popup.setCancelButtonText("Cancel");
            this.popup.enableCancelButton(false);
            this.downloaded = null;
            this.remoteObjectLoaded(this.currentNode);
        }
    }

    private void showSaveDialog(File file) {
        MainFrame.isTempRelease = true;
        File fileName = FileChooserUtil.saveFile(".xlsx");
        if (fileName != null) {
            File selectedFile = fileName;
            if (selectedFile.exists()) {
                this.sourceFile = file;
                this.destinationFile = selectedFile;
                this.isOverride = true;
                this.downloaded = DownloadState.NOT_SAVED;
                this.errorMSG = "File already exists. Do you want to override it?";
                this.removeInheritedComponents();
                this.processReturnValue(this.errorMSG);
                this.showMessage(this.errorMSG);
            } else {
                this.moveFile(file, selectedFile);
            }
        } else {
            this.downloaded = DownloadState.NOT_SAVED;
            this.removeInheritedComponents();
            this.popup.enableCancelButton(false);
            this.showMessage("<b>Operation canceled!</b>");
        }
        MainFrame.isTempRelease = false;
    }

    private void processReturnValue(String t) {
        if (t != null && t.isEmpty()) {
            t = null;
        }
        if (t == null) {
            this.isError = false;
            this.errorMSG = null;
        } else {
            this.isError = true;
            this.errorMSG = t;
        }
    }

    private void moveFile(File source, File destination) {
        try {
            if (!source.renameTo(destination)) {
                this.errorMSG = "Unable to save file";
            } else {
                this.showMessage("Exported");
            }
        }
        catch (Exception e) {
            this.errorMSG = e.getMessage();
        }
        this.isOverride = false;
    }

    public void exceptionOccurred(Exception exception) {
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = ExportTWMOrderComponent.this.layoutInheritedComponents(parent);
            ExportTWMOrderComponent.this.options.setLocation(ExportTWMOrderComponent.this.border, y + ExportTWMOrderComponent.this.border);
            ExportTWMOrderComponent.this.options.setSize(parent.getWidth() - 2 * ExportTWMOrderComponent.this.border, (int)ExportTWMOrderComponent.this.options.getPreferredSize().getHeight());
            y = ExportTWMOrderComponent.this.options.getY() + ExportTWMOrderComponent.this.options.getHeight();
            ExportTWMOrderComponent.this.includeSummary.setLocation(ExportTWMOrderComponent.this.border, y + ExportTWMOrderComponent.this.border);
            ExportTWMOrderComponent.this.includeSummary.setSize(parent.getWidth() - 2 * ExportTWMOrderComponent.this.border, (int)ExportTWMOrderComponent.this.includeSummary.getPreferredSize().getHeight());
            y = ExportTWMOrderComponent.this.includeSummary.getY() + ExportTWMOrderComponent.this.includeSummary.getHeight();
            ExportTWMOrderComponent.this.includeSupplierOverview.setLocation(ExportTWMOrderComponent.this.border, y + ExportTWMOrderComponent.this.border / 4);
            ExportTWMOrderComponent.this.includeSupplierOverview.setSize(parent.getWidth() - 2 * ExportTWMOrderComponent.this.border, (int)ExportTWMOrderComponent.this.includeSupplierOverview.getPreferredSize().getHeight());
            y = ExportTWMOrderComponent.this.includeSupplierOverview.getY() + ExportTWMOrderComponent.this.includeSupplierOverview.getHeight();
            ExportTWMOrderComponent.this.includeAllOrders.setLocation(ExportTWMOrderComponent.this.border, y + ExportTWMOrderComponent.this.border);
            ExportTWMOrderComponent.this.includeAllOrders.setSize(parent.getWidth() - 2 * ExportTWMOrderComponent.this.border, (int)ExportTWMOrderComponent.this.includeAllOrders.getPreferredSize().getHeight());
            y = ExportTWMOrderComponent.this.includeAllOrders.getY() + ExportTWMOrderComponent.this.includeAllOrders.getHeight();
            ExportTWMOrderComponent.this.includeApprovedOrders.setLocation(ExportTWMOrderComponent.this.border, y + ExportTWMOrderComponent.this.border / 4);
            ExportTWMOrderComponent.this.includeApprovedOrders.setSize(parent.getWidth() - 2 * ExportTWMOrderComponent.this.border, (int)ExportTWMOrderComponent.this.includeApprovedOrders.getPreferredSize().getHeight());
            y = ExportTWMOrderComponent.this.includeApprovedOrders.getY() + ExportTWMOrderComponent.this.includeApprovedOrders.getHeight();
            ExportTWMOrderComponent.this.includeNotApprovedOrders.setLocation(ExportTWMOrderComponent.this.border, y + ExportTWMOrderComponent.this.border / 4);
            ExportTWMOrderComponent.this.includeNotApprovedOrders.setSize(parent.getWidth() - 2 * ExportTWMOrderComponent.this.border, (int)ExportTWMOrderComponent.this.includeNotApprovedOrders.getPreferredSize().getHeight());
            y = ExportTWMOrderComponent.this.includeNotApprovedOrders.getY() + ExportTWMOrderComponent.this.includeNotApprovedOrders.getHeight();
            ExportTWMOrderComponent.this.includeNotCheckedOrders.setLocation(ExportTWMOrderComponent.this.border, y + ExportTWMOrderComponent.this.border / 4);
            ExportTWMOrderComponent.this.includeNotCheckedOrders.setSize(parent.getWidth() - 2 * ExportTWMOrderComponent.this.border, (int)ExportTWMOrderComponent.this.includeNotCheckedOrders.getPreferredSize().getHeight());
            y = ExportTWMOrderComponent.this.includeNotCheckedOrders.getY() + ExportTWMOrderComponent.this.includeNotCheckedOrders.getHeight();
            ExportTWMOrderComponent.this.useOnlyAttachedOrders.setLocation(ExportTWMOrderComponent.this.border, y + ExportTWMOrderComponent.this.border);
            ExportTWMOrderComponent.this.useOnlyAttachedOrders.setSize(parent.getWidth() - 2 * ExportTWMOrderComponent.this.border, (int)ExportTWMOrderComponent.this.includeNotCheckedOrders.getPreferredSize().getHeight());
            y = ExportTWMOrderComponent.this.useOnlyAttachedOrders.getY() + ExportTWMOrderComponent.this.useOnlyAttachedOrders.getHeight();
            ExportTWMOrderComponent.this.ignoreUncheckedOrders.setLocation(ExportTWMOrderComponent.this.border, y + ExportTWMOrderComponent.this.border);
            ExportTWMOrderComponent.this.ignoreUncheckedOrders.setSize(parent.getWidth() - 2 * ExportTWMOrderComponent.this.border, (int)ExportTWMOrderComponent.this.ignoreUncheckedOrders.getPreferredSize().getHeight());
            y = ExportTWMOrderComponent.this.ignoreUncheckedOrders.getY() + ExportTWMOrderComponent.this.ignoreUncheckedOrders.getHeight();
            ExportTWMOrderComponent.this.sortBy.setLocation(ExportTWMOrderComponent.this.border, y + ExportTWMOrderComponent.this.border);
            ExportTWMOrderComponent.this.sortBy.setSize(200, (int)ExportTWMOrderComponent.this.sortBy.getPreferredSize().getHeight());
            y = ExportTWMOrderComponent.this.sortBy.getY() + ExportTWMOrderComponent.this.sortBy.getHeight();
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = ExportTWMOrderComponent.this.getInheritedComponentsHeight();
            h += ExportTWMOrderComponent.this.border;
            h = (int)((double)h + ExportTWMOrderComponent.this.options.getPreferredSize().getHeight());
            h += ExportTWMOrderComponent.this.border;
            h = (int)((double)h + ExportTWMOrderComponent.this.includeSummary.getPreferredSize().getHeight());
            h += ExportTWMOrderComponent.this.border / 4;
            h = (int)((double)h + ExportTWMOrderComponent.this.includeSupplierOverview.getPreferredSize().getHeight());
            h += ExportTWMOrderComponent.this.border;
            h = (int)((double)h + ExportTWMOrderComponent.this.includeAllOrders.getPreferredSize().getHeight());
            h += ExportTWMOrderComponent.this.border / 4;
            h = (int)((double)h + ExportTWMOrderComponent.this.includeApprovedOrders.getPreferredSize().getHeight());
            h += ExportTWMOrderComponent.this.border / 4;
            h = (int)((double)h + ExportTWMOrderComponent.this.includeNotApprovedOrders.getPreferredSize().getHeight());
            h += ExportTWMOrderComponent.this.border / 4;
            h = (int)((double)h + ExportTWMOrderComponent.this.includeNotCheckedOrders.getPreferredSize().getHeight());
            h += ExportTWMOrderComponent.this.border;
            h = (int)((double)h + ExportTWMOrderComponent.this.useOnlyAttachedOrders.getPreferredSize().getHeight());
            h += ExportTWMOrderComponent.this.border;
            h = (int)((double)h + ExportTWMOrderComponent.this.ignoreUncheckedOrders.getPreferredSize().getHeight());
            h += ExportTWMOrderComponent.this.border;
            h = (int)((double)h + ExportTWMOrderComponent.this.sortBy.getPreferredSize().getHeight());
            return new Dimension(0, h += ExportTWMOrderComponent.this.border);
        }
    }
}

