/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.article.allergenstatehistory;

import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.DefaultScrollablePrintPopupInsert;
import ch.icit.pegasus.client.gui.utils.print.APrintConfigurationComplete;
import ch.icit.pegasus.client.gui.utils.tables.AllergenHistoryTable;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;

public class PrintArticleAllergenStateHistoryComponent
extends DefaultScrollablePrintPopupInsert {
    private static final long serialVersionUID = 1L;
    private final Node<BasicArticleLight> currentArticle;
    private TitledItem<Table2> table;
    private boolean isLoadingRemains = false;

    public PrintArticleAllergenStateHistoryComponent(Node<BasicArticleLight> currentNode) {
        super(false, false);
        this.currentArticle = currentNode;
        this.getViewContainer().setLayout(new Layout());
    }

    @Override
    public APrintConfigurationComplete<?> getPrintConfiguration() {
        return null;
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        this.createComponents();
        this.isLoadingRemains = true;
        this.popup.enableOKButton(true);
        this.popup.enableCancelButton(false);
        this.removeInheritedComponents();
        this.ensureAnimation(Words.LOAD_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                BasicArticleLight flight = (BasicArticleLight)PrintArticleAllergenStateHistoryComponent.this.currentArticle.getValue();
                List sheets = ((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getAllergenHistory(new BasicArticleReference(flight.getId())).getList();
                Node n = INodeCreator.getDefaultImpl().createNodes(sheets, false);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintArticleAllergenStateHistoryComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    public void remoteObjectLoaded(Node node) {
        if (this.isLoadingRemains) {
            if (node.getValue() != null) {
                if (this.errorMSG == null) {
                    this.removeAnimation(false);
                    this.createInners();
                    this.table.getElement().getModel().setNode(node);
                    this.createComponents();
                } else {
                    this.removeAnimation(true);
                }
            }
            this.isLoadingRemains = false;
        } else {
            super.remoteObjectLoaded(node);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.table != null) {
            this.table.setVisible(false);
        }
    }

    private void createInners() {
        this.table = new TitledItem<AllergenHistoryTable>(new AllergenHistoryTable(), Words.ALLERGEN_HISTORY, TitledItem.TitledItemOrientation.NORTH);
        this.table.setIgnorePrefHeight(true);
        this.table.getElement().setRequestFocusOnAdd(true);
        this.getViewContainer().add(this.table);
    }

    @Override
    public String getTitleString() {
        return Words.ARTICLE;
    }

    @Override
    public String getTitleValue() {
        return (String)this.currentArticle.getChildNamed(BasicArticleLight_.name).getValue();
    }

    @Override
    public boolean withSecondSeparator() {
        return true;
    }

    @Override
    protected void startPrinting() {
        this.popup.hidePopUp(new Object[0]);
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return new Object[0];
    }

    @Override
    public boolean isClosableWithEnter() {
        return true;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int cy = PrintArticleAllergenStateHistoryComponent.this.layoutInheritedComponents(parent);
            cy += PrintArticleAllergenStateHistoryComponent.this.border;
            if (PrintArticleAllergenStateHistoryComponent.this.table != null) {
                PrintArticleAllergenStateHistoryComponent.this.table.setLocation(0, cy);
                PrintArticleAllergenStateHistoryComponent.this.table.setSize(parent.getWidth(), parent.getHeight() - (cy + PrintArticleAllergenStateHistoryComponent.this.border));
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintArticleAllergenStateHistoryComponent.this.getInheritedComponentsHeight() + PrintArticleAllergenStateHistoryComponent.this.border;
            return new Dimension(0, h);
        }
    }
}

