/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.article.usage;

import ch.icit.pegasus.client.converter.CustomerConverter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.PeriodConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooserListener;
import ch.icit.pegasus.client.gui.utils.icons.ToogleSkinIcon;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.DefaultScrollablePrintPopupInsert;
import ch.icit.pegasus.client.gui.utils.print.APrintConfigurationComplete;
import ch.icit.pegasus.client.gui.utils.print.BasicArticlePrintConfigurationComplete;
import ch.icit.pegasus.client.gui.utils.print.PrintPopupToolkit;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.StowingListServiceManager;
import ch.icit.pegasus.client.services.interfaces.recipe.RecipeServiceManager;
import ch.icit.pegasus.client.services.interfaces.search.SearchServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientExceptionCollection;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.exception.SearchException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLight_;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostComplete_;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostVariantComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostVariantComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductReference;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight_;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete_;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeReference;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantLight;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantLight_;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.search.ADtoSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.HandlingCostVariantSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.ProductVariantSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.RecipeVariantSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.StowingListTemplateVariantSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.DateWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLadapter.XmlCache;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class PrintArticleUsageComponent
extends DefaultScrollablePrintPopupInsert
implements DateChooserListener {
    private static final long serialVersionUID = 1L;
    private final Node<BasicArticleLight> currentArticle;
    private TitledItem<Table2> table;
    private boolean isLoadingRemains = false;
    private TitledItem<DateChooser> dateChooser;

    public PrintArticleUsageComponent(Node<BasicArticleLight> currentNode) {
        super(false, false);
        this.currentArticle = currentNode;
        this.getViewContainer().setLayout(new Layout());
    }

    @Override
    public APrintConfigurationComplete<?> getPrintConfiguration() {
        return new BasicArticlePrintConfigurationComplete();
    }

    private void loadItems(boolean fromCheckBox) {
        this.isLoadingRemains = true;
        this.popup.enableOKButton(false);
        this.popup.enableCancelButton(false);
        if (!fromCheckBox) {
            this.removeInheritedComponents();
        }
        this.ensureAnimation(Words.LOAD_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                PeriodComplete searchPeriod = new PeriodComplete();
                searchPeriod.setStartDate(new java.sql.Date(PrintArticleUsageComponent.this.dateChooser != null ? ((DateChooser)PrintArticleUsageComponent.this.dateChooser.getElement()).getSelectedDate().getTime() : System.currentTimeMillis()));
                searchPeriod.setEndDate(new java.sql.Date(searchPeriod.getStartDate().getTime()));
                BasicArticleLight artL = (BasicArticleLight)PrintArticleUsageComponent.this.currentArticle.getValue(BasicArticleLight.class);
                ProductVariantSearchConfiguration pvsc = new ProductVariantSearchConfiguration();
                pvsc.setArticle(new BasicArticleReference(artL.getId()));
                pvsc.setNumResults(Integer.MAX_VALUE);
                pvsc.setPeriod(searchPeriod);
                pvsc.setUsePeriod(Boolean.valueOf(true));
                ArrayList exceptions = new ArrayList();
                SearchResult r = ((SearchServiceManager)ServiceManagerRegistry.getService(SearchServiceManager.class)).search((ADtoSearchConfiguration)pvsc);
                if (r.getResults() != null) {
                    r.getResults().forEach(productVariantLight -> {
                        productVariantLight.afterUnmarshal(null, null);
                        if (productVariantLight.getProduct() == null) {
                            try {
                                ProductComplete productByReference = (ProductComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getProductByReference(new ProductReference(productVariantLight.getProductId())).getValue();
                                XmlCache.getXmlCache().put(productVariantLight.getProductId(), (Object)productByReference);
                                productVariantLight.setProduct(productByReference);
                            }
                            catch (ClientServerCallException clientServerCallException) {
                                // empty catch block
                            }
                        }
                    });
                }
                RecipeVariantSearchConfiguration rsc = new RecipeVariantSearchConfiguration();
                rsc.setPeriod(searchPeriod);
                rsc.setVariantPeriod(searchPeriod);
                rsc.setUsePeriod(Boolean.valueOf(true));
                rsc.setArticle(new BasicArticleReference(artL.getId()));
                rsc.setNumResults(Integer.MAX_VALUE);
                SearchResult r2 = ((SearchServiceManager)ServiceManagerRegistry.getService(SearchServiceManager.class)).search((ADtoSearchConfiguration)rsc);
                if (r2 != null) {
                    r2.getResults().forEach(productVariantLight -> {
                        productVariantLight.afterUnmarshal(null, null);
                        if (productVariantLight.getRecipe() == null) {
                            try {
                                RecipeComplete productByReference = (RecipeComplete)((RecipeServiceManager)ServiceManagerRegistry.getService(RecipeServiceManager.class)).getRecipe(new RecipeReference(productVariantLight.getRecipeId())).getValue();
                                XmlCache.getXmlCache().put(productVariantLight.getRecipeId(), (Object)productByReference);
                                productVariantLight.setRecipe(productByReference);
                            }
                            catch (ClientServerCallException clientServerCallException) {
                                // empty catch block
                            }
                        }
                    });
                }
                HandlingCostVariantSearchConfiguration hcs = new HandlingCostVariantSearchConfiguration();
                hcs.setArticle(new BasicArticleReference(artL.getId()));
                hcs.setPeriod(searchPeriod);
                hcs.setNumResults(Integer.MAX_VALUE);
                SearchResult r3 = ((SearchServiceManager)ServiceManagerRegistry.getService(SearchServiceManager.class)).search((ADtoSearchConfiguration)hcs);
                if (r3.getResults() != null) {
                    r3.getResults().forEach(productVariantLight -> {
                        productVariantLight.afterUnmarshal(null, null);
                        if (productVariantLight.getBase() == null) {
                            try {
                                HandlingCostComplete productByReference = (HandlingCostComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getHandlingCost(new HandlingCostComplete(productVariantLight.getBaseId())).getValue();
                                XmlCache.getXmlCache().put(productVariantLight.getBaseId(), (Object)productByReference);
                                productVariantLight.setBase(productByReference);
                            }
                            catch (ClientServerCallException clientServerCallException) {
                                // empty catch block
                            }
                        }
                    });
                }
                StowingListTemplateVariantSearchConfiguration slsc = new StowingListTemplateVariantSearchConfiguration();
                slsc.setArticle(new BasicArticleReference(artL.getId()));
                slsc.setNumResults(Integer.MAX_VALUE);
                slsc.setIncludeDeleted(Boolean.valueOf(true));
                slsc.setVariantPeriod(searchPeriod);
                SearchResult r4 = ((SearchServiceManager)ServiceManagerRegistry.getService(SearchServiceManager.class)).search((ADtoSearchConfiguration)slsc);
                List stwlist = r4.getResults();
                if (stwlist != null) {
                    stwlist.forEach(productVariantLight -> {
                        productVariantLight.afterUnmarshal(null, null);
                        if (productVariantLight.getBase() == null) {
                            try {
                                StowingListTemplateComplete productByReference = (StowingListTemplateComplete)((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).getStowingListTemplateComplete(new StowingListTemplateReference(productVariantLight.getBaseId())).getValue();
                                XmlCache.getXmlCache().put(productVariantLight.getBaseId(), (Object)productByReference);
                                productVariantLight.setBase(productByReference);
                            }
                            catch (ClientServerCallException clientServerCallException) {
                                // empty catch block
                            }
                        }
                    });
                    Collections.sort(stwlist, (o1, o2) -> o1.getBase().getNumber().compareTo(o2.getBase().getNumber()));
                }
                ViewNode nn = new ViewNode("");
                if (exceptions.size() == 0) {
                    List results = r.getResults() != null ? r.getResults() : new ArrayList();
                    List results2 = r2.getResults() != null ? r2.getResults() : new ArrayList();
                    List results3 = r3.getResults() != null ? r3.getResults() : new ArrayList();
                    List results4 = stwlist != null ? stwlist : new ArrayList();
                    Node pr = INodeCreator.getDefaultImpl().createNodes(results, false);
                    Node rr = INodeCreator.getDefaultImpl().createNodes(results2, false);
                    Node hr = INodeCreator.getDefaultImpl().createNodes(results3, false);
                    Node sr = INodeCreator.getDefaultImpl().createNodes(results4, false);
                    Iterator it = pr.getChilds();
                    while (it.hasNext()) {
                        nn.addChild((Node)it.next(), 0L);
                    }
                    it = rr.getChilds();
                    while (it.hasNext()) {
                        nn.addChild((Node)it.next(), 0L);
                    }
                    it = hr.getChilds();
                    while (it.hasNext()) {
                        nn.addChild((Node)it.next(), 0L);
                    }
                    it = sr.getChilds();
                    while (it.hasNext()) {
                        nn.addChild((Node)it.next(), 0L);
                    }
                } else {
                    throw new ClientExceptionCollection("Unable to search Article Usage", exceptions);
                }
                return nn;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintArticleUsageComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        this.createComponents();
        this.loadItems(false);
    }

    public void remoteObjectLoaded(Node node) {
        if (this.isLoadingRemains) {
            if (node.getValue() == null) {
                if (this.errorMSG == null) {
                    this.removeAnimation(false);
                    this.popup.enableCancelButton(true);
                    if (this.table == null) {
                        this.createInners();
                    }
                    this.table.getElement().getModel().setNode(node);
                    this.table.setVisible(true);
                    this.dateChooser.setVisible(true);
                    this.createComponents();
                } else {
                    this.removeAnimation(true);
                }
            } else {
                ArrayList<ScreenValidationObject> rets = new ArrayList<ScreenValidationObject>();
                for (SearchException e : (List)node.getValue()) {
                    rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, e.getMessage()));
                }
                this.isError = true;
                this.errorMSG = ScreenValidationObject.createMessageString(rets, (String)"Unable to load article usage:");
                this.removeAnimation(true);
            }
            this.isLoadingRemains = false;
        } else {
            super.remoteObjectLoaded(node);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.table != null) {
            this.table.setVisible(false);
        }
        if (this.dateChooser != null) {
            this.dateChooser.setVisible(false);
        }
    }

    private void createInners() {
        this.table = new TitledItem<Table2>(new Table2(false, null, true, false), "ARTICLE IS USED IN", TitledItem.TitledItemOrientation.NORTH);
        this.table.setIgnorePrefHeight(true);
        this.table.getElement().setRequestFocusOnAdd(true);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.TYPE, null, null, null, "", 80, 80, 80));
        columns.add(new TableColumnInfo(Words.NO_NUMBER, null, null, null, "", 60, 60, 60));
        columns.add(new TableColumnInfo(Words.NAME, null, null, null, "", 10, 10, 10));
        int tw = TableColumnInfo.periodColumnWidth;
        columns.add(new TableColumnInfo(Words.CUSTOMER, null, null, null, "", 120, 120, 120));
        columns.add(new TableColumnInfo(Words.PERIOD, null, null, null, "", tw += 2 * this.table.getElement().getCellPadding(), tw, tw));
        columns.add(new TableColumnInfo("Deleted", null, null, null, "", DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + 2 * this.table.getElement().getCellPadding()));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.8);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.2);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(5)).setxExpand(0.0);
        this.table.getElement().setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
        this.dateChooser = new TitledItem<DateChooser>(new DateChooser(INodeCreator.getDefaultImpl().getNode4DTO((Object)new java.sql.Date(System.currentTimeMillis()), false, false)), Words.DUE_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.dateChooser.getElement().setIsTimestamp(false);
        this.dateChooser.getElement().addDateChooserListener(this);
        this.getViewContainer().add(this.table);
        this.getViewContainer().add(this.dateChooser);
    }

    @Override
    public String getTitleString() {
        return "ARTICLE NAME";
    }

    @Override
    protected String getProgressText() {
        if (this.isLoadingRemains) {
            return "Load Article Data";
        }
        return "Print Article Usage";
    }

    @Override
    public String getTitleValue() {
        return (String)this.currentArticle.getChildNamed(new String[]{"name"}).getValue();
    }

    @Override
    public boolean withSecondSeparator() {
        return true;
    }

    @Override
    protected void startPrinting() {
        super.startPrinting();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                java.sql.Date dueDate = (java.sql.Date)((DateChooser)PrintArticleUsageComponent.this.dateChooser.getElement()).getNode().getValue();
                PegasusFileComplete file = (PegasusFileComplete)((SupplyReportServiceManager)ServiceManagerRegistry.getService(SupplyReportServiceManager.class)).printArticleUsage((BasicArticleReference)PrintArticleUsageComponent.this.currentArticle.getValue(), new DateWrapper(dueDate), ReportingOutputFormatE.XLSX).getValue();
                PrintPopupToolkit.previewFile(file);
                return new ViewNode("");
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintArticleUsageComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return new Object[0];
    }

    @Override
    public boolean isClosableWithEnter() {
        return true;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public void dateChanged(DateChooser source, Date selectedDate) {
        this.loadItems(true);
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private TextLabel type;
        private TextLabel number;
        private TextLabel name;
        private TextLabel customer;
        private TextLabel validityPeriod;
        private ToogleSkinIcon skin;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            boolean deleted = false;
            this.type = new TextLabel();
            if (m.getNode().getValue() instanceof ProductVariantLight) {
                if (m.getNode().getChildNamed(ProductVariantLight_.product).getValue() != null) {
                    this.number = new TextLabel(m.getNode().getChildNamed(new DtoField[]{ProductVariantLight_.product, ProductComplete_.number}), ConverterRegistry.getConverter(IntegerConverter.class));
                    this.customer = new TextLabel(m.getNode().getChildNamed(new DtoField[]{ProductVariantLight_.product, ProductComplete_.customer}), ConverterRegistry.getConverter(CustomerConverter.class));
                    deleted = ((ProductVariantLight)m.getNode().getValue()).getProduct().getIsDeleted();
                } else {
                    this.number = new TextLabel(m.getNode().getChildNamed(ProductVariantLight_.productNumber), ConverterRegistry.getConverter(IntegerConverter.class));
                    this.customer = new TextLabel(m.getNode().getChildNamed(ProductVariantLight_.productCustomer), ConverterRegistry.getConverter(StringConverter.class));
                    deleted = ((ProductVariantLight)m.getNode().getValue()).getProductDeleted();
                }
                this.name = new TextLabel(m.getNode().getChildNamed(ProductVariantLight_.name), ConverterRegistry.getConverter(StringConverter.class));
                this.validityPeriod = new TextLabel(m.getNode().getChildNamed(ProductVariantLight_.validityPeriod), ConverterRegistry.getConverter(PeriodConverter.class));
                this.type.setText("Product");
            } else if (m.getNode().getValue() instanceof StowingListTemplateComplete) {
                this.number = new TextLabel(m.getNode().getChildNamed(StowingListTemplateComplete_.number), ConverterRegistry.getConverter(IntegerConverter.class));
                this.name = new TextLabel(m.getNode().getChildNamed(new DtoField[]{StowingListTemplateComplete_.currentVariant, StowingListTemplateVariantLight_.name}));
                this.customer = new TextLabel(m.getNode().getChildNamed(StowingListTemplateComplete_.customer), ConverterRegistry.getConverter(CustomerConverter.class));
                this.validityPeriod = new TextLabel();
                this.type.setText("Stowing");
                deleted = ((StowingListTemplateComplete)m.getNode().getValue()).getIsDeleted();
            } else if (m.getNode().getValue() instanceof StowingListTemplateVariantLight) {
                if (m.getNode().getChildNamed(StowingListTemplateVariantLight_.base).getValue() != null) {
                    this.number = new TextLabel(m.getNode().getChildNamed(new DtoField[]{StowingListTemplateVariantLight_.base, StowingListTemplateComplete_.number}), ConverterRegistry.getConverter(IntegerConverter.class));
                    this.customer = new TextLabel(m.getNode().getChildNamed(new DtoField[]{StowingListTemplateVariantLight_.base, StowingListTemplateComplete_.customer}), ConverterRegistry.getConverter(CustomerConverter.class));
                    deleted = ((StowingListTemplateVariantLight)m.getNode().getValue()).getBase().getIsDeleted();
                } else {
                    this.number = new TextLabel(m.getNode().getChildNamed(StowingListTemplateVariantLight_.baseNumber), ConverterRegistry.getConverter(IntegerConverter.class));
                    this.customer = new TextLabel(m.getNode().getChildNamed(StowingListTemplateVariantLight_.baseCustomer), ConverterRegistry.getConverter(StringConverter.class));
                    deleted = ((StowingListTemplateVariantLight)m.getNode().getValue()).getBaseDeleted();
                }
                this.name = new TextLabel(m.getNode().getChildNamed(StowingListTemplateVariantLight_.name));
                this.validityPeriod = new TextLabel(m.getNode().getChildNamed(StowingListTemplateVariantLight_.validityPeriod), ConverterRegistry.getConverter(PeriodConverter.class));
                this.type.setText("Stowing");
            } else if (m.getNode().getValue() instanceof RecipeVariantLight) {
                if (m.getNode().getChildNamed(RecipeVariantLight_.recipe).getValue() != null) {
                    this.number = new TextLabel(m.getNode().getChildNamed(new DtoField[]{RecipeVariantLight_.recipe, RecipeComplete_.number}), ConverterRegistry.getConverter(IntegerConverter.class));
                    deleted = ((RecipeVariantLight)m.getNode().getValue()).getRecipe().getIsDeleted();
                } else {
                    this.number = new TextLabel(m.getNode().getChildNamed(RecipeVariantLight_.recipeNumber), ConverterRegistry.getConverter(IntegerConverter.class));
                    deleted = ((RecipeVariantLight)m.getNode().getValue()).getDeleted();
                }
                this.name = new TextLabel(m.getNode().getChildNamed(RecipeVariantLight_.name), ConverterRegistry.getConverter(StringConverter.class));
                this.validityPeriod = new TextLabel(m.getNode().getChildNamed(RecipeVariantLight_.validityPeriod), ConverterRegistry.getConverter(PeriodConverter.class));
                this.customer = new TextLabel();
                this.type.setText("Recipe");
            } else if (m.getNode().getValue() instanceof HandlingCostVariantComplete) {
                if (m.getNode().getChildNamed(HandlingCostVariantComplete_.base).getValue() != null) {
                    this.number = new TextLabel(m.getNode().getChildNamed(new DtoField[]{HandlingCostVariantComplete_.base, HandlingCostComplete_.number}), ConverterRegistry.getConverter(IntegerConverter.class));
                    this.customer = new TextLabel(m.getNode().getChildNamed(new DtoField[]{HandlingCostVariantComplete_.base, HandlingCostComplete_.customer}), ConverterRegistry.getConverter(CustomerConverter.class));
                    deleted = ((HandlingCostVariantComplete)m.getNode().getValue()).getBase().getIsDeleted();
                } else {
                    this.number = new TextLabel(m.getNode().getChildNamed(HandlingCostVariantComplete_.baseNumber), ConverterRegistry.getConverter(IntegerConverter.class));
                    this.customer = new TextLabel(m.getNode().getChildNamed(HandlingCostVariantComplete_.baseCustomer), ConverterRegistry.getConverter(StringConverter.class));
                    deleted = ((HandlingCostVariantComplete)m.getNode().getValue()).getBaseDeleted();
                }
                this.name = new TextLabel(m.getNode().getChildNamed(HandlingCostVariantComplete_.name), ConverterRegistry.getConverter(StringConverter.class));
                this.validityPeriod = new TextLabel();
                this.type.setText("Handling");
            }
            this.skin = new ToogleSkinIcon(DefaultSkins.CheckCrossBoxIcon, !deleted);
            this.type.setProgress(1.0f);
            this.number.setProgress(1.0f);
            this.name.setProgress(1.0f);
            this.validityPeriod.setProgress(1.0f);
            this.customer.setProgress(1.0f);
            this.skin.setProgress(1.0f);
            this.setLayout(new Layout());
            this.add(this.type);
            this.add(this.number);
            this.add(this.name);
            this.add(this.validityPeriod);
            this.add(this.customer);
            this.add(this.skin);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.type.kill();
            this.number.kill();
            this.name.kill();
            this.validityPeriod.kill();
            this.customer.kill();
            this.skin.kill();
            this.type = null;
            this.number = null;
            this.name = null;
            this.validityPeriod = null;
            this.customer = null;
            this.skin = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            return null;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.type.getText();
                }
                case 1: {
                    return this.model.getNode().getChildNamed(new String[]{"number"}) != null ? this.model.getNode().getChildNamed(new String[]{"number"}).getValue() : null;
                }
                case 2: {
                    return this.model.getNode().getChildNamed(new String[]{"name"}).getValue();
                }
                case 3: {
                    if (this.model.getNode().getValue() instanceof ProductVariantLight) {
                        return this.model.getNode().getChildNamed(new String[]{"validityPeriod"}).getValue();
                    }
                }
                case 4: 
                case 5: {
                    return null;
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.type.setEnabled(isEnabled);
            this.number.setEnabled(isEnabled);
            this.name.setEnabled(isEnabled);
            this.validityPeriod.setEnabled(isEnabled);
            this.customer.setEnabled(isEnabled);
            this.skin.setEnabled(isEnabled);
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.type.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.type.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.type.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.type.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.number.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.number.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.number.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.number.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.name.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.name.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.name.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.name.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.customer.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.customer.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.customer.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.customer.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.validityPeriod.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.validityPeriod.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.validityPeriod.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.validityPeriod.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(5);
                TableRowImpl.this.skin.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.skin.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.skin.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.skin.getPreferredSize().getHeight());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int cy = PrintArticleUsageComponent.this.layoutInheritedComponents(parent);
            cy += PrintArticleUsageComponent.this.border;
            if (PrintArticleUsageComponent.this.dateChooser != null) {
                PrintArticleUsageComponent.this.dateChooser.setLocation(PrintArticleUsageComponent.this.border, cy);
                PrintArticleUsageComponent.this.dateChooser.setSize(PrintArticleUsageComponent.this.dateChooser.getPreferredSize());
                cy = PrintArticleUsageComponent.this.dateChooser.getY() + PrintArticleUsageComponent.this.dateChooser.getHeight() + PrintArticleUsageComponent.this.border;
            }
            if (PrintArticleUsageComponent.this.table != null) {
                PrintArticleUsageComponent.this.table.setLocation(PrintArticleUsageComponent.this.border, cy);
                PrintArticleUsageComponent.this.table.setSize(parent.getWidth() - 2 * PrintArticleUsageComponent.this.border, parent.getHeight() - (cy + PrintArticleUsageComponent.this.border));
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintArticleUsageComponent.this.getInheritedComponentsHeight() + PrintArticleUsageComponent.this.border;
            return new Dimension(0, h);
        }
    }
}

