/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.product.factsheet.excel;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.ProductReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.HUDToolkit;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductReference;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight_;
import ch.icit.pegasus.server.core.dtos.report.ProductFactSheetReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ProductFactSheetsReportConfiguration;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.DataFieldAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ProductAccess;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;

public class ExportProductFactSheetComponent
extends DefaultScrollablePrintPopup2<ProductComplete>
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private final Node<ProductComplete> currentProduct;
    private final Node configNode;
    private TitledItem<DateChooser> dueDate;
    private HorizontalSeparator sep1;
    private TextLabel printOptionTitle;
    private TitledItem<CheckBox> includeCosts;
    private TitledItem<CheckBox> includeMealPlanAndStowingListData;
    private TitledItem<ComboBox> includeTender;
    private TitledItem<CheckBox> resolveRecipesToArticles;
    private TitledItem<CheckBox> splitCostCenters;
    private TitledItem<CheckBox> includeManMinutes;
    private TitledItem<CheckBox> includeProductMM;
    private TitledItem<CheckBox> includeGroupMM;
    private TitledItem<CheckBox> includeComponentMM;
    private boolean showProductionCosts = false;
    private boolean printExternalCostFactSheet = false;

    public ExportProductFactSheetComponent(Node<ProductComplete> node) {
        super(false, false, false, null);
        this.currentProduct = node;
        Runnable r = () -> {
            UserComplete user = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
            ModuleAccessRightComplete r1 = HUDToolkit.getCurrentAccessRight(ProductAccess.MODULE_PRODUCT, user);
            for (DataFieldAccessRightComplete a : r1.getFieldAccessRights()) {
                if (a.getField().getName().equals(ProductAccess.SHOW_PRODUCTION_COSTS.getName())) {
                    this.showProductionCosts = true;
                    continue;
                }
                if (!a.getField().getName().equals(ProductAccess.PRINT_EXTERNAL_COST_FACT_SHEET.getName())) continue;
                this.printExternalCostFactSheet = true;
            }
        };
        this.loadBeforeShowing(r);
        ProductFactSheetReportConfiguration config = new ProductFactSheetReportConfiguration(null);
        config.setDueDate(new Timestamp(System.currentTimeMillis()));
        this.configNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)config, false, false);
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        Font f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
        Color fb = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color"));
        Node dNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)new Date(System.currentTimeMillis()), false, false);
        this.dueDate = new TitledItem<DateChooser>(new DateChooser(dNode), Words.DUE_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.dueDate.getElement().setIsTimestamp(true);
        this.sep1 = new HorizontalSeparator();
        this.printOptionTitle = new TextLabel(WordsToolkit.toUpperCase((String)Words.OPTIONS));
        this.printOptionTitle.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_titled_item_font_type")));
        this.printOptionTitle.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_titled_item_foreground")));
        this.includeCosts = new TitledItem<CheckBox>(new CheckBox(), "Include Costs (Sales Price)", TitledItem.TitledItemOrientation.EAST);
        this.includeCosts.setTitleFont(f);
        this.includeCosts.setTitleForeground(fb);
        this.includeCosts.getElement().setChecked(this.showProductionCosts);
        this.includeCosts.getElement().addButtonListener(this);
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        if (Boolean.TRUE.equals(settings.getUseProductTenderScenario())) {
            this.includeTender = new TitledItem<ComboBox>(new ComboBox(), Words.TENDER, TitledItem.TitledItemOrientation.NORTH);
            this.includeTender.getElement().addItem(Words.ALL);
            this.includeTender.getElement().addItem(Words.TENDER);
            this.includeTender.getElement().addItem(Words.PRODUCTIVE);
            if (!this.printExternalCostFactSheet) {
                this.includeTender.getElement().setSelectedItem(Words.PRODUCTIVE);
            }
        }
        this.includeManMinutes = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_MAN_MINUTES_SHEET, TitledItem.TitledItemOrientation.EAST);
        this.includeMealPlanAndStowingListData = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_MEAL_PLAN_AND_STOWING_LIST, TitledItem.TitledItemOrientation.EAST);
        this.includeProductMM = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_PRODUCT_MM_SHEET, TitledItem.TitledItemOrientation.EAST);
        this.includeGroupMM = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_GROUP_MM_SHEET, TitledItem.TitledItemOrientation.EAST);
        this.includeComponentMM = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_COMPONENT_MM_SHEET, TitledItem.TitledItemOrientation.EAST);
        this.resolveRecipesToArticles = new TitledItem<CheckBox>(new CheckBox(), Words.RESOLVE_RECIPES_TO_ARTICLES, TitledItem.TitledItemOrientation.EAST);
        this.splitCostCenters = new TitledItem<CheckBox>(new CheckBox(), Words.SPLIT_DEPARTMENTS, TitledItem.TitledItemOrientation.EAST);
        this.getViewContainer().add(this.dueDate);
        this.getViewContainer().add(this.sep1);
        this.getViewContainer().add(this.printOptionTitle);
        this.getViewContainer().add(this.includeCosts);
        if (this.includeTender != null) {
            this.getViewContainer().add(this.includeTender);
        }
        this.getViewContainer().add(this.includeManMinutes);
        this.getViewContainer().add(this.includeProductMM);
        this.getViewContainer().add(this.includeGroupMM);
        this.getViewContainer().add(this.includeComponentMM);
        this.getViewContainer().add(this.includeMealPlanAndStowingListData);
        this.getViewContainer().add(this.resolveRecipesToArticles);
        this.getViewContainer().add(this.splitCostCenters);
        this.setEnabled(true);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.sep1.setEnabled(isEnabled);
        this.printOptionTitle.setEnabled(isEnabled);
        this.includeCosts.setEnabled(isEnabled && this.showProductionCosts);
        if (this.includeTender != null) {
            this.includeTender.setEnabled(isEnabled && this.printExternalCostFactSheet);
        }
        this.includeManMinutes.setEnabled(isEnabled);
        this.includeProductMM.setEnabled(isEnabled);
        this.includeGroupMM.setEnabled(isEnabled);
        this.includeComponentMM.setEnabled(isEnabled);
        this.includeMealPlanAndStowingListData.setEnabled(isEnabled);
        this.resolveRecipesToArticles.setEnabled(isEnabled);
        this.splitCostCenters.setEnabled(isEnabled);
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String v = s[1];
            Boolean b = Boolean.valueOf(v);
            if (n.equals("costs")) {
                this.includeCosts.getElement().setChecked(b);
            }
            if (n.equals("mp_stowing")) {
                this.includeMealPlanAndStowingListData.getElement().setChecked(b);
            }
            if (n.equals("resolveRecipesToArticles")) {
                this.resolveRecipesToArticles.getElement().setChecked(b);
            }
            if (n.equals("splitCostCenters")) {
                this.splitCostCenters.getElement().setChecked(b);
            }
            if (n.equals("manMinutes")) {
                this.includeManMinutes.getElement().setChecked(b);
            }
            if (n.equals("includeProductMM")) {
                this.includeProductMM.getElement().setChecked(b);
            }
            if (n.equals("includeGroupMM")) {
                this.includeGroupMM.getElement().setChecked(b);
            }
            if (!n.equals("includeComponentMM")) continue;
            this.includeComponentMM.getElement().setChecked(b);
        }
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        conf.addProperty("costs", "" + this.includeCosts.getElement().isChecked());
        conf.addProperty("mp_stowing", "" + this.includeMealPlanAndStowingListData.getElement().isChecked());
        conf.addProperty("resolveRecipesToArticles", "" + this.resolveRecipesToArticles.getElement().isChecked());
        conf.addProperty("splitCostCenters", "" + this.splitCostCenters.getElement().isChecked());
        conf.addProperty("manMinutes", "" + this.includeManMinutes.getElement().isChecked());
        conf.addProperty("includeProductMM", "" + this.includeProductMM.getElement().isChecked());
        conf.addProperty("includeGroupMM", "" + this.includeGroupMM.getElement().isChecked());
        conf.addProperty("includeComponentMM", "" + this.includeComponentMM.getElement().isChecked());
        return conf;
    }

    @Override
    public String getTitleString() {
        return Words.PRODUCT_FACT_SHEETS;
    }

    @Override
    public String getTitleValue() {
        return (String)this.currentProduct.getChildNamed(new DtoField[]{ProductComplete_.currentVariant, ProductVariantLight_.name}).getValue();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.printOptionTitle != null) {
            this.printOptionTitle.kill();
        }
        if (this.dueDate != null) {
            this.dueDate.kill();
        }
        if (this.sep1 != null) {
            this.sep1.kill();
        }
        if (this.includeCosts != null) {
            this.includeCosts.kill();
        }
        if (this.includeTender != null) {
            this.includeTender.kill();
        }
        if (this.includeMealPlanAndStowingListData != null) {
            this.includeMealPlanAndStowingListData.kill();
        }
        if (this.includeManMinutes != null) {
            this.includeManMinutes.kill();
        }
        if (this.includeProductMM != null) {
            this.includeProductMM.kill();
        }
        if (this.includeGroupMM != null) {
            this.includeGroupMM.kill();
        }
        if (this.includeComponentMM != null) {
            this.includeComponentMM.kill();
        }
        if (this.resolveRecipesToArticles != null) {
            this.resolveRecipesToArticles.kill();
        }
        if (this.splitCostCenters != null) {
            this.splitCostCenters.kill();
        }
        this.includeMealPlanAndStowingListData = null;
        this.includeTender = null;
        this.printOptionTitle = null;
        this.dueDate = null;
        this.sep1 = null;
        this.includeCosts = null;
        this.resolveRecipesToArticles = null;
        this.splitCostCenters = null;
        this.includeManMinutes = null;
        this.includeProductMM = null;
        this.includeGroupMM = null;
        this.includeComponentMM = null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.dueDate != null) {
            this.dueDate.setVisible(true);
        }
        if (this.sep1 != null) {
            this.sep1.setVisible(true);
        }
        if (this.printOptionTitle != null) {
            this.printOptionTitle.setVisible(true);
        }
        if (this.includeCosts != null) {
            this.includeCosts.setVisible(true);
        }
        if (this.includeTender != null) {
            this.includeTender.setVisible(true);
        }
        if (this.includeManMinutes != null) {
            this.includeManMinutes.setVisible(true);
        }
        if (this.includeProductMM != null) {
            this.includeProductMM.setVisible(true);
        }
        if (this.includeGroupMM != null) {
            this.includeGroupMM.setVisible(true);
        }
        if (this.includeComponentMM != null) {
            this.includeComponentMM.setVisible(true);
        }
        if (this.includeMealPlanAndStowingListData != null) {
            this.includeMealPlanAndStowingListData.setVisible(true);
        }
        if (this.resolveRecipesToArticles != null) {
            this.resolveRecipesToArticles.setVisible(true);
        }
        if (this.splitCostCenters != null) {
            this.splitCostCenters.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.dueDate != null) {
            this.dueDate.setVisible(false);
        }
        if (this.sep1 != null) {
            this.sep1.setVisible(false);
        }
        if (this.printOptionTitle != null) {
            this.printOptionTitle.setVisible(false);
        }
        if (this.includeCosts != null) {
            this.includeCosts.setVisible(false);
        }
        if (this.includeTender != null) {
            this.includeTender.setVisible(false);
        }
        if (this.includeMealPlanAndStowingListData != null) {
            this.includeMealPlanAndStowingListData.setVisible(false);
        }
        if (this.includeManMinutes != null) {
            this.includeManMinutes.setVisible(false);
        }
        if (this.includeProductMM != null) {
            this.includeProductMM.setVisible(false);
        }
        if (this.includeGroupMM != null) {
            this.includeGroupMM.setVisible(false);
        }
        if (this.includeComponentMM != null) {
            this.includeComponentMM.setVisible(false);
        }
        if (this.resolveRecipesToArticles != null) {
            this.resolveRecipesToArticles.setVisible(false);
        }
        if (this.splitCostCenters != null) {
            this.splitCostCenters.setVisible(false);
        }
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ExportProductFactSheetComponent.this.configNode.commit();
                Date date = (Date)((DateChooser)ExportProductFactSheetComponent.this.dueDate.getElement()).getNode().getValue();
                ArrayList<ProductReference> products = new ArrayList<ProductReference>();
                products.add(new ProductReference(((ProductComplete)ExportProductFactSheetComponent.this.currentProduct.getValue()).getId()));
                boolean showCosts = false;
                if (ExportProductFactSheetComponent.this.showProductionCosts) {
                    showCosts = ((CheckBox)ExportProductFactSheetComponent.this.includeCosts.getElement()).isChecked();
                }
                boolean includeMP_STW = false;
                if (ExportProductFactSheetComponent.this.includeMealPlanAndStowingListData != null) {
                    includeMP_STW = ((CheckBox)ExportProductFactSheetComponent.this.includeMealPlanAndStowingListData.getElement()).isChecked();
                }
                boolean manMinutes = ((CheckBox)ExportProductFactSheetComponent.this.includeManMinutes.getElement()).isChecked();
                boolean includeProductMMSheet = ((CheckBox)ExportProductFactSheetComponent.this.includeProductMM.getElement()).isChecked();
                boolean includeGroupMMSheet = ((CheckBox)ExportProductFactSheetComponent.this.includeGroupMM.getElement()).isChecked();
                boolean includeComponentMMSheet = ((CheckBox)ExportProductFactSheetComponent.this.includeComponentMM.getElement()).isChecked();
                Boolean showTender = false;
                if (ExportProductFactSheetComponent.this.includeTender != null) {
                    if (!ExportProductFactSheetComponent.this.printExternalCostFactSheet) {
                        showTender = false;
                    } else if (((ComboBox)ExportProductFactSheetComponent.this.includeTender.getElement()).getSelectedItem().equals(Words.ALL)) {
                        showTender = null;
                    } else if (((ComboBox)ExportProductFactSheetComponent.this.includeTender.getElement()).getSelectedItem().equals(Words.TENDER)) {
                        showTender = true;
                    } else if (((ComboBox)ExportProductFactSheetComponent.this.includeTender.getElement()).getSelectedItem().equals(Words.PRODUCTIVE)) {
                        showTender = false;
                    }
                }
                boolean resolveRecipes = ExportProductFactSheetComponent.this.resolveRecipesToArticles != null ? ((CheckBox)ExportProductFactSheetComponent.this.resolveRecipesToArticles.getElement()).isChecked() : false;
                boolean splitDepartments = ExportProductFactSheetComponent.this.splitCostCenters != null ? ((CheckBox)ExportProductFactSheetComponent.this.splitCostCenters.getElement()).isChecked() : false;
                ProductFactSheetsReportConfiguration configuration = new ProductFactSheetsReportConfiguration();
                configuration.setDueDate(date);
                configuration.setIncludeCosts(Boolean.valueOf(showCosts));
                configuration.setIncludeMpAndStwUsage(Boolean.valueOf(includeMP_STW));
                configuration.setResolveRecipesToArticles(Boolean.valueOf(resolveRecipes));
                configuration.setIncludeMMSheet(Boolean.valueOf(manMinutes));
                configuration.setShowProductComponentDepartmentsSeperately(Boolean.valueOf(splitDepartments));
                configuration.setIncludeProductMMSheet(Boolean.valueOf(includeProductMMSheet));
                configuration.setIncludeGroupMMSheet(Boolean.valueOf(includeGroupMMSheet));
                configuration.setIncludeComponentMMSheet(Boolean.valueOf(includeComponentMMSheet));
                configuration.setShowTender(showTender);
                PegasusFileComplete t = (PegasusFileComplete)((ProductReportServiceManager)ServiceManagerRegistry.getService(ProductReportServiceManager.class)).createProductFactSheetExportForProducts(new ListWrapper(products), configuration).getValue();
                ExportProductFactSheetComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ExportProductFactSheetComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<ProductComplete> getCurrentNode() {
        return this.currentProduct;
    }

    @Override
    public BatchJob<ProductComplete> createBatchJob(Node<ProductComplete> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = ExportProductFactSheetComponent.this.layoutInheritedComponents(parent);
            if (ExportProductFactSheetComponent.this.dueDate != null) {
                ExportProductFactSheetComponent.this.dueDate.setLocation(ExportProductFactSheetComponent.this.border, y + ExportProductFactSheetComponent.this.border / 2);
                ExportProductFactSheetComponent.this.dueDate.setSize(parent.getWidth() - 2 * ExportProductFactSheetComponent.this.border, (int)ExportProductFactSheetComponent.this.dueDate.getPreferredSize().getHeight());
                y = ExportProductFactSheetComponent.this.dueDate.getY() + ExportProductFactSheetComponent.this.dueDate.getHeight();
            }
            if (ExportProductFactSheetComponent.this.sep1 != null) {
                ExportProductFactSheetComponent.this.sep1.setLocation(0, y + ExportProductFactSheetComponent.this.border / 2);
                ExportProductFactSheetComponent.this.sep1.setSize(parent.getWidth(), (int)ExportProductFactSheetComponent.this.sep1.getPreferredSize().getHeight());
                y = ExportProductFactSheetComponent.this.sep1.getY() + ExportProductFactSheetComponent.this.sep1.getHeight();
            }
            if (ExportProductFactSheetComponent.this.printOptionTitle != null) {
                ExportProductFactSheetComponent.this.printOptionTitle.setLocation(ExportProductFactSheetComponent.this.border, y + ExportProductFactSheetComponent.this.border);
                ExportProductFactSheetComponent.this.printOptionTitle.setSize(parent.getWidth() - 2 * ExportProductFactSheetComponent.this.border, (int)ExportProductFactSheetComponent.this.printOptionTitle.getPreferredSize().getHeight());
                y = ExportProductFactSheetComponent.this.printOptionTitle.getY() + ExportProductFactSheetComponent.this.printOptionTitle.getHeight();
            }
            if (ExportProductFactSheetComponent.this.includeCosts != null) {
                ExportProductFactSheetComponent.this.includeCosts.setLocation(ExportProductFactSheetComponent.this.border, y + ExportProductFactSheetComponent.this.border / 2);
                ExportProductFactSheetComponent.this.includeCosts.setSize(parent.getWidth() - 2 * ExportProductFactSheetComponent.this.border, (int)ExportProductFactSheetComponent.this.includeCosts.getPreferredSize().getHeight());
                y = ExportProductFactSheetComponent.this.includeCosts.getY() + ExportProductFactSheetComponent.this.includeCosts.getHeight();
            }
            if (ExportProductFactSheetComponent.this.includeMealPlanAndStowingListData != null) {
                ExportProductFactSheetComponent.this.includeMealPlanAndStowingListData.setLocation(ExportProductFactSheetComponent.this.border, y + ExportProductFactSheetComponent.this.border / 2);
                ExportProductFactSheetComponent.this.includeMealPlanAndStowingListData.setSize(parent.getWidth() - 2 * ExportProductFactSheetComponent.this.border, (int)ExportProductFactSheetComponent.this.includeMealPlanAndStowingListData.getPreferredSize().getHeight());
                y = ExportProductFactSheetComponent.this.includeMealPlanAndStowingListData.getY() + ExportProductFactSheetComponent.this.includeMealPlanAndStowingListData.getHeight();
            }
            if (ExportProductFactSheetComponent.this.includeManMinutes != null) {
                ExportProductFactSheetComponent.this.includeManMinutes.setLocation(ExportProductFactSheetComponent.this.border, y + ExportProductFactSheetComponent.this.border / 2);
                ExportProductFactSheetComponent.this.includeManMinutes.setSize(parent.getWidth() - 2 * ExportProductFactSheetComponent.this.border, (int)ExportProductFactSheetComponent.this.includeManMinutes.getPreferredSize().getHeight());
                y = ExportProductFactSheetComponent.this.includeManMinutes.getY() + ExportProductFactSheetComponent.this.includeManMinutes.getHeight();
            }
            if (ExportProductFactSheetComponent.this.includeProductMM != null) {
                ExportProductFactSheetComponent.this.includeProductMM.setLocation(ExportProductFactSheetComponent.this.border, y + ExportProductFactSheetComponent.this.border / 2);
                ExportProductFactSheetComponent.this.includeProductMM.setSize(parent.getWidth() - 2 * ExportProductFactSheetComponent.this.border, (int)ExportProductFactSheetComponent.this.includeProductMM.getPreferredSize().getHeight());
                y = ExportProductFactSheetComponent.this.includeProductMM.getY() + ExportProductFactSheetComponent.this.includeProductMM.getHeight();
            }
            if (ExportProductFactSheetComponent.this.includeGroupMM != null) {
                ExportProductFactSheetComponent.this.includeGroupMM.setLocation(ExportProductFactSheetComponent.this.border, y + ExportProductFactSheetComponent.this.border / 2);
                ExportProductFactSheetComponent.this.includeGroupMM.setSize(parent.getWidth() - 2 * ExportProductFactSheetComponent.this.border, (int)ExportProductFactSheetComponent.this.includeGroupMM.getPreferredSize().getHeight());
                y = ExportProductFactSheetComponent.this.includeGroupMM.getY() + ExportProductFactSheetComponent.this.includeGroupMM.getHeight();
            }
            if (ExportProductFactSheetComponent.this.includeComponentMM != null) {
                ExportProductFactSheetComponent.this.includeComponentMM.setLocation(ExportProductFactSheetComponent.this.border, y + ExportProductFactSheetComponent.this.border / 2);
                ExportProductFactSheetComponent.this.includeComponentMM.setSize(parent.getWidth() - 2 * ExportProductFactSheetComponent.this.border, (int)ExportProductFactSheetComponent.this.includeComponentMM.getPreferredSize().getHeight());
                y = ExportProductFactSheetComponent.this.includeComponentMM.getY() + ExportProductFactSheetComponent.this.includeComponentMM.getHeight();
            }
            if (ExportProductFactSheetComponent.this.includeTender != null) {
                ExportProductFactSheetComponent.this.includeTender.setLocation(ExportProductFactSheetComponent.this.border, y + ExportProductFactSheetComponent.this.border / 2);
                ExportProductFactSheetComponent.this.includeTender.setSize(parent.getWidth() - 2 * ExportProductFactSheetComponent.this.border, (int)ExportProductFactSheetComponent.this.includeTender.getPreferredSize().getHeight());
                y = ExportProductFactSheetComponent.this.includeTender.getY() + ExportProductFactSheetComponent.this.includeTender.getHeight();
            }
            if (ExportProductFactSheetComponent.this.resolveRecipesToArticles != null) {
                ExportProductFactSheetComponent.this.resolveRecipesToArticles.setLocation(ExportProductFactSheetComponent.this.border, y + ExportProductFactSheetComponent.this.border);
                ExportProductFactSheetComponent.this.resolveRecipesToArticles.setSize(ExportProductFactSheetComponent.this.resolveRecipesToArticles.getPreferredSize());
                y = ExportProductFactSheetComponent.this.resolveRecipesToArticles.getY() + ExportProductFactSheetComponent.this.resolveRecipesToArticles.getHeight();
            }
            if (ExportProductFactSheetComponent.this.splitCostCenters != null) {
                ExportProductFactSheetComponent.this.splitCostCenters.setLocation(ExportProductFactSheetComponent.this.border, y + ExportProductFactSheetComponent.this.border);
                ExportProductFactSheetComponent.this.splitCostCenters.setSize(ExportProductFactSheetComponent.this.splitCostCenters.getPreferredSize());
                y = ExportProductFactSheetComponent.this.splitCostCenters.getY() + ExportProductFactSheetComponent.this.splitCostCenters.getHeight();
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = ExportProductFactSheetComponent.this.getInheritedComponentsHeight();
            int w = 250;
            h += ExportProductFactSheetComponent.this.border;
            if (ExportProductFactSheetComponent.this.dueDate != null) {
                h = (int)((double)h + ExportProductFactSheetComponent.this.dueDate.getPreferredSize().getHeight());
                h += ExportProductFactSheetComponent.this.border / 2;
            }
            if (ExportProductFactSheetComponent.this.sep1 != null) {
                h = (int)((double)h + ExportProductFactSheetComponent.this.sep1.getPreferredSize().getHeight());
                h += ExportProductFactSheetComponent.this.border;
            }
            if (ExportProductFactSheetComponent.this.printOptionTitle != null) {
                h = (int)((double)h + ExportProductFactSheetComponent.this.printOptionTitle.getPreferredSize().getHeight());
                h += ExportProductFactSheetComponent.this.border / 2;
            }
            if (ExportProductFactSheetComponent.this.includeCosts != null) {
                h = (int)((double)h + ExportProductFactSheetComponent.this.includeCosts.getPreferredSize().getHeight());
                h += ExportProductFactSheetComponent.this.border;
            }
            if (ExportProductFactSheetComponent.this.includeTender != null) {
                h = (int)((double)h + ExportProductFactSheetComponent.this.includeTender.getPreferredSize().getHeight());
                h += ExportProductFactSheetComponent.this.border;
            }
            if (ExportProductFactSheetComponent.this.includeMealPlanAndStowingListData != null) {
                h = (int)((double)h + ExportProductFactSheetComponent.this.includeMealPlanAndStowingListData.getPreferredSize().getHeight());
                h += ExportProductFactSheetComponent.this.border;
            }
            if (ExportProductFactSheetComponent.this.includeManMinutes != null) {
                h = (int)((double)h + ExportProductFactSheetComponent.this.includeManMinutes.getPreferredSize().getHeight());
                h += ExportProductFactSheetComponent.this.border;
            }
            if (ExportProductFactSheetComponent.this.includeProductMM != null) {
                h = (int)((double)h + ExportProductFactSheetComponent.this.includeProductMM.getPreferredSize().getHeight());
                h += ExportProductFactSheetComponent.this.border;
            }
            if (ExportProductFactSheetComponent.this.includeGroupMM != null) {
                h = (int)((double)h + ExportProductFactSheetComponent.this.includeGroupMM.getPreferredSize().getHeight());
                h += ExportProductFactSheetComponent.this.border;
            }
            if (ExportProductFactSheetComponent.this.includeComponentMM != null) {
                h = (int)((double)h + ExportProductFactSheetComponent.this.includeComponentMM.getPreferredSize().getHeight());
                h += ExportProductFactSheetComponent.this.border;
            }
            if (ExportProductFactSheetComponent.this.resolveRecipesToArticles != null) {
                h = (int)((double)h + ExportProductFactSheetComponent.this.resolveRecipesToArticles.getPreferredSize().getHeight());
                h += ExportProductFactSheetComponent.this.border;
            }
            if (ExportProductFactSheetComponent.this.splitCostCenters != null) {
                h = (int)((double)h + ExportProductFactSheetComponent.this.splitCostCenters.getPreferredSize().getHeight());
                h += ExportProductFactSheetComponent.this.border;
            }
            return new Dimension(w, h);
        }
    }
}

