/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.customer.sobconfiguration.utils;

import ch.icit.pegasus.client.converter.CreditCardTypeConverter;
import ch.icit.pegasus.client.converter.CreditCardValidityConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.CreditCardRangeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CreditCardRangeComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.CreditCardTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CreditCardValidityE;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class CreditCardRangesTable
extends Table2 {
    private static final long serialVersionUID = 1L;

    public CreditCardRangesTable() {
        super(true, Words.TABLE_ADD, true, true);
        this.setTitleText("Card Ranges");
        this.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                CreditCardRangeComplete r = new CreditCardRangeComplete();
                r.setStartNo(Long.valueOf(0L));
                r.setEndNo(Long.valueOf(0L));
                r.setClientOId(Long.valueOf(ADTO.getNextId()));
                Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)r, true, false);
                CreditCardRangesTable.this.getModel().getNode().addChild(n, 0L);
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.CREDIT_CARD_TYPE, null, null, null, "", 40, 40, 40));
        columns.add(new TableColumnInfo(Words.ALLOWED, null, null, null, "", 200, 200, 200));
        columns.add(new TableColumnInfo(Words.FROM, null, null, null, "", 150, 150, 150));
        columns.add(new TableColumnInfo(Words.TO, null, null, null, "", 150, 150, 150));
        int tw = 2 * this.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private ComboBox type;
        private ComboBox allowed;
        private TextField from;
        private TextField to;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            this.type = new ComboBox(m.getNode().getChildNamed(CreditCardRangeComplete_.card), NodeToolkit.getAffixList(CreditCardTypeComplete.class), ConverterRegistry.getConverter(CreditCardTypeConverter.class));
            this.allowed = new ComboBox(m.getNode().getChildNamed(CreditCardRangeComplete_.validity), NodeToolkit.getAffixList(CreditCardValidityE.class), ConverterRegistry.getConverter(CreditCardValidityConverter.class));
            this.from = new NumberTextField(m.getNode().getChildNamed(CreditCardRangeComplete_.startNo), TextFieldType.LONG);
            this.to = new NumberTextField(m.getNode().getChildNamed(CreditCardRangeComplete_.endNo), TextFieldType.LONG);
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.setLayout(new Layout());
            this.add(this.type);
            this.add(this.allowed);
            this.add(this.from);
            this.add(this.to);
            this.add(this.delete);
        }

        @Override
        public List<Component> getFocusComponents() {
            List<Component> a = this.type.getFocusComponents();
            CheckedListAdder.addToList(a, this.allowed);
            CheckedListAdder.addToList(a, this.from);
            CheckedListAdder.addToList(a, this.to);
            CheckedListAdder.addToList(a, this.delete);
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.model.getNode().getChildNamed(new String[]{CreditCardRangeComplete_.card + "-cardTypeName"}).getValue();
                }
                case 1: {
                    return this.model.getNode().getChildNamed(CreditCardRangeComplete_.validity).getValue();
                }
                case 2: {
                    return this.model.getNode().getChildNamed(CreditCardRangeComplete_.startNo).getValue();
                }
                case 3: {
                    return this.model.getNode().getChildNamed(CreditCardRangeComplete_.endNo).getValue();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.type.setEnabled(isEnabled);
            this.allowed.setEnabled(isEnabled);
            this.from.setEnabled(isEnabled);
            this.to.setEnabled(isEnabled);
            this.delete.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.type.kill();
            this.type = null;
            this.allowed.kill();
            this.allowed = null;
            this.from.kill();
            this.from = null;
            this.to.kill();
            this.to = null;
            this.delete.kill();
            this.delete = null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), 0L);
            }
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.type.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.type.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.type.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.type.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.allowed.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.allowed.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.allowed.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.allowed.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.from.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.from.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.from.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.from.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.to.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.to.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.to.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.to.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }
}

