/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.label;

import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.PDFViewer;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.LabelReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientExceptionCollection;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.DeliverableComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.DeliverySpaceComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.DeliverySpaceDistributionRuleComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.EquipmentDistributionRuleComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyDistributionRuleComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentReservedSpaceTrayComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.TrackableItemComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TrackableItemWrapper;
import com.sun.pdfview.PDFFile;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class LabelPreviewInsert
extends PopUpInsert {
    private static final long serialVersionUID = 1L;
    private FlightReference flight;
    private StowingListTemplateReference stw;
    private FlightScheduleReference flightSchedule;
    private TrackableItemComplete item;
    private LoadingAnimation animation;
    private List<DeliverableComplete> instructions;
    private PDFViewer viewer;
    private TextLabel label;

    public LabelPreviewInsert(TrackableItemComplete item, FlightReference flight, List<DeliverableComplete> instructions) {
        this(item);
        this.item = item;
        this.flight = flight;
        this.instructions = new ArrayList<DeliverableComplete>();
        this.instructions.addAll(instructions);
        this.loadPreview();
    }

    public LabelPreviewInsert(TrackableItemComplete item, StowingListTemplateReference stw, List<DeliverableComplete> instructions) {
        this(item);
        this.item = item;
        this.stw = stw;
        this.instructions = new ArrayList<DeliverableComplete>();
        this.instructions.addAll(instructions);
        this.loadPreview();
    }

    public LabelPreviewInsert(TrackableItemComplete item, FlightScheduleReference flight, List<DeliverableComplete> instructions) {
        this(item);
        this.item = item;
        this.flightSchedule = flight;
        this.instructions = new ArrayList<DeliverableComplete>();
        this.instructions.addAll(instructions);
        this.loadPreview();
    }

    public LabelPreviewInsert(TrackableItemComplete item) {
        this.item = item;
        this.setLayout(new Layout());
    }

    private void showAnimation(String maxText) {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged(maxText);
            this.animation.fadeIn();
            this.animation.start();
            this.add((Component)this.animation, 0);
        }
    }

    private void hideAnimation() {
        if (this.animation != null) {
            this.animation.stop();
            this.animation.kill();
            this.animation = null;
        }
    }

    private void loadPreview() {
        this.showAnimation("Create Label Preview");
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                byte[] b = null;
                ArrayList<DeliverableComplete> a = new ArrayList<DeliverableComplete>();
                for (DeliverableComplete i : LabelPreviewInsert.this.instructions) {
                    boolean found = false;
                    for (GalleyDistributionRuleComplete gdr : i.getDeliveryInstruction().getGalleyDistributionRules()) {
                        for (EquipmentDistributionRuleComplete edr : gdr.getEquipmentDistributionRules()) {
                            if (LabelPreviewInsert.this.item instanceof GalleyEquipmentComplete) {
                                GalleyEquipmentComplete eq = (GalleyEquipmentComplete)LabelPreviewInsert.this.item;
                                for (EquipmentDistributionRuleComplete edrc : eq.getEquipmentDistributionRules()) {
                                    if (!edrc.equals((Object)edr)) continue;
                                    found = true;
                                }
                                continue;
                            }
                            for (DeliverySpaceDistributionRuleComplete dsdr : edr.getInsertDistributionRule()) {
                                DeliverySpaceComplete s;
                                if (LabelPreviewInsert.this.item instanceof DeliverySpaceComplete) {
                                    s = (DeliverySpaceComplete)LabelPreviewInsert.this.item;
                                    for (DeliverySpaceDistributionRuleComplete dsdrc : s.getDistributionRules()) {
                                        if (!dsdrc.equals((Object)dsdr)) continue;
                                        found = true;
                                    }
                                    continue;
                                }
                                if (!(LabelPreviewInsert.this.item instanceof GalleyEquipmentReservedSpaceTrayComplete)) continue;
                                s = ((GalleyEquipmentReservedSpaceTrayComplete)LabelPreviewInsert.this.item).getContainingReservedSpace();
                                for (DeliverySpaceDistributionRuleComplete dsdrc : s.getDistributionRules()) {
                                    if (!dsdrc.equals((Object)dsdr)) continue;
                                    found = true;
                                }
                            }
                        }
                    }
                    if (!found) continue;
                    a.add(i);
                }
                ArrayList<String> errors = new ArrayList<String>();
                if (LabelPreviewInsert.this.item != null && LabelPreviewInsert.this.flight != null) {
                    if (LabelPreviewInsert.this.item instanceof TrackableItemComplete) {
                        b = ((LabelReportServiceManager)ServiceManagerRegistry.getService(LabelReportServiceManager.class)).createLabelPreviewForFlight(new TrackableItemWrapper(LabelPreviewInsert.this.item), new ListWrapper(a), LabelPreviewInsert.this.flight);
                    }
                } else if (LabelPreviewInsert.this.item != null && LabelPreviewInsert.this.flightSchedule != null) {
                    if (LabelPreviewInsert.this.item instanceof TrackableItemComplete) {
                        b = ((LabelReportServiceManager)ServiceManagerRegistry.getService(LabelReportServiceManager.class)).createLabelPreviewForFlightWithWarnings(new TrackableItemWrapper(LabelPreviewInsert.this.item), new ListWrapper(a), LabelPreviewInsert.this.flightSchedule, new ListWrapper(errors));
                    }
                } else if (LabelPreviewInsert.this.item != null && LabelPreviewInsert.this.stw != null && LabelPreviewInsert.this.item instanceof TrackableItemComplete) {
                    errors.add("Label Preview without a Flight Schedule or Flight is not yet implemented");
                }
                if (errors.isEmpty() && b == null) {
                    errors.add("Unable to create Label Data on Server.");
                }
                if (!errors.isEmpty()) {
                    throw new ClientExceptionCollection("", ScreenValidationObject.convertToScreenValidationList(errors));
                }
                ViewNode n = new ViewNode("Error");
                ByteBuffer buffer = null;
                if (b != null) {
                    buffer = ByteBuffer.wrap(b);
                }
                n.setValue((Object)buffer, 0L);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        if (node.getValue() instanceof ByteBuffer) {
                            try {
                                LabelPreviewInsert.this.showPreview((ByteBuffer)node.getValue());
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }

                    public void errorOccurred(ClientException exception) {
                        LabelPreviewInsert.this.errorOccurred(exception);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void showPreview(ByteBuffer array) throws IOException {
        this.hideAnimation();
        PDFFile pdfFile = new PDFFile(array);
        this.viewer = new PDFViewer();
        this.add(this.viewer);
        this.viewer.showPDF(null, pdfFile);
        this.label = new TextLabel("* only saved data is shown on label.");
        this.add(this.label);
        this.revalidate();
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.viewer != null) {
            this.viewer.kill();
        }
        if (this.label != null) {
            this.label.kill();
        }
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            return null;
        }
        return new Object[1];
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return false;
    }

    @Override
    public boolean tryToGrabFocus() {
        return false;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        return a;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            if (LabelPreviewInsert.this.animation != null) {
                LabelPreviewInsert.this.animation.setLocation((int)((double)parent.getWidth() - LabelPreviewInsert.this.animation.getPreferredSize().getWidth()) / 2, (int)(((double)parent.getHeight() - LabelPreviewInsert.this.animation.getPreferredSize().getHeight()) / 2.0));
                LabelPreviewInsert.this.animation.setSize(LabelPreviewInsert.this.animation.getPreferredSize());
            }
            if (LabelPreviewInsert.this.viewer != null) {
                LabelPreviewInsert.this.viewer.setLocation(0, 0);
                LabelPreviewInsert.this.viewer.setSize((int)parent.getSize().getWidth(), (int)((double)parent.getHeight() - LabelPreviewInsert.this.label.getPreferredSize().getHeight()));
                LabelPreviewInsert.this.label.setLocation(15, LabelPreviewInsert.this.viewer.getHeight());
                LabelPreviewInsert.this.label.setSize(parent.getWidth() - 15, (int)LabelPreviewInsert.this.label.getPreferredSize().getHeight());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(300, 200);
        }
    }
}

