/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.mealplan.spec.details;

import ch.icit.pegasus.client.converter.ListInterpretationModeEConverter;
import ch.icit.pegasus.client.converter.MealTypeConverter;
import ch.icit.pegasus.client.converter.RoundingStrategyEConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.multiselection.MultiSPMLTypeSelectionComboBox;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.RoundingStrategyE;
import ch.icit.pegasus.server.core.dtos.masterdata.AlaCarteMenuTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.SpecialMenuTypeComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.ACateringServiceComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleVariantComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanLight;
import ch.icit.pegasus.server.core.dtos.mealplan.MealTypeComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.MealTypeComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.MealTypeConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.MealTypeConfigurationComplete_;
import ch.icit.pegasus.server.core.dtos.util.ListInterpretationModeE;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.IDTO;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class MealTypeConfigurationDetailsPanel<T extends IDTO>
extends DefaultDetailsPanel<T> {
    private static final long serialVersionUID = 1L;
    private Table2 table;
    private Node<CateringServiceScheduleVariantComplete> currentNode;

    public MealTypeConfigurationDetailsPanel(RowEditor<T> editor) {
        super(editor, null);
        this.setTitleText(Words.MEAL_TYPE_CONFIGURATION);
        this.setCustomLayouter(new Layout());
        this.table = new Table2(true, Words.TABLE_ADD, false, false);
        this.table.setProvider(this.provider);
        this.table.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                MealTypeConfigurationDetailsPanel.this.editor.revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                MealTypeConfigurationComplete mtc = new MealTypeConfigurationComplete();
                mtc.setClientOId(Long.valueOf(ADTO.getNextId()));
                Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)mtc, true, false);
                MealTypeConfigurationDetailsPanel.this.table.getModel().getNode().addChild(n, 0L);
                MealTypeConfigurationDetailsPanel.this.editor.revalidate();
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.TYPE, 120, 120, 120));
        columns.add(new TableColumnInfo(Words.SPML_MODE, 150, 150, 150));
        columns.add(new TableColumnInfo(Words.SPML_TYPE, 100, 100, 100));
        columns.add(new TableColumnInfo(Words.CARTE_MODE, 150, 150, 150));
        columns.add(new TableColumnInfo(Words.CARTE_TYPE, 120, 120, 120));
        columns.add(new TableColumnInfo(Words.ROUNDING, 120, 120, 120));
        int tw = this.table.getCellPadding() * 2 + CheckBox.getPreferredWidth() + 5;
        columns.add(new TableColumnInfo(Words.FIT, tw, tw, tw));
        ArrayList<Integer> fatLines = new ArrayList<Integer>();
        fatLines.add(2);
        fatLines.add(4);
        this.table.setFatLines(fatLines);
        tw = this.table.getCellPadding() * 2 + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL);
        columns.add(new TableColumnInfo("", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(5)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(6)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(7)).setxExpand(0.0);
        this.table.setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
        this.addToView(this.table);
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.table);
        return focusList;
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.table != null) {
            this.table.kill();
        }
        this.table = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean shouldEnable = isEnabled;
        MealPlanLight mp = (MealPlanLight)this.editor.getModel().getNode().getChildNamed(CateringServiceScheduleComplete_.mealplan).getValue();
        if (mp != null) {
            shouldEnable = mp.getState() == ModificationStateE.DRAFT && shouldEnable;
        }
        super.setEnabled(shouldEnable);
        this.table.setEnabled(shouldEnable);
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        Iterator it = this.table.getModel().getNode().getFailSafeChildIterator();
        HashSet<MealTypeComplete> include = new HashSet<MealTypeComplete>();
        HashSet<MealTypeComplete> exclude = new HashSet<MealTypeComplete>();
        while (it.hasNext()) {
            Node next = (Node)it.next();
            next.commitThis();
            if (((MealTypeConfigurationComplete)next.getValue()).getSpmlMode() == ListInterpretationModeE.INCLUDE) {
                if (include.contains(((MealTypeConfigurationComplete)next.getValue()).getMealType())) {
                    validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Duplicate Meal Type Configuration found"));
                    continue;
                }
                include.add(((MealTypeConfigurationComplete)next.getValue()).getMealType());
                continue;
            }
            if (((MealTypeConfigurationComplete)next.getValue()).getSpmlMode() != ListInterpretationModeE.EXCLUDE) continue;
            if (exclude.contains(((MealTypeConfigurationComplete)next.getValue()).getMealType())) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Duplicate Meal Type Configuration found"));
                continue;
            }
            exclude.add(((MealTypeConfigurationComplete)next.getValue()).getMealType());
        }
        return validationObjects;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.currentNode = node;
        this.table.getModel().setNode(this.currentNode.getChildNamed(ACateringServiceComplete_.mealTypeConfigs));
    }

    @Override
    public void requestFocusInWindowNow() {
        this.table.requestFocusInWindowNow();
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private ComboBox mealType;
        private ComboBox spmlMode;
        private MultiSPMLTypeSelectionComboBox<SpecialMenuTypeComplete> spml;
        private ComboBox carteMode;
        private MultiSPMLTypeSelectionComboBox<AlaCarteMenuTypeComplete> carte;
        private ComboBox rounding;
        private CheckBox fit;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            this.setLayout(new RowLayout());
            ViewNode roundings = new ViewNode("");
            Iterator it = NodeToolkit.getAffixList(RoundingStrategyE.class).getFailSafeChildIterator();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                if (n.getValue() == RoundingStrategyE.FILL) continue;
                roundings.addChild(n, 0L);
            }
            this.mealType = new ComboBox(m.getNode().getChildNamed(MealTypeConfigurationComplete_.mealType), NodeToolkit.getAffixList(MealTypeComplete.class), ConverterRegistry.getConverter(MealTypeConverter.class));
            this.spmlMode = new ComboBox(m.getNode().getChildNamed(MealTypeConfigurationComplete_.spmlMode), NodeToolkit.getAffixList(ListInterpretationModeE.class), ConverterRegistry.getConverter(ListInterpretationModeEConverter.class));
            this.spml = new MultiSPMLTypeSelectionComboBox<SpecialMenuTypeComplete>(m.getNode().getChildNamed(MealTypeConfigurationComplete_.spmlTypes), SpecialMenuTypeComplete.class);
            this.carteMode = new ComboBox(m.getNode().getChildNamed(MealTypeConfigurationComplete_.alaCarteMode), NodeToolkit.getAffixList(ListInterpretationModeE.class), ConverterRegistry.getConverter(ListInterpretationModeEConverter.class));
            this.carte = new MultiSPMLTypeSelectionComboBox<AlaCarteMenuTypeComplete>(m.getNode().getChildNamed(MealTypeConfigurationComplete_.alaCarteTypes), AlaCarteMenuTypeComplete.class);
            this.fit = new CheckBox((Node<Boolean>)m.getNode().getChildNamed(MealTypeConfigurationComplete_.normalizeRatioAmounts));
            this.rounding = new ComboBox(m.getNode().getChildNamed(MealTypeConfigurationComplete_.roundingStrategy), (Node)roundings, ConverterRegistry.getConverter(RoundingStrategyEConverter.class));
            this.delete = new DeleteButton();
            this.fit.addButtonListener(this);
            this.delete.addButtonListener(this);
            this.add(this.mealType);
            this.add(this.spmlMode);
            this.add(this.spml);
            this.add(this.carteMode);
            this.add(this.carte);
            this.add(this.rounding);
            this.add(this.fit);
            this.add(this.delete);
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.mealType);
            CheckedListAdder.addToList(a, this.spmlMode);
            CheckedListAdder.addToList(a, this.spml);
            CheckedListAdder.addToList(a, this.carteMode);
            CheckedListAdder.addToList(a, this.carte);
            CheckedListAdder.addToList(a, this.rounding);
            CheckedListAdder.addToList(a, this.delete);
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.model.getNode().getChildNamed(new String[]{MealTypeConfigurationComplete_.mealType + "-" + MealTypeComplete_.code}).getValue();
                }
                case 1: {
                    return this.model.getNode().getChildNamed(MealTypeConfigurationComplete_.spmlMode).getValue();
                }
                case 2: {
                    return MultiSPMLTypeSelectionComboBox.getSpecialMealTypeSelectionText((List)this.model.getNode().getChildNamed(MealTypeConfigurationComplete_.spmlTypes).getValue());
                }
                case 3: {
                    return this.model.getNode().getChildNamed(MealTypeConfigurationComplete_.alaCarteMode).getValue();
                }
                case 4: {
                    return MultiSPMLTypeSelectionComboBox.getSpecialMealTypeSelectionText((List)this.model.getNode().getChildNamed(MealTypeConfigurationComplete_.alaCarteTypes).getValue());
                }
                case 5: {
                    return this.model.getNode().getChildNamed(MealTypeConfigurationComplete_.roundingStrategy).getValue();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.mealType.setEnabled(isEnabled);
            this.spmlMode.setEnabled(isEnabled);
            this.spml.setEnabled(isEnabled);
            this.carteMode.setEnabled(isEnabled);
            this.carte.setEnabled(isEnabled);
            this.fit.setEnabled(isEnabled);
            boolean r = isEnabled && this.fit.isChecked();
            this.rounding.setEnabled(r);
            this.delete.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.mealType.kill();
            this.mealType = null;
            this.spmlMode.kill();
            this.spmlMode = null;
            this.spml.kill();
            this.spml = null;
            this.carteMode.kill();
            this.carteMode = null;
            this.carte.kill();
            this.carte = null;
            this.fit.kill();
            this.fit = null;
            this.rounding.kill();
            this.rounding = null;
            this.delete.kill();
            this.delete = null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), 0L);
            } else if (source == this.fit) {
                this.setEnabled(this.isEnabled());
            }
        }

        private class RowLayout
        extends DefaultLayout {
            private RowLayout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.mealType.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.mealType.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.mealType.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.mealType.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.spmlMode.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.spmlMode.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.spmlMode.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.spmlMode.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.spml.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.spml.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.spml.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.spml.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.carteMode.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.carteMode.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.carteMode.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.carteMode.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.carte.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.carte.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.carte.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.carte.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(5);
                TableRowImpl.this.rounding.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.rounding.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.rounding.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.rounding.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(6);
                TableRowImpl.this.fit.setLocation((int)((double)currentX + ((double)w - TableRowImpl.this.fit.getPreferredSize().getWidth()) / 2.0), (int)(((double)parent.getHeight() - TableRowImpl.this.fit.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.fit.setSize(TableRowImpl.this.fit.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(7);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            MealTypeConfigurationDetailsPanel.this.table.setLocation(0, 0);
            MealTypeConfigurationDetailsPanel.this.table.setSize(parent.getSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, (int)MealTypeConfigurationDetailsPanel.this.table.getPreferredSize().getHeight());
        }
    }
}

