/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.mealplan.spec.details;

import ch.icit.pegasus.client.comparators.controller.ComparatorRegistry;
import ch.icit.pegasus.client.converter.CateringRotationConverter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.RotationDurationConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.submodules.tool.mealplan.spec.details.PartsDetailsPanel;
import ch.icit.pegasus.client.gui.submodules.tool.mealplan.spec.details.RotationConfigurationDetailsPanel;
import ch.icit.pegasus.client.gui.submodules.tool.mealplan.spec.details.utils.popupinsert.DayOfMonthPopupInsert;
import ch.icit.pegasus.client.gui.submodules.tool.mealplan.spec.details.utils.popupinsert.MonthInsert;
import ch.icit.pegasus.client.gui.submodules.tool.mealplan.spec.details.utils.popupinsert.WeekDayInsert;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.SortableTable2RowPanel;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.EditButton;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.popup.IPopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.popup.myway.PopupInsertFactory;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.tables.comparators.NumberComparator;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceRotationComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceRotationComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceRotationLight_;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleVariantComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleVariantComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.DayOfMonthRotationComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.DayOfMonthRotationStrategyComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.FixDurationRotationComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.FixPeriodRotationStrategyComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.FixRotationStrategyComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanLight;
import ch.icit.pegasus.server.core.dtos.mealplan.MonthRotationComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.MonthRotationStrategyComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.RotationDurationComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.RotationStrategyComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.WeekdayRotationComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.WeekdayRotationStrategyComplete;
import ch.icit.pegasus.server.core.dtos.util.DateDurationComplete;
import ch.icit.pegasus.server.core.dtos.util.DateUnitE;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.IDTO;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RotationDetailsPanel<T extends IDTO>
extends DefaultDetailsPanel<T>
implements NodeListener {
    private static final long serialVersionUID = 1L;
    private Table2 table;
    private PartsDetailsPanel partsPanel;
    private Node<?> rotationNode;
    private Node<MealPlanLight> mpNode;
    private Node<CateringServiceScheduleVariantComplete> currentNode;

    public RotationDetailsPanel(RowEditor<T> editor, RotationConfigurationDetailsPanel rot, Node<MealPlanLight> mpNode) {
        super(editor, null);
        this.mpNode = mpNode;
        this.setTitleText(Words.CYCLES);
        this.table = new Table2(true, Words.ADD_CYCLE, false, false);
        this.table.setComparator(ComparatorRegistry.getComparator(NumberComparator.class));
        this.table.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                RotationDetailsPanel.this.table.writeNumber("number", 1);
                RotationDetailsPanel.this.editor.revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                if (RotationDetailsPanel.this.currentNode.getChildNamed(CateringServiceScheduleVariantComplete_.rotationStrategy).getValue() == null) {
                    InnerPopupFactory.showErrorDialog("Cycle Strategy must be defined before adding Cycles", (Component)source);
                } else {
                    CateringServiceRotationComplete rotation = new CateringServiceRotationComplete();
                    rotation.setClientOId(Long.valueOf(ADTO.getNextId()));
                    rotation.setNumber(Integer.valueOf(RotationDetailsPanel.this.currentNode.getChildNamed(CateringServiceScheduleVariantComplete_.rotations).getChildCount() + 1));
                    RotationDurationComplete rot = RotationDetailsPanel.this.getDurationForStrategy((RotationStrategyComplete)RotationDetailsPanel.this.currentNode.getChildNamed(CateringServiceScheduleVariantComplete_.rotationStrategy).getValue());
                    if (rot != null) {
                        rot.setClientOId(Long.valueOf(ADTO.getNextId()));
                        rotation.setRotationStrategy(rot);
                    }
                    RotationDetailsPanel.this.currentNode.getChildNamed(CateringServiceScheduleVariantComplete_.rotations).addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)rotation, true, false), System.currentTimeMillis());
                    RotationDetailsPanel.this.invalidate();
                    RotationDetailsPanel.this.revalidate();
                }
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.NO_NUMBER, null, null, null, "", 40, 40, 40));
        columns.add(new TableColumnInfo(Words.DURATION, null, null, null, "", 30, 30, 30));
        int tw = 3 * this.table.getCellPadding() + 2 * this.table.getInnerCellPadding() + 4 * DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        this.table.setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
        this.setCustomLayouter(new Layout());
        this.addToView(this.table);
    }

    public void setPartPanel(PartsDetailsPanel p) {
        this.partsPanel = p;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.currentNode = node;
        this.rotationNode = this.currentNode.getChildNamed(CateringServiceScheduleVariantComplete_.rotations);
        Iterator it = this.rotationNode.getChilds();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            n.setConverter(ConverterRegistry.getConverter(CateringRotationConverter.class));
        }
        this.table.getModel().setNode(this.rotationNode);
        this.rotationNode.addNodeListener((NodeListener)this);
        this.ensureAddPartButton();
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.table);
        return focusList;
    }

    public RotationDurationComplete getDurationForStrategy(RotationStrategyComplete strat) {
        if (strat instanceof FixRotationStrategyComplete) {
            FixDurationRotationComplete d = new FixDurationRotationComplete();
            d.setDuration(new DateDurationComplete());
            d.getDuration().setDuration(Double.valueOf(1.0));
            d.getDuration().setUnit(DateUnitE.DAY);
            return d;
        }
        if (strat instanceof WeekdayRotationStrategyComplete) {
            return new WeekdayRotationComplete();
        }
        if (strat instanceof DayOfMonthRotationStrategyComplete) {
            return new DayOfMonthRotationComplete();
        }
        if (strat instanceof MonthRotationStrategyComplete) {
            return new MonthRotationComplete();
        }
        return null;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.rotationNode != null) {
            this.rotationNode.removeNodeListener((NodeListener)this);
        }
        if (this.table != null) {
            this.table.kill();
        }
        this.table = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean shouldEnable = isEnabled;
        MealPlanLight mp = (MealPlanLight)this.editor.getModel().getNode().getChildNamed(CateringServiceScheduleComplete_.mealplan).getValue();
        if (mp != null) {
            shouldEnable = mp.getState() == ModificationStateE.DRAFT && shouldEnable;
        }
        super.setEnabled(shouldEnable);
        this.table.setEnabled(shouldEnable);
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    private void ensureAddPartButton() {
        if (this.partsPanel != null) {
            this.partsPanel.enableAddButton(this.rotationNode.getChildCount() > 0);
        }
    }

    public void childAdded(Node<?> source, Node<?> child) {
        this.ensureAddPartButton();
    }

    public void childRemoved(Node<?> source, Node<?> child) {
        this.ensureAddPartButton();
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public void valueChanged(Node<?> node) {
    }

    public boolean isSwingOnly() {
        return true;
    }

    private class TableRowImpl
    extends SortableTable2RowPanel
    implements InnerPopUpListener2,
    NodeListener {
        private static final long serialVersionUID = 1L;
        private TextLabel number;
        private TextLabel schedule;
        private EditButton edit;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            this.setSortAttributeName(CateringServiceRotationLight_.number);
            this.setStartEndOffset(1, 0);
            RotationDetailsPanel.this.currentNode.getChildNamed(CateringServiceRotationComplete_.rotationStrategy).addNodeListener((NodeListener)this);
            this.number = new TextLabel(m.getNode().getChildNamed(CateringServiceRotationLight_.number), ConverterRegistry.getConverter(IntegerConverter.class));
            this.schedule = new TextLabel(this.model.getNode().getChildNamed(CateringServiceRotationComplete_.rotationStrategy), ConverterRegistry.getConverter(RotationDurationConverter.class));
            this.edit = new EditButton();
            this.edit.getFader().setPermanent(true);
            this.edit.setProgress(0.0f);
            this.setLayout(new Layout());
            this.edit.addButtonListener(this);
            this.valueChanged(RotationDetailsPanel.this.currentNode.getChildNamed(CateringServiceRotationComplete_.rotationStrategy));
            this.add(this.number);
            this.add(this.schedule);
            this.add(this.edit);
        }

        @Override
        public void requestFocusInWindowNow() {
            if (this.edit != null) {
                this.edit.requestFocusInWindowNow();
            }
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.edit) {
                this.showEditPopup(x, y);
            } else if (source == this.deleteButton && this.model.getNode().getParent().getChildCount() == 1) {
                InnerPopupFactory.showErrorDialog("You can't delete this Cycle. Every Service needs at least one Cycle.<br/>Please add first the new Cycle, than remove the old ones.", "Unable to remove cyle", (Component)this);
                return;
            }
            super.buttonPressed(source, x, y);
        }

        private void showEditPopup(int x, int y) {
            RotationStrategyComplete currentStrat = (RotationStrategyComplete)RotationDetailsPanel.this.currentNode.getChildNamed(CateringServiceScheduleVariantComplete_.rotationStrategy).getValue();
            JPanelFadable insert = null;
            String popupTitle = "";
            if (currentStrat instanceof FixRotationStrategyComplete) {
                insert = PopupInsertFactory.getFixPopup((Node<FixDurationRotationComplete>)this.model.getNode().getChildNamed(CateringServiceRotationComplete_.rotationStrategy));
                popupTitle = Words.CONFIGURE_DURATION;
            } else if (currentStrat instanceof WeekdayRotationStrategyComplete) {
                insert = new WeekDayInsert((Node<WeekdayRotationComplete>)this.getModel().getNode().getChildNamed(CateringServiceRotationComplete_.rotationStrategy));
                popupTitle = Words.CONFIGURE_WEEKDAYS;
            } else if (currentStrat instanceof DayOfMonthRotationStrategyComplete) {
                insert = new DayOfMonthPopupInsert((Node<List<DayOfMonthRotationComplete>>)this.getModel().getNode().getChildNamed(CateringServiceRotationComplete_.rotationStrategy));
                popupTitle = Words.CONFIGURE_MONTH_DAYS;
            } else if (currentStrat instanceof MonthRotationStrategyComplete) {
                insert = new MonthInsert((Node<MonthRotationComplete>)this.getModel().getNode().getChildNamed(CateringServiceRotationComplete_.rotationStrategy));
                popupTitle = Words.CONFIGURE_MONTHS;
            }
            if (insert != null) {
                InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
                popUp.setAttributes(this.edit, true, true, popupTitle);
                popUp.setView((IPopUpInsert)((Object)insert));
                popUp.showPopUp(x, y, -1, -1, this, this.edit, PopupType.NORMAL);
            }
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.number.setEnabled(isEnabled);
            this.schedule.setEnabled(isEnabled);
            this.edit.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            if (RotationDetailsPanel.this.currentNode != null && RotationDetailsPanel.this.currentNode.getChildNamed(CateringServiceScheduleVariantComplete_.rotationStrategy) != null) {
                RotationDetailsPanel.this.currentNode.getChildNamed(CateringServiceScheduleVariantComplete_.rotationStrategy).removeNodeListener((NodeListener)this);
            }
            this.number.kill();
            this.schedule.kill();
            this.edit.kill();
            this.number = null;
            this.schedule = null;
            this.edit = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            a.add(this.edit);
            a.addAll(super.getFocusComponents());
            return a;
        }

        @Override
        public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
            this.getModel().getNode().getChildNamed(CateringServiceRotationComplete_.rotationStrategy).commit();
            this.schedule.updateString();
        }

        public void valueChanged(Node<?> node) {
            if (this.edit != null) {
                if (node.getValue() instanceof FixPeriodRotationStrategyComplete) {
                    this.edit.fadeOut(false);
                } else {
                    this.edit.fadeIn();
                }
            }
        }

        public void childAdded(Node<?> source, Node<?> child) {
        }

        public void childRemoved(Node<?> source, Node<?> child) {
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        public boolean isSwingOnly() {
            return true;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImpl.this.number.setLocation(TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.number.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.number.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.number.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(1);
                TableRowImpl.this.schedule.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.schedule.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.schedule.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.schedule.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(2);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.edit.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.edit.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.edit.setSize(TableRowImpl.this.edit.getPreferredSize());
                TableRowImpl.this.layoutSortButtons(TableRowImpl.this.edit.getX() + TableRowImpl.this.edit.getWidth(), parent.getHeight(), true);
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            RotationDetailsPanel.this.table.setLocation(0, 0);
            RotationDetailsPanel.this.table.setSize(parent.getWidth(), parent.getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, (int)RotationDetailsPanel.this.table.getPreferredSize().getHeight());
        }
    }
}

