/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.mealplan.spec.details;

import ch.icit.pegasus.client.converter.CateringServiceScheduleVariantConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.searchbox.objectbased.SearchTextFieldObjectBased;
import ch.icit.pegasus.client.gui.utils.searchbox.objectbased.SearchTextFieldObjectBasedFactory;
import ch.icit.pegasus.client.gui.utils.searchbox.objectbased.SearchTextFieldObjectBasedListener;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.mealplan.MealPlanServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.toolkits.MealPlanToolkit;
import ch.icit.pegasus.client.util.toolkits.copy.MealPlanCopyToolkit;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleVariantComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanLight;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;

public class TemplateDetailsPanel
extends DefaultDetailsPanel
implements SearchTextFieldObjectBasedListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    private TitledItem<SearchTextFieldObjectBased> mpSearch;
    private TitledItem<ComboBox> variant;
    private TitledItem<ComboBox> services;
    private TextButton load;
    private MealPlanComplete selectedMealPlan;
    private List<CateringServiceScheduleComplete> currentScheds;
    private CateringServiceScheduleComplete selectedService;
    private CateringServiceScheduleVariantComplete selectedVariant;

    public TemplateDetailsPanel(RowEditor editor) {
        super(editor, null, true, true, true);
        this.setTitleText(Words.TEMPLATE);
        this.mpSearch = new TitledItem<SearchTextFieldObjectBased>(SearchTextFieldObjectBasedFactory.getMealPlanSearchField(true), Words.MEAL_PLAN, TitledItem.TitledItemOrientation.NORTH);
        this.services = new TitledItem<ComboBox>(new ComboBox(), Words.SERVICE, TitledItem.TitledItemOrientation.NORTH);
        this.variant = new TitledItem<ComboBox>(new ComboBox((Node)new DTOProxyNode(), null, ConverterRegistry.getConverter(CateringServiceScheduleVariantConverter.class)), Words.VARIANT, TitledItem.TitledItemOrientation.NORTH);
        this.load = new TextButton(Words.LOAD);
        this.load.addButtonListener(this);
        this.mpSearch.getElement().addSearchTextFieldListener(this);
        this.services.getElement().addItemListener(this);
        this.variant.getElement().addItemListener(this);
        this.services.setEnabled(false);
        this.variant.setEnabled(false);
        this.setCustomLayouter(new Layout());
        this.addToView(this.mpSearch);
        this.addToView(this.services);
        this.addToView(this.variant);
        this.addToView(this.load);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        if (source == this.load && this.selectedService != null && this.selectedVariant != null) {
            this.editor.setEnabled(false);
            this.editor.showCommittingAnimation(Words.COPY_MEAL_PLAN);
            CateringServiceScheduleComplete r = MealPlanCopyToolkit.copyService(this.selectedService, this.selectedVariant);
            this.editor.getModel().getNode().removeExistingValues();
            this.editor.getModel().getNode().setValue((Object)r, 0L);
            this.editor.getModel().getNode().updateNode();
            this.editor.setNode(this.editor.getModel().getNode());
            this.editor.getModel().getNode().getChildNamed(CateringServiceScheduleComplete_.variants);
            this.editor.hideCommittingAnimation();
            this.editor.setEnabled(true);
            this.editor.revalidate();
        }
    }

    @Override
    public void requestFocusInWindowNow() {
        this.mpSearch.requestFocusInWindowNow();
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.mpSearch.setEnabled(isEnabled);
        this.services.setEnabled(isEnabled & this.mpSearch.getElement().isItemSelected());
        this.variant.setEnabled(this.services.isEnabled());
        this.load.setEnabled(isEnabled && this.mpSearch.getElement().isItemSelected());
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.mpSearch.kill();
        this.mpSearch = null;
        this.services.kill();
        this.services = null;
        this.variant.kill();
        this.variant = null;
        this.load.kill();
        this.load = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> a = this.mpSearch.getFocusComponents();
        CheckedListAdder.addToList(a, this.services);
        CheckedListAdder.addToList(a, this.variant);
        CheckedListAdder.addToList(a, this.load);
        return a;
    }

    @Override
    public void newValueSelected(SearchTextFieldObjectBased searchTextFieldObjectBased, final Object selectedValue) {
        this.services.setEnabled(false);
        this.variant.setEnabled(false);
        this.load.setEnabled(false);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                MealPlanLight l = (MealPlanLight)selectedValue;
                TemplateDetailsPanel.this.selectedMealPlan = (MealPlanComplete)((MealPlanServiceManager)ServiceManagerRegistry.getService(MealPlanServiceManager.class)).getMealPlan(new MealPlanReference(l.getId())).getValue();
                List scheds = ((MealPlanServiceManager)ServiceManagerRegistry.getService(MealPlanServiceManager.class)).getServiceSchedules(new MealPlanReference(l.getId())).getList();
                scheds.removeIf(o1 -> Boolean.TRUE.equals(o1.getIsDeleted()));
                TemplateDetailsPanel.this.currentScheds = scheds;
                DTOProxyNode n = new DTOProxyNode((Object)scheds);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        List scheds = (List)node.getValue();
                        if (TemplateDetailsPanel.this.services != null) {
                            ((ComboBox)TemplateDetailsPanel.this.services.getElement()).removeAllItems();
                            for (CateringServiceScheduleComplete s : scheds) {
                                String t = MealPlanToolkit.createServiceGroupString(s.getCabinClass(), s.getLegs(), s.getType());
                                ((ComboBox)TemplateDetailsPanel.this.services.getElement()).addItem(t);
                            }
                            TemplateDetailsPanel.this.services.setEnabled(true);
                        }
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)((Object)exception), (Component)TemplateDetailsPanel.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            if (e.getSource() == this.services.getElement()) {
                String t = (String)e.getItem();
                for (CateringServiceScheduleComplete s : this.currentScheds) {
                    String tt = MealPlanToolkit.createServiceGroupString(s.getCabinClass(), s.getLegs(), s.getType());
                    if (!tt.equals(t)) continue;
                    this.selectedService = s;
                    ThreadSafeExecutable run = new ThreadSafeExecutable(){

                        @Override
                        public Node<?> loadData() throws Exception {
                            List variants = ((MealPlanServiceManager)ServiceManagerRegistry.getService(MealPlanServiceManager.class)).getVariants(new ListWrapper(TemplateDetailsPanel.this.selectedService.getVariants())).getList();
                            ArrayList v = new ArrayList();
                            v.addAll(variants);
                            TemplateDetailsPanel.this.selectedService.setVariants(v);
                            return null;
                        }

                        @Override
                        public RemoteLoader getInvoker() {
                            return new RemoteLoader(){

                                public void remoteObjectLoaded(Node<?> node) {
                                    TemplateDetailsPanel.this.load.setEnabled(true);
                                    Node r = INodeCreator.getDefaultImpl().getNode4DTO((Object)TemplateDetailsPanel.this.selectedService, true, false);
                                    TemplateDetailsPanel.this.variant.setEnabled(true);
                                    ((ComboBox)TemplateDetailsPanel.this.variant.getElement()).refreshPossibleValues(r.getChildNamed(CateringServiceScheduleComplete_.variants));
                                    ((ComboBox)TemplateDetailsPanel.this.variant.getElement()).getNode().setValue((Object)TemplateDetailsPanel.this.selectedService.getCurrentVariant(), 0L);
                                    TemplateDetailsPanel.this.selectedVariant = (CateringServiceScheduleVariantComplete)((ComboBox)TemplateDetailsPanel.this.variant.getElement()).getNode().getValue(CateringServiceScheduleVariantComplete.class);
                                }

                                public void errorOccurred(ClientException exception) {
                                    InnerPopupFactory.showErrorDialog((Exception)((Object)exception), (Component)TemplateDetailsPanel.this);
                                }
                            };
                        }

                        @Override
                        public long getID() {
                            return 0L;
                        }
                    };
                    ThreadSafeLoader.run(run);
                }
            } else {
                this.selectedVariant = (CateringServiceScheduleVariantComplete)this.variant.getElement().getNode().getValue(CateringServiceScheduleVariantComplete.class);
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, (int)((double)TemplateDetailsPanel.this.verticalBorder + TemplateDetailsPanel.this.mpSearch.getPreferredSize().getHeight() + (double)TemplateDetailsPanel.this.verticalBorder));
        }

        @Override
        public void layoutContainer(Container parent) {
            TemplateDetailsPanel.this.mpSearch.setLocation(TemplateDetailsPanel.this.horizontalBorder, TemplateDetailsPanel.this.verticalBorder);
            TemplateDetailsPanel.this.mpSearch.setSize(350, (int)TemplateDetailsPanel.this.mpSearch.getPreferredSize().getHeight());
            TemplateDetailsPanel.this.services.setLocation(TemplateDetailsPanel.this.mpSearch.getX() + TemplateDetailsPanel.this.mpSearch.getWidth() + TemplateDetailsPanel.this.inner_horizontalBorder, TemplateDetailsPanel.this.mpSearch.getY());
            TemplateDetailsPanel.this.services.setSize(300, (int)TemplateDetailsPanel.this.services.getPreferredSize().getHeight());
            TemplateDetailsPanel.this.variant.setLocation(TemplateDetailsPanel.this.services.getX() + TemplateDetailsPanel.this.services.getWidth() + TemplateDetailsPanel.this.inner_horizontalBorder, TemplateDetailsPanel.this.services.getY());
            TemplateDetailsPanel.this.variant.setSize(300, (int)TemplateDetailsPanel.this.variant.getPreferredSize().getHeight());
            TemplateDetailsPanel.this.load.setLocation((int)((double)parent.getWidth() - ((double)TemplateDetailsPanel.this.horizontalBorder + TemplateDetailsPanel.this.load.getPreferredSize().getWidth())), (int)((double)parent.getHeight() - ((double)TemplateDetailsPanel.this.verticalBorder + TemplateDetailsPanel.this.load.getPreferredSize().getHeight())));
            TemplateDetailsPanel.this.load.setSize(TemplateDetailsPanel.this.load.getPreferredSize());
        }
    }
}

