/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table;

import ch.icit.pegasus.client.attributes.AttributeListener;
import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.table.DetailsEditorParagraph;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.commiter.RemoteCommitter;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.FadebleShape;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.ExpandIcon;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainer;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.BorderedInletPanel;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemViewSettingsComplete;
import ch.icit.pegasus.server.core.general.IUniversal;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public abstract class DefaultDetailsPanel<T extends IUniversal>
extends BorderedInletPanel
implements AttributeListener,
LafListener,
Focusable,
DetailsEditorParagraph,
ButtonListener,
RemoteLoader {
    private static final long serialVersionUID = 1L;
    protected final SystemSettingsComplete settings;
    protected final SystemViewSettingsComplete viewSettings;
    protected final UserComplete currentUser;
    private JPanel viewPort;
    protected boolean isNodeInit = false;
    protected FadebleShape shape;
    protected VisibleContainer visibleContainer;
    protected int horizontalBorder = 10;
    protected int verticalBorder = 10;
    protected int inner_horizontalBorder = 4;
    protected int inner_verticalBorder = 4;
    protected RowEditor<T> editor;
    protected ExpandIcon expand;
    private List<MutableFocusContainerListener> focusCycleListener = new ArrayList<MutableFocusContainerListener>();
    protected RDProvider provider;
    protected int buttonShapeHeight = 20;
    protected Button.ButtonState currentState = null;
    protected GeneralPath outline;

    public DefaultDetailsPanel(RowEditor<T> editor, RDProvider provider) {
        this(editor, provider, true);
    }

    public DefaultDetailsPanel(RowEditor<T> editor, RDProvider provider, boolean hasTitle) {
        this(editor, provider, hasTitle, true);
    }

    public DefaultDetailsPanel(RowEditor<T> editor, RDProvider provider, boolean hasTitle, boolean hasSkin) {
        this(editor, provider, hasTitle, hasSkin, false);
    }

    public DefaultDetailsPanel(RowEditor<T> editor, RDProvider provider, boolean hasTitle, boolean hasSkin, boolean expandable) {
        super(hasTitle, hasSkin);
        this.settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        this.viewSettings = (SystemViewSettingsComplete)NodeToolkit.getAffixClass(SystemViewSettingsComplete.class).getValue();
        this.currentUser = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
        this.provider = provider;
        this.editor = editor;
        this.shape = new FadebleShape(false);
        this.lafAttributeChanged("All attribues changed");
        float[] dash = new float[]{AttributesConverter.getFloat4String(AttributeLoader.getAttributeLoader().getAttribute("table_detailsparagraph_shape_dash")).floatValue()};
        this.shape.setShapeStroke(new BasicStroke(1.0f, 0, 0, 1.0f, dash, 0.0f));
        this.viewPort = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paint(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                this.paintChildren(g2);
            }
        };
        if (expandable) {
            this.expand = new ExpandIcon(SizedSkin1Field.SkinSize.SMALL);
            this.expand.setExpanded(false);
            this.expand.addButtonListener(this);
            this.titleText.setDelegateComponent(this.expand);
            this.add(this.expand);
        }
        this.viewPort.setOpaque(false);
        this.setOpaque(false);
        this.setLayout(new Layout());
        this.attributeChanged("All attributes changed");
        this.shape.setProgress(0.0f);
        this.shape.getFader().setPermanent(true);
        this.add(this.viewPort);
    }

    @Override
    public void removeFocusCycleChangeListener(MutableFocusContainerListener listener) {
        this.focusCycleListener.remove(listener);
    }

    @Override
    public void addFocusCycleChangeListener(MutableFocusContainerListener listener) {
        this.focusCycleListener.add(listener);
    }

    protected void fireFocusCycleChanged(MutableFocusContainer target) {
        for (MutableFocusContainerListener l : this.focusCycleListener) {
            l.focusCycleChanged(target);
        }
    }

    public boolean hasExpandableContent() {
        return true;
    }

    public boolean isInnerComponent(Component c) {
        return false;
    }

    @Override
    public boolean isRemoteValidation() {
        return false;
    }

    @Override
    public void validateRemote(List<ScreenValidationObject> callBack) throws ClientServerCallException {
    }

    public void switchState(Button.ButtonState newState) {
    }

    public RDProvider getProvider() {
        return this.provider;
    }

    public RowEditor getEditor() {
        return this.editor;
    }

    @Override
    public List<RemoteCommitter> commitParagraph() {
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        return new ArrayList<ScreenValidationObject>();
    }

    @Override
    public final void setVisibleContainer(VisibleContainer pane) {
        this.visibleContainer = pane;
        for (Component c : this.viewPort.getComponents()) {
            if (!(c instanceof Focusable)) continue;
            ((Focusable)((Object)c)).setVisibleContainer(pane);
        }
    }

    public int getVerticalBorder() {
        return this.verticalBorder;
    }

    public int getHorizontalBorder() {
        return this.horizontalBorder;
    }

    @Override
    public void setValid(boolean b) {
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.shape != null) {
            this.shape.setEnabled(isEnabled);
        }
        if (this.expand != null) {
            this.expand.setEnabled(isEnabled);
        }
    }

    @Override
    public void allDone() {
    }

    @Override
    public boolean isInAddEditor() {
        return true;
    }

    @Override
    public void resetParagraph() {
    }

    protected void generateOutline() {
        this.outline = new GeneralPath();
        this.outline.moveTo(0.0f, 0.0f);
        this.outline.lineTo(this.getWidth(), this.getHeight() - 2 * this.verticalBorder);
        this.outline.moveTo(0.0f, this.getHeight() - 2 * this.verticalBorder);
        this.outline.lineTo(this.getWidth(), 0.0f);
    }

    @Override
    public final void setSize(int w, int h) {
        super.setSize(w, h);
        if (this.currentState == Button.ButtonState.STATE_NOTSELECTED) {
            this.generateOutline();
            this.shape.setShape(this.outline);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.shape != null) {
            this.shape.kill();
        }
        this.remove(this.viewPort);
        this.viewPort = null;
        this.shape = null;
        if (this.outline != null) {
            this.outline.reset();
            this.outline = null;
        }
        if (this.expand != null) {
            this.expand.kill();
            this.expand = null;
        }
    }

    @Override
    public boolean grabsFocus() {
        return false;
    }

    public void setBorders(int hb, int vb) {
        this.horizontalBorder = hb;
        this.verticalBorder = vb;
    }

    public void addToView(Component comp) {
        this.viewPort.add(comp, 0);
    }

    public void removeFromView(Component comp) {
        this.viewPort.remove(comp);
    }

    public void setCustomLayouter(LayoutManager lay) {
        this.viewPort.setLayout(lay);
    }

    public JPanel getViewPort() {
        return this.viewPort;
    }

    public LayoutManager getCustomLayouter() {
        return this.viewPort.getLayout();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getLayout().preferredLayoutSize(this);
    }

    public void setView(JPanel view) {
        this.remove(this.viewPort);
        this.viewPort = view;
        this.viewPort.setOpaque(false);
        this.add(this.viewPort);
    }

    @Override
    public void lafAttributeChanged(String att) {
        super.lafAttributeChanged(att);
        Color lineColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_line_color"));
        if (this.shape != null) {
            this.shape.setOutLineColor(lineColor);
        }
    }

    @Override
    public void attributeChanged(String attributeName) {
        super.attributeChanged(attributeName);
        if ("All attributes changed".equals(attributeName)) {
            this.horizontalBorder = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_details_horizontal_border"));
            this.verticalBorder = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_details_vertical_border"));
            this.inner_horizontalBorder = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_details_inner_horizontal_border"));
            this.inner_verticalBorder = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_details_inner_vertical_border"));
        }
    }

    @Override
    public void layoutTitle(Container parent) {
        if (this.hasTitle) {
            if (this.expand != null) {
                this.expand.setLocation(this.titleX, 5);
                this.expand.setSize(this.expand.getPreferredSize());
                this.titleText.setLocation((int)((double)this.titleX + this.expand.getPreferredSize().getWidth() + 5.0), this.titleY);
            } else {
                this.titleText.setLocation(this.titleX, this.titleY);
            }
            this.titleText.setSize(parent.getWidth() - (this.titleText.getX() + this.titleX), (int)this.titleText.getPreferredSize().getHeight());
        }
    }

    @Override
    public abstract List<Component> getFocusComponents();

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    @Override
    public void setNode(Node<?> node) {
        this.setExanded(this.hasExpandableContent());
    }

    public boolean isExpanded() {
        return this.expand != null ? this.expand.isExpanded() : true;
    }

    public void setExanded(boolean isExpanded) {
        if (this.expand != null) {
            this.expand.setExpanded(isExpanded);
            this.buttonPressed(this.expand, 0, 0);
        }
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.expand) {
            if (this.getParent() != null && this.getParent() != this.editor) {
                this.getParent().invalidate();
                this.getParent().validate();
            }
            if (this.editor != null) {
                this.editor.invalidate();
                this.editor.validate();
            }
            this.fireFocusCycleChanged(this);
        }
    }

    public void remoteObjectLoaded(Node<?> node) {
    }

    public void errorOccurred(ClientException exception) {
        InnerPopupFactory.showErrorDialog((Exception)((Object)exception), (Component)this);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth();
            int h = parent.getHeight();
            int th = 0;
            DefaultDetailsPanel.this.layoutTitle(DefaultDetailsPanel.this);
            th = DefaultDetailsPanel.this.getTitleHeight();
            if (DefaultDetailsPanel.this.hasTitle) {
                DefaultDetailsPanel.this.viewPort.setLocation(1, th);
                DefaultDetailsPanel.this.viewPort.setSize(w - 2, h - th);
            } else {
                DefaultDetailsPanel.this.viewPort.setLocation(0, th);
                DefaultDetailsPanel.this.viewPort.setSize(w, h - th);
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension dim = DefaultDetailsPanel.this.viewPort.getLayout().preferredLayoutSize(DefaultDetailsPanel.this.viewPort);
            int w = (int)dim.getWidth();
            int h = (int)dim.getHeight();
            h += DefaultDetailsPanel.this.getTitleHeight();
            if (DefaultDetailsPanel.this.expand != null && !DefaultDetailsPanel.this.expand.isExpanded()) {
                h = DefaultDetailsPanel.this.getTitleHeight();
            }
            return new Dimension(w, h);
        }
    }
}

