/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table;

import ch.icit.pegasus.client.actions.ClientAction;
import ch.icit.pegasus.client.gui.table.CellFactory;
import ch.icit.pegasus.client.gui.table.CellModel;
import ch.icit.pegasus.client.gui.table.CellPanel;
import ch.icit.pegasus.client.gui.table.CellViewFactory;
import ch.icit.pegasus.client.gui.table.RowEditorFactory;
import ch.icit.pegasus.client.gui.table.RowPanel;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table.TableModel;
import ch.icit.pegasus.client.gui.table.enablestate.EnableStateValidator;
import ch.icit.pegasus.client.gui.table.events.TableRowObservable;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.animators.AlphaFader;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.validator.Validator;
import ch.icit.pegasus.server.core.general.IUniversal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RowModel<T extends IUniversal>
extends TableRowObservable
implements NodeListener,
RemoteLoader {
    protected RowPanel<T> view;
    private TableModel<T, ?> parentModel;
    private ArrayList<CellModel> models = new ArrayList();
    private CellFactory cellFactory;
    private RowEditorFactory<T> rowEditorFactory;
    private boolean isHeader;
    private boolean isAddRow;
    protected List<ClientAction> actions = new ArrayList<ClientAction>();
    private boolean isResetingOnCommit = true;
    public static final int STATE_ADD = 3;
    public static final int STATE_ADD_CONTINUE = 5;
    public static final int STATE_NONE = 7;
    private int currentState = 7;
    private boolean isBlocked;
    private Node<T> node;
    private boolean hasDeleteButton;
    private boolean isExpandable = true;
    private int preferredBlockHeight = 0;
    private Validator<T> deleteButtonValidator;
    private boolean isLoaded;
    private boolean isKilled;
    private boolean isLoading;

    public RowModel(TableModel<T, ?> parentModel, boolean isHeader, Node<T> node) {
        this.isHeader = isHeader;
        this.setNode(node);
        this.parentModel = parentModel;
    }

    public int getIndex(CellModel m) {
        return this.models.indexOf(m);
    }

    public void addClientAction(ClientAction action) {
        this.actions.add(action);
    }

    public Iterator<ClientAction> getActions() {
        return this.actions.iterator();
    }

    public void cancelRow() {
        if (this.getView() != null && this.getView().getRowContentPanel() != null && this.getView().getRowContentPanel().getRowEditor() != null) {
            this.getView().getRowContentPanel().getRowEditor().buttonPressed(this.getView().getRowContentPanel().getRowEditor().getCancelButton(), 0, 0);
        }
    }

    public void saveRow() {
        if (this.getView() != null && this.getView().getRowContentPanel() != null && this.getView().getRowContentPanel().getRowEditor() != null) {
            this.getView().getRowContentPanel().getRowEditor().buttonPressed(this.getView().getRowContentPanel().getRowEditor().getAddButton(), 0, 0);
        }
    }

    public boolean isExpandable() {
        return this.isExpandable;
    }

    public void setExpandable(boolean isExpandable) {
        this.isExpandable = isExpandable;
    }

    public void setResetingOnCommit(boolean b) {
        this.isResetingOnCommit = b;
    }

    public void kill() {
        if (this.isKilled) {
            return;
        }
        this.isKilled = true;
        this.view.kill();
        this.view = null;
        if (this.node != null) {
            this.node.removeNodeListener((NodeListener)this);
            this.node = null;
        }
        this.parentModel = null;
        this.models.clear();
        this.models = null;
        this.cellFactory = null;
        this.rowEditorFactory = null;
    }

    public void setNode(Node node) {
        this.node = node;
        if (this.node != null) {
            this.node.addNodeListener((NodeListener)this);
        }
    }

    public void setCurrentState(int state) {
        this.currentState = state;
    }

    public void mergeNode(Node newNode) {
        this.mergeNode(newNode, false);
    }

    public void mergeNode(Node newNode, boolean withReset) {
        this.node = newNode;
        if (this.models != null) {
            this.updateCells(withReset);
        }
        this.view.setRemoved(false);
        if (this.view.getFader().isAnimating(AlphaFader.FadeType.FadeOut)) {
            this.view.getFader().fadeIn();
        }
        this.view.getFader().clearListeners();
    }

    private void createEmptyNode() {
        if (this.node == null && !this.isHeader && this.parentModel != null && this.parentModel.getNode() != null) {
            this.node = this.parentModel.getDataHandler().createEmptyNode();
            if (this.isAddRow) {
                this.getView().delegateNodeReset(this.node);
            }
        }
    }

    public void resetNode() {
        if (this.isAddRow) {
            this.node = null;
            this.createEmptyNode();
        }
    }

    public Node getNode() {
        return this.node;
    }

    public Node<T> getTypeSafeNode() {
        return this.node;
    }

    public void updateView() {
        this.view.repaint(32L);
    }

    public void setAddRow(boolean isAddRow) {
        this.isAddRow = isAddRow;
    }

    public boolean isAddRow() {
        return this.isAddRow;
    }

    public boolean isHeader() {
        return this.isHeader;
    }

    protected void callBackRelayout() {
        this.parentModel.callBackRelayout();
    }

    private void doFinalExpand() {
        this.view.expand();
        if (this.parentModel.hasCellEditors()) {
            for (CellModel m : this.models) {
                m.getView().setState(3, false);
            }
        }
    }

    protected boolean doLoadCompleteData(final RemoteLoader loader) {
        if (this.isAddRow) {
            return false;
        }
        this.isLoading = true;
        RemoteLoader lo = new RemoteLoader(){

            public void remoteObjectLoaded(Node<?> node) {
                RowModel.this.isLoaded = false;
                RowModel.this.isLoading = false;
                loader.remoteObjectLoaded(node);
            }

            public void errorOccurred(ClientException exception) {
                RowModel.this.isLoaded = false;
                RowModel.this.isLoading = false;
                loader.errorOccurred(exception);
            }
        };
        return this.parentModel.getDataHandler().reloadDataBeforeOpening(this.getNode(), lo, this.getParentModel().getTable().getLoadingAnimation());
    }

    public void expandRow(boolean exp) {
        if (exp) {
            this.isBlocked = true;
            if (this.parentModel.expandRow(this.view)) {
                this.doFinalExpand();
                this.notifyAboutExpand();
            }
        } else if (!this.isBlocked || !this.parentModel.isModal()) {
            if (this.parentModel != null) {
                this.parentModel.colapseRow(this.view);
            }
            if (this.view != null) {
                this.view.colapse();
            }
            if (this.parentModel != null && this.parentModel.hasCellEditors()) {
                for (CellModel m : this.models) {
                    m.getView().setState(4, false);
                }
            }
            this.notifyAboutCollapse();
        }
    }

    public void setBlocked(boolean b) {
        this.isBlocked = b;
    }

    public int getExpandedRowHeight() {
        return (int)this.getView().getPreferredSize().getHeight();
    }

    public int getColapsedRowHeight(RowPanel callingClass) {
        if (this.isHeader()) {
            if (callingClass.isHidden()) {
                return this.preferredBlockHeight;
            }
            return this.parentModel.getCollapsedTitleHeight();
        }
        if (callingClass.isHidden()) {
            return this.preferredBlockHeight;
        }
        return this.parentModel.getCollapsedRowHeight();
    }

    public void setHeader(boolean isHeader) {
        this.isHeader = isHeader;
    }

    public void setPreferredBlockHeight(int preferredBlockHeight) {
        this.preferredBlockHeight = preferredBlockHeight;
    }

    public void fetchData() {
        for (int i = 0; i < this.parentModel.getColumnCount(); ++i) {
            CellPanel cell = this.cellFactory.getCellPanel(this, this.parentModel.getColumnInfo(i));
            CellModel cellModel = this.cellFactory.getCellModel(this, this.parentModel.getColumnInfo(i));
            this.addCell(cell, cellModel, i);
        }
    }

    private void ensureRowEnableState() {
        EnableStateValidator ev;
        if (this.parentModel != null && (ev = this.parentModel.getColumnInfo(0).getStateValidator()) != null && this.node != null) {
            if (!ev.isEnabled(this.getNode().getValue(), this.getParentModel().getTable().getAttributes(this.getView()))) {
                this.view.setDisabledPermanent(true);
            } else {
                this.view.setDisabledPermanent(false);
            }
        }
    }

    public Object getOrginalData(TableColumnInfo info) {
        String attName = info.getAttributeName();
        int s = attName.indexOf("&");
        if (s != -1) {
            String[] splits = attName.split("&");
            Object[] values = new Object[splits.length];
            Node<T> n = this.node;
            for (int i = 0; i < values.length; ++i) {
                Object m = n.getValueForNamed(splits[i]);
                if (m == null) continue;
                values[i] = m;
            }
            return values;
        }
        s = attName.indexOf("$");
        if (s != -1) {
            String[] splits = attName.split("\\$");
            Object[] values = new Object[splits.length];
            Node<T> n = this.node;
            for (int i = 0; i < values.length; ++i) {
                Object m = n.getValueForNamed(splits[i]);
                if (m == null) continue;
                values[i] = m;
            }
            return values;
        }
        Node<T> n = this.node;
        Object m = n.getValueForNamed(attName);
        if (m == null) {
            return "n/a";
        }
        return m;
    }

    protected int getColumnIndex(CellModel model) {
        return this.models.indexOf(model);
    }

    public int getRowHeight() {
        return this.view.getCalculatedHeight();
    }

    protected void propagateColumnWidth(boolean updateView) {
        for (int i = 0; i < this.parentModel.getColumnCount(); ++i) {
            if (this.models.size() <= i) continue;
            this.models.get(i).setCellHeight(this.getColapsedRowHeight(this.getView()) - 2);
        }
        if (updateView) {
            this.view.invalidate();
            this.view.validate();
        }
    }

    public void addCell(CellPanel cellPanel, CellModel cellModel, int dx) {
        cellPanel.setModel(cellModel);
        cellModel.setView(cellPanel);
        cellModel.setCellFactory(CellViewFactory.getViewFactory());
        this.models.add(dx, cellModel);
        this.view.addCell(dx, cellPanel);
        cellPanel.setState(4, false);
    }

    protected void updateCells(boolean withReset) {
        for (CellModel cm : this.models) {
            cm.getView().setState(4, withReset);
        }
    }

    public void setView(RowPanel<T> view) {
        this.view = view;
        this.view.setHasDeleteButton(this.hasDeleteButton);
    }

    public RowPanel<T> getView() {
        return this.view;
    }

    public void setParentModel(TableModel<T, ?> parentModel) {
        this.parentModel = parentModel;
        this.ensureRowEnableState();
    }

    public TableModel<T, ?> getParentModel() {
        return this.parentModel;
    }

    public void setCellFactory(CellFactory cellFactory) {
        this.cellFactory = cellFactory;
    }

    public CellFactory getCellFactory() {
        return this.cellFactory;
    }

    public int getMinWidth(int columnIndex) {
        return this.parentModel.getColumnInfo(columnIndex).getMinWidth();
    }

    public int getMaxWidth(int columnIndex) {
        return this.parentModel.getColumnInfo(columnIndex).getMaxWidth();
    }

    public int getPreferredWidth(int columnIndex) {
        return this.parentModel.getColumnInfo(columnIndex).getPreferredWidth();
    }

    public void revalidateHeaderNames() {
        for (CellModel model : this.models) {
            model.revalidateHeaderValue();
        }
    }

    public RowEditorFactory<T> getRowEditorFactory() {
        return this.rowEditorFactory;
    }

    protected long getUnDoId() {
        return this.view.getUnDoId();
    }

    public void setRowEditorFactory(RowEditorFactory<T> editorFactory) {
        this.rowEditorFactory = editorFactory;
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void valueChanged(Node<?> node) {
        if (this.isKilled) {
            node.removeNodeListener((NodeListener)this);
            return;
        }
        this.updateCells(false);
        this.view.configureSmartButtons();
    }

    public void select(boolean b) {
        this.view.select(b);
    }

    public void remoteObjectLoaded(Node<?> node) {
        if (this.getView() == null) {
            return;
        }
        if (this.getView().getRowContentPanel() != null) {
            this.getView().getRowContentPanel().getRowEditor().hideCommittingAnimation();
        }
        if (node == null || node.getValue() == null) {
            return;
        }
        boolean errorFound = false;
        if (!errorFound && this.isAddRow && node != null) {
            this.getParentModel().getNode().addChild(node, 0L);
            if (this.currentState == 3) {
                this.setBlocked(false);
                this.expandRow(false);
            } else if (this.currentState == 5) {
                Node<?> n = this.parentModel.getDataHandler().resetData(node);
                this.setNode(n);
            } else {
                Node<?> n = this.parentModel.getDataHandler().resetData(node);
                this.setNode(n);
                if (node instanceof Node) {
                    node.updateNode();
                }
                this.getNode().updateView();
                this.view.resetHolePanel();
            }
        } else {
            if (node != null && node.hasChildNamed(DtoFieldConstants.recentyCommited.getFieldName())) {
                this.notifyAboutCommit();
                node.removeChild(node.getChildNamed(DtoFieldConstants.recentyCommited), 0L);
            }
            if (node.getValue() != null) {
                this.updateCells(true);
            }
            this.setBlocked(false);
            this.expandRow(false);
        }
        this.view.configureSmartButtons();
        if (this.getView().getRowContentPanel() != null) {
            this.view.getRowContentPanel().getRowEditor().setComponentsEnabled(true);
        }
        if (this.isResetingOnCommit) {
            this.getNode().removeAllChilds();
        }
        this.getParentModel().block4Saving(false);
        this.currentState = 7;
        if (node.getValue() == null) {
            node.getParent().removeChild(node, 0L);
        }
    }

    public void errorOccurred(ClientException exception) {
        InnerPopupFactory.showErrorDialog((Exception)((Object)exception), "", new InnerPopUpListener2(){

            @Override
            public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                RowModel.this.setBlocked(false);
                if (RowModel.this.view != null && RowModel.this.getView().getRowContentPanel() != null) {
                    RowModel.this.view.getRowContentPanel().getRowEditor().setComponentsEnabled(true);
                }
                RowModel.this.getParentModel().block4Saving(false);
            }
        }, this.getView());
        this.getParentModel().getTable().hideAnimation();
    }

    public void setHasDeleteButton(boolean b) {
        this.hasDeleteButton = b;
    }

    public T getDTO(Class<?> dtoClass) {
        if (this.getNode() != null) {
            return (T)((IUniversal)this.getNode().getValue(dtoClass));
        }
        return null;
    }

    public T getDTO() {
        if (this.getNode() != null) {
            return (T)((IUniversal)this.getNode().getValue());
        }
        return null;
    }

    public Object getInnerSelectedDTO() {
        return this.view.getInnerSelectedDTO();
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public void toggleExpandButton(boolean b) {
        this.view.toggleExpandButton(b);
    }

    public void setDeleteButtonValidator(Validator object) {
        this.deleteButtonValidator = object;
    }

    public Validator getDeleteButtonValidator() {
        return this.deleteButtonValidator;
    }

    public boolean hasActionType(Class<?> class1) {
        for (ClientAction a : this.actions) {
            if (!class1.isInstance(a)) continue;
            return true;
        }
        return false;
    }

    public void setLoaded(boolean b) {
        this.isLoaded = b;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public boolean isSwingOnly() {
        return true;
    }

    public boolean isLoading() {
        return this.isLoading;
    }
}

