/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table.renderer;

import ch.icit.pegasus.client.attributes.AttributeListener;
import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.table.CellRenderer;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.skins.SkinRegistry;
import ch.icit.pegasus.client.gui.utils.skins.TypedSkin1Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.WAGStateRendererSkin;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightStateE;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class CellViewWAGStateERenderer
extends CellRenderer
implements AttributeListener {
    private static final long serialVersionUID = 1L;
    private TypedSkin1Field skin;
    private int xInsert;
    private FlightLight flight;
    private FlightStateE currentState;

    public CellViewWAGStateERenderer(FlightLight flight) {
        this.currentState = flight.getFlightState();
        this.flight = flight;
        this.skin = SkinRegistry.getSkin(WAGStateRendererSkin.class);
        this.attributeChanged("All attributes changed");
        this.updateTooltip(flight.getFlightState());
    }

    public FlightLight getFlight() {
        return this.flight;
    }

    private void updateTooltip(FlightStateE state) {
        String tt = "Flight State is: ";
        switch (state) {
            case CANCELLED: {
                tt = Words.CANCELED;
                break;
            }
            case CLOSED: {
                tt = Words.CLOSED;
                break;
            }
            case EN_ROUTE: {
                tt = Words.EN_ROUTE;
                break;
            }
            case OPEN: {
                tt = Words.OPEN;
                break;
            }
            case PLANNED: {
                tt = Words.PLANNED;
                break;
            }
            case DISPATCHED: {
                tt = Words.DISPATCHED;
                break;
            }
            default: {
                tt = "-";
            }
        }
        this.setToolTipText(tt);
    }

    @Override
    public Dimension getPreferredSize() {
        int a = this.skin.getImage(Button.ButtonState.UP, (Enum)this.currentState).getWidth();
        int b = this.skin.getImage(Button.ButtonState.UP, (Enum)this.currentState).getHeight();
        int w = a * 4 + 3;
        return new Dimension(w, b);
    }

    public FlightStateE getFlightStateE() {
        return this.currentState;
    }

    @Override
    public String getStringValue() {
        return CellViewWAGStateERenderer.getValueString(this.currentState);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int currentX = 0;
        int currentY = 0;
        currentX = this.isFirstColumn ? this.firstColumnInset : this.xInsert;
        currentY = (this.getHeight() - this.skin.getImage(Button.ButtonState.UP, (Enum)this.currentState).getHeight()) / 2;
        this.skin.paint(g2, currentX, currentY, Button.ButtonState.UP, (Enum)this.currentState);
        this.paintChildren(g2);
    }

    @Override
    public void attributeChanged(String attributeName) {
        if ("All attributes changed".equals(attributeName)) {
            this.xInsert = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_cell_horizontal_padding"));
            this.firstColumnInset = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_first_column_inset"));
            this.repaint(32L);
        }
    }

    public static String getValueString(FlightStateE value) {
        return value.toString();
    }
}

