/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils;

import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.animators.AlphaFader;
import ch.icit.pegasus.client.gui.utils.animators.Fadable;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.laf.LafLoader;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import javax.swing.JPanel;

public class FadebleShape
extends JPanel
implements Fadable {
    private static final long serialVersionUID = 1L;
    private AlphaFader<FadebleShape> fader;
    private Shape shape;
    private Color shapeOutline;
    private Color shapeFill;
    private boolean isFill;
    private Stroke shapeStroke;
    private TextLabel text;
    private boolean isSurround;
    private Color surroundColor;
    private Color clipFillColor;
    private Shape clipingArea;
    private boolean useAddHeight = false;
    private boolean isKilled;

    public FadebleShape(boolean isFill) {
        this((Shape)null, isFill);
    }

    public FadebleShape(Shape f, boolean isFill) {
        this(f, isFill, "");
    }

    public FadebleShape(Shape f, boolean isFill, String text) {
        this.text = new TextLabel(text);
        this.text.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type")));
        this.isFill = isFill;
        this.setOpaque(false);
        this.fader = new AlphaFader<FadebleShape>(this);
        this.setLayout(new Layout());
        this.setShape(f);
        this.add(this.text);
    }

    public Color getClipFillColor() {
        return this.clipFillColor;
    }

    public void setClipFillColor(Color clipFillColor) {
        this.clipFillColor = clipFillColor;
    }

    public Color getSurroundColor() {
        return this.surroundColor;
    }

    public void setSurroundColor(Color surroundColor) {
        this.surroundColor = surroundColor;
    }

    public boolean isSurround() {
        return this.isSurround;
    }

    public void setSurround(boolean isSurround) {
        this.isSurround = isSurround;
    }

    public Shape getClipingArea() {
        return this.clipingArea;
    }

    public void setClipingArea(Shape clipingArea) {
        this.clipingArea = clipingArea;
    }

    public void setText(String t) {
        this.text.setText(t);
        this.validate();
    }

    public void setFillColor(Color c) {
        this.shapeFill = c;
    }

    public void setOutLineColor(Color c) {
        this.shapeOutline = c;
    }

    public void setShapeStroke(Stroke s) {
        this.shapeStroke = s;
    }

    public void setShape(Shape s) {
        this.shape = s;
        this.repaint(32L);
    }

    public Shape getShape() {
        return this.shape;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.fader);
        if (this.shape == null) {
            return;
        }
        Shape backClip = g2.getClip();
        if (this.text != null) {
            Area a = new Area(backClip);
            a.subtract(new Area(this.text.getBounds()));
            g2.setClip(a);
        }
        if (this.clipingArea != null) {
            g2.clip(this.clipingArea);
        }
        if (this.isFill) {
            g2.setColor(this.shapeFill);
            g2.fill(this.shape);
        }
        Stroke b = g2.getStroke();
        if (this.shapeStroke != null) {
            g2.setStroke(this.shapeStroke);
        }
        if (this.shapeOutline != null) {
            g2.setColor(this.shapeOutline);
        }
        g2.draw(this.shape);
        if (this.shapeStroke != null) {
            g2.setStroke(b);
        }
        if (this.text != null) {
            g2.setClip(backClip);
        }
        if (this.isSurround) {
            g2.setColor(this.surroundColor);
            if (this.clipingArea != null) {
                if (this.clipFillColor != null) {
                    g2.setColor(this.clipFillColor);
                    g2.fill(this.clipingArea);
                }
                g2.draw(this.clipingArea);
            }
        }
        this.paintChildren(g2);
    }

    @Override
    public void fadeIn() {
        this.fader.fadeIn();
    }

    @Override
    public void fadeIn(long animationTime) {
        this.fader.fadeIn(animationTime);
    }

    @Override
    public void fadeOut(boolean destroy, long animationTime) {
        this.fader.fadeOut(animationTime, destroy);
    }

    @Override
    public void fadeOut(boolean destroy) {
        this.fader.fadeOut(destroy);
    }

    public AlphaFader<FadebleShape> getFader() {
        return this.fader;
    }

    @Override
    public float getProgress() {
        return this.fader.getProgress();
    }

    @Override
    public boolean isAnimating(AlphaFader.FadeType fadeIn) {
        return this.fader.isAnimating(fadeIn);
    }

    @Override
    public void kill() {
        if (this.isKilled) {
            return;
        }
        this.isKilled = true;
        this.shape = null;
        this.shapeOutline = null;
        this.shapeFill = null;
        this.shapeStroke = null;
        if (this.text != null) {
            this.text.kill();
        }
    }

    public void setUseAddHeight(boolean b) {
        this.useAddHeight = b;
        this.validate();
    }

    @Override
    public void setProgress(float progress) {
        this.fader.setProgress(progress);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            if (FadebleShape.this.text != null) {
                if (FadebleShape.this.useAddHeight) {
                    FadebleShape.this.text.setLocation((int)((double)parent.getWidth() - FadebleShape.this.text.getPreferredSize().getWidth()) / 2, (int)(((double)parent.getHeight() - FadebleShape.this.text.getPreferredSize().getHeight()) / 2.0 + FadebleShape.this.text.getPreferredSize().getHeight() / 2.0) - 1);
                } else {
                    FadebleShape.this.text.setLocation((int)((double)parent.getWidth() - FadebleShape.this.text.getPreferredSize().getWidth()) / 2, (int)(((double)parent.getHeight() - FadebleShape.this.text.getPreferredSize().getHeight()) / 2.0) - 1);
                }
                FadebleShape.this.text.setSize(FadebleShape.this.text.getPreferredSize());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }
    }
}

