/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils;

import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.Killable;
import ch.icit.pegasus.client.gui.utils.Nodable;
import ch.icit.pegasus.client.gui.utils.ScrollPane;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.animators.AlphaFader;
import ch.icit.pegasus.client.gui.utils.animators.Fadable;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class ScrollableTextArea
extends ScrollPane
implements Focusable,
NodeListener,
DocumentListener,
Killable,
Fadable,
Nodable {
    private static final long serialVersionUID = 1L;
    private JTextArea userMsg;
    private Node<String> node;
    private AlphaFader<ScrollableTextArea> fader = new AlphaFader<ScrollableTextArea>(this);
    private boolean isEditable = true;
    private int maxStringLength = 255;

    public ScrollableTextArea(Node<String> node, boolean isEditable) {
        this();
        this.isEditable = isEditable;
        this.userMsg.setEditable(isEditable);
        this.setNode(node);
    }

    public ScrollableTextArea(Node<String> node) {
        this(node, true);
    }

    public ScrollableTextArea() {
        this.fader.setProgress(1.0f);
        this.userMsg = new JTextArea();
        this.userMsg.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type")));
        this.ensureForeground(true);
        this.userMsg.setCaretColor(this.userMsg.getForeground());
        this.userMsg.setDocument(new PlainDocument(){
            private static final long serialVersionUID = 1L;

            @Override
            public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                if (text == null) {
                    return;
                }
                int t = text.length() + ScrollableTextArea.this.userMsg.getText().length();
                if (t > ScrollableTextArea.this.maxStringLength) {
                    return;
                }
                super.replace(offset, length, text, attrs);
            }
        });
        this.setViewportView(this.userMsg);
        this.setBorder(BorderFactory.createLineBorder(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_background_color"))));
        this.userMsg.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
        this.userMsg.getDocument().addDocumentListener(this);
        this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
        this.getHorizontalScrollBar().setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
        this.getVerticalScrollBar().setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
        this.setOpaque(false);
    }

    public JTextArea getTextArea() {
        return this.userMsg;
    }

    public String getSelectedText() {
        return this.userMsg.getSelectedText();
    }

    public int getSelectedTextStart() {
        return this.userMsg.getSelectionStart();
    }

    public int getSelectedTextEnd() {
        return this.userMsg.getSelectionEnd();
    }

    @Override
    public Node<?> getNode() {
        return this.node;
    }

    public void setMaxStringLength(int maxStringLength) {
        this.maxStringLength = maxStringLength;
    }

    public int getMaxStringLength() {
        return this.maxStringLength;
    }

    public boolean hasInnerFocus() {
        return this.userMsg.hasFocus();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.ensureForeground(isEnabled);
        super.setEnabled(isEnabled);
        this.userMsg.setEnabled(isEnabled);
    }

    private void ensureForeground(boolean isEnabled) {
        if (isEnabled) {
            this.userMsg.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color")));
        } else {
            this.userMsg.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_disabled_color")));
        }
    }

    @Override
    public void setNode(Node<?> node) {
        if (this.node != null && this.node != node) {
            this.node.removeNodeListener((NodeListener)this);
        }
        this.node = node;
        if (this.node != null) {
            this.node.addNodeListener((NodeListener)this);
            this.valueChanged(this.node);
            this.invalidate();
            this.revalidate();
            this.validate();
        }
    }

    public void tryToGrabFocus() {
        this.userMsg.requestFocusInWindow();
    }

    public String getText() {
        return this.userMsg.getText();
    }

    public void setText(String text) {
        this.userMsg.setText(text);
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        a.add(this.userMsg);
        return a;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public void valueChanged(Node<?> node) {
        if (this.node != null && !this.isKilled()) {
            String v = (String)this.node.getValue();
            String v2 = this.userMsg.getText();
            String newTextValue = "";
            newTextValue = v != null && v2 != null && !v.equals(v2) ? v : (v == null ? "" : v);
            this.userMsg.getDocument().removeDocumentListener(this);
            this.userMsg.setText(newTextValue);
            this.userMsg.getDocument().addDocumentListener(this);
        }
    }

    private void stringChanged() {
        if (this.node != null) {
            this.node.setValueSilent((Object)this.userMsg.getText(), false, System.currentTimeMillis(), new NodeListener[]{this});
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.stringChanged();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.stringChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.stringChanged();
    }

    @Override
    public void fadeIn() {
        this.fader.fadeIn();
    }

    @Override
    public void fadeIn(long animationTime) {
        this.fader.fadeIn(animationTime);
    }

    @Override
    public void fadeOut(boolean destroy, long animationTime) {
        this.fader.fadeOut(animationTime, destroy);
    }

    @Override
    public void fadeOut(boolean destroy) {
        this.fader.fadeOut(destroy);
    }

    public AlphaFader<ScrollableTextArea> getFader() {
        return this.fader;
    }

    @Override
    public float getProgress() {
        return this.fader.getProgress();
    }

    @Override
    public boolean isAnimating(AlphaFader.FadeType fadeIn) {
        return this.fader.isAnimating(fadeIn);
    }

    @Override
    public void setProgress(float progress) {
        this.fader.setProgress(progress);
    }

    @Override
    public void kill() {
        if (this.isKilled) {
            return;
        }
        super.kill();
        this.userMsg.getDocument().removeDocumentListener(this);
        this.setNode(null);
        this.userMsg = null;
        this.node = null;
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.userMsg.requestFocusInWindow();
    }

    public boolean isSwingOnly() {
        return true;
    }
}

