/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.animators;

import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.utils.animators.AlphaFader;
import ch.icit.pegasus.client.gui.utils.animators.AnimationProvider;
import java.awt.Component;
import java.awt.event.ActionEvent;

public class PulseFader<T extends Component>
extends AlphaFader<T> {
    private float max = 1.0f;
    private float min = 0.4f;
    private boolean pulsing = false;

    public PulseFader(T comp) {
        super(comp);
        this.fadeProgress = this.min;
    }

    private void stopPulsing(long animationTime) {
        this.pulsing = false;
        this.doFadeOut(animationTime, true);
    }

    private void startPulsing(long animationTime) {
        this.pulsing = true;
        if (this.isFaded()) {
            this.doFadeOut(animationTime, false);
        } else {
            this.doFadeIn(animationTime);
        }
    }

    @Override
    public final void setProgress(float p) {
        if (p == 0.0f) {
            super.setProgress(this.min);
        }
        if (p == 1.0f) {
            super.setProgress(this.max);
        }
    }

    @Override
    public final void fadeIn(long animationTime) {
        this.startPulsing(animationTime);
    }

    private void doFadeIn(long animationTime) {
        if (AnimationProvider.isAnimationActiv) {
            this.animationDurationTime = animationTime == -1L ? Long.valueOf(AttributeLoader.getAttributeLoader().getAttribute("animationTime")) : animationTime;
            if (this.isDisableWhenHidden && this.view.getParent() != null) {
                this.view.setEnabled(this.view.getParent().isEnabled());
            }
            this.isFadeAction = true;
            this.fadeProgress = this.min;
            if (this.view != null) {
                this.view.setVisible(true);
                this.isFadeIn = true;
                this.fadeStartTime = System.currentTimeMillis();
                AnimationProvider.registerAnimater(this);
            }
        } else if (this.pulsing) {
            this.fadeOut(animationTime, false);
        } else {
            if (this.isDisableWhenHidden && this.view.getParent().isEnabled()) {
                this.view.setEnabled(true);
            }
            this.view.setVisible(true);
            this.setProgress(this.max);
            this.repaintParent();
            this.fireAnimationEvent(true);
        }
    }

    private void doFadeOut(long animationTime, boolean destroy) {
        if (AnimationProvider.isAnimationActiv) {
            this.isDestroyAfterFadeOut = destroy;
            this.animationDurationTime = animationTime == -1L ? Long.valueOf(AttributeLoader.getAttributeLoader().getAttribute("animationTime")) : animationTime;
            this.isFadeAction = true;
            this.isFadeIn = false;
            this.fadeStartTime = System.currentTimeMillis();
            AnimationProvider.registerAnimater(this);
        } else if (this.pulsing) {
            this.fadeIn(animationTime);
        } else {
            this.view.setVisible(false);
            this.setProgress(this.min);
            this.fireAnimationEvent(false);
            this.kill();
        }
    }

    @Override
    public final void fadeOut(long animationTime, boolean destroy) {
        this.stopPulsing(animationTime);
    }

    @Override
    public final void actionPerformed(ActionEvent e) {
        if (!this.isFadeAction || this.isKilled) {
            AnimationProvider.deregisterAnimater(this);
            return;
        }
        if (this.isFadeIn) {
            this.fadeProgress = (float)(System.currentTimeMillis() - this.fadeStartTime) / (float)this.animationDurationTime;
            if (this.fadeProgress < this.min) {
                this.fadeProgress = this.min;
            }
            if (this.fadeProgress >= this.max) {
                this.fadeProgress = this.max;
                AnimationProvider.deregisterAnimater(this);
                if (this.pulsing) {
                    this.doFadeOut(this.animationDurationTime, false);
                } else {
                    this.isFadeAction = false;
                    this.fireAnimationEvent(true);
                }
            }
            if (this.view != null && this.view.getParent() != null) {
                this.view.getParent().repaint(32L);
            }
        } else {
            this.fadeProgress = (float)(System.currentTimeMillis() - this.fadeStartTime) / (float)this.animationDurationTime;
            this.fadeProgress = 1.0f - this.fadeProgress;
            if (this.fadeProgress <= this.min) {
                this.fadeProgress = this.min;
                AnimationProvider.deregisterAnimater(this);
                if (this.pulsing) {
                    this.doFadeIn(this.animationDurationTime);
                } else {
                    this.isFadeAction = false;
                    this.fireAnimationEvent(false);
                    if (!this.remainsInside) {
                        this.kill();
                    }
                    if (this.view != null) {
                        this.view.setVisible(false);
                    }
                }
            }
            if (this.view != null && this.view.getParent() != null) {
                this.view.getParent().repaint(32L);
            }
        }
    }
}

