/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.autocompletion.utils;

import ch.icit.pegasus.client.gui.utils.autocompletion.AutoCompletionPopUp;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;

public class AutoCompletionEntry
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = 1L;
    private String text;
    private boolean isSelected;
    private AutoCompletionPopUp ref;

    public AutoCompletionEntry(String text, AutoCompletionPopUp ref) {
        this.text = text;
        this.ref = ref;
        this.setOpaque(false);
        this.addMouseListener(this);
    }

    public void setSelected(boolean s) {
        this.isSelected = s;
        this.repaint(32L);
    }

    public String getText() {
        return this.text;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.isSelected) {
            g2.setColor(this.ref.getSelectionColor());
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        g2.setFont(this.getFont());
        g2.setColor(this.getForeground());
        g2.drawString(this.text, this.ref.getEntryHBorder(), (this.getHeight() + g2.getFont().getSize()) / 2);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.getFontMetrics(this.getFont()).stringWidth(this.text) + 2 * this.ref.getEntryHBorder(), this.getFont().getSize() + 2 * this.ref.getEntryVBorder());
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.ref.getSelected() != this) {
            this.ref.selectEntry(this);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getX() > 0 && e.getX() < this.getWidth() && e.getY() > 0 && e.getY() < this.getHeight()) {
            this.ref.manualyChoosenEntry(this);
        }
    }
}

