/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.combobox;

import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.Killable;
import ch.icit.pegasus.client.gui.utils.image.ImageConsumer;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class CustomScrollBarUI
extends BasicScrollBarUI
implements LafListener,
ImageConsumer,
Killable {
    private static BufferedImage thumb_horiz_UP_11;
    private static BufferedImage thumb_horiz_UP_12;
    private static BufferedImage thumb_horiz_UP_13;
    private static BufferedImage thumb_horiz_UP_14;
    private static BufferedImage thumb_horiz_DOWN_11;
    private static BufferedImage thumb_horiz_DOWN_12;
    private static BufferedImage thumb_horiz_DOWN_13;
    private static BufferedImage thumb_horiz_DOWN_14;
    private static BufferedImage thumb_horiz_OVER_11;
    private static BufferedImage thumb_horiz_OVER_12;
    private static BufferedImage thumb_horiz_OVER_13;
    private static BufferedImage thumb_horiz_OVER_14;
    private static BufferedImage track_horiz_11;
    private static BufferedImage track_horiz_12;
    private static BufferedImage track_horiz_13;
    private static BufferedImage button1_horiz_UP;
    private static BufferedImage button1_horiz_DOWN;
    private static BufferedImage button1_horiz_OVER;
    private static BufferedImage button1_horiz_DISABLED;
    private static BufferedImage button2_horiz_UP;
    private static BufferedImage button2_horiz_DOWN;
    private static BufferedImage button2_horiz_OVER;
    private static BufferedImage button2_horiz_DISABLED;
    private static BufferedImage thumb_vert_UP_11;
    private static BufferedImage thumb_vert_UP_12;
    private static BufferedImage thumb_vert_UP_13;
    private static BufferedImage thumb_vert_UP_14;
    private static BufferedImage thumb_vert_DOWN_11;
    private static BufferedImage thumb_vert_DOWN_12;
    private static BufferedImage thumb_vert_DOWN_13;
    private static BufferedImage thumb_vert_DOWN_14;
    private static BufferedImage thumb_vert_OVER_11;
    private static BufferedImage thumb_vert_OVER_12;
    private static BufferedImage thumb_vert_OVER_13;
    private static BufferedImage thumb_vert_OVER_14;
    private static BufferedImage track_vert_11;
    private static BufferedImage track_vert_12;
    private static BufferedImage track_vert_13;
    private static BufferedImage button1_vert_UP;
    private static BufferedImage button1_vert_DOWN;
    private static BufferedImage button1_vert_OVER;
    private static BufferedImage button1_vert_DISABLED;
    private static BufferedImage button2_vert_UP;
    private static BufferedImage button2_vert_DOWN;
    private static BufferedImage button2_vert_OVER;
    private static BufferedImage button2_vert_DISABLED;
    private static boolean isInit;
    private int orientation = 1;
    private boolean isKilled = false;

    public CustomScrollBarUI(int orient) {
        this.orientation = orient;
        this.init();
    }

    private void init() {
        if (!isInit) {
            this.lafAttributeChanged("All attribues changed");
        }
    }

    @Override
    protected BasicScrollBarUI.TrackListener createTrackListener() {
        return new TrackListener2();
    }

    @Override
    public boolean isKilled() {
        return this.isKilled;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
    }

    @Override
    protected JButton createDecreaseButton(final int orientation) {
        if (orientation == 1 || orientation == 5) {
            JButton button = new JButton(){

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(button1_vert_UP.getWidth(), button1_vert_UP.getHeight());
                }

                @Override
                public void paint(Graphics g) {
                    Graphics2D g2 = (Graphics2D)g;
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    BufferedImage currentImage = null;
                    if (orientation == 1) {
                        currentImage = button1_vert_UP;
                        if (CustomScrollBarUI.this.scrollbar.getVisibleAmount() == CustomScrollBarUI.this.scrollbar.getMaximum()) {
                            currentImage = button1_vert_DISABLED;
                        } else if (this.getModel().isPressed()) {
                            currentImage = button1_vert_DOWN;
                        } else if (this.getModel().isRollover()) {
                            currentImage = button1_vert_OVER;
                        }
                    } else {
                        currentImage = button2_vert_UP;
                        if (CustomScrollBarUI.this.scrollbar.getVisibleAmount() == CustomScrollBarUI.this.scrollbar.getMaximum()) {
                            currentImage = button2_vert_DISABLED;
                        } else if (this.getModel().isPressed()) {
                            currentImage = button2_vert_DOWN;
                        } else if (this.getModel().isRollover()) {
                            currentImage = button2_vert_OVER;
                        }
                    }
                    g2.drawImage(currentImage, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f), null);
                }
            };
            button.setOpaque(false);
            button.setFocusable(false);
            return button;
        }
        JButton button = new JButton(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(button1_horiz_UP.getWidth(), button1_horiz_UP.getHeight());
            }

            @Override
            public void paint(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                BufferedImage currentImage = null;
                if (orientation == 3) {
                    currentImage = button1_horiz_UP;
                    if (!this.getModel().isEnabled()) {
                        currentImage = button1_horiz_DISABLED;
                    } else if (this.getModel().isPressed()) {
                        currentImage = button1_horiz_DOWN;
                    } else if (this.getModel().isRollover()) {
                        currentImage = button1_horiz_OVER;
                    }
                } else {
                    currentImage = button2_horiz_UP;
                    if (!this.getModel().isEnabled()) {
                        currentImage = button2_horiz_DISABLED;
                    } else if (this.getModel().isPressed()) {
                        currentImage = button2_horiz_DOWN;
                    } else if (this.getModel().isRollover()) {
                        currentImage = button2_horiz_OVER;
                    }
                }
                g2.drawImage(currentImage, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f), null);
            }
        };
        button.setOpaque(false);
        button.setFocusable(false);
        return button;
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        return this.createDecreaseButton(orientation);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (this.orientation == 1) {
            return new Dimension(button1_vert_UP.getWidth(), 0);
        }
        return new Dimension(0, button1_horiz_UP.getHeight());
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (!this.scrollbar.isEnabled()) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (thumbBounds.isEmpty() || !this.scrollbar.isEnabled()) {
            return;
        }
        if (this.orientation == 1) {
            BufferedImage current_11 = thumb_vert_UP_11;
            BufferedImage current_12 = thumb_vert_UP_12;
            BufferedImage current_13 = thumb_vert_UP_13;
            BufferedImage current_14 = thumb_vert_UP_14;
            if (this.isDragging) {
                current_11 = thumb_vert_DOWN_11;
                current_12 = thumb_vert_DOWN_12;
                current_13 = thumb_vert_DOWN_13;
                current_14 = thumb_vert_DOWN_14;
            } else if (this.isThumbRollover()) {
                current_11 = thumb_vert_OVER_11;
                current_12 = thumb_vert_OVER_12;
                current_13 = thumb_vert_OVER_13;
                current_14 = thumb_vert_OVER_14;
            }
            g2.drawImage(current_11, new AffineTransform(1.0, 0.0, 0.0, 1.0, thumbBounds.getX(), thumbBounds.getY()), null);
            Rectangle middle = new Rectangle(0, 0, current_12.getWidth(), current_12.getHeight());
            g2.setPaint(new TexturePaint(current_12, middle));
            int diff = (int)(thumbBounds.getHeight() - (double)(current_11.getHeight() + current_14.getHeight() + current_13.getHeight()));
            int pw = diff / 2;
            g2.fillRect((int)thumbBounds.getX(), (int)thumbBounds.getY() + current_11.getHeight(), (int)thumbBounds.getWidth(), pw);
            int d = diff - pw * 2;
            g2.fillRect((int)thumbBounds.getX(), (int)(thumbBounds.getY() + (double)(current_11.getHeight() + (pw += d) - d + current_13.getHeight())), (int)thumbBounds.getWidth(), pw);
            g2.drawImage(current_13, new AffineTransform(1.0, 0.0, 0.0, 1.0, thumbBounds.getX(), thumbBounds.getY() + (double)current_11.getHeight() + (double)(pw -= d)), null);
            g2.drawImage(current_14, new AffineTransform(1.0, 0.0, 0.0, 1.0, thumbBounds.getX(), thumbBounds.getY() + thumbBounds.getHeight() - (double)current_14.getHeight()), null);
        } else {
            BufferedImage current_11 = thumb_horiz_UP_11;
            BufferedImage current_12 = thumb_horiz_UP_13;
            BufferedImage current_13 = thumb_horiz_UP_12;
            BufferedImage current_14 = thumb_horiz_UP_14;
            if (this.isDragging) {
                current_11 = thumb_horiz_DOWN_11;
                current_12 = thumb_horiz_DOWN_12;
                current_13 = thumb_horiz_DOWN_13;
                current_14 = thumb_horiz_DOWN_14;
            } else if (this.isThumbRollover()) {
                current_11 = thumb_horiz_OVER_11;
                current_12 = thumb_horiz_OVER_13;
                current_13 = thumb_horiz_OVER_12;
                current_14 = thumb_horiz_OVER_14;
            }
            g2.drawImage(current_11, new AffineTransform(1.0, 0.0, 0.0, 1.0, thumbBounds.getX(), thumbBounds.getY()), null);
            int diff = (int)(thumbBounds.getWidth() - (double)(current_11.getWidth() + current_14.getWidth() + current_13.getWidth()));
            int pw = diff / 2;
            Rectangle middle = new Rectangle(0, 0, current_12.getWidth(), current_12.getHeight());
            g2.setPaint(new TexturePaint(current_12, middle));
            g2.fillRect((int)thumbBounds.getX() + current_11.getWidth(), (int)thumbBounds.getY(), pw, current_12.getHeight());
            int d = diff - pw * 2;
            g2.fillRect((int)(thumbBounds.getX() + (double)current_11.getWidth() + (double)(pw += d) - (double)d + (double)current_13.getWidth()), (int)thumbBounds.getY(), pw, current_12.getHeight());
            g2.drawImage(current_13, new AffineTransform(1.0, 0.0, 0.0, 1.0, thumbBounds.getX() + (double)current_11.getWidth() + (double)(pw -= d), thumbBounds.getY()), null);
            g2.drawImage(current_14, new AffineTransform(1.0, 0.0, 0.0, 1.0, thumbBounds.getX() + thumbBounds.getWidth() - (double)current_14.getWidth(), thumbBounds.getY()), null);
        }
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        if (!this.scrollbar.isEnabled()) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (trackBounds.isEmpty() || !this.scrollbar.isEnabled()) {
            return;
        }
        if (this.orientation == 1) {
            g2.drawImage(track_vert_11, new AffineTransform(1.0, 0.0, 0.0, 1.0, trackBounds.getX(), trackBounds.getY()), null);
            Rectangle track = new Rectangle(0, 0, track_vert_12.getWidth(), track_vert_12.getHeight());
            g2.setPaint(new TexturePaint(track_vert_12, track));
            g2.fillRect((int)trackBounds.getX(), (int)trackBounds.getY() + track_vert_11.getHeight(), (int)track.getWidth(), (int)trackBounds.getHeight() - (track_vert_11.getHeight() + track_vert_13.getHeight()));
            g2.drawImage(track_vert_13, new AffineTransform(1.0, 0.0, 0.0, 1.0, trackBounds.getX(), trackBounds.getY() + trackBounds.getHeight() - (double)track_vert_13.getHeight()), null);
        } else {
            g2.drawImage(track_horiz_11, new AffineTransform(1.0, 0.0, 0.0, 1.0, trackBounds.getX(), trackBounds.getY()), null);
            Rectangle track = new Rectangle(0, 0, track_horiz_12.getWidth(), track_horiz_12.getHeight());
            g2.setPaint(new TexturePaint(track_horiz_12, track));
            g2.fillRect((int)trackBounds.getX() + track_horiz_11.getWidth(), (int)trackBounds.getY(), (int)trackBounds.getWidth() - (track_horiz_11.getWidth() + track_horiz_13.getWidth()), (int)trackBounds.getHeight());
            g2.drawImage(track_horiz_13, new AffineTransform(1.0, 0.0, 0.0, 1.0, trackBounds.getX() + trackBounds.getWidth() - (double)track_horiz_13.getWidth(), trackBounds.getY()), null);
        }
    }

    @Override
    public void lafAttributeChanged(String att) {
        this.loadImages();
    }

    @Override
    public void loadImages() {
        if (thumb_vert_UP_11 == null) {
            thumb_vert_UP_11 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("scrollpane_vert_thumb_up_11"));
            thumb_vert_UP_12 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("scrollpane_vert_thumb_up_12"));
            thumb_vert_UP_13 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("scrollpane_vert_thumb_up_13"));
            thumb_vert_UP_14 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("scrollpane_vert_thumb_up_14"));
            thumb_vert_DOWN_11 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("scrollpane_vert_thumb_down_11"));
            thumb_vert_DOWN_12 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("scrollpane_vert_thumb_down_12"));
            thumb_vert_DOWN_13 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("scrollpane_vert_thumb_down_13"));
            thumb_vert_DOWN_14 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("scrollpane_vert_thumb_down_14"));
            thumb_vert_OVER_11 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("scrollpane_vert_thumb_over_11"));
            thumb_vert_OVER_12 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("scrollpane_vert_thumb_over_12"));
            thumb_vert_OVER_13 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("scrollpane_vert_thumb_over_13"));
            thumb_vert_OVER_14 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("scrollpane_vert_thumb_over_14"));
            track_vert_11 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("scrollpane_vert_track_11"));
            track_vert_12 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("scrollpane_vert_track_12"));
            track_vert_13 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("scrollpane_vert_track_13"));
            button1_vert_UP = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("scrollpane_vert_icon1_UP"));
            button1_vert_DOWN = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("scrollpane_vert_icon1_DOWN"));
            button1_vert_OVER = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("scrollpane_vert_icon1_OVER"));
            button1_vert_DISABLED = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("scrollpane_vert_icon1_DISABLED"));
            button2_vert_UP = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("scrollpane_vert_icon2_UP"));
            button2_vert_DOWN = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("scrollpane_vert_icon2_DOWN"));
            button2_vert_OVER = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("scrollpane_vert_icon2_OVER"));
            button2_vert_DISABLED = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("scrollpane_vert_icon2_DISABLED"));
            thumb_horiz_UP_11 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("scrollpane_horiz_thumb_up_11"));
            thumb_horiz_UP_12 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("scrollpane_horiz_thumb_up_12"));
            thumb_horiz_UP_13 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("scrollpane_horiz_thumb_up_13"));
            thumb_horiz_UP_14 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("scrollpane_horiz_thumb_up_14"));
            thumb_horiz_DOWN_11 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("scrollpane_horiz_thumb_down_11"));
            thumb_horiz_DOWN_12 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("scrollpane_horiz_thumb_down_12"));
            thumb_horiz_DOWN_13 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("scrollpane_horiz_thumb_down_13"));
            thumb_horiz_DOWN_14 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("scrollpane_horiz_thumb_down_14"));
            thumb_horiz_OVER_11 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("scrollpane_horiz_thumb_over_11"));
            thumb_horiz_OVER_12 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("scrollpane_horiz_thumb_over_12"));
            thumb_horiz_OVER_13 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("scrollpane_horiz_thumb_over_13"));
            thumb_horiz_OVER_14 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("scrollpane_horiz_thumb_over_14"));
            track_horiz_11 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("scrollpane_horiz_track_11"));
            track_horiz_12 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("scrollpane_horiz_track_12"));
            track_horiz_13 = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("scrollpane_horiz_track_13"));
            button1_horiz_UP = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("scrollpane_horiz_icon1_UP"));
            button1_horiz_DOWN = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("scrollpane_horiz_icon1_DOWN"));
            button1_horiz_OVER = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("scrollpane_horiz_icon1_OVER"));
            button1_horiz_DISABLED = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("scrollpane_horiz_icon1_DISABLED"));
            button2_horiz_UP = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("scrollpane_horiz_icon2_UP"));
            button2_horiz_DOWN = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("scrollpane_horiz_icon2_DOWN"));
            button2_horiz_OVER = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("scrollpane_horiz_icon2_OVER"));
            button2_horiz_DISABLED = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("scrollpane_horiz_icon2_DISABLED"));
        }
    }

    @Override
    public void clearImages() {
        thumb_vert_UP_11 = null;
        this.loadImages();
    }

    static {
        isInit = false;
    }

    protected class TrackListener2
    extends BasicScrollBarUI.TrackListener
    implements MouseMotionListener {
        protected TrackListener2() {
            super(CustomScrollBarUI.this);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            CustomScrollBarUI.this.scrollbar.repaint(32L);
        }
    }
}

