/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.panels;

import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.filterchain.UIStateLoadable;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.ConfigPanel;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.report.analysis.FlightAnalysisCheckerSheetsConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class CheckerSheetConfigPanel
extends ConfigPanel
implements Focusable,
ButtonListener,
UIStateLoadable {
    private static final long serialVersionUID = 1L;
    protected int border = 10;
    private TextLabel sheetSelection = new TextLabel(Words.SELECTION);
    private TitledItem<CheckBox> overviewSheet = new TitledItem<CheckBox>(new CheckBox(), Words.OVERVIEW, TitledItem.TitledItemOrientation.EAST);
    private TitledItem<CheckBox> mealRatioSheet;
    private TitledItem<CheckBox> productByEquipmentSheet;
    private TitledItem<CheckBox> productByEquipmentAll;
    private TitledItem<CheckBox> productByEquipmentMealPlanOnly;
    private TitledItem<CheckBox> productByEquipmentMealPlanWithMealType;
    private TitledItem<CheckBox> productByEquipmentMealPlanWithoutMealType;
    private TitledItem<CheckBox> productByEquipmentStandardOnly;
    private TitledItem<CheckBox> productByEquipmentAll_ClassSplit;
    private TitledItem<CheckBox> productByEquipmentMealPlanOnly_ClassSplit;
    private TitledItem<CheckBox> productByEquipmentMealPlanWithMealType_ClassSplit;
    private TitledItem<CheckBox> productByEquipmentMealPlanWithoutMealType_ClassSplit;
    private TitledItem<CheckBox> productByEquipmentStandardOnly_ClassSplit;
    private TitledItem<CheckBox> productByEquipmentAll_splitByGalley;
    private TitledItem<CheckBox> productByEquipmentMealPlanOnly_splitByGalley;
    private TitledItem<CheckBox> productByEquipmentMealPlanWithMealType_splitByGalley;
    private TitledItem<CheckBox> productByEquipmentMealPlanWithoutMealType_splitByGalley;
    private TitledItem<CheckBox> productByEquipmentStandardOnly_splitByGalley;
    private TitledItem<CheckBox> labelSheet;
    private TitledItem<CheckBox> includeGalleyMap;
    private TitledItem<CheckBox> deliverySlip;
    private TitledItem<CheckBox> equipmentChecker;
    private TitledItem<CheckBox> productForecast;
    private TitledItem<CheckBox> includeAllDepartments;
    private TitledItem<CheckBox> includeMeals;
    private TitledItem<CheckBox> includeStandards;
    private TitledItem<CheckBox> includeArticles;
    FilterChainConfiguration conf;

    public CheckerSheetConfigPanel() {
        this.overviewSheet.getElement().setChecked(true);
        this.equipmentChecker = new TitledItem<CheckBox>(new CheckBox(), Words.EQUIPMENT_CHECKER, TitledItem.TitledItemOrientation.EAST);
        this.equipmentChecker.getElement().setChecked(true);
        this.mealRatioSheet = new TitledItem<CheckBox>(new CheckBox(), Words.MEAL_RATIO_SHEET, TitledItem.TitledItemOrientation.EAST);
        this.mealRatioSheet.getElement().setChecked(true);
        this.productForecast = new TitledItem<CheckBox>(new CheckBox(), Words.KITCHEN_FORECAST, TitledItem.TitledItemOrientation.EAST);
        this.productForecast.getElement().setChecked(true);
        this.productForecast.getElement().addButtonListener(this);
        this.includeAllDepartments = new TitledItem<CheckBox>(new CheckBox(), Words.ALL_DEPARTMENTS, TitledItem.TitledItemOrientation.EAST);
        this.includeAllDepartments.getElement().setChecked(false);
        this.labelSheet = new TitledItem<CheckBox>(new CheckBox(), Words.LABELS, TitledItem.TitledItemOrientation.EAST);
        this.labelSheet.getElement().setChecked(true);
        this.labelSheet.getElement().addButtonListener(this);
        this.includeGalleyMap = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_GALLEY_MAP, TitledItem.TitledItemOrientation.EAST);
        this.deliverySlip = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_DELIVERY_SLIP, TitledItem.TitledItemOrientation.EAST);
        this.deliverySlip.getElement().setChecked(true);
        this.productByEquipmentSheet = new TitledItem<CheckBox>(new CheckBox(), Words.PRODUCTS_TO_EQUIPMENT_TABLE, TitledItem.TitledItemOrientation.EAST);
        this.productByEquipmentSheet.getElement().setChecked(true);
        this.productByEquipmentSheet.getElement().addButtonListener(this);
        this.productByEquipmentAll = new TitledItem<CheckBox>(new CheckBox(), Words.ALL, TitledItem.TitledItemOrientation.EAST);
        this.productByEquipmentAll.getElement().setChecked(true);
        this.productByEquipmentMealPlanOnly = new TitledItem<CheckBox>(new CheckBox(), Words.MEALS_ONLY, TitledItem.TitledItemOrientation.EAST);
        this.productByEquipmentMealPlanWithMealType = new TitledItem<CheckBox>(new CheckBox(), Words.MEALS_WITH_MEAL_TYPE_ONLY, TitledItem.TitledItemOrientation.EAST);
        this.productByEquipmentMealPlanWithoutMealType = new TitledItem<CheckBox>(new CheckBox(), Words.MEALS_WITHOUT_MEAL_TYPE_ONLY, TitledItem.TitledItemOrientation.EAST);
        this.productByEquipmentStandardOnly = new TitledItem<CheckBox>(new CheckBox(), Words.STANDARDS_ONLY, TitledItem.TitledItemOrientation.EAST);
        this.productByEquipmentAll.getElement().addButtonListener(this);
        this.productByEquipmentMealPlanOnly.getElement().addButtonListener(this);
        this.productByEquipmentMealPlanWithMealType.getElement().addButtonListener(this);
        this.productByEquipmentMealPlanWithoutMealType.getElement().addButtonListener(this);
        this.productByEquipmentStandardOnly.getElement().addButtonListener(this);
        this.productByEquipmentAll_ClassSplit = new TitledItem<CheckBox>(new CheckBox(), Words.SPLIT_BY_CLASS, TitledItem.TitledItemOrientation.EAST);
        this.productByEquipmentAll_ClassSplit.getElement().setChecked(true);
        this.productByEquipmentMealPlanOnly_ClassSplit = new TitledItem<CheckBox>(new CheckBox(), Words.SPLIT_BY_CLASS, TitledItem.TitledItemOrientation.EAST);
        this.productByEquipmentMealPlanWithMealType_ClassSplit = new TitledItem<CheckBox>(new CheckBox(), Words.SPLIT_BY_CLASS, TitledItem.TitledItemOrientation.EAST);
        this.productByEquipmentMealPlanWithoutMealType_ClassSplit = new TitledItem<CheckBox>(new CheckBox(), Words.SPLIT_BY_CLASS, TitledItem.TitledItemOrientation.EAST);
        this.productByEquipmentStandardOnly_ClassSplit = new TitledItem<CheckBox>(new CheckBox(), Words.SPLIT_BY_CLASS, TitledItem.TitledItemOrientation.EAST);
        this.productByEquipmentAll_splitByGalley = new TitledItem<CheckBox>(new CheckBox(), Words.SPLIT_BY_GALLEY, TitledItem.TitledItemOrientation.EAST);
        this.productByEquipmentAll_splitByGalley.getElement().setChecked(true);
        this.productByEquipmentMealPlanOnly_splitByGalley = new TitledItem<CheckBox>(new CheckBox(), Words.SPLIT_BY_GALLEY, TitledItem.TitledItemOrientation.EAST);
        this.productByEquipmentMealPlanWithMealType_splitByGalley = new TitledItem<CheckBox>(new CheckBox(), Words.SPLIT_BY_GALLEY, TitledItem.TitledItemOrientation.EAST);
        this.productByEquipmentMealPlanWithoutMealType_splitByGalley = new TitledItem<CheckBox>(new CheckBox(), Words.SPLIT_BY_GALLEY, TitledItem.TitledItemOrientation.EAST);
        this.productByEquipmentStandardOnly_splitByGalley = new TitledItem<CheckBox>(new CheckBox(), Words.SPLIT_BY_GALLEY, TitledItem.TitledItemOrientation.EAST);
        this.includeMeals = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_MEALS, TitledItem.TitledItemOrientation.EAST);
        this.includeMeals.getElement().setChecked(true);
        this.includeStandards = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_STANDARD, TitledItem.TitledItemOrientation.EAST);
        this.includeStandards.getElement().setChecked(true);
        this.includeArticles = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_ARTICLE, TitledItem.TitledItemOrientation.EAST);
        this.includeArticles.getElement().setChecked(true);
        this.setLayout(new Layout());
        this.add(this.sheetSelection);
        this.add(this.mealRatioSheet);
        this.add(this.overviewSheet);
        this.add(this.equipmentChecker);
        this.add(this.productForecast);
        this.add(this.includeAllDepartments);
        this.add(this.productByEquipmentSheet);
        this.add(this.productByEquipmentAll);
        this.add(this.productByEquipmentMealPlanOnly);
        this.add(this.productByEquipmentMealPlanWithMealType);
        this.add(this.productByEquipmentMealPlanWithoutMealType);
        this.add(this.productByEquipmentStandardOnly);
        this.add(this.productByEquipmentAll_ClassSplit);
        this.add(this.productByEquipmentMealPlanOnly_ClassSplit);
        this.add(this.productByEquipmentMealPlanWithMealType_ClassSplit);
        this.add(this.productByEquipmentMealPlanWithoutMealType_ClassSplit);
        this.add(this.productByEquipmentStandardOnly_ClassSplit);
        this.add(this.productByEquipmentAll_splitByGalley);
        this.add(this.productByEquipmentMealPlanOnly_splitByGalley);
        this.add(this.productByEquipmentMealPlanWithMealType_splitByGalley);
        this.add(this.productByEquipmentMealPlanWithoutMealType_splitByGalley);
        this.add(this.productByEquipmentStandardOnly_splitByGalley);
        this.add(this.labelSheet);
        this.add(this.includeGalleyMap);
        this.add(this.deliverySlip);
        this.add(this.includeMeals);
        this.add(this.includeStandards);
        this.add(this.includeArticles);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.mealRatioSheet.setEnabled(isEnabled);
        this.sheetSelection.setEnabled(isEnabled);
        this.overviewSheet.setEnabled(isEnabled);
        this.equipmentChecker.setEnabled(isEnabled);
        this.productForecast.setEnabled(isEnabled);
        this.includeAllDepartments.setEnabled(isEnabled && this.productForecast.getElement().isChecked());
        this.productByEquipmentSheet.setEnabled(isEnabled);
        boolean productByEquipment = this.productByEquipmentSheet.getElement().isChecked() && isEnabled;
        this.productByEquipmentAll.setEnabled(productByEquipment);
        this.productByEquipmentMealPlanOnly.setEnabled(productByEquipment);
        this.productByEquipmentMealPlanWithMealType.setEnabled(productByEquipment);
        this.productByEquipmentMealPlanWithoutMealType.setEnabled(productByEquipment);
        this.productByEquipmentStandardOnly.setEnabled(productByEquipment);
        this.productByEquipmentAll_ClassSplit.setEnabled(productByEquipment && this.productByEquipmentAll.getElement().isChecked());
        this.productByEquipmentMealPlanOnly_ClassSplit.setEnabled(productByEquipment && this.productByEquipmentMealPlanOnly.getElement().isChecked());
        this.productByEquipmentMealPlanWithMealType_ClassSplit.setEnabled(productByEquipment && this.productByEquipmentMealPlanWithMealType.getElement().isChecked());
        this.productByEquipmentMealPlanWithoutMealType_ClassSplit.setEnabled(productByEquipment && this.productByEquipmentMealPlanWithoutMealType.getElement().isChecked());
        this.productByEquipmentStandardOnly_ClassSplit.setEnabled(productByEquipment && this.productByEquipmentStandardOnly.getElement().isChecked());
        this.productByEquipmentAll_splitByGalley.setEnabled(productByEquipment && this.productByEquipmentAll.getElement().isChecked());
        this.productByEquipmentMealPlanOnly_splitByGalley.setEnabled(productByEquipment && this.productByEquipmentMealPlanOnly.getElement().isChecked());
        this.productByEquipmentMealPlanWithMealType_splitByGalley.setEnabled(productByEquipment && this.productByEquipmentMealPlanWithMealType.getElement().isChecked());
        this.productByEquipmentMealPlanWithoutMealType_splitByGalley.setEnabled(productByEquipment && this.productByEquipmentMealPlanWithoutMealType.getElement().isChecked());
        this.productByEquipmentStandardOnly_splitByGalley.setEnabled(productByEquipment && this.productByEquipmentStandardOnly.getElement().isChecked());
        this.labelSheet.setEnabled(isEnabled);
        this.includeGalleyMap.setEnabled(this.labelSheet.getElement().isChecked() && isEnabled);
        this.deliverySlip.setEnabled(isEnabled);
        this.includeMeals.setEnabled(isEnabled);
        this.includeStandards.setEnabled(isEnabled);
        this.includeArticles.setEnabled(isEnabled);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        this.setEnabled(this.isEnabled());
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.overviewSheet);
        CheckedListAdder.addToList(a, this.equipmentChecker);
        CheckedListAdder.addToList(a, this.mealRatioSheet);
        CheckedListAdder.addToList(a, this.productForecast);
        CheckedListAdder.addToList(a, this.includeAllDepartments);
        CheckedListAdder.addToList(a, this.productByEquipmentSheet);
        CheckedListAdder.addToList(a, this.productByEquipmentAll);
        CheckedListAdder.addToList(a, this.productByEquipmentMealPlanOnly);
        CheckedListAdder.addToList(a, this.productByEquipmentMealPlanWithMealType);
        CheckedListAdder.addToList(a, this.productByEquipmentMealPlanWithoutMealType);
        CheckedListAdder.addToList(a, this.productByEquipmentStandardOnly);
        CheckedListAdder.addToList(a, this.productByEquipmentAll_ClassSplit);
        CheckedListAdder.addToList(a, this.productByEquipmentMealPlanOnly_ClassSplit);
        CheckedListAdder.addToList(a, this.productByEquipmentMealPlanWithMealType_ClassSplit);
        CheckedListAdder.addToList(a, this.productByEquipmentMealPlanWithoutMealType_ClassSplit);
        CheckedListAdder.addToList(a, this.productByEquipmentStandardOnly_ClassSplit);
        CheckedListAdder.addToList(a, this.productByEquipmentAll_splitByGalley);
        CheckedListAdder.addToList(a, this.productByEquipmentMealPlanOnly_splitByGalley);
        CheckedListAdder.addToList(a, this.productByEquipmentMealPlanWithMealType_splitByGalley);
        CheckedListAdder.addToList(a, this.productByEquipmentMealPlanWithoutMealType_splitByGalley);
        CheckedListAdder.addToList(a, this.productByEquipmentStandardOnly_splitByGalley);
        CheckedListAdder.addToList(a, this.labelSheet);
        CheckedListAdder.addToList(a, this.includeGalleyMap);
        CheckedListAdder.addToList(a, this.deliverySlip);
        CheckedListAdder.addToList(a, this.includeMeals);
        CheckedListAdder.addToList(a, this.includeStandards);
        CheckedListAdder.addToList(a, this.includeArticles);
        return a;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.mealRatioSheet.requestFocusInWindowNow();
    }

    @Override
    public String getPersistString() {
        return null;
    }

    @Override
    public void loadState(String state, String id) {
    }

    @Override
    public String getID() {
        return null;
    }

    @Override
    public boolean shouldPersist() {
        return false;
    }

    @Override
    public void setShouldPersist(boolean isPersisting) {
    }

    public List<ScreenValidationObject> validateBeforePrint() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        if (!this.includeStandards.getElement().isChecked() && !this.includeMeals.getElement().isChecked()) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_MEALS_OR_STANDARDS_ARE_SELECTED));
        }
        boolean isSheetSelected = false;
        if (this.overviewSheet.getElement().isChecked()) {
            isSheetSelected = true;
        }
        if (this.equipmentChecker.getElement().isChecked()) {
            isSheetSelected = true;
        }
        if (this.productByEquipmentSheet.getElement().isChecked()) {
            isSheetSelected = true;
        }
        if (this.labelSheet.getElement().isChecked()) {
            isSheetSelected = true;
        }
        if (this.deliverySlip.getElement().isChecked()) {
            isSheetSelected = true;
        }
        if (this.productForecast.getElement().isChecked()) {
            isSheetSelected = true;
        }
        if (this.mealRatioSheet.getElement().isChecked()) {
            isSheetSelected = true;
        }
        if (!isSheetSelected) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_ATLEAST_ONE_SHEET_IS_SELECTED));
        }
        return a;
    }

    public void fillReportConfiguration(FlightAnalysisCheckerSheetsConfiguration config) {
        config.setIncludeOverviewSheet(Boolean.valueOf(this.overviewSheet.getElement().isChecked()));
        config.setIncludeProductSheet(Boolean.valueOf(this.productByEquipmentSheet.getElement().isChecked()));
        config.setIncludeProductsAll(Boolean.valueOf(this.productByEquipmentAll.getElement().isChecked()));
        config.setIncludeProductsMealsOnly(Boolean.valueOf(this.productByEquipmentMealPlanOnly.getElement().isChecked()));
        config.setIncludeProductsMealsWithMealTypeOnly(Boolean.valueOf(this.productByEquipmentMealPlanWithMealType.getElement().isChecked()));
        config.setIncludeProductsMealsWithoutMealTypeOnly(Boolean.valueOf(this.productByEquipmentMealPlanWithoutMealType.getElement().isChecked()));
        config.setIncludeProductsStandardsOnly(Boolean.valueOf(this.productByEquipmentStandardOnly.getElement().isChecked()));
        config.setIncludeProductsAll_splitByClass(Boolean.valueOf(this.productByEquipmentAll_ClassSplit.getElement().isChecked()));
        config.setIncludeProductsMealsOnly_splitByClass(Boolean.valueOf(this.productByEquipmentMealPlanOnly_ClassSplit.getElement().isChecked()));
        config.setIncludeProductsMealsWithMealTypeOnly_splitByClass(Boolean.valueOf(this.productByEquipmentMealPlanWithMealType_ClassSplit.getElement().isChecked()));
        config.setIncludeProductsMealsWithoutMealTypeOnly_splitByClass(Boolean.valueOf(this.productByEquipmentMealPlanWithoutMealType_ClassSplit.getElement().isChecked()));
        config.setIncludeProductsStandardsOnly_splitByClass(Boolean.valueOf(this.productByEquipmentStandardOnly_ClassSplit.getElement().isChecked()));
        config.setIncludeProductsAll_splitByGalley(Boolean.valueOf(this.productByEquipmentAll_splitByGalley.getElement().isChecked()));
        config.setIncludeProductsMealsOnly_splitByGalley(Boolean.valueOf(this.productByEquipmentMealPlanOnly_splitByGalley.getElement().isChecked()));
        config.setIncludeProductsMealsWithMealTypeOnly_splitByGalley(Boolean.valueOf(this.productByEquipmentMealPlanWithMealType_splitByGalley.getElement().isChecked()));
        config.setIncludeProductsMealsWithoutMealTypeOnly_splitByGalley(Boolean.valueOf(this.productByEquipmentMealPlanWithoutMealType_splitByGalley.getElement().isChecked()));
        config.setIncludeProductsStandardsOnly_splitByGalley(Boolean.valueOf(this.productByEquipmentStandardOnly_splitByGalley.getElement().isChecked()));
        config.setIncludeLabelSheet(Boolean.valueOf(this.labelSheet.getElement().isChecked()));
        config.setIncludeMeals(Boolean.valueOf(this.includeMeals.getElement().isChecked()));
        config.setIncludeStandards(Boolean.valueOf(this.includeStandards.getElement().isChecked()));
        config.setIncludeGalleyMap(Boolean.valueOf(this.includeGalleyMap.getElement().isChecked()));
        config.setIncludeDeliverySlip(Boolean.valueOf(this.deliverySlip.getElement().isChecked()));
        config.setIncludeKitchenForecast(Boolean.valueOf(this.productForecast.getElement().isChecked()));
        config.setIncludeAllDepartments(Boolean.valueOf(this.productForecast.getElement().isChecked() && this.includeAllDepartments.getElement().isChecked()));
        config.setIncludeEquipmentChecker(Boolean.valueOf(this.equipmentChecker.getElement().isChecked()));
        config.setIncludeArticles(Boolean.valueOf(this.includeArticles.getElement().isChecked()));
        config.setIncludeMealsByTypeAndRatio(Boolean.valueOf(this.mealRatioSheet.getElement().isChecked()));
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration config) {
        this.conf = config;
        for (String[] s : this.conf.getProperties()) {
            String n = s[0];
            String v = s[1];
            Boolean b = Boolean.valueOf(v);
            switch (n) {
                case "overview": {
                    this.overviewSheet.getElement().setChecked(b);
                    break;
                }
                case "equipment_checker": {
                    this.equipmentChecker.getElement().setChecked(b);
                    break;
                }
                case "matrix": {
                    this.productByEquipmentSheet.getElement().setChecked(b);
                    break;
                }
                case "mealsByType": {
                    this.mealRatioSheet.getElement().setChecked(b);
                    break;
                }
                case "matrix_all": {
                    this.productByEquipmentAll.getElement().setChecked(b);
                    break;
                }
                case "matrix_all_class": {
                    this.productByEquipmentAll_ClassSplit.getElement().setChecked(b);
                    break;
                }
                case "matrix_all_galley": {
                    this.productByEquipmentAll_splitByGalley.getElement().setChecked(b);
                    break;
                }
                case "matrix_mp": {
                    this.productByEquipmentMealPlanOnly.getElement().setChecked(b);
                    break;
                }
                case "matrix_mp_class": {
                    this.productByEquipmentMealPlanOnly_ClassSplit.getElement().setChecked(b);
                    break;
                }
                case "matrix_mp_galley": {
                    this.productByEquipmentMealPlanOnly_splitByGalley.getElement().setChecked(b);
                    break;
                }
                case "matrix_mpwithmt": {
                    this.productByEquipmentMealPlanWithMealType.getElement().setChecked(b);
                    break;
                }
                case "matrix_mpwithmt_class": {
                    this.productByEquipmentMealPlanWithMealType_ClassSplit.getElement().setChecked(b);
                    break;
                }
                case "matrix_mpwithmt_galley": {
                    this.productByEquipmentMealPlanWithMealType_splitByGalley.getElement().setChecked(b);
                    break;
                }
                case "matrix_mpohnemt": {
                    this.productByEquipmentMealPlanWithoutMealType.getElement().setChecked(b);
                    break;
                }
                case "matrix_mpohnemt_class": {
                    this.productByEquipmentMealPlanWithoutMealType_ClassSplit.getElement().setChecked(b);
                    break;
                }
                case "matrix_mpohnemt_galley": {
                    this.productByEquipmentMealPlanWithoutMealType_splitByGalley.getElement().setChecked(b);
                    break;
                }
                case "matrix_std": {
                    this.productByEquipmentStandardOnly.getElement().setChecked(b);
                    break;
                }
                case "matrix_std_class": {
                    this.productByEquipmentStandardOnly_ClassSplit.getElement().setChecked(b);
                    break;
                }
                case "matrix_std_galley": {
                    this.productByEquipmentStandardOnly_splitByGalley.getElement().setChecked(b);
                    break;
                }
                case "label": {
                    this.labelSheet.getElement().setChecked(b);
                    break;
                }
                case "label_galley": {
                    this.includeGalleyMap.getElement().setChecked(b);
                    break;
                }
                case "deliveryslip": {
                    this.deliverySlip.getElement().setChecked(b);
                    break;
                }
                case "kitchenforecast": {
                    this.productForecast.getElement().setChecked(b);
                    break;
                }
                case "includeAllDepartments": {
                    this.includeAllDepartments.getElement().setChecked(b);
                    break;
                }
                case "meals": {
                    this.includeMeals.getElement().setChecked(b);
                    break;
                }
                case "std": {
                    this.includeStandards.getElement().setChecked(b);
                    break;
                }
                case "articles": {
                    this.includeArticles.getElement().setChecked(b);
                }
            }
        }
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        conf.addProperty("overview", "" + this.overviewSheet.getElement().isChecked());
        conf.addProperty("equipment_checker", "" + this.equipmentChecker.getElement().isChecked());
        conf.addProperty("mealsByType", "" + this.mealRatioSheet.getElement().isChecked());
        conf.addProperty("matrix", "" + this.productByEquipmentSheet.getElement().isChecked());
        conf.addProperty("matrix_all", "" + this.productByEquipmentAll.getElement().isChecked());
        conf.addProperty("matrix_all_class", "" + this.productByEquipmentAll_ClassSplit.getElement().isChecked());
        conf.addProperty("matrix_all_galley", "" + this.productByEquipmentAll_splitByGalley.getElement().isChecked());
        conf.addProperty("matrix_mp", "" + this.productByEquipmentMealPlanOnly.getElement().isChecked());
        conf.addProperty("matrix_mp_class", "" + this.productByEquipmentMealPlanOnly_ClassSplit.getElement().isChecked());
        conf.addProperty("matrix_mp_galley", "" + this.productByEquipmentMealPlanOnly_splitByGalley.getElement().isChecked());
        conf.addProperty("matrix_mpwithmt", "" + this.productByEquipmentMealPlanWithMealType.getElement().isChecked());
        conf.addProperty("matrix_mpwithmt_class", "" + this.productByEquipmentMealPlanWithMealType_ClassSplit.getElement().isChecked());
        conf.addProperty("matrix_mpwithmt_galley", "" + this.productByEquipmentMealPlanWithMealType_splitByGalley.getElement().isChecked());
        conf.addProperty("matrix_mpohnemt", "" + this.productByEquipmentMealPlanWithoutMealType.getElement().isChecked());
        conf.addProperty("matrix_mpohnemt_class", "" + this.productByEquipmentMealPlanWithoutMealType_ClassSplit.getElement().isChecked());
        conf.addProperty("matrix_mpohnemt_galley", "" + this.productByEquipmentMealPlanWithoutMealType_splitByGalley.getElement().isChecked());
        conf.addProperty("matrix_std", "" + this.productByEquipmentStandardOnly.getElement().isChecked());
        conf.addProperty("matrix_std_class", "" + this.productByEquipmentStandardOnly_ClassSplit.getElement().isChecked());
        conf.addProperty("matrix_std_galley", "" + this.productByEquipmentStandardOnly_splitByGalley.getElement().isChecked());
        conf.addProperty("label", "" + this.labelSheet.getElement().isChecked());
        conf.addProperty("label_galley", "" + this.includeGalleyMap.getElement().isChecked());
        conf.addProperty("deliveryslip", "" + this.deliverySlip.getElement().isChecked());
        conf.addProperty("kitchenforecast", "" + this.productForecast.getElement().isChecked());
        conf.addProperty("includeAllDepartments", "" + this.includeAllDepartments.getElement().isChecked());
        conf.addProperty("meals", "" + this.includeMeals.getElement().isChecked());
        conf.addProperty("std", "" + this.includeStandards.getElement().isChecked());
        conf.addProperty("articles", "" + this.includeArticles.getElement().isChecked());
        this.conf = conf;
        return conf;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            if (CheckerSheetConfigPanel.this.sheetSelection != null) {
                CheckerSheetConfigPanel.this.sheetSelection.setLocation(CheckerSheetConfigPanel.this.border, 0);
                CheckerSheetConfigPanel.this.sheetSelection.setSize(CheckerSheetConfigPanel.this.sheetSelection.getPreferredSize());
                CheckerSheetConfigPanel.this.overviewSheet.setLocation(CheckerSheetConfigPanel.this.border, CheckerSheetConfigPanel.this.sheetSelection.getY() + CheckerSheetConfigPanel.this.sheetSelection.getHeight() + CheckerSheetConfigPanel.this.border / 2);
                CheckerSheetConfigPanel.this.overviewSheet.setSize(CheckerSheetConfigPanel.this.overviewSheet.getPreferredSize());
                CheckerSheetConfigPanel.this.equipmentChecker.setLocation(CheckerSheetConfigPanel.this.border, CheckerSheetConfigPanel.this.overviewSheet.getY() + CheckerSheetConfigPanel.this.overviewSheet.getHeight() + CheckerSheetConfigPanel.this.border / 4);
                CheckerSheetConfigPanel.this.equipmentChecker.setSize(CheckerSheetConfigPanel.this.equipmentChecker.getPreferredSize());
                CheckerSheetConfigPanel.this.mealRatioSheet.setLocation(CheckerSheetConfigPanel.this.border, CheckerSheetConfigPanel.this.equipmentChecker.getY() + CheckerSheetConfigPanel.this.equipmentChecker.getHeight() + CheckerSheetConfigPanel.this.border / 4);
                CheckerSheetConfigPanel.this.mealRatioSheet.setSize(CheckerSheetConfigPanel.this.mealRatioSheet.getPreferredSize());
                CheckerSheetConfigPanel.this.productByEquipmentSheet.setLocation(CheckerSheetConfigPanel.this.border, CheckerSheetConfigPanel.this.mealRatioSheet.getY() + CheckerSheetConfigPanel.this.mealRatioSheet.getHeight() + CheckerSheetConfigPanel.this.border / 4);
                CheckerSheetConfigPanel.this.productByEquipmentSheet.setSize(CheckerSheetConfigPanel.this.productByEquipmentSheet.getPreferredSize());
                CheckerSheetConfigPanel.this.productByEquipmentAll.setLocation(CheckerSheetConfigPanel.this.border * 2, CheckerSheetConfigPanel.this.productByEquipmentSheet.getY() + CheckerSheetConfigPanel.this.productByEquipmentSheet.getHeight() + CheckerSheetConfigPanel.this.border / 8);
                CheckerSheetConfigPanel.this.productByEquipmentAll.setSize(CheckerSheetConfigPanel.this.productByEquipmentAll.getPreferredSize());
                CheckerSheetConfigPanel.this.productByEquipmentMealPlanOnly.setLocation(CheckerSheetConfigPanel.this.border * 2, CheckerSheetConfigPanel.this.productByEquipmentAll.getY() + CheckerSheetConfigPanel.this.productByEquipmentAll.getHeight() + CheckerSheetConfigPanel.this.border / 8);
                CheckerSheetConfigPanel.this.productByEquipmentMealPlanOnly.setSize(CheckerSheetConfigPanel.this.productByEquipmentMealPlanOnly.getPreferredSize());
                CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithMealType.setLocation(CheckerSheetConfigPanel.this.border * 2, CheckerSheetConfigPanel.this.productByEquipmentMealPlanOnly.getY() + CheckerSheetConfigPanel.this.productByEquipmentMealPlanOnly.getHeight() + CheckerSheetConfigPanel.this.border / 8);
                CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithMealType.setSize(CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithMealType.getPreferredSize());
                CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithoutMealType.setLocation(CheckerSheetConfigPanel.this.border * 2, CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithMealType.getY() + CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithMealType.getHeight() + CheckerSheetConfigPanel.this.border / 8);
                CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithoutMealType.setSize(CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithoutMealType.getPreferredSize());
                CheckerSheetConfigPanel.this.productByEquipmentStandardOnly.setLocation(CheckerSheetConfigPanel.this.border * 2, CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithoutMealType.getY() + CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithoutMealType.getHeight() + CheckerSheetConfigPanel.this.border / 8);
                CheckerSheetConfigPanel.this.productByEquipmentStandardOnly.setSize(CheckerSheetConfigPanel.this.productByEquipmentStandardOnly.getPreferredSize());
                CheckerSheetConfigPanel.this.productByEquipmentAll_ClassSplit.setLocation(CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithoutMealType.getX() + CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithoutMealType.getWidth() + 5, CheckerSheetConfigPanel.this.productByEquipmentAll.getY());
                CheckerSheetConfigPanel.this.productByEquipmentAll_ClassSplit.setSize(CheckerSheetConfigPanel.this.productByEquipmentAll_ClassSplit.getPreferredSize());
                CheckerSheetConfigPanel.this.productByEquipmentMealPlanOnly_ClassSplit.setLocation(CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithoutMealType.getX() + CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithoutMealType.getWidth() + 5, CheckerSheetConfigPanel.this.productByEquipmentMealPlanOnly.getY());
                CheckerSheetConfigPanel.this.productByEquipmentMealPlanOnly_ClassSplit.setSize(CheckerSheetConfigPanel.this.productByEquipmentMealPlanOnly_ClassSplit.getPreferredSize());
                CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithMealType_ClassSplit.setLocation(CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithoutMealType.getX() + CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithoutMealType.getWidth() + 5, CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithMealType.getY());
                CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithMealType_ClassSplit.setSize(CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithMealType_ClassSplit.getPreferredSize());
                CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithoutMealType_ClassSplit.setLocation(CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithoutMealType.getX() + CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithoutMealType.getWidth() + 5, CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithoutMealType.getY());
                CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithoutMealType_ClassSplit.setSize(CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithoutMealType_ClassSplit.getPreferredSize());
                CheckerSheetConfigPanel.this.productByEquipmentStandardOnly_ClassSplit.setLocation(CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithoutMealType.getX() + CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithoutMealType.getWidth() + 5, CheckerSheetConfigPanel.this.productByEquipmentStandardOnly.getY());
                CheckerSheetConfigPanel.this.productByEquipmentStandardOnly_ClassSplit.setSize(CheckerSheetConfigPanel.this.productByEquipmentStandardOnly_ClassSplit.getPreferredSize());
                CheckerSheetConfigPanel.this.productByEquipmentAll_splitByGalley.setLocation(CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithoutMealType_ClassSplit.getX() + CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithoutMealType_ClassSplit.getWidth() + 5, CheckerSheetConfigPanel.this.productByEquipmentAll.getY());
                CheckerSheetConfigPanel.this.productByEquipmentAll_splitByGalley.setSize(CheckerSheetConfigPanel.this.productByEquipmentAll_splitByGalley.getPreferredSize());
                CheckerSheetConfigPanel.this.productByEquipmentMealPlanOnly_splitByGalley.setLocation(CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithoutMealType_ClassSplit.getX() + CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithoutMealType_ClassSplit.getWidth() + 5, CheckerSheetConfigPanel.this.productByEquipmentMealPlanOnly.getY());
                CheckerSheetConfigPanel.this.productByEquipmentMealPlanOnly_splitByGalley.setSize(CheckerSheetConfigPanel.this.productByEquipmentMealPlanOnly_splitByGalley.getPreferredSize());
                CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithMealType_splitByGalley.setLocation(CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithoutMealType_ClassSplit.getX() + CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithoutMealType_ClassSplit.getWidth() + 5, CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithMealType.getY());
                CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithMealType_splitByGalley.setSize(CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithMealType_splitByGalley.getPreferredSize());
                CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithoutMealType_splitByGalley.setLocation(CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithoutMealType_ClassSplit.getX() + CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithoutMealType_ClassSplit.getWidth() + 5, CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithoutMealType.getY());
                CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithoutMealType_splitByGalley.setSize(CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithoutMealType_splitByGalley.getPreferredSize());
                CheckerSheetConfigPanel.this.productByEquipmentStandardOnly_splitByGalley.setLocation(CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithoutMealType_ClassSplit.getX() + CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithoutMealType_ClassSplit.getWidth() + 5, CheckerSheetConfigPanel.this.productByEquipmentStandardOnly.getY());
                CheckerSheetConfigPanel.this.productByEquipmentStandardOnly_splitByGalley.setSize(CheckerSheetConfigPanel.this.productByEquipmentStandardOnly_splitByGalley.getPreferredSize());
                CheckerSheetConfigPanel.this.labelSheet.setLocation(CheckerSheetConfigPanel.this.border, CheckerSheetConfigPanel.this.productByEquipmentStandardOnly.getY() + CheckerSheetConfigPanel.this.productByEquipmentStandardOnly.getHeight() + CheckerSheetConfigPanel.this.border / 4);
                CheckerSheetConfigPanel.this.labelSheet.setSize(CheckerSheetConfigPanel.this.labelSheet.getPreferredSize());
                CheckerSheetConfigPanel.this.includeGalleyMap.setLocation(2 * CheckerSheetConfigPanel.this.border, CheckerSheetConfigPanel.this.labelSheet.getY() + CheckerSheetConfigPanel.this.labelSheet.getHeight() + CheckerSheetConfigPanel.this.border / 8);
                CheckerSheetConfigPanel.this.includeGalleyMap.setSize(CheckerSheetConfigPanel.this.includeGalleyMap.getPreferredSize());
                CheckerSheetConfigPanel.this.deliverySlip.setLocation(CheckerSheetConfigPanel.this.border, CheckerSheetConfigPanel.this.includeGalleyMap.getY() + CheckerSheetConfigPanel.this.includeGalleyMap.getHeight() + CheckerSheetConfigPanel.this.border / 4);
                CheckerSheetConfigPanel.this.deliverySlip.setSize(CheckerSheetConfigPanel.this.deliverySlip.getPreferredSize());
                CheckerSheetConfigPanel.this.productForecast.setLocation(CheckerSheetConfigPanel.this.border, CheckerSheetConfigPanel.this.deliverySlip.getY() + CheckerSheetConfigPanel.this.deliverySlip.getHeight() + CheckerSheetConfigPanel.this.border / 4);
                CheckerSheetConfigPanel.this.productForecast.setSize(CheckerSheetConfigPanel.this.productForecast.getPreferredSize());
                CheckerSheetConfigPanel.this.includeAllDepartments.setLocation(2 * CheckerSheetConfigPanel.this.border, CheckerSheetConfigPanel.this.productForecast.getY() + CheckerSheetConfigPanel.this.productForecast.getHeight() + CheckerSheetConfigPanel.this.border / 4);
                CheckerSheetConfigPanel.this.includeAllDepartments.setSize(CheckerSheetConfigPanel.this.includeAllDepartments.getPreferredSize());
                CheckerSheetConfigPanel.this.includeMeals.setLocation(CheckerSheetConfigPanel.this.border, CheckerSheetConfigPanel.this.includeAllDepartments.getY() + CheckerSheetConfigPanel.this.includeAllDepartments.getHeight() + CheckerSheetConfigPanel.this.border);
                CheckerSheetConfigPanel.this.includeMeals.setSize(CheckerSheetConfigPanel.this.includeMeals.getPreferredSize());
                CheckerSheetConfigPanel.this.includeStandards.setLocation(CheckerSheetConfigPanel.this.border, CheckerSheetConfigPanel.this.includeMeals.getY() + CheckerSheetConfigPanel.this.includeMeals.getHeight() + CheckerSheetConfigPanel.this.border / 4);
                CheckerSheetConfigPanel.this.includeStandards.setSize(CheckerSheetConfigPanel.this.includeStandards.getPreferredSize());
                CheckerSheetConfigPanel.this.includeArticles.setLocation(CheckerSheetConfigPanel.this.border, CheckerSheetConfigPanel.this.includeStandards.getY() + CheckerSheetConfigPanel.this.includeStandards.getHeight() + CheckerSheetConfigPanel.this.border / 4);
                CheckerSheetConfigPanel.this.includeArticles.setSize(CheckerSheetConfigPanel.this.includeArticles.getPreferredSize());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = 0;
            int w = 250;
            if (CheckerSheetConfigPanel.this.sheetSelection != null) {
                h += CheckerSheetConfigPanel.this.border;
                h = (int)((double)h + CheckerSheetConfigPanel.this.sheetSelection.getPreferredSize().getHeight());
                h += CheckerSheetConfigPanel.this.border / 2;
                h = (int)((double)h + CheckerSheetConfigPanel.this.overviewSheet.getPreferredSize().getHeight());
                h += CheckerSheetConfigPanel.this.border / 4;
                h = (int)((double)h + CheckerSheetConfigPanel.this.equipmentChecker.getPreferredSize().getHeight());
                h += CheckerSheetConfigPanel.this.border / 4;
                h = (int)((double)h + CheckerSheetConfigPanel.this.mealRatioSheet.getPreferredSize().getHeight());
                h += CheckerSheetConfigPanel.this.border / 4;
                h = (int)((double)h + CheckerSheetConfigPanel.this.productByEquipmentSheet.getPreferredSize().getHeight());
                h += CheckerSheetConfigPanel.this.border / 4;
                h = (int)((double)h + CheckerSheetConfigPanel.this.productByEquipmentAll.getPreferredSize().getHeight());
                h += CheckerSheetConfigPanel.this.border / 8;
                h = (int)((double)h + CheckerSheetConfigPanel.this.productByEquipmentMealPlanOnly.getPreferredSize().getHeight());
                h += CheckerSheetConfigPanel.this.border / 8;
                h = (int)((double)h + CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithMealType.getPreferredSize().getHeight());
                h += CheckerSheetConfigPanel.this.border / 8;
                h = (int)((double)h + CheckerSheetConfigPanel.this.productByEquipmentMealPlanWithoutMealType.getPreferredSize().getHeight());
                h += CheckerSheetConfigPanel.this.border / 8;
                h = (int)((double)h + CheckerSheetConfigPanel.this.productByEquipmentStandardOnly.getPreferredSize().getHeight());
                h += CheckerSheetConfigPanel.this.border / 4;
                h = (int)((double)h + CheckerSheetConfigPanel.this.labelSheet.getPreferredSize().getHeight());
                h += CheckerSheetConfigPanel.this.border / 8;
                h = (int)((double)h + CheckerSheetConfigPanel.this.includeGalleyMap.getPreferredSize().getHeight());
                h += CheckerSheetConfigPanel.this.border / 4;
                h = (int)((double)h + CheckerSheetConfigPanel.this.deliverySlip.getPreferredSize().getHeight());
                h += CheckerSheetConfigPanel.this.border / 4;
                h = (int)((double)h + CheckerSheetConfigPanel.this.productForecast.getPreferredSize().getHeight());
                h += CheckerSheetConfigPanel.this.border / 4;
                h = (int)((double)h + CheckerSheetConfigPanel.this.includeAllDepartments.getPreferredSize().getHeight());
                h += CheckerSheetConfigPanel.this.border;
                h = (int)((double)h + CheckerSheetConfigPanel.this.includeMeals.getPreferredSize().getHeight());
                h += CheckerSheetConfigPanel.this.border / 4;
                h = (int)((double)h + CheckerSheetConfigPanel.this.includeStandards.getPreferredSize().getHeight());
                h += CheckerSheetConfigPanel.this.border / 4;
                h = (int)((double)h + CheckerSheetConfigPanel.this.includeArticles.getPreferredSize().getHeight());
            }
            return new Dimension(w, h += CheckerSheetConfigPanel.this.border);
        }
    }
}

