/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.panels;

import ch.icit.pegasus.client.converter.DateUnitEConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.Validatable;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.filterchain.UIStateLoadable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.layout.CreepyLayout;
import ch.icit.pegasus.client.gui.utils.layout.CreepyLayoutConstraints;
import ch.icit.pegasus.client.gui.utils.panels.DefaultPanel;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.server.core.dtos.util.DateDurationComplete;
import ch.icit.pegasus.server.core.dtos.util.DateUnitE;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;

public class DateDurationPanelInt
extends DefaultPanel
implements Validatable,
UIStateLoadable {
    private static final long serialVersionUID = 1L;
    private NumberTextField fixAmount;
    private ComboBox unit;

    public DateDurationPanelInt() {
        CreepyLayout crl = new CreepyLayout();
        crl.setOuterBorderHorizontal(0);
        crl.setOuterBorderVertical(0);
        this.setLayout(crl);
        this.fixAmount = new NumberTextField(null, TextFieldType.INT);
        this.fixAmount.setText("1");
        this.unit = new ComboBox(null, StaticEnumServiceManager.getAllDateDurations(), ConverterRegistry.getConverter(DateUnitEConverter.class));
        this.unit.setPreferredSize(new Dimension(80, 0));
        this.unit.setProgress(1.0f);
        this.unit.setSelectedIndex(2);
        this.fixAmount.setProgress(1.0f);
        this.add((Component)this.fixAmount, new CreepyLayoutConstraints(1.0, 0.0, 0, 0));
        this.add((Component)this.unit, new CreepyLayoutConstraints(0.0, 0.0, 1, 0));
    }

    public long getWindow() {
        Node u = (Node)this.unit.getSelectedItem();
        long base = ((DateUnitE)u.getValue()).getBaseMillis();
        try {
            int count = Integer.valueOf(this.fixAmount.getText());
            return base * (long)count;
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public DateDurationComplete getDateDuration() {
        Node u = (Node)this.unit.getSelectedItem();
        int count = 0;
        try {
            count = Integer.valueOf(this.fixAmount.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        DateDurationComplete d = new DateDurationComplete();
        d.setUnit((DateUnitE)u.getValue());
        d.setDuration(Double.valueOf(count));
        return d;
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> o = this.fixAmount.getFocusComponents();
        CheckedListAdder.addToList(o, this.unit);
        return o;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.fixAmount.setEnabled(isEnabled);
        this.unit.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.fixAmount.kill();
        this.fixAmount = null;
        this.unit.kill();
        this.unit = null;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        this.fixAmount.setVisibleContainer(pane);
        this.unit.setVisibleContainer(pane);
    }

    @Override
    public void requestFocusInWindowNow() {
        this.fixAmount.requestFocusInWindowNow();
    }

    @Override
    public void setValid() {
        this.fixAmount.setValid();
        this.unit.setValid();
    }

    @Override
    public void setInvalid() {
        this.fixAmount.setInvalid();
        this.unit.setInvalid();
    }

    @Override
    public void setWarning() {
        this.fixAmount.setWarning();
        this.unit.setWarning();
    }

    @Override
    public void setPermanent(boolean isPermantent) {
        this.fixAmount.setPermanent(isPermantent);
        this.unit.setPermanent(isPermantent);
    }

    @Override
    public String getPersistString() {
        String t = this.fixAmount.getPersistString();
        t = t + "<>";
        t = t + this.unit.getPersistString();
        return t;
    }

    @Override
    public void loadState(String state, String id) {
        String[] s = state.split("<>");
        this.fixAmount.loadState(s[0], "");
        this.unit.loadState(s[1], "");
    }

    @Override
    public String getID() {
        return null;
    }

    @Override
    public boolean shouldPersist() {
        return false;
    }

    @Override
    public void setShouldPersist(boolean isPersisting) {
    }
}

