/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.PaxFigureTypeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.flight.details.utils.PaxTable4;
import ch.icit.pegasus.client.gui.modules.flight.details.utils.PaxTableChangeListener;
import ch.icit.pegasus.client.gui.utils.Nodable;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.panels.TabbedItem;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.tabbed.TabPaxTypeCheckBoxButton;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.CalendarUtil;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLegComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.ILegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.PaxFigureComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.PaxFigureComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PaxFigureTypeComplete;
import ch.icit.pegasus.server.core.dtos.util.DateDurationComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class MultiPaxTable
extends TabbedItem<PaxTable4>
implements Nodable,
PaxTableChangeListener {
    private static final long serialVersionUID = 1L;
    private Node<FlightComplete> flightNode;
    private RDProvider provider;
    private Container superPanel;
    private MutableFocusContainerListener focusCycleCreator;
    private List<MutableFocusContainerListener> focusListeners = new ArrayList<MutableFocusContainerListener>();

    public MultiPaxTable(RDProvider provider) {
        this.provider = provider;
    }

    @Override
    public void setNode(Node<?> node) {
        this.flightNode = node;
        this.clearTabbedItem();
        if (this.flightNode != null) {
            Converter c = ConverterRegistry.getConverter(PaxFigureTypeConverter.class);
            List<PaxFigureTypeComplete> types = this.createTypeList();
            PaxFigureTypeComplete selectedView = this.getBestMatchingType(this.flightNode, types);
            for (PaxFigureTypeComplete type : types) {
                this.insertPaxTable(node, (Converter<PaxFigureTypeComplete, String>)c, type, Objects.equals(selectedView, type));
            }
            this.insertPaxTable(this.flightNode, (Converter<PaxFigureTypeComplete, String>)c, null, selectedView == null);
            if (types.isEmpty()) {
                this.removeHeaders();
            }
        }
    }

    private PaxFigureTypeComplete getBestMatchingType(Node<FlightComplete> flightNode2, List<PaxFigureTypeComplete> types) {
        if (flightNode2 == null) {
            return null;
        }
        Node paxTypeNode = flightNode2.getChildNamed(FlightComplete_.selectedPaxType);
        if (paxTypeNode != null) {
            PaxFigureTypeComplete tt = (PaxFigureTypeComplete)paxTypeNode.getValue();
            if (paxTypeNode != null && tt != null) {
                return tt;
            }
            if (Boolean.TRUE.equals(flightNode2.getChildNamed(FlightLight_.invoicePaxSelected).getValue())) {
                return tt;
            }
        }
        long current = System.currentTimeMillis();
        if (flightNode2 == null) {
            return null;
        }
        FlightLight flight = (FlightLight)flightNode2.getValue(FlightLight.class);
        if (flight == null) {
            return null;
        }
        if (flight.getStd() == null) {
            return null;
        }
        long std = flight.getStd().getTime();
        if (current > std) {
            return null;
        }
        Collections.sort(types);
        PaxFigureTypeComplete latestMatch = null;
        for (PaxFigureTypeComplete t : types) {
            long dif = CalendarUtil.getDuration((DateDurationComplete)t.getDuration());
            long ntime = std - dif;
            if (current < ntime) {
                if (latestMatch != null) {
                    return latestMatch;
                }
                return t;
            }
            latestMatch = t;
        }
        return latestMatch;
    }

    public void setSuperPanel(Container superPanel) {
        this.superPanel = superPanel;
    }

    public void setFocusCycleCreator(MutableFocusContainerListener focusCycleCreator) {
        this.focusCycleCreator = focusCycleCreator;
    }

    private void insertPaxTable(Node<?> node, Converter<PaxFigureTypeComplete, String> c, PaxFigureTypeComplete type, boolean selected) {
        TabPaxTypeCheckBoxButton button = new TabPaxTypeCheckBoxButton(type != null ? (String)c.convert((Object)type, null, new Object[0]) : Words.INVOICED_PAX, type, this.flightNode);
        PaxTable4 table = new PaxTable4(this.provider);
        table.setSuperPanel(this.superPanel);
        table.setFocusCycleCreator(this.focusCycleCreator);
        table.addPaxTableListener(this);
        if (table.getTable() != null && table.getTable().getModel() != null) {
            for (MutableFocusContainerListener l : this.focusListeners) {
                table.getTable().getModel().addFocusCycleChangeListener(l);
            }
        }
        table.setSelectedPaxFigureType(type);
        table.setNode(node);
        this.addView(table, button, selected);
    }

    private List<PaxFigureTypeComplete> createTypeList() {
        HashSet<Object> typeMap = new HashSet<Object>();
        if (this.flightNode != null) {
            Iterator it = this.flightNode.getChildNamed(FlightLight_.legs).getFailSafeChildIterator();
            while (it.hasNext()) {
                Node l = (Node)it.next();
                Iterator it2 = l.getChildNamed(FlightLegComplete_.paxFigures).getFailSafeChildIterator();
                while (it2.hasNext()) {
                    Node p = (Node)it2.next();
                    Node pft = p.getChildNamed(PaxFigureComplete_.paxFigureType);
                    if (pft.getValue() == null) continue;
                    typeMap.add(pft.getValue());
                }
            }
        }
        ArrayList<PaxFigureTypeComplete> types = new ArrayList<PaxFigureTypeComplete>();
        types.addAll(typeMap);
        Collections.sort(types);
        return types;
    }

    @Override
    public Node<?> getNode() {
        return this.flightNode;
    }

    public List<ScreenValidationObject> isTableValid() {
        ArrayList<ScreenValidationObject> o = new ArrayList<ScreenValidationObject>();
        for (PaxTable4 table : this.getViews()) {
            o.addAll(table.isTableValid());
        }
        return o;
    }

    public void setValid(boolean valid) {
        for (PaxTable4 table : this.getViews()) {
            table.setValid(valid);
        }
    }

    public void addFocusCycleChangeListener(MutableFocusContainerListener listener) {
        this.focusListeners.add(listener);
    }

    public void setPaxMax(CabinClassComplete clazz, ILegComplete leg, Integer max) {
        for (PaxTable4 table : this.getViews()) {
            table.setPaxMax(clazz, leg, max != null ? max : 0);
        }
    }

    @Override
    public void paxChanged(PaxFigureComplete paxFigure, int number) {
        if (paxFigure.getPaxFigureType() != null) {
            List<PaxFigureTypeComplete> types = this.createTypeList();
            boolean found = false;
            for (PaxFigureTypeComplete t : types) {
                if (found) {
                    this.updatePax(paxFigure, t, number);
                    continue;
                }
                if (!t.equals((Object)paxFigure.getPaxFigureType())) continue;
                found = true;
            }
            this.updatePax(paxFigure, null, number);
        }
    }

    private void updatePax(PaxFigureComplete paxFigure, PaxFigureTypeComplete type, int number) {
        for (PaxTable4 t : this.getViews()) {
            if (type != null) {
                if (!type.equals((Object)t.getSelectedPaxFigureType())) continue;
                t.updatePax(paxFigure, number);
                continue;
            }
            if (t.getSelectedPaxFigureType() != null) continue;
            t.updatePax(paxFigure, number);
        }
    }

    @Override
    public void updateFocusCycle() {
        if (this.focusCycleCreator != null) {
            this.focusCycleCreator.focusCycleChanged(null);
            List<Component> l = this.getFocusComponents();
            if (!l.isEmpty()) {
                Component c = l.get(0);
                c.requestFocusInWindow();
            }
        }
    }
}

