/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.panels;

import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.textfield.PasswordTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.validator.ValidatingObject;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class UserNamePasswordPanel
extends JPanelFadable
implements Focusable,
RemoteLoader {
    private static final long serialVersionUID = 1L;
    public static final int TYPE_ADD = 3;
    public static final int TYPE_CHANGE = 5;
    private final int horizontalBorder = 10;
    private final int verticalBorder = 10;
    private int currentType;
    private final int tempType;
    private Node<UserComplete> userNode;
    private TitledItem<TextField> field1;
    private TitledItem<TextField> field2;
    private TitledItem<TextField> field3;

    public UserNamePasswordPanel(Node<UserComplete> user, int type) {
        this.tempType = type;
        this.setOpaque(false);
        this.setLayout(new Layouter());
        this.setProgress(1.0f);
        if (user != null) {
            this.setNode(user);
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.field1.setEnabled(isEnabled);
        this.field2.setEnabled(isEnabled);
        this.field3.setEnabled(isEnabled);
    }

    public void setNode(Node node) {
        this.userNode = node;
        this.switchType(this.tempType);
    }

    public ValidatingObject validateUsernameAndPassword() {
        String msg = "";
        String tm = "";
        boolean isCValid = true;
        ValidatingObject ret = null;
        ArrayList<ValidatingObject> innerObject = new ArrayList<ValidatingObject>();
        if (this.currentType == 3) {
            if (this.field1.getElement().getText().equals("")) {
                tm = Words.USERNAME_NOT_SET + "<br>";
                msg = msg + tm;
                isCValid = false;
                innerObject.add(new ValidatingObject(false, tm, this.field1.getElement()));
            }
            if (this.field2.getElement().getText().equals("")) {
                tm = Words.PASSWORD_NOT_SET + "<br>";
                msg = msg + tm;
                isCValid = false;
                innerObject.add(new ValidatingObject(false, tm, this.field2.getElement()));
            }
            if (this.field3.getElement().getText().equals("")) {
                tm = Words.RETYPE_PASSWORD + "<br>";
                msg = msg + tm;
                isCValid = false;
                innerObject.add(new ValidatingObject(false, tm, this.field3.getElement()));
            }
            if (!this.field2.getElement().getText().equals(this.field3.getElement().getText())) {
                tm = Words.THE_RETYPED_PASSWORD_IS_NOT_EQUALS_TO_THE_NEW_PASSWORD + "<br>";
                msg = msg + tm;
                isCValid = false;
                innerObject.add(new ValidatingObject(false, tm, this.field2.getElement()));
                innerObject.add(new ValidatingObject(false, tm, this.field3.getElement()));
            }
        } else if (!this.field2.getElement().getText().equals("") || !this.field3.getElement().getText().equals("")) {
            if (this.field1.getElement().getText().equals("")) {
                tm = Words.ENTER_YOUR_CURRENT_PASSWORD + "<br>";
                msg = msg + tm;
                isCValid = false;
                innerObject.add(new ValidatingObject(false, tm, this.field1.getElement()));
            }
            if (this.field2.getElement().getText().equals("")) {
                tm = Words.PASSWORD_NOT_SET + "<br>";
                msg = msg + tm;
                isCValid = false;
                innerObject.add(new ValidatingObject(false, tm, this.field2.getElement()));
            }
            if (this.field3.getElement().getText().equals("")) {
                tm = Words.RETYPE_NEW_PASSWORD + "<br>";
                msg = msg + tm;
                isCValid = false;
                innerObject.add(new ValidatingObject(false, tm, this.field3.getElement()));
            }
            if (!this.field2.getElement().getText().equals(this.field3.getElement().getText())) {
                tm = Words.THE_RETYPED_PASSWORD_IS_NOT_EQUALS_TO_THE_NEW_PASSWORD + "<br>";
                msg = msg + tm;
                isCValid = false;
                innerObject.add(new ValidatingObject(false, tm, this.field2.getElement()));
                innerObject.add(new ValidatingObject(false, tm, this.field3.getElement()));
            }
        }
        ret = new ValidatingObject(isCValid, msg, null);
        ret.setInnerObjects(innerObject);
        return ret;
    }

    private void switchType(int newType) {
        if (newType != this.currentType) {
            this.currentType = newType;
            Node pwd1 = this.userNode.getChildNamed(DtoFieldConstants.pwd1);
            Node pwd2 = this.userNode.getChildNamed(DtoFieldConstants.pwd2);
            if (pwd1 == null) {
                pwd1 = new Node();
                pwd1.setName(DtoFieldConstants.pwd1);
                this.userNode.addChild(pwd1, 0L);
            }
            if (pwd2 == null) {
                pwd2 = new Node();
                pwd2.setName(DtoFieldConstants.pwd2);
                this.userNode.addChild(pwd2, 0L);
            }
            switch (this.currentType) {
                case 3: {
                    this.field1 = new TitledItem<TextField>(new TextField(this.userNode.getChildNamed(UserLight_.userName)), Words.USERNAME, TitledItem.TitledItemOrientation.NORTH);
                    this.field2 = new TitledItem<PasswordTextField>(new PasswordTextField(pwd1), Words.ENTER_PASSWORD, TitledItem.TitledItemOrientation.NORTH);
                    this.field3 = new TitledItem<PasswordTextField>(new PasswordTextField(pwd2), Words.RETYPE_PASSWORD, TitledItem.TitledItemOrientation.NORTH);
                    break;
                }
                case 5: {
                    Node pwd3 = this.userNode.getChildNamed(DtoFieldConstants.pwd3);
                    if (pwd3 == null) {
                        pwd3 = new Node();
                        pwd3.setName(DtoFieldConstants.pwd3);
                        this.userNode.addChild(pwd3, 0L);
                    }
                    this.field1 = new TitledItem<PasswordTextField>(new PasswordTextField(pwd1), Words.ENTER_CURRENT_PASSWORD, TitledItem.TitledItemOrientation.NORTH);
                    this.field2 = new TitledItem<PasswordTextField>(new PasswordTextField(pwd2), Words.ENTER_NEW_PASSWORD, TitledItem.TitledItemOrientation.NORTH);
                    this.field3 = new TitledItem<PasswordTextField>(new PasswordTextField(pwd3), Words.RETYPE_NEW_PASSWORD, TitledItem.TitledItemOrientation.NORTH);
                }
            }
            this.add(this.field1);
            this.add(this.field2);
            this.add(this.field3);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.field1.kill();
        this.field1 = null;
        this.field2.kill();
        this.field2 = null;
        this.field3.kill();
        this.field3 = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.field1);
        CheckedListAdder.addToList(a, this.field2);
        CheckedListAdder.addToList(a, this.field3);
        return a;
    }

    public void remoteObjectLoaded(Node<?> node) {
        if (node == null || !this.field1.getElement().isFieldValid()) {
            this.field1.getElement().setInvalid();
        } else {
            this.field1.getElement().setValid();
        }
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        this.field1.setVisibleContainer(pane);
        this.field2.setVisibleContainer(pane);
        this.field3.setVisibleContainer(pane);
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.field1.requestFocusInWindowNow();
    }

    public void errorOccurred(ClientException exception) {
        InnerPopupFactory.showErrorDialog((Exception)((Object)exception), (Component)this);
    }

    private class Layouter
    extends DefaultLayout {
        private Layouter() {
        }

        @Override
        public void layoutContainer(Container parent) {
            UserNamePasswordPanel.this.field1.setLocation(10, 10);
            UserNamePasswordPanel.this.field1.setSize(parent.getWidth() - 20, (int)UserNamePasswordPanel.this.field1.getPreferredSize().getHeight());
            UserNamePasswordPanel.this.field2.setLocation(10, UserNamePasswordPanel.this.field1.getY() + UserNamePasswordPanel.this.field1.getHeight() + 10);
            UserNamePasswordPanel.this.field2.setSize(UserNamePasswordPanel.this.field1.getSize());
            UserNamePasswordPanel.this.field3.setLocation(10, UserNamePasswordPanel.this.field2.getY() + UserNamePasswordPanel.this.field2.getHeight() + 10);
            UserNamePasswordPanel.this.field3.setSize(UserNamePasswordPanel.this.field2.getSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = 10;
            h = (int)((double)h + UserNamePasswordPanel.this.field1.getPreferredSize().getHeight() * 3.0);
            return new Dimension(0, h += 30);
        }
    }
}

