/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.popup.inserts;

import ch.icit.pegasus.client.converter.PriceConverter3;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.formatter.FormatterRegistry;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.node.impls.EmbeddedDTONode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;

public class EditPricePopupInsert
extends PopUpInsert {
    private static final long serialVersionUID = 1L;
    private TitledItem<TextLabel> oldAmount;
    private TitledItem<InputComboBox> newAmount;
    private final Node<PriceComplete> node;
    private final Node<PriceComplete> newOne;

    public EditPricePopupInsert(Node<PriceComplete> node) {
        this.node = node;
        this.newOne = new EmbeddedDTONode();
        if (node.getValue() == null) {
            SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            PriceComplete p = new PriceComplete(s.getCurrency(), Double.valueOf(0.0));
            p.setClientOId(Long.valueOf(p.getNextId()));
            node.setValue((Object)p, 0L);
            node.updateNode();
        }
        this.newOne.setValue((Object)new PriceComplete(((PriceComplete)node.getValue()).getCurrency(), ((PriceComplete)node.getValue()).getPrice()), 0L);
        this.oldAmount = new TitledItem<TextLabel>(new TextLabel(((PriceConverter3)ConverterRegistry.getConverter(PriceConverter3.class)).convert(node.getValue(PriceComplete.class), null, new Object[0])), "Old Price", TitledItem.TitledItemOrientation.NORTH);
        this.newAmount = new TitledItem<InputComboBox>(new InputComboBox(null, null, FormatterRegistry.getDecimalFormat(Words.EXTENDED_PRICE_PATTERN), InputComboBox.InputComboBoxType.PRICE_DOUBLE), "New Price", TitledItem.TitledItemOrientation.NORTH);
        this.newAmount.getElement().setMaxKommaStellen(3);
        this.newAmount.getElement().allowMinus(false);
        this.newAmount.getElement().setNode(this.newOne.getChildNamed(new String[]{"price"}), this.newOne.getChildNamed(new String[]{"currency"}));
        this.setLayout(new Layout());
        this.add(this.oldAmount);
        this.add(this.newAmount);
    }

    @Override
    public boolean tryToGrabFocus() {
        return true;
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> a = this.newAmount.getFocusComponents();
        return a;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            return null;
        }
        this.node.getChildNamed(new String[]{"price"}).setValue(this.newOne.getChildNamed(new String[]{"price"}).getValue(), 0L);
        Object[] o = new Object[]{this.node};
        return o;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.newAmount.kill();
        this.oldAmount.kill();
        this.newAmount = null;
        this.oldAmount = null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int w = (int)EditPricePopupInsert.this.newAmount.getPreferredSize().getWidth();
            int h = (int)EditPricePopupInsert.this.oldAmount.getPreferredSize().getHeight();
            h += 5;
            h = (int)((double)h + EditPricePopupInsert.this.newAmount.getPreferredSize().getHeight());
            return new Dimension(w, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            EditPricePopupInsert.this.oldAmount.setLocation(0, 0);
            EditPricePopupInsert.this.oldAmount.setSize(EditPricePopupInsert.this.oldAmount.getPreferredSize());
            EditPricePopupInsert.this.newAmount.setLocation(0, EditPricePopupInsert.this.oldAmount.getY() + EditPricePopupInsert.this.oldAmount.getHeight() + 5);
            EditPricePopupInsert.this.newAmount.setSize(EditPricePopupInsert.this.newAmount.getPreferredSize());
        }
    }
}

