/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.popup.inserts;

import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.MultiLineTextLabel;
import ch.icit.pegasus.client.gui.utils.ScrollPane;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.icons.impl.CheckBoxRO;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.popup.inserts.EnterMessagePopupInsert;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.toolkits.ArticleToolkit;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.haccp.PurchaseOrderPositionHACCPLogComplete;
import ch.icit.pegasus.server.core.dtos.ordering.haccp.PurchaseOrderPositionHACCPLogComplete_;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeLight;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeReference;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.StringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class HACCPCheckPopUpInsert
extends PopUpInsert
implements RemoteLoader {
    private static final long serialVersionUID = 1L;
    private final BasicArticleLight article;
    private final PurchaseOrderPositionComplete position;
    private final boolean fromReceiveModule;
    private ParameterObject parameterObject;
    private ScrollPane scrollPane;
    private JComponent viewPort;
    private Color backgroundColor;
    protected MultiLineTextLabel label;
    private TextLabel articleConfiguration;
    private HorizontalSeparator sep1;
    private LoadingAnimation loadingAnimation;
    private TitledItem<TextField> chargeNo;
    private TitledItem<CheckBox> truckOk;
    private TitledItem<CheckBoxRO> chilled;
    private TitledItem<CheckBoxRO> frozen;
    private TitledItem<CheckBox> qualityCondition;
    private TitledItem<TextField> temperature;
    private TitledItem<CheckBoxRO> halalState;
    private TitledItem<TextField> noExpiryDate;
    private TitledItem<DateChooser> expiryDate;
    private TextButton stateOk;
    private TextButton stateNotOk;

    public HACCPCheckPopUpInsert(BasicArticleLight article, PurchaseOrderPositionComplete position, String text, ParameterObject parameterObject, boolean fromReceiveModule) {
        this.article = article;
        this.position = position;
        this.fromReceiveModule = fromReceiveModule;
        this.initLayout();
        this.initMultiLabelThings(text, parameterObject);
    }

    private void doSaveHACCPSpotCheck() {
        this.stateNotOk.fadeOut(true);
        this.stateOk.fadeOut(true);
        this.articleConfiguration.fadeOut(true);
        this.sep1.fadeOut(true);
        this.chargeNo.fadeOut(true);
        this.truckOk.fadeOut(true);
        this.chilled.fadeOut(true);
        this.frozen.fadeOut(true);
        this.qualityCondition.fadeOut(true);
        this.temperature.fadeOut(true);
        this.halalState.fadeOut(true);
        if (this.expiryDate != null) {
            this.expiryDate.fadeOut(true);
        }
        if (this.noExpiryDate != null) {
            this.noExpiryDate.fadeOut(true);
        }
        if (this.fromReceiveModule) {
            this.popup.enableOKButton(true);
            this.label.setText("HACCP Check done");
            return;
        }
        this.ensureAnimation("Save HACCP Check");
        this.loadingAnimation.fadeIn();
        this.popup.enableOKButton(false);
        this.saveData();
    }

    protected void ensureAnimation(String current) {
        if (this.loadingAnimation == null) {
            this.loadingAnimation = new LoadingAnimation();
            this.loadingAnimation.stateChanged(current);
            this.viewPort.add(this.loadingAnimation);
            this.loadingAnimation.start();
            this.loadingAnimation.fadeIn();
        }
        if (this.label != null) {
            this.label.fadeOut(false);
        }
    }

    private boolean checkChargeNumber() {
        String articleNumber;
        String value = (String)this.parameterObject.chargeNo.getValue();
        if (this.article.getName().equals(value)) {
            this.chargeNo.getElement().setInvalid();
            return false;
        }
        if (("" + this.article.getNumber()).equals(value)) {
            this.chargeNo.getElement().setInvalid();
            return false;
        }
        if (this.position != null && (articleNumber = this.position.getSupplierCondition().getArticleNumber()).equals(value)) {
            this.chargeNo.getElement().setInvalid();
            return false;
        }
        return true;
    }

    protected void hideAnimation() {
        if (this.loadingAnimation != null) {
            this.loadingAnimation.stop();
            this.loadingAnimation.fadeOut(true);
            this.loadingAnimation = null;
        }
        if (this.label != null) {
            this.label.fadeIn();
        }
    }

    private void initLayout() {
        this.setOpaque(false);
        this.setLayout(new InnerLayout());
    }

    private void initMultiLabelThings(String text, ParameterObject parameterObject) {
        this.parameterObject = parameterObject;
        this.label = new MultiLineTextLabel();
        this.label.getFader().setPermanent(true);
        this.backgroundColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("innerpopup_extension_background"));
        this.scrollPane = new ScrollPane();
        this.scrollPane.setScrollPaneBackground(this.backgroundColor);
        this.viewPort = new Port();
        this.viewPort.setLayout(new ViewPortLayout());
        this.articleConfiguration = new TextLabel(Words.ARTICLE + " " + Words.CONFIGURATION);
        this.sep1 = new HorizontalSeparator();
        this.chargeNo = new TitledItem<TextField>(new TextField(), "ChargeNo", TitledItem.TitledItemOrientation.WEST);
        this.chargeNo.getElement().setNode((Node)parameterObject.chargeNo);
        this.truckOk = new TitledItem<CheckBox>(new CheckBox(), "Truck Ok", TitledItem.TitledItemOrientation.WEST);
        this.truckOk.getElement().setNode(parameterObject.truckOk);
        this.chilled = new TitledItem<CheckBoxRO>(new CheckBoxRO(), "Chilled", TitledItem.TitledItemOrientation.WEST);
        this.chilled.getElement().setNode(parameterObject.chilledState);
        this.frozen = new TitledItem<CheckBoxRO>(new CheckBoxRO(), "Frozen", TitledItem.TitledItemOrientation.WEST);
        this.frozen.getElement().setNode(parameterObject.frozenState);
        this.qualityCondition = new TitledItem<CheckBox>(new CheckBox(), "Quality", TitledItem.TitledItemOrientation.WEST);
        this.qualityCondition.getElement().setNode(parameterObject.qualityCondition);
        this.temperature = new TitledItem<TextField>(new TextField(null, TextFieldType.DOUBLE), "Temperature [\u00b0C]", TitledItem.TitledItemOrientation.WEST);
        this.temperature.getElement().setNode((Node)parameterObject.temperature);
        boolean frozenArticle = ArticleToolkit.isFrozenArticle(this.article);
        boolean chilledArticle = ArticleToolkit.isChilledArticle(this.article);
        this.temperature.setEnabled(frozenArticle || chilledArticle);
        this.halalState = new TitledItem<CheckBoxRO>(new CheckBoxRO(), "Halal", TitledItem.TitledItemOrientation.WEST);
        this.halalState.getElement().setNode(parameterObject.halalState);
        if (Boolean.TRUE.equals(parameterObject.noExpiryDate.getValue())) {
            this.noExpiryDate = new TitledItem<TextField>(new TextField(), "Expiry Text", TitledItem.TitledItemOrientation.WEST);
            this.noExpiryDate.getElement().setNode((Node)parameterObject.expiryText);
        } else {
            this.expiryDate = new TitledItem<DateChooser>(new DateChooser(), "Expiry Date", TitledItem.TitledItemOrientation.WEST);
            this.expiryDate.getElement().setNode((Node)parameterObject.expiryDate);
        }
        this.stateOk = new TextButton("Ok");
        this.stateNotOk = new TextButton("Not Ok");
        this.stateOk.addButtonListener((source, x, y) -> {
            if (!this.checkChargeNumber()) {
                InnerPopupFactory.showErrorDialog("Review Charge Number. Article Number, Name and Supplier Article Numbers are not allowed", (Component)this);
                return;
            }
            if (!this.validateBeforeSaveData()) {
                return;
            }
            parameterObject.okState.setValue((Object)true, 0L);
            parameterObject.spotCheckDone.setValue((Object)true, 0L);
            this.doSaveHACCPSpotCheck();
        });
        this.stateNotOk.addButtonListener((source, x, y) -> {
            if (!this.checkChargeNumber()) {
                InnerPopupFactory.showErrorDialog("Review Charge Number. Article Number, Name and Supplier Article Numbers are not allowed", (Component)this);
                return;
            }
            if (!this.validateBeforeSaveData()) {
                return;
            }
            InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
            popUp.setAttributes(source, true, true, "HACCP deviation comment");
            Node node = new Node();
            popUp.setView(new EnterMessagePopupInsert(node));
            InnerPopUpListener2 listener2 = (source1, xargs) -> {
                if (xargs != null) {
                    parameterObject.spotCheckDone.setValue((Object)true, 0L);
                    parameterObject.okState.setValue((Object)false, 0L);
                    parameterObject.comment.setValue(node.getValue(), 0L);
                    this.doSaveHACCPSpotCheck();
                }
            };
            popUp.showPopUp(x, y, 400, 400, listener2, source, PopupType.NORMAL);
        });
        int width = (int)this.temperature.getTitle().getPreferredSize().getWidth();
        this.chargeNo.setColumnWidth(width += 10);
        this.truckOk.setColumnWidth(width);
        this.qualityCondition.setColumnWidth(width);
        this.temperature.setColumnWidth(width);
        this.halalState.setColumnWidth(width);
        if (this.expiryDate != null) {
            this.expiryDate.setColumnWidth(width);
        }
        if (this.noExpiryDate != null) {
            this.noExpiryDate.setColumnWidth(width);
        }
        this.chilled.setColumnWidth(width);
        this.frozen.setColumnWidth(width);
        this.setText(text);
        this.viewPort.add(this.label);
        this.viewPort.add(this.articleConfiguration);
        this.viewPort.add(this.sep1);
        this.viewPort.add(this.chargeNo);
        this.viewPort.add(this.truckOk);
        this.viewPort.add(this.qualityCondition);
        this.viewPort.add(this.temperature);
        this.viewPort.add(this.halalState);
        if (this.expiryDate != null) {
            this.viewPort.add(this.expiryDate);
        }
        if (this.noExpiryDate != null) {
            this.viewPort.add(this.noExpiryDate);
        }
        this.viewPort.add(this.chilled);
        this.viewPort.add(this.frozen);
        this.viewPort.add(this.stateNotOk);
        this.viewPort.add(this.stateOk);
        this.scrollPane.setViewportView(this.viewPort);
        this.add(this.scrollPane);
        this.invalidate();
        this.validate();
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.label != null) {
            this.label.kill();
            this.label = null;
        }
        if (this.loadingAnimation != null) {
            this.loadingAnimation.stop();
            this.loadingAnimation.kill();
            this.loadingAnimation = null;
        }
        if (this.articleConfiguration != null) {
            this.articleConfiguration.kill();
            this.articleConfiguration = null;
        }
        if (this.sep1 != null) {
            this.sep1.kill();
            this.sep1 = null;
        }
        if (this.chargeNo != null) {
            this.chargeNo.kill();
            this.chargeNo = null;
        }
        if (this.truckOk != null) {
            this.truckOk.kill();
            this.truckOk = null;
        }
        if (this.qualityCondition != null) {
            this.qualityCondition.kill();
            this.qualityCondition = null;
        }
        if (this.temperature != null) {
            this.temperature.kill();
            this.temperature = null;
        }
        if (this.halalState != null) {
            this.halalState.kill();
            this.halalState = null;
        }
        if (this.expiryDate != null) {
            this.expiryDate.kill();
            this.expiryDate = null;
        }
        if (this.noExpiryDate != null) {
            this.noExpiryDate.kill();
            this.noExpiryDate = null;
        }
        if (this.chilled != null) {
            this.chilled.kill();
            this.chilled = null;
        }
        if (this.frozen != null) {
            this.frozen.kill();
            this.frozen = null;
        }
    }

    public void setText(String t) {
        if (this.label != null) {
            this.label.setLabelText(t);
        }
    }

    public String getText() {
        if (this.label != null) {
            return this.label.getText();
        }
        return "";
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.OK_FOREGROUND) {
            return new Object[1];
        }
        return null;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return false;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getLayout().preferredLayoutSize(this);
    }

    @Override
    public boolean tryToGrabFocus() {
        return false;
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    private boolean validateBeforeSaveData() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        String chargeText = this.chargeNo.getElement().getText();
        String tempText = this.temperature.getElement().getText();
        if (StringUtil.isBlank((String)chargeText)) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure Charge is set"));
        }
        boolean chilledArticle = ArticleToolkit.isChilledArticle(this.article);
        boolean frozenArticle = ArticleToolkit.isFrozenArticle(this.article);
        if (chilledArticle || frozenArticle) {
            if (StringUtil.isBlank((String)tempText)) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure Temperature is set"));
            } else {
                try {
                    Double.valueOf(tempText);
                }
                catch (Exception e) {
                    validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure Temperature is a number"));
                }
            }
        }
        if (validationObjects.isEmpty()) {
            return true;
        }
        InnerPopupFactory.showErrorDialog(validationObjects, "Ensure HACCP Check is complete", (Component)this);
        return false;
    }

    private void saveData() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                PurchaseOrderPositionHACCPLogComplete dto = HACCPCheckPopUpInsert.this.parameterObject.getDTO();
                ((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).saveHACCPCheck(new ArticleChargeReference(((ArticleChargeLight)((HACCPCheckPopUpInsert)HACCPCheckPopUpInsert.this).parameterObject.charge.getValue()).getId()), dto);
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        HACCPCheckPopUpInsert.this.hideAnimation();
                        HACCPCheckPopUpInsert.this.popup.enableOKButton(true);
                        HACCPCheckPopUpInsert.this.label.setText("HACCP Check saved");
                    }

                    public void errorOccurred(ClientException exception) {
                        HACCPCheckPopUpInsert.this.hideAnimation();
                        HACCPCheckPopUpInsert.this.popup.enableOKButton(true);
                        HACCPCheckPopUpInsert.this.label.setText("HACCP Check not saved");
                        InnerPopupFactory.showErrorDialog((Exception)((Object)exception), (Component)HACCPCheckPopUpInsert.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private class ViewPortLayout
    extends DefaultLayout {
        private ViewPortLayout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int w = (int)((double)HACCPCheckPopUpInsert.this.scrollPane.getWidth() - HACCPCheckPopUpInsert.this.scrollPane.getVerticalScrollBar().getPreferredSize().getWidth());
            int h = (int)HACCPCheckPopUpInsert.this.label.getPreferredSize().getHeight() + HACCPCheckPopUpInsert.this.border;
            h = (int)((double)h + (HACCPCheckPopUpInsert.this.articleConfiguration.getPreferredSize().getHeight() + (double)HACCPCheckPopUpInsert.this.border));
            h = (int)((double)h + (HACCPCheckPopUpInsert.this.chilled.getPreferredSize().getHeight() + (double)(HACCPCheckPopUpInsert.this.border / 2)));
            h = (int)((double)h + (HACCPCheckPopUpInsert.this.frozen.getPreferredSize().getHeight() + (double)(HACCPCheckPopUpInsert.this.border / 2)));
            h = (int)((double)h + (HACCPCheckPopUpInsert.this.halalState.getPreferredSize().getHeight() + (double)HACCPCheckPopUpInsert.this.border));
            h = (int)((double)h + (HACCPCheckPopUpInsert.this.sep1.getPreferredSize().getHeight() + (double)HACCPCheckPopUpInsert.this.border));
            h = (int)((double)h + (HACCPCheckPopUpInsert.this.chargeNo.getPreferredSize().getHeight() + (double)(HACCPCheckPopUpInsert.this.border / 2)));
            h = (int)((double)h + (HACCPCheckPopUpInsert.this.truckOk.getPreferredSize().getHeight() + (double)(HACCPCheckPopUpInsert.this.border / 2)));
            h = (int)((double)h + (HACCPCheckPopUpInsert.this.qualityCondition.getPreferredSize().getHeight() + (double)(HACCPCheckPopUpInsert.this.border / 2)));
            h = (int)((double)h + (HACCPCheckPopUpInsert.this.temperature.getPreferredSize().getHeight() + (double)(HACCPCheckPopUpInsert.this.border / 2)));
            if (HACCPCheckPopUpInsert.this.expiryDate != null) {
                h = (int)((double)h + (HACCPCheckPopUpInsert.this.expiryDate.getPreferredSize().getHeight() + (double)HACCPCheckPopUpInsert.this.border));
            }
            if (HACCPCheckPopUpInsert.this.noExpiryDate != null) {
                h = (int)((double)h + (HACCPCheckPopUpInsert.this.noExpiryDate.getPreferredSize().getHeight() + (double)HACCPCheckPopUpInsert.this.border));
            }
            h = (int)((double)h + (HACCPCheckPopUpInsert.this.stateOk.getPreferredSize().getHeight() + (double)HACCPCheckPopUpInsert.this.border));
            if (HACCPCheckPopUpInsert.this.loadingAnimation != null && (double)h < HACCPCheckPopUpInsert.this.loadingAnimation.getPreferredSize().getHeight()) {
                h = (int)HACCPCheckPopUpInsert.this.loadingAnimation.getPreferredSize().getHeight();
            }
            return new Dimension(w, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            HACCPCheckPopUpInsert.this.label.setLocation(0, 0);
            HACCPCheckPopUpInsert.this.label.setSize(parent.getWidth(), (int)HACCPCheckPopUpInsert.this.label.getPreferredSize().getHeight());
            if (HACCPCheckPopUpInsert.this.loadingAnimation != null) {
                HACCPCheckPopUpInsert.this.loadingAnimation.setSize(HACCPCheckPopUpInsert.this.loadingAnimation.getPreferredSize());
                HACCPCheckPopUpInsert.this.loadingAnimation.setLocation((parent.getWidth() - HACCPCheckPopUpInsert.this.loadingAnimation.getWidth()) / 2, (parent.getHeight() - HACCPCheckPopUpInsert.this.loadingAnimation.getHeight()) / 2);
            } else {
                HACCPCheckPopUpInsert.this.articleConfiguration.setLocation(HACCPCheckPopUpInsert.this.border, HACCPCheckPopUpInsert.this.label.getY() + HACCPCheckPopUpInsert.this.label.getHeight() + HACCPCheckPopUpInsert.this.border);
                HACCPCheckPopUpInsert.this.articleConfiguration.setSize(parent.getWidth() - 2 * HACCPCheckPopUpInsert.this.border, (int)HACCPCheckPopUpInsert.this.articleConfiguration.getPreferredSize().getHeight());
                HACCPCheckPopUpInsert.this.chilled.setLocation(HACCPCheckPopUpInsert.this.border, HACCPCheckPopUpInsert.this.articleConfiguration.getY() + HACCPCheckPopUpInsert.this.articleConfiguration.getHeight() + HACCPCheckPopUpInsert.this.border / 2);
                HACCPCheckPopUpInsert.this.chilled.setSize(parent.getWidth() - 2 * HACCPCheckPopUpInsert.this.border, (int)HACCPCheckPopUpInsert.this.chilled.getPreferredSize().getHeight());
                HACCPCheckPopUpInsert.this.frozen.setLocation(HACCPCheckPopUpInsert.this.border, HACCPCheckPopUpInsert.this.chilled.getY() + HACCPCheckPopUpInsert.this.chilled.getHeight() + HACCPCheckPopUpInsert.this.border / 2);
                HACCPCheckPopUpInsert.this.frozen.setSize(parent.getWidth() - 2 * HACCPCheckPopUpInsert.this.border, (int)HACCPCheckPopUpInsert.this.frozen.getPreferredSize().getHeight());
                HACCPCheckPopUpInsert.this.halalState.setLocation(HACCPCheckPopUpInsert.this.border, HACCPCheckPopUpInsert.this.frozen.getY() + HACCPCheckPopUpInsert.this.frozen.getHeight() + HACCPCheckPopUpInsert.this.border / 2);
                HACCPCheckPopUpInsert.this.halalState.setSize(parent.getWidth() - 2 * HACCPCheckPopUpInsert.this.border, (int)HACCPCheckPopUpInsert.this.halalState.getPreferredSize().getHeight());
                HACCPCheckPopUpInsert.this.sep1.setLocation(HACCPCheckPopUpInsert.this.border, HACCPCheckPopUpInsert.this.halalState.getY() + HACCPCheckPopUpInsert.this.halalState.getHeight() + HACCPCheckPopUpInsert.this.border);
                HACCPCheckPopUpInsert.this.sep1.setSize(parent.getWidth() - 2 * HACCPCheckPopUpInsert.this.border, (int)HACCPCheckPopUpInsert.this.sep1.getPreferredSize().getHeight());
                HACCPCheckPopUpInsert.this.chargeNo.setLocation(HACCPCheckPopUpInsert.this.border, HACCPCheckPopUpInsert.this.sep1.getY() + HACCPCheckPopUpInsert.this.sep1.getHeight() + HACCPCheckPopUpInsert.this.border);
                HACCPCheckPopUpInsert.this.chargeNo.setSize(parent.getWidth() - 2 * HACCPCheckPopUpInsert.this.border, (int)HACCPCheckPopUpInsert.this.chargeNo.getPreferredSize().getHeight());
                HACCPCheckPopUpInsert.this.truckOk.setLocation(HACCPCheckPopUpInsert.this.border, HACCPCheckPopUpInsert.this.chargeNo.getY() + HACCPCheckPopUpInsert.this.chargeNo.getHeight() + HACCPCheckPopUpInsert.this.border / 2);
                HACCPCheckPopUpInsert.this.truckOk.setSize(parent.getWidth() - 2 * HACCPCheckPopUpInsert.this.border, (int)HACCPCheckPopUpInsert.this.truckOk.getPreferredSize().getHeight());
                HACCPCheckPopUpInsert.this.qualityCondition.setLocation(HACCPCheckPopUpInsert.this.border, HACCPCheckPopUpInsert.this.truckOk.getY() + HACCPCheckPopUpInsert.this.truckOk.getHeight() + HACCPCheckPopUpInsert.this.border / 2);
                HACCPCheckPopUpInsert.this.qualityCondition.setSize(parent.getWidth() - 2 * HACCPCheckPopUpInsert.this.border, (int)HACCPCheckPopUpInsert.this.qualityCondition.getPreferredSize().getHeight());
                HACCPCheckPopUpInsert.this.temperature.setLocation(HACCPCheckPopUpInsert.this.border, HACCPCheckPopUpInsert.this.qualityCondition.getY() + HACCPCheckPopUpInsert.this.qualityCondition.getHeight() + HACCPCheckPopUpInsert.this.border / 2);
                HACCPCheckPopUpInsert.this.temperature.setSize(parent.getWidth() - 2 * HACCPCheckPopUpInsert.this.border, (int)HACCPCheckPopUpInsert.this.temperature.getPreferredSize().getHeight());
                int currentY = 0;
                if (HACCPCheckPopUpInsert.this.expiryDate != null) {
                    HACCPCheckPopUpInsert.this.expiryDate.setLocation(HACCPCheckPopUpInsert.this.border, HACCPCheckPopUpInsert.this.temperature.getY() + HACCPCheckPopUpInsert.this.temperature.getHeight() + HACCPCheckPopUpInsert.this.border / 2);
                    HACCPCheckPopUpInsert.this.expiryDate.setSize(parent.getWidth() - 2 * HACCPCheckPopUpInsert.this.border, (int)HACCPCheckPopUpInsert.this.expiryDate.getPreferredSize().getHeight());
                    currentY = HACCPCheckPopUpInsert.this.expiryDate.getY() + HACCPCheckPopUpInsert.this.expiryDate.getHeight();
                } else {
                    HACCPCheckPopUpInsert.this.noExpiryDate.setLocation(HACCPCheckPopUpInsert.this.border, HACCPCheckPopUpInsert.this.temperature.getY() + HACCPCheckPopUpInsert.this.temperature.getHeight() + HACCPCheckPopUpInsert.this.border / 2);
                    HACCPCheckPopUpInsert.this.noExpiryDate.setSize(parent.getWidth() - 2 * HACCPCheckPopUpInsert.this.border, (int)HACCPCheckPopUpInsert.this.noExpiryDate.getPreferredSize().getHeight());
                    currentY = HACCPCheckPopUpInsert.this.noExpiryDate.getY() + HACCPCheckPopUpInsert.this.noExpiryDate.getHeight();
                }
                if (HACCPCheckPopUpInsert.this.stateOk != null && HACCPCheckPopUpInsert.this.stateOk.getFader() != null && HACCPCheckPopUpInsert.this.stateOk.getFader().isFaded()) {
                    HACCPCheckPopUpInsert.this.stateOk.setLocation(5, currentY + HACCPCheckPopUpInsert.this.border);
                    HACCPCheckPopUpInsert.this.stateOk.setSize(HACCPCheckPopUpInsert.this.stateOk.getPreferredSize());
                }
                if (HACCPCheckPopUpInsert.this.stateNotOk != null && HACCPCheckPopUpInsert.this.stateNotOk.getFader() != null && HACCPCheckPopUpInsert.this.stateNotOk.getFader().isFaded()) {
                    HACCPCheckPopUpInsert.this.stateNotOk.setLocation((int)((double)parent.getWidth() - (5.0 + HACCPCheckPopUpInsert.this.stateNotOk.getPreferredSize().getWidth())), currentY + HACCPCheckPopUpInsert.this.border);
                    HACCPCheckPopUpInsert.this.stateNotOk.setSize(HACCPCheckPopUpInsert.this.stateNotOk.getPreferredSize());
                }
            }
        }
    }

    private class Port
    extends JComponent {
        private static final long serialVersionUID = 1L;

        private Port() {
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(HACCPCheckPopUpInsert.this.backgroundColor);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.paintChildren(g2);
        }
    }

    private class InnerLayout
    extends DefaultLayout {
        private InnerLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            if (HACCPCheckPopUpInsert.this.loadingAnimation != null) {
                HACCPCheckPopUpInsert.this.loadingAnimation.setLocation((int)((double)parent.getWidth() - HACCPCheckPopUpInsert.this.loadingAnimation.getPreferredSize().getWidth()) / 2, (int)(((double)parent.getHeight() - HACCPCheckPopUpInsert.this.loadingAnimation.getPreferredSize().getHeight()) / 2.0));
                HACCPCheckPopUpInsert.this.loadingAnimation.setSize(HACCPCheckPopUpInsert.this.loadingAnimation.getPreferredSize());
            }
            if (HACCPCheckPopUpInsert.this.scrollPane != null) {
                HACCPCheckPopUpInsert.this.scrollPane.setLocation(0, 0);
                HACCPCheckPopUpInsert.this.scrollPane.setSize(parent.getSize());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension d = new Dimension();
            if (HACCPCheckPopUpInsert.this.userPrefHeight != null) {
                d.setSize(d.getWidth(), (double)HACCPCheckPopUpInsert.this.userPrefHeight.intValue());
            } else if (HACCPCheckPopUpInsert.this.viewPort != null) {
                d.setSize(d.getWidth(), HACCPCheckPopUpInsert.this.viewPort.getPreferredSize().getHeight());
            } else {
                d.setSize(d.getWidth(), (double)(HACCPCheckPopUpInsert.this.loadingAnimation.getHeight() + 10));
            }
            if (HACCPCheckPopUpInsert.this.userPrefWidth != null) {
                d.setSize((double)HACCPCheckPopUpInsert.this.userPrefWidth.intValue(), d.getHeight());
            } else if (HACCPCheckPopUpInsert.this.viewPort != null) {
                d.setSize(HACCPCheckPopUpInsert.this.viewPort.getPreferredSize().getWidth(), d.getHeight());
            } else {
                d.setSize(HACCPCheckPopUpInsert.this.loadingAnimation.getPreferredSize().getWidth() + 10.0, d.getHeight());
            }
            return d;
        }
    }

    public static class ParameterObject {
        public Node<String> chargeNo = new Node();
        public Node<String> truckType = new Node();
        public Node<Boolean> truckOk = new Node();
        public Node<Boolean> chilledState = new Node();
        public Node<Boolean> frozenState = new Node();
        public Node<Boolean> qualityCondition = new Node();
        public Node<Double> temperature = new Node();
        public Node<Boolean> halalState = new Node();
        public Node<Date> expiryDate = new Node();
        public Node<Boolean> noExpiryDate = new Node();
        public Node<String> expiryText = new Node();
        public Node<Boolean> okState = new Node();
        public Node<String> comment = new Node();
        public Node<Boolean> spotCheckDone = new Node();
        public Node<ArticleChargeLight> charge = new Node();

        public ParameterObject(String chargeNo, String truckType, Boolean truckOk, Boolean chilledState, Boolean frozenState, Boolean qualityCondition, Double temperature, Boolean halalState, Date expiryDate, Boolean okState, String comment, ArticleChargeLight charge, boolean noExpiryDate, String noExpiryText) {
            this.halalState.setValue((Object)halalState, 0L);
            this.chilledState.setValue((Object)chilledState, 0L);
            this.frozenState.setValue((Object)frozenState, 0L);
            this.truckType.setValue((Object)truckType, 0L);
            this.chargeNo.setValue((Object)chargeNo, 0L);
            this.truckOk.setValue((Object)truckOk, 0L);
            this.qualityCondition.setValue((Object)qualityCondition, 0L);
            this.temperature.setValue((Object)temperature, 0L);
            this.expiryDate.setValue((Object)expiryDate, 0L);
            this.okState.setValue((Object)okState, 0L);
            this.comment.setValue((Object)comment, 0L);
            this.spotCheckDone.setValue((Object)false, 0L);
            this.noExpiryDate.setValue((Object)noExpiryDate, 0L);
            this.expiryText.setValue((Object)noExpiryText, 0L);
        }

        public ParameterObject(PurchaseOrderPositionHACCPLogComplete haccpLog, ArticleChargeLight charge) {
            Node logNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)haccpLog, false, false);
            this.chargeNo = logNode.getChildNamed(PurchaseOrderPositionHACCPLogComplete_.chargeNo);
            this.truckType = logNode.getChildNamed(PurchaseOrderPositionHACCPLogComplete_.truckType);
            this.truckOk = logNode.getChildNamed(PurchaseOrderPositionHACCPLogComplete_.truckOk);
            this.chilledState = logNode.getChildNamed(PurchaseOrderPositionHACCPLogComplete_.chilledState);
            this.frozenState = logNode.getChildNamed(PurchaseOrderPositionHACCPLogComplete_.frozenState);
            this.qualityCondition = logNode.getChildNamed(PurchaseOrderPositionHACCPLogComplete_.qualityCondition);
            this.temperature = logNode.getChildNamed(PurchaseOrderPositionHACCPLogComplete_.temperature);
            this.halalState = logNode.getChildNamed(PurchaseOrderPositionHACCPLogComplete_.halalState);
            this.expiryDate = logNode.getChildNamed(PurchaseOrderPositionHACCPLogComplete_.expiryDate);
            this.okState = logNode.getChildNamed(PurchaseOrderPositionHACCPLogComplete_.okState);
            this.comment = logNode.getChildNamed(PurchaseOrderPositionHACCPLogComplete_.comment);
            this.charge = INodeCreator.getDefaultImpl().getNode4DTO((Object)charge, false, false);
            this.noExpiryDate = logNode.getChildNamed(PurchaseOrderPositionHACCPLogComplete_.noExpiryDate);
            this.expiryText = logNode.getChildNamed(PurchaseOrderPositionHACCPLogComplete_.expiryText);
        }

        public PurchaseOrderPositionHACCPLogComplete getDTO() {
            PurchaseOrderPositionHACCPLogComplete log = new PurchaseOrderPositionHACCPLogComplete();
            log.setChargeNo((String)this.chargeNo.getValue());
            log.setComment((String)this.comment.getValue());
            log.setExpiryDate((Date)this.expiryDate.getValue());
            log.setHalalState((Boolean)this.halalState.getValue());
            log.setOkState((Boolean)this.okState.getValue());
            log.setQualityCondition((Boolean)this.qualityCondition.getValue());
            log.setTemperature((Double)this.temperature.getValue());
            log.setTruckOk((Boolean)this.truckOk.getValue());
            log.setTruckType((String)this.truckType.getValue());
            log.setChilledState((Boolean)this.chilledState.getValue());
            log.setFrozenState((Boolean)this.frozenState.getValue());
            log.setNoExpiryDate((Boolean)this.noExpiryDate.getValue());
            log.setExpiryText((String)this.expiryText.getValue());
            log.setCheckDate(new Date(System.currentTimeMillis()));
            log.setUser((UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
            return log;
        }
    }
}

