/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.popup.inserts;

import ch.icit.pegasus.client.converter.TransportCostTypeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.TransportCostTypeComplete;
import ch.icit.pegasus.server.core.dtos.ordering.TransportCostComplete;
import ch.icit.pegasus.server.core.dtos.ordering.TransportCostComplete_;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class TransportCostsPopup
extends PopUpInsert {
    private static final long serialVersionUID = 1L;
    private Table2 table;
    private boolean isEditable = true;

    public TransportCostsPopup(Node docs, RDProvider provider, boolean isEditable) {
        this(docs, provider, isEditable, "documents");
    }

    public TransportCostsPopup(Node docs, RDProvider provider, boolean isEditable, String overrideName) {
        this.isEditable = isEditable;
        this.table = new Table2(isEditable, "Add", false, false);
        this.table.setOverrideName(overrideName);
        this.table.setProvider(provider);
        this.table.setUseWriteAccessRight(true);
        this.table.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                TransportCostsPopup.this.table.validate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                List t = (List)NodeToolkit.getAffixList(TransportCostTypeComplete.class).getValue();
                SystemSettingsComplete value = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                TransportCostComplete d = new TransportCostComplete();
                if (!t.isEmpty()) {
                    d.setTransportCostType((TransportCostTypeComplete)t.get(0));
                }
                d.setCosts(new PriceComplete(value.getCurrency(), Double.valueOf(0.0)));
                d.setClientOId(Long.valueOf(ADTO.getNextId()));
                Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)d, true, false);
                TransportCostsPopup.this.table.getModel().getNode().addChild(n, System.currentTimeMillis());
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo("TRANSPORT TYPE", null, null, null, "", 40, 40, 40));
        columns.add(new TableColumnInfo("PRICE", null, null, null, "", 30, 30, 30));
        int tw = 2 * this.table.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        this.table.setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
        this.table.setProgress(1.0f);
        this.table.getModel().setNode(docs);
        this.setLayout(new Layout());
        this.add(this.table);
    }

    @Override
    public boolean tryToGrabFocus() {
        return false;
    }

    @Override
    public List<Component> getFocusComponents() {
        return this.table.getFocusComponents();
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            return null;
        }
        return new Object[1];
    }

    @Override
    public boolean isInnerComponent(Component c) {
        for (Table2RowPanel p : this.table.getRows()) {
            TableRowImpl pp = (TableRowImpl)p;
            if (!pp.isInnerComponent(c)) continue;
            return true;
        }
        return false;
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private ComboBox type;
        private TextField price;
        private DeleteButton deleteButton;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            this.setLayout(new InnerLayout());
            this.type = new ComboBox(m.getNode().getChildNamed(TransportCostComplete_.transportCostType), NodeToolkit.getAffixList(TransportCostTypeComplete.class), ConverterRegistry.getConverter(TransportCostTypeConverter.class));
            this.price = new NumberTextField(m.getNode().getChildNamed(new DtoField[]{TransportCostComplete_.costs, PriceComplete_.price}), TextFieldType.DOUBLE);
            this.type.setProgress(1.0f);
            this.deleteButton = new DeleteButton();
            this.deleteButton.addButtonListener(this);
            this.add(this.type);
            this.add(this.price);
            this.add(this.deleteButton);
        }

        @Override
        public boolean isInnerComponent(Component c) {
            if (this.type.getCurrentPopUp() != null) {
                for (Component currentC = c; currentC != null; currentC = currentC.getParent()) {
                    if (!currentC.equals(this.type.getCurrentPopUp())) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.type);
            CheckedListAdder.addToList(a, this.price);
            CheckedListAdder.addToList(a, this.deleteButton);
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled && TransportCostsPopup.this.isEditable);
            this.type.setEnabled(isEnabled && TransportCostsPopup.this.isEditable);
            this.price.setEnabled(isEnabled && TransportCostsPopup.this.isEditable);
            this.deleteButton.setEnabled(isEnabled && TransportCostsPopup.this.isEditable);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.type.kill();
            this.price.kill();
            this.deleteButton.kill();
            this.type = null;
            this.price = null;
            this.deleteButton = null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.deleteButton) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), System.currentTimeMillis());
            }
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImpl.this.type.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.type.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.type.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.type.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.price.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.price.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.price.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.price.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.deleteButton.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.deleteButton.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.deleteButton.setSize(TableRowImpl.this.deleteButton.getPreferredSize());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(350, 450);
        }

        @Override
        public void layoutContainer(Container parent) {
            TransportCostsPopup.this.table.setLocation(0, 0);
            TransportCostsPopup.this.table.setSize(parent.getSize());
        }
    }
}

