/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.print;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;

public class Resource {
    private final String name;
    private final Type type;
    private final TargetFormat defaultFormat;
    private final Category category;

    public Resource(String name, Type type, Category category, TargetFormat format) {
        this.name = name;
        this.type = type;
        this.category = category;
        this.defaultFormat = format;
    }

    public String getPath() {
        return this.category.getPath() + this.type.getFilename(this.name);
    }

    public InputStream getInputStream() throws FileNotFoundException {
        InputStream in = Resource.getClassLoader().getResourceAsStream(this.getPath());
        if (in == null) {
            throw new FileNotFoundException(this.getPath());
        }
        return in;
    }

    public URL getURL() throws FileNotFoundException {
        URL url = Resource.getClassLoader().getResource(this.getPath());
        if (url == null) {
            throw new FileNotFoundException(this.getPath());
        }
        return url;
    }

    private static ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public String toString() {
        try {
            return this.getPath() + " -> " + this.getURL();
        }
        catch (FileNotFoundException e) {
            return this.getPath() + " - FILE DOES NOT EXIST!";
        }
    }

    public TargetFormat getFormat() {
        return this.defaultFormat;
    }

    public static enum Category {
        CLIENT("client", null),
        REPORT("report", CLIENT),
        XSL_TEMPLATES("xsl", REPORT),
        STOWAGE_REPORT("stowage", XSL_TEMPLATES),
        RECIPE_REPORT("recipe", XSL_TEMPLATES),
        PRODUCT_REPORT("product", XSL_TEMPLATES),
        ORDER_REPORT("order", XSL_TEMPLATES),
        STORE_REPORT("store", XSL_TEMPLATES),
        USER_REPORT("user", XSL_TEMPLATES),
        FLIGHT_REPORT("flight", XSL_TEMPLATES);

        private final Category parentCategory;
        private final String name;

        private Category(String name, Category parentCategory) {
            this.name = name;
            this.parentCategory = parentCategory;
        }

        String getPath() {
            if (this.parentCategory == null) {
                return this.name + "/";
            }
            return this.parentCategory.getPath() + this.name + "/";
        }
    }

    public static enum TargetFormat {
        PDF("pdf"),
        CSV("csv"),
        SVG("svg"),
        RTF("rtf");

        private final String suffix;

        private TargetFormat(String fileSuffix) {
            this.suffix = fileSuffix;
        }

        public String getSuffix() {
            return this.suffix;
        }
    }

    public static enum Type {
        XSL_STYLESHEET("xsl"),
        XML_CONFIGURATION("xml");

        private final String suffix;

        private Type(String fileSuffix) {
            this.suffix = fileSuffix;
        }

        String getFilename(String name) {
            return name + "." + this.suffix;
        }
    }
}

