/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.productionweeklyplan;

import ch.icit.pegasus.client.converter.QuantityConverter1Decimal;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.productionweeklyplan.ProductionWeeklyPlanViewTable;
import ch.icit.pegasus.client.gui.utils.productionweeklyplan.TableGenerator;
import ch.icit.pegasus.client.gui.utils.textfield.PlainTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.ListNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.production_new.UpdateConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanComplete;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanComplete_;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.JobComplete;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.ProductionJobComplete;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.ProductionJobComplete_;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DayView
implements TableGenerator {
    private final String name;
    private final ProductionWeeklyPlanViewTable.TableRowImpl tableRow;
    private final List<UpdateConfigurationComplete> counts;
    private Date selectedDate;
    private PlainTextField forecast;
    private PlainTextField produce;
    private TextLabel endStock;
    private PlainTextField waste;
    private Table2RowModel model;
    private List<PlainTextField> updates = new ArrayList<PlainTextField>();

    public DayView(String name, ProductionWeeklyPlanViewTable.TableRowImpl tableRow, List<UpdateConfigurationComplete> counts) {
        this.name = name;
        this.tableRow = tableRow;
        this.counts = counts;
    }

    public void setSelectedDate(Date selectedDate) {
        this.selectedDate = selectedDate;
    }

    public Date getSelectedDate() {
        return this.selectedDate;
    }

    public int getColumnCount(CustomerLight customer) {
        return 4 + this.getUpdateColumnCount(customer);
    }

    private int getUpdateColumnCount(CustomerLight customer) {
        for (UpdateConfigurationComplete count : this.counts) {
            if (customer == null && count.getCustomer() == null) {
                return count.getColumnCount();
            }
            if (customer == null || !customer.equals((Object)count.getCustomer())) continue;
            return count.getColumnCount();
        }
        for (UpdateConfigurationComplete count : this.counts) {
            if (count.getCustomer() != null) continue;
            return count.getColumnCount();
        }
        return 0;
    }

    public int getDayPreferredDayWidth(CustomerLight customer) {
        int w = 195;
        w += 75;
        return w += this.getUpdateColumnCount(customer) * 65;
    }

    @Override
    public List<TableColumnInfo> generateColumns(CustomerLight customer) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo("Forecast", null, null, null, "", 70));
        int updateColumnCount = this.getUpdateColumnCount(customer);
        for (int i = 0; i < updateColumnCount; ++i) {
            columns.add(new TableColumnInfo("Update", null, null, null, "", 70));
        }
        columns.add(new TableColumnInfo("Produce", null, null, null, "", 70));
        columns.add(new TableColumnInfo("End<br/>Stock", null, null, null, "", 75));
        columns.add(new TableColumnInfo("Waste", null, null, null, "", 70));
        columns.forEach(tableColumnInfo -> tableColumnInfo.setxExpand(0.0));
        return columns;
    }

    @Override
    public void installItems(Table2RowModel model, Container container, Node<WeeklyPlanComplete> weeklyPlanCompleteNode, Node stockNode) {
        this.model = model;
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        ListNode unitsNode = new ListNode();
        unitsNode.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)settings.getPieceUnit(), false, false), 0L);
        this.endStock = new TextLabel(stockNode.getChildNamed(new String[]{this.name}), ConverterRegistry.getConverter(QuantityConverter1Decimal.class));
        this.forecast = new PlainTextField(null, TextFieldType.DOUBLE);
        int updateColumnCount = this.getUpdateColumnCount((CustomerLight)weeklyPlanCompleteNode.getChildNamed(WeeklyPlanComplete_.customer).getValue());
        for (int i = 0; i < updateColumnCount; ++i) {
            PlainTextField update2 = new PlainTextField(null, TextFieldType.DOUBLE);
            this.updates.add(update2);
        }
        this.produce = new PlainTextField(null, TextFieldType.DOUBLE);
        this.waste = new PlainTextField(null, TextFieldType.DOUBLE);
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                DayView.this.checkForFocusJump(e);
            }
        };
        this.forecast.getTextField().addKeyListener(keyAdapter);
        this.updates.forEach(update -> update.getTextField().addKeyListener(keyAdapter));
        this.produce.getTextField().addKeyListener(keyAdapter);
        this.waste.getTextField().addKeyListener(keyAdapter);
        container.add(this.forecast);
        this.updates.forEach(update -> container.add((Component)update));
        container.add(this.produce);
        container.add(this.endStock);
        container.add(this.waste);
    }

    private void checkForFocusJump(KeyEvent e) {
        if (e.getKeyCode() == 38) {
            this.moveUp(e);
        }
        if (e.getKeyCode() == 40) {
            this.moveDown(e);
        }
        if (e.getKeyCode() == 37) {
            this.moveLeft(e);
        }
        if (e.getKeyCode() == 39) {
            this.moveRight(e);
        }
        if (e.getKeyCode() == 10) {
            this.moveRight(e);
        }
    }

    private void moveRight(KeyEvent e) {
        if (e.getSource() == this.forecast.getTextField()) {
            if (this.updates.size() >= 1) {
                this.updates.get(0).requestFocusInWindowNow();
            } else {
                this.produce.requestFocusInWindowNow();
            }
        }
        int count = 0;
        for (PlainTextField update : this.updates) {
            if (e.getSource() == update.getTextField()) {
                if (this.updates.size() > count + 1) {
                    this.updates.get(count + 1).requestFocusInWindowNow();
                } else {
                    this.produce.requestFocusInWindowNow();
                }
            }
            ++count;
        }
        if (e.getSource() == this.produce.getTextField()) {
            this.waste.requestFocusInWindowNow();
        }
        if (e.getSource() == this.waste.getTextField()) {
            this.tableRow.selectNext(this, ProductionWeeklyPlanViewTable.KeyNavType.Waste);
        }
    }

    private boolean moveLeft(KeyEvent e) {
        if (e.getSource() == this.forecast.getTextField()) {
            this.tableRow.selectPrevious(this, ProductionWeeklyPlanViewTable.KeyNavType.Forecast);
        }
        int count = 0;
        for (PlainTextField update : this.updates) {
            if (e.getSource() == update.getTextField()) {
                if (count - 1 >= 0) {
                    this.updates.get(count - 1).requestFocusInWindowNow();
                } else {
                    this.forecast.requestFocusInWindowNow();
                }
            }
            ++count;
        }
        if (e.getSource() == this.produce.getTextField()) {
            if (this.updates.size() >= 1) {
                this.updates.get(this.updates.size() - 1).requestFocusInWindowNow();
            } else {
                this.forecast.requestFocusInWindowNow();
            }
        }
        if (e.getSource() == this.waste.getTextField()) {
            this.produce.requestFocusInWindowNow();
        }
        return false;
    }

    private void moveDown(KeyEvent e) {
        if (e.getSource() == this.forecast.getTextField()) {
            this.tableRow.selectLower(this, ProductionWeeklyPlanViewTable.KeyNavType.Forecast);
        }
        int count = 0;
        for (PlainTextField update : this.updates) {
            if (e.getSource() == update.getTextField()) {
                ProductionWeeklyPlanViewTable.KeyNavType navTarget = null;
                if (count == 0) {
                    navTarget = ProductionWeeklyPlanViewTable.KeyNavType.Update;
                }
                if (count == 1) {
                    navTarget = ProductionWeeklyPlanViewTable.KeyNavType.Update2;
                }
                if (count == 2) {
                    navTarget = ProductionWeeklyPlanViewTable.KeyNavType.Update3;
                }
                if (navTarget != null) {
                    this.tableRow.selectLower(this, navTarget);
                }
            }
            ++count;
        }
        if (e.getSource() == this.produce.getTextField()) {
            this.tableRow.selectLower(this, ProductionWeeklyPlanViewTable.KeyNavType.Produce);
        }
        if (e.getSource() == this.waste.getTextField()) {
            this.tableRow.selectLower(this, ProductionWeeklyPlanViewTable.KeyNavType.Waste);
        }
    }

    private void moveUp(KeyEvent e) {
        if (e.getSource() == this.forecast.getTextField()) {
            this.tableRow.selectUpper(this, ProductionWeeklyPlanViewTable.KeyNavType.Forecast);
        }
        int count = 0;
        for (PlainTextField update : this.updates) {
            if (e.getSource() == update.getTextField()) {
                ProductionWeeklyPlanViewTable.KeyNavType navTarget = null;
                if (count == 0) {
                    navTarget = ProductionWeeklyPlanViewTable.KeyNavType.Update;
                }
                if (count == 1) {
                    navTarget = ProductionWeeklyPlanViewTable.KeyNavType.Update2;
                }
                if (count == 2) {
                    navTarget = ProductionWeeklyPlanViewTable.KeyNavType.Update3;
                }
                if (navTarget != null) {
                    this.tableRow.selectUpper(this, navTarget);
                }
            }
            ++count;
        }
        if (e.getSource() == this.produce.getTextField()) {
            this.tableRow.selectUpper(this, ProductionWeeklyPlanViewTable.KeyNavType.Produce);
        }
        if (e.getSource() == this.waste.getTextField()) {
            this.tableRow.selectUpper(this, ProductionWeeklyPlanViewTable.KeyNavType.Waste);
        }
    }

    @Override
    public void updateItems(Table2RowModel model, Node<WeeklyPlanComplete> node) {
        ProductComplete product = (ProductComplete)model.getNode().getValue();
        PeriodComplete period = new PeriodComplete(this.selectedDate, this.selectedDate);
        Iterator it = node.getChildNamed(WeeklyPlanComplete_.jobs).getFailSafeChildIterator();
        while (it.hasNext()) {
            Node job = (Node)it.next();
            if (!(job.getValue() instanceof ProductionJobComplete) || ((JobComplete)job.getValue()).getJobSchedule().getTime() < period.getStartDate().getTime() || ((JobComplete)job.getValue()).getJobSchedule().getTime() > period.getEndDate().getTime() || !((ProductionJobComplete)job.getValue()).getProduct().equals((Object)product)) continue;
            this.forecast.setNode(job.getChildNamed(ProductionJobComplete_.forecastQuantity));
            int count = 0;
            for (PlainTextField update : this.updates) {
                Node updateNode = null;
                if (count == 0) {
                    updateNode = job.getChildNamed(ProductionJobComplete_.correctionQuantity);
                }
                if (count == 1) {
                    updateNode = job.getChildNamed(ProductionJobComplete_.correctionQuantity2);
                }
                if (count == 2) {
                    updateNode = job.getChildNamed(ProductionJobComplete_.correctionQuantity3);
                }
                if (updateNode != null) {
                    update.setNode(updateNode);
                }
                ++count;
            }
            this.produce.setNode(job.getChildNamed(new DtoField[]{ProductionJobComplete_.quantity, QuantityComplete_.quantity}));
            this.waste.setNode(job.getChildNamed(ProductionJobComplete_.wasteQuantity));
        }
    }

    @Override
    public int layoutItems(int cx, int cy, int pw, int ph, int index) {
        int currentX = cx;
        int w = this.model.getParentModel().getColumnWidth(index++);
        this.forecast.setLocation(currentX + this.getCellPadding(), (int)(((double)ph - this.forecast.getPreferredSize().getHeight()) / 2.0));
        this.forecast.setSize(w - 2 * this.getCellPadding(), (int)this.forecast.getPreferredSize().getHeight());
        currentX += w;
        w = this.model.getParentModel().getColumnWidth(index++);
        for (PlainTextField update : this.updates) {
            update.setLocation(currentX + this.getCellPadding(), (int)(((double)ph - update.getPreferredSize().getHeight()) / 2.0));
            update.setSize(w - 2 * this.getCellPadding(), (int)update.getPreferredSize().getHeight());
            currentX += w;
            w = this.model.getParentModel().getColumnWidth(index++);
        }
        this.produce.setLocation(currentX + this.getCellPadding(), (int)(((double)ph - this.produce.getPreferredSize().getHeight()) / 2.0));
        this.produce.setSize(w - 2 * this.getCellPadding(), (int)this.produce.getPreferredSize().getHeight());
        currentX += w;
        w = this.model.getParentModel().getColumnWidth(index++);
        this.endStock.setLocation(currentX + this.getCellPadding(), (int)(((double)ph - this.endStock.getPreferredSize().getHeight()) / 2.0));
        this.endStock.setSize(w - 2 * this.getCellPadding(), (int)this.endStock.getPreferredSize().getHeight());
        currentX += w;
        w = this.model.getParentModel().getColumnWidth(index++);
        this.waste.setLocation(currentX + this.getCellPadding(), (int)(((double)ph - this.waste.getPreferredSize().getHeight()) / 2.0));
        this.waste.setSize(w - 2 * this.getCellPadding(), (int)this.waste.getPreferredSize().getHeight());
        return currentX + w;
    }

    private int getCellPadding() {
        return this.model.getParentModel().getTable().getCellPadding();
    }

    public void select(ProductionWeeklyPlanViewTable.KeyNavType type) {
        switch (type) {
            case Forecast: {
                this.forecast.requestFocusInWindowNow();
                break;
            }
            case Update: {
                if (this.updates.size() < 1) break;
                this.updates.get(0).requestFocusInWindowNow();
                break;
            }
            case Update2: {
                if (this.updates.size() < 2) break;
                this.updates.get(1).requestFocusInWindowNow();
                break;
            }
            case Update3: {
                if (this.updates.size() < 3) break;
                this.updates.get(2).requestFocusInWindowNow();
                break;
            }
            case Produce: {
                this.produce.requestFocusInWindowNow();
                break;
            }
            case Waste: {
                this.waste.requestFocusInWindowNow();
            }
        }
    }
}

