/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.productionweeklyplan;

import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.table2.Table2ViewFactory;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.panels.ScrollableBackground;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.productionweeklyplan.DayView;
import ch.icit.pegasus.client.gui.utils.productionweeklyplan.HeaderView;
import ch.icit.pegasus.client.gui.utils.productionweeklyplan.ProductionWeeklyPlanTableHeader;
import ch.icit.pegasus.client.gui.utils.productionweeklyplan.StockForwardCalculator;
import ch.icit.pegasus.client.gui.utils.productionweeklyplan.SummaryView;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.weeklyplan.WeeklyPlanServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanComplete;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanComplete_;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanLight;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanReference;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanSettingsComplete;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.JobComplete;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.ProductProductionJobComplete;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.RecipeProductionJobComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.DateUtil;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import ch.icit.utils.Tuple;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ProductionWeeklyPlanViewTable
extends ScrollableBackground {
    public static final int editQtyWidth = 120;
    public static final int qtyWidth = 75;
    public static final int numberWidth = 150;
    public static final int sepWidth = 3;
    private HeaderView headerView;
    private SummaryView summaryView;
    private Node<WeeklyPlanComplete> node;
    private Table2 dataTable;
    private DayView mo = new DayView("mo", null, ((WeeklyPlanSettingsComplete)NodeToolkit.getAffixClass(WeeklyPlanSettingsComplete.class).getValue()).getMondayUpdateCount());
    private DayView tue = new DayView("tue", null, ((WeeklyPlanSettingsComplete)NodeToolkit.getAffixClass(WeeklyPlanSettingsComplete.class).getValue()).getTuesdayUpdateCount());
    private DayView wed = new DayView("wed", null, ((WeeklyPlanSettingsComplete)NodeToolkit.getAffixClass(WeeklyPlanSettingsComplete.class).getValue()).getWednesdayUpdateCount());
    private DayView thu = new DayView("thu", null, ((WeeklyPlanSettingsComplete)NodeToolkit.getAffixClass(WeeklyPlanSettingsComplete.class).getValue()).getThursdayUpdateCount());
    private DayView fri = new DayView("fri", null, ((WeeklyPlanSettingsComplete)NodeToolkit.getAffixClass(WeeklyPlanSettingsComplete.class).getValue()).getFridayUpdateCount());
    private DayView sat = new DayView("sat", null, ((WeeklyPlanSettingsComplete)NodeToolkit.getAffixClass(WeeklyPlanSettingsComplete.class).getValue()).getSaturdayUpdateCount());
    private DayView sun = new DayView("sun", null, ((WeeklyPlanSettingsComplete)NodeToolkit.getAffixClass(WeeklyPlanSettingsComplete.class).getValue()).getSundayUpdateCount());

    public ProductionWeeklyPlanViewTable(RDProvider provider, Node<WeeklyPlanLight> node) {
        super(false);
        Node<WeeklyPlanLight> n = node;
        this.node = n;
        this.headerView = new HeaderView();
        this.summaryView = new SummaryView();
        this.getScrollPane().setHorizontalScrollBarPolicy(30);
        this.getScrollPane().setWheelScrollingEnabled(false);
        this.dataTable = new Table2(false, "");
        int columnCount = 3;
        this.dataTable.getFatLines().add(columnCount);
        this.dataTable.getFatLines().add(columnCount += this.mo.getColumnCount(((WeeklyPlanLight)node.getValue()).getCustomer()));
        this.dataTable.getFatLines().add(columnCount += this.tue.getColumnCount(((WeeklyPlanLight)node.getValue()).getCustomer()));
        this.dataTable.getFatLines().add(columnCount += this.wed.getColumnCount(((WeeklyPlanLight)node.getValue()).getCustomer()));
        this.dataTable.getFatLines().add(columnCount += this.thu.getColumnCount(((WeeklyPlanLight)node.getValue()).getCustomer()));
        this.dataTable.getFatLines().add(columnCount += this.fri.getColumnCount(((WeeklyPlanLight)node.getValue()).getCustomer()));
        this.dataTable.getFatLines().add(columnCount += this.sat.getColumnCount(((WeeklyPlanLight)node.getValue()).getCustomer()));
        this.dataTable.getFatLines().add(columnCount += this.sun.getColumnCount(((WeeklyPlanLight)node.getValue()).getCustomer()));
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.addAll(this.headerView.generateColumns(((WeeklyPlanLight)node.getValue()).getCustomer()));
        columns.addAll(this.mo.generateColumns(((WeeklyPlanLight)node.getValue()).getCustomer()));
        columns.addAll(this.tue.generateColumns(((WeeklyPlanLight)node.getValue()).getCustomer()));
        columns.addAll(this.wed.generateColumns(((WeeklyPlanLight)node.getValue()).getCustomer()));
        columns.addAll(this.thu.generateColumns(((WeeklyPlanLight)node.getValue()).getCustomer()));
        columns.addAll(this.fri.generateColumns(((WeeklyPlanLight)node.getValue()).getCustomer()));
        columns.addAll(this.sat.generateColumns(((WeeklyPlanLight)node.getValue()).getCustomer()));
        columns.addAll(this.sun.generateColumns(((WeeklyPlanLight)node.getValue()).getCustomer()));
        columns.addAll(this.summaryView.generateColumns(((WeeklyPlanLight)node.getValue()).getCustomer()));
        this.dataTable.setModel(new Table2Model(columns, new Table2ViewFactory(){

            @Override
            public Table2RowPanel getRowPanel(Table2RowModel model) {
                return new TableRowImpl(model);
            }

            @Override
            public Table2RowPanel getHeaderPane(Table2RowModel model) {
                return new ProductionWeeklyPlanTableHeader(model);
            }
        }));
        this.getViewPort().setLayout(new Layout());
        this.getViewPort().add(this.dataTable);
    }

    public void setNode(Node<WeeklyPlanComplete> node) {
        this.node = node;
        HashMap<Tuple, JobComplete> jobIndex = new HashMap<Tuple, JobComplete>();
        HashSet<Object> allProducts = new HashSet<Object>();
        HashSet<ProductComplete> allProducts2 = new HashSet<ProductComplete>();
        HashSet<Tuple> allRecipes = new HashSet<Tuple>();
        for (JobComplete jobComplete : (List)node.getChildNamed(WeeklyPlanComplete_.jobs).getValue()) {
            Iterator cDate;
            Timestamp date;
            ProductComplete product;
            if (jobComplete instanceof ProductProductionJobComplete) {
                product = ((ProductProductionJobComplete)jobComplete).getProduct();
                date = jobComplete.getJobSchedule();
                cDate = new PeriodComplete(new Date(date.getTime()), new Date(date.getTime())).getStartDate();
                Tuple tuple = new Tuple((Object)cDate, (Object)product);
                jobIndex.put(tuple, jobComplete);
                allProducts.add(product);
                continue;
            }
            if (!(jobComplete instanceof RecipeProductionJobComplete)) continue;
            product = ((RecipeProductionJobComplete)jobComplete).getProduct();
            date = jobComplete.getJobSchedule();
            cDate = new PeriodComplete(new Date(date.getTime()), new Date(date.getTime())).getStartDate();
            Tuple tuple = new Tuple(cDate, (Object)product);
            jobIndex.put(tuple, jobComplete);
            allRecipes.add(new Tuple((Object)product, (Object)((RecipeProductionJobComplete)jobComplete).getRecipe()));
            allProducts2.add(product);
        }
        SystemSettingsComplete setting = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        ArrayList<ProductProductionJobComplete> newJobs = new ArrayList<ProductProductionJobComplete>();
        PeriodComplete period = (PeriodComplete)node.getChildNamed(WeeklyPlanComplete_.period).getValue();
        Date cDate = new Date(period.getStartDate().getTime());
        while (cDate.before(period.getEndDate())) {
            ProductProductionJobComplete job;
            Tuple key;
            for (ProductComplete productComplete : allProducts) {
                key = new Tuple((Object)new PeriodComplete(new Date(cDate.getTime()), new Date(cDate.getTime())).getStartDate(), (Object)productComplete);
                if (jobIndex.containsKey(key)) continue;
                job = new ProductProductionJobComplete();
                job.setClientOId(Long.valueOf(ADTO.getNextId()));
                job.setCorrectionQuantity(Double.valueOf(0.0));
                job.setCorrectionQuantityUnit(setting.getPieceUnit());
                job.setCorrectionQuantity(Double.valueOf(0.0));
                job.setCorrectionQuantityUnit(setting.getPieceUnit());
                job.setCorrectionQuantity(Double.valueOf(0.0));
                job.setCorrectionQuantityUnit(setting.getPieceUnit());
                job.setForecastQuantity(Double.valueOf(0.0));
                job.setForecastQuantityUnit(setting.getPieceUnit());
                job.setWasteQuantity(Double.valueOf(0.0));
                job.setWasteQuantityUnit(setting.getPieceUnit());
                job.setQuantity(new QuantityComplete(Double.valueOf(0.0), setting.getPieceUnit()));
                job.setProduct(productComplete);
                job.setJobSchedule(new Timestamp(cDate.getTime()));
                newJobs.add(job);
            }
            for (Tuple tuple : allRecipes) {
                key = new Tuple((Object)new PeriodComplete(new Date(cDate.getTime()), new Date(cDate.getTime())).getStartDate(), tuple.getS());
                if (jobIndex.containsKey(key)) continue;
                job = new RecipeProductionJobComplete();
                job.setClientOId(Long.valueOf(ADTO.getNextId()));
                job.setCorrectionQuantity(Double.valueOf(0.0));
                job.setCorrectionQuantityUnit(((RecipeComplete)tuple.getT()).getCurrentVariant().getYield().getUnit());
                job.setForecastQuantity(Double.valueOf(0.0));
                job.setForecastQuantityUnit(((RecipeComplete)tuple.getT()).getCurrentVariant().getYield().getUnit());
                job.setWasteQuantity(Double.valueOf(0.0));
                job.setWasteQuantityUnit(((RecipeComplete)tuple.getT()).getCurrentVariant().getYield().getUnit());
                job.setQuantity(new QuantityComplete(Double.valueOf(0.0), ((RecipeComplete)tuple.getT()).getCurrentVariant().getYield().getUnit()));
                job.setProduct((ProductComplete)tuple.getS());
                job.setRecipe((RecipeComplete)tuple.getT());
                job.setJobSchedule(new Timestamp(cDate.getTime()));
                newJobs.add(job);
            }
            cDate = (Date)DateUtil.addDays((java.util.Date)cDate, (int)1);
        }
        ((WeeklyPlanComplete)node.getValue()).getJobs().addAll(newJobs);
        for (JobComplete jobComplete : newJobs) {
            node.getChildNamed(WeeklyPlanComplete_.jobs).addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)jobComplete, false, false), 0L);
        }
        allProducts.addAll(allProducts2);
        Node productNodes = INodeCreator.getDefaultImpl().createNodes(new ArrayList(allProducts), true);
        this.dataTable.getModel().setNode(productNodes);
        ((ProductionWeeklyPlanTableHeader)this.dataTable.getHeader().getView()).setNode(node);
        this.revalidate();
    }

    public void reloadFlights(final RemoteLoader callBack) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                WeeklyPlanComplete weeklyPlan = (WeeklyPlanComplete)((WeeklyPlanServiceManager)ServiceManagerRegistry.getService(WeeklyPlanServiceManager.class)).updateFlightsOnWeeklyPlan(new WeeklyPlanReference(((WeeklyPlanComplete)ProductionWeeklyPlanViewTable.this.node.getValue()).getId())).getValue();
                return INodeCreator.getDefaultImpl().getNode4DTO((Object)weeklyPlan, false, false);
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        InnerPopupFactory.showMessage("Weekly Plan Update", "Flights updated on Weekly Plan", null, ProductionWeeklyPlanViewTable.this);
                        callBack.remoteObjectLoaded(node);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)((Object)exception), (Component)ProductionWeeklyPlanViewTable.this);
                        callBack.errorOccurred(exception);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    public void loadMatDispo(final RemoteLoader callBack) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                WeeklyPlanComplete weeklyPlan = (WeeklyPlanComplete)((WeeklyPlanServiceManager)ServiceManagerRegistry.getService(WeeklyPlanServiceManager.class)).calculateWeeklyPlanProductionTargets(new WeeklyPlanReference(((WeeklyPlanComplete)ProductionWeeklyPlanViewTable.this.node.getValue()).getId())).getValue();
                return INodeCreator.getDefaultImpl().getNode4DTO((Object)weeklyPlan, false, false);
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        InnerPopupFactory.showMessage("Weekly Plan Update", "Production Targets updated", null, ProductionWeeklyPlanViewTable.this);
                        ProductionWeeklyPlanViewTable.this.setNode(node);
                        callBack.remoteObjectLoaded(node);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)((Object)exception), (Component)ProductionWeeklyPlanViewTable.this);
                        callBack.errorOccurred(exception);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    protected class TableRowImpl
    extends Table2RowPanel {
        private HeaderView header;
        private DayView mo;
        private DayView tue;
        private DayView wed;
        private DayView thu;
        private DayView fri;
        private DayView sat;
        private DayView sun;
        private SummaryView summary;
        private Node stockNode;
        private StockForwardCalculator stockForwardCalculator;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.header = new HeaderView();
            this.mo = new DayView("mo", this, ((WeeklyPlanSettingsComplete)NodeToolkit.getAffixClass(WeeklyPlanSettingsComplete.class).getValue()).getMondayUpdateCount());
            this.tue = new DayView("tue", this, ((WeeklyPlanSettingsComplete)NodeToolkit.getAffixClass(WeeklyPlanSettingsComplete.class).getValue()).getTuesdayUpdateCount());
            this.wed = new DayView("wed", this, ((WeeklyPlanSettingsComplete)NodeToolkit.getAffixClass(WeeklyPlanSettingsComplete.class).getValue()).getWednesdayUpdateCount());
            this.thu = new DayView("thu", this, ((WeeklyPlanSettingsComplete)NodeToolkit.getAffixClass(WeeklyPlanSettingsComplete.class).getValue()).getThursdayUpdateCount());
            this.fri = new DayView("fri", this, ((WeeklyPlanSettingsComplete)NodeToolkit.getAffixClass(WeeklyPlanSettingsComplete.class).getValue()).getFridayUpdateCount());
            this.sat = new DayView("sat", this, ((WeeklyPlanSettingsComplete)NodeToolkit.getAffixClass(WeeklyPlanSettingsComplete.class).getValue()).getSaturdayUpdateCount());
            this.sun = new DayView("sun", this, ((WeeklyPlanSettingsComplete)NodeToolkit.getAffixClass(WeeklyPlanSettingsComplete.class).getValue()).getSundayUpdateCount());
            this.summary = new SummaryView();
            this.stockNode = new Node();
            NodeToolkit.ensureChild((Node)this.stockNode, (String)"item");
            NodeToolkit.ensureChild((Node)this.stockNode, (String)"startStock");
            NodeToolkit.ensureChild((Node)this.stockNode, (String)"mo");
            NodeToolkit.ensureChild((Node)this.stockNode, (String)"tue");
            NodeToolkit.ensureChild((Node)this.stockNode, (String)"wed");
            NodeToolkit.ensureChild((Node)this.stockNode, (String)"thu");
            NodeToolkit.ensureChild((Node)this.stockNode, (String)"fri");
            NodeToolkit.ensureChild((Node)this.stockNode, (String)"sat");
            NodeToolkit.ensureChild((Node)this.stockNode, (String)"sun");
            NodeToolkit.ensureChild((Node)this.stockNode, (String)"endStock");
            NodeToolkit.ensureChild((Node)this.stockNode, (String)"totDeliver");
            NodeToolkit.ensureChild((Node)this.stockNode, (String)"totProduce");
            this.stockForwardCalculator = new StockForwardCalculator((Node<WeeklyPlanComplete>)ProductionWeeklyPlanViewTable.this.node, this.stockNode);
            Date startDate = (Date)ProductionWeeklyPlanViewTable.this.node.getChildNamed(new DtoField[]{WeeklyPlanComplete_.period, PeriodComplete_.startDate}).getValue();
            Date currentDate = new Date(startDate.getTime());
            this.mo.setSelectedDate(new Date(currentDate.getTime()));
            currentDate = (Date)DateUtil.addDays((java.util.Date)currentDate, (int)1);
            this.tue.setSelectedDate(new Date(currentDate.getTime()));
            currentDate = (Date)DateUtil.addDays((java.util.Date)currentDate, (int)1);
            this.wed.setSelectedDate(new Date(currentDate.getTime()));
            currentDate = (Date)DateUtil.addDays((java.util.Date)currentDate, (int)1);
            this.thu.setSelectedDate(new Date(currentDate.getTime()));
            currentDate = (Date)DateUtil.addDays((java.util.Date)currentDate, (int)1);
            this.fri.setSelectedDate(new Date(currentDate.getTime()));
            currentDate = (Date)DateUtil.addDays((java.util.Date)currentDate, (int)1);
            this.sat.setSelectedDate(new Date(currentDate.getTime()));
            currentDate = (Date)DateUtil.addDays((java.util.Date)currentDate, (int)1);
            this.sun.setSelectedDate(new Date(currentDate.getTime()));
            this.header.installItems(m, this, (Node<WeeklyPlanComplete>)ProductionWeeklyPlanViewTable.this.node, this.stockNode);
            this.mo.installItems(m, this, (Node<WeeklyPlanComplete>)ProductionWeeklyPlanViewTable.this.node, this.stockNode);
            this.tue.installItems(m, this, (Node<WeeklyPlanComplete>)ProductionWeeklyPlanViewTable.this.node, this.stockNode);
            this.wed.installItems(m, this, (Node<WeeklyPlanComplete>)ProductionWeeklyPlanViewTable.this.node, this.stockNode);
            this.thu.installItems(m, this, (Node<WeeklyPlanComplete>)ProductionWeeklyPlanViewTable.this.node, this.stockNode);
            this.fri.installItems(m, this, (Node<WeeklyPlanComplete>)ProductionWeeklyPlanViewTable.this.node, this.stockNode);
            this.sat.installItems(m, this, (Node<WeeklyPlanComplete>)ProductionWeeklyPlanViewTable.this.node, this.stockNode);
            this.sun.installItems(m, this, (Node<WeeklyPlanComplete>)ProductionWeeklyPlanViewTable.this.node, this.stockNode);
            this.summary.installItems(m, this, (Node<WeeklyPlanComplete>)ProductionWeeklyPlanViewTable.this.node, this.stockNode);
            this.header.updateItems(m, (Node<WeeklyPlanComplete>)ProductionWeeklyPlanViewTable.this.node);
            this.mo.updateItems(m, (Node<WeeklyPlanComplete>)ProductionWeeklyPlanViewTable.this.node);
            this.tue.updateItems(m, (Node<WeeklyPlanComplete>)ProductionWeeklyPlanViewTable.this.node);
            this.wed.updateItems(m, (Node<WeeklyPlanComplete>)ProductionWeeklyPlanViewTable.this.node);
            this.thu.updateItems(m, (Node<WeeklyPlanComplete>)ProductionWeeklyPlanViewTable.this.node);
            this.fri.updateItems(m, (Node<WeeklyPlanComplete>)ProductionWeeklyPlanViewTable.this.node);
            this.sat.updateItems(m, (Node<WeeklyPlanComplete>)ProductionWeeklyPlanViewTable.this.node);
            this.sun.updateItems(m, (Node<WeeklyPlanComplete>)ProductionWeeklyPlanViewTable.this.node);
            this.summary.updateItems(m, (Node<WeeklyPlanComplete>)ProductionWeeklyPlanViewTable.this.node);
            this.setLayout(new Layout());
            this.stockForwardCalculator.calculateStock();
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        public void selectUpper(DayView dayView, KeyNavType type) {
            int index = this.getModel().getParentModel().getTable().getRowIndex(this);
            if (index == 0) {
                return;
            }
            TableRowImpl newRow = (TableRowImpl)this.getModel().getParentModel().getTable().getRowAt(index - 1);
            newRow.select(dayView, type);
        }

        public void selectLower(DayView dayView, KeyNavType type) {
            int index = this.getModel().getParentModel().getTable().getRowIndex(this);
            if (index == this.getModel().getParentModel().getTable().getRowCount() - 1) {
                return;
            }
            TableRowImpl newRow = (TableRowImpl)this.getModel().getParentModel().getTable().getRowAt(index + 1);
            newRow.select(dayView, type);
        }

        public void selectNext(DayView dayView, KeyNavType type) {
            DayView nextDay = null;
            if (dayView.equals(this.mo)) {
                nextDay = this.tue;
            }
            if (dayView.equals(this.tue)) {
                nextDay = this.wed;
            }
            if (dayView.equals(this.wed)) {
                nextDay = this.thu;
            }
            if (dayView.equals(this.thu)) {
                nextDay = this.fri;
            }
            if (dayView.equals(this.fri)) {
                nextDay = this.sat;
            }
            if (dayView.equals(this.sat)) {
                nextDay = this.sun;
            }
            if (dayView.equals(this.sun)) {
                // empty if block
            }
            if (nextDay != null) {
                this.select(nextDay, KeyNavType.Forecast);
            }
        }

        public void selectPrevious(DayView dayView, KeyNavType type) {
            DayView nextDay = null;
            if (dayView.equals(this.mo)) {
                // empty if block
            }
            if (dayView.equals(this.tue)) {
                nextDay = this.mo;
            }
            if (dayView.equals(this.wed)) {
                nextDay = this.tue;
            }
            if (dayView.equals(this.thu)) {
                nextDay = this.wed;
            }
            if (dayView.equals(this.fri)) {
                nextDay = this.thu;
            }
            if (dayView.equals(this.sat)) {
                nextDay = this.fri;
            }
            if (dayView.equals(this.sun)) {
                nextDay = this.sat;
            }
            if (nextDay != null) {
                this.select(nextDay, KeyNavType.Waste);
            }
        }

        private void select(DayView dayView, KeyNavType type) {
            DayView innerDayView = null;
            if (dayView.getSelectedDate().equals(this.mo.getSelectedDate())) {
                innerDayView = this.mo;
            }
            if (dayView.getSelectedDate().equals(this.tue.getSelectedDate())) {
                innerDayView = this.tue;
            }
            if (dayView.getSelectedDate().equals(this.wed.getSelectedDate())) {
                innerDayView = this.wed;
            }
            if (dayView.getSelectedDate().equals(this.thu.getSelectedDate())) {
                innerDayView = this.thu;
            }
            if (dayView.getSelectedDate().equals(this.fri.getSelectedDate())) {
                innerDayView = this.fri;
            }
            if (dayView.getSelectedDate().equals(this.sat.getSelectedDate())) {
                innerDayView = this.sat;
            }
            if (dayView.getSelectedDate().equals(this.sun.getSelectedDate())) {
                innerDayView = this.sun;
            }
            if (innerDayView == null) {
                throw new IllegalStateException("No day to select found");
            }
            innerDayView.select(type);
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                CustomerLight customer = null;
                if (ProductionWeeklyPlanViewTable.this.node != null) {
                    customer = (CustomerLight)ProductionWeeklyPlanViewTable.this.node.getChildNamed(WeeklyPlanComplete_.customer).getValue();
                }
                int summaryWidth = 225;
                int dayWidth = TableRowImpl.this.mo.getDayPreferredDayWidth(customer) + TableRowImpl.this.tue.getDayPreferredDayWidth(customer) + TableRowImpl.this.wed.getDayPreferredDayWidth(customer) + TableRowImpl.this.thu.getDayPreferredDayWidth(customer) + TableRowImpl.this.fri.getDayPreferredDayWidth(customer) + TableRowImpl.this.sat.getDayPreferredDayWidth(customer) + TableRowImpl.this.sun.getDayPreferredDayWidth(customer);
                int headerWidth = parent.getWidth() - (summaryWidth + dayWidth + 24);
                int currentX = 0;
                int currentColumn = 0;
                currentX = TableRowImpl.this.header.layoutItems(currentX, 0, headerWidth, parent.getHeight(), currentColumn);
                currentColumn = 4;
                currentX = TableRowImpl.this.mo.layoutItems(currentX, 0, dayWidth, parent.getHeight(), currentColumn);
                currentX = TableRowImpl.this.tue.layoutItems(currentX, 0, dayWidth, parent.getHeight(), currentColumn += TableRowImpl.this.mo.getColumnCount(customer));
                currentX = TableRowImpl.this.wed.layoutItems(currentX, 0, dayWidth, parent.getHeight(), currentColumn += TableRowImpl.this.tue.getColumnCount(customer));
                currentX = TableRowImpl.this.thu.layoutItems(currentX, 0, dayWidth, parent.getHeight(), currentColumn += TableRowImpl.this.wed.getColumnCount(customer));
                currentX = TableRowImpl.this.fri.layoutItems(currentX, 0, dayWidth, parent.getHeight(), currentColumn += TableRowImpl.this.thu.getColumnCount(customer));
                currentX = TableRowImpl.this.sat.layoutItems(currentX, 0, dayWidth, parent.getHeight(), currentColumn += TableRowImpl.this.fri.getColumnCount(customer));
                currentX = TableRowImpl.this.sun.layoutItems(currentX, 0, dayWidth, parent.getHeight(), currentColumn += TableRowImpl.this.sat.getColumnCount(customer));
                currentX = TableRowImpl.this.summary.layoutItems(currentX, 0, summaryWidth, parent.getHeight(), currentColumn += TableRowImpl.this.sun.getColumnCount(customer));
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            CustomerLight customer = null;
            if (ProductionWeeklyPlanViewTable.this.node != null) {
                customer = (CustomerLight)ProductionWeeklyPlanViewTable.this.node.getChildNamed(WeeklyPlanComplete_.customer).getValue();
            }
            int summaryWidth = 225;
            int dayWidth = ProductionWeeklyPlanViewTable.this.mo.getDayPreferredDayWidth(customer) + ProductionWeeklyPlanViewTable.this.tue.getDayPreferredDayWidth(customer) + ProductionWeeklyPlanViewTable.this.wed.getDayPreferredDayWidth(customer) + ProductionWeeklyPlanViewTable.this.thu.getDayPreferredDayWidth(customer) + ProductionWeeklyPlanViewTable.this.fri.getDayPreferredDayWidth(customer) + ProductionWeeklyPlanViewTable.this.sat.getDayPreferredDayWidth(customer) + ProductionWeeklyPlanViewTable.this.sun.getDayPreferredDayWidth(customer);
            int headerWidth = 525;
            return new Dimension(headerWidth + dayWidth + summaryWidth + 24, 0);
        }

        @Override
        public void layoutContainer(Container parent) {
            ProductionWeeklyPlanViewTable.this.dataTable.setLocation(0, 0);
            ProductionWeeklyPlanViewTable.this.dataTable.setSize(parent.getWidth(), parent.getHeight());
        }
    }

    protected static enum KeyNavType {
        Forecast,
        Update,
        Update2,
        Update3,
        Produce,
        Waste;

    }
}

