/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.searchbox;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.Nodable;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.SelectionManager;
import ch.icit.pegasus.client.gui.utils.Validatable;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteSearchButton;
import ch.icit.pegasus.client.gui.utils.combobox.DefaultListViewPopupInsert;
import ch.icit.pegasus.client.gui.utils.combobox.activators.ActivationAdapter;
import ch.icit.pegasus.client.gui.utils.combobox.iconmapper.IconMapperController;
import ch.icit.pegasus.client.gui.utils.filterchain.UIStateLoadable;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.AsynchronLoaderAnimation;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.MouseConsumer;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextFieldFilter;
import ch.icit.pegasus.client.gui.utils.skins.Skin3Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.gui.utils.textfield.JTextField2;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.ListNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ProxyNode;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.searcher.SearchFieldSearchAlgorithm;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.exception.SearchException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.system.ADeletableDTO;
import ch.icit.pegasus.server.core.dtos.system.IDeletableDTO;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.dtos.utils.StoreToolkit;
import ch.icit.pegasus.server.core.dtos.utils.TransactionType;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.util.StringUtil;
import ch.icit.pegasus.server.dtos.IDTO;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class SearchTextField2<T extends IDTO>
extends JPanelFadable
implements LafListener,
FocusListener,
MouseListener,
Focusable,
InnerPopUpListener2,
KeyListener,
NodeListener,
DocumentListener,
RemoteLoader,
ButtonListener,
UIStateLoadable,
Nodable,
Validatable,
MouseConsumer {
    private static final long serialVersionUID = 1L;
    private List<SearchTextField2Listener> listeners = new ArrayList<SearchTextField2Listener>();
    private SearchTextFieldFilter filter;
    private boolean ignoreEmptySearch;
    private boolean keepCurrentValue = true;
    private List<ADTO> doNotMerge;
    private boolean isAutoCompletion = false;
    protected Node<T> node;
    private Node possibleValues;
    protected DeleteSearchButton deleteSearchButton;
    private Point cachedTopParentPosition;
    private boolean isPersistable = true;
    private int cachedPopupOffset;
    private Converter defaultEntryConverter;
    private Converter defaultViewConverter;
    private ActivationAdapter defaultActivationAdapter;
    private Color okForeground;
    private Color deletedForeground;
    private Color deactivatedForeground;
    private Color warningForeground;
    private Color stateWarningForeground;
    private Color halalWarningForeground;
    private Color selectedTextOkBackground;
    private Color selectedTextNotOkBackground;
    private Color selectedTextOkForeground;
    private SearchFieldSearchAlgorithm<?, T> searchAlgorithm;
    protected AsynchronLoaderAnimation loaderAnimation;
    private Object[] additionalSearchFields;
    private InnerPopUp2 popUp;
    private Selectable selectableElement;
    protected int minWidth = 50;
    protected int xOffset = 0;
    private Class iconMapper;
    private boolean isWithALL;
    protected JTextField2 textField;
    protected Skin3Field skin;
    private String id;
    private String name;
    protected String defaultText;
    protected Button.ButtonState state = Button.ButtonState.UP;
    protected Button.ButtonState paintState = Button.ButtonState.UP;
    protected boolean isSearchActiv;
    private String nextPattern;
    protected VisibleContainer visibleContainer;
    protected boolean isDown;
    private boolean isTrySelectOne;
    private boolean isProxy;
    private boolean isFilterChain;
    private List<T> ignoreValues;

    public SearchTextField2() {
        this.skin = (Skin3Field)DefaultSkins.SearchFieldTexture.createDynamicSkin();
        this.textField = new JTextField2();
        this.textField.setBorder(BorderFactory.createEmptyBorder());
        this.textField.setOpaque(false);
        this.loaderAnimation = new AsynchronLoaderAnimation();
        this.loaderAnimation.getFader().setPermanent(true);
        this.loaderAnimation.setProgress(0.0f);
        this.getFader().setDisableWhenHidden(true);
        this.setProgress(1.0f);
        this.setOpaque(false);
        this.lafAttributeChanged("All attribues changed");
        this.addMouseListener(this);
        this.textField.addMouseListener(this);
        this.textField.addFocusListener(this);
        this.setLayout(new SearchTextFieldLayout());
        this.setIgnoreValues(new ArrayList());
        this.add(this.textField);
        this.add(this.loaderAnimation);
    }

    public void setKeepCurrentValue(boolean keepCurrentValue) {
        this.keepCurrentValue = keepCurrentValue;
    }

    public void setIgnoreEmptySearch(boolean ignoreEmptySearch) {
        this.ignoreEmptySearch = ignoreEmptySearch;
    }

    public void setDoNotMergeDTOs(List<ADTO> doNotMerge) {
        this.doNotMerge = doNotMerge;
        if (this.searchAlgorithm != null) {
            this.searchAlgorithm.setNotMergeDTOs(doNotMerge);
        }
    }

    public SearchTextField2(Node value) {
        this(true);
        this.setNode(value);
    }

    public SearchTextField2(boolean isAutoComplitionActiv) {
        this();
        this.setAutoCompletion(isAutoComplitionActiv);
    }

    public void setIsFilterChain(boolean b) {
        this.isFilterChain = b;
    }

    @Override
    public String getPersistString() {
        return this.getText();
    }

    @Override
    public void loadState(String state, String id) {
        this.setText(state);
    }

    public void setWithALL(boolean isWithALL) {
        this.isWithALL = isWithALL;
        if (isWithALL) {
            this.deleteSearchButton = new DeleteSearchButton();
            this.deleteSearchButton.getFader().setPermanent(true);
            this.deleteSearchButton.addButtonListener(this);
            this.add(this.deleteSearchButton);
        }
    }

    public void setFilter(SearchTextFieldFilter filter) {
        this.filter = filter;
    }

    public void setDefaultActivationAdapter(ActivationAdapter adapter) {
        this.defaultActivationAdapter = adapter;
    }

    public void grapAutoFocus() {
    }

    public void setSelectiveDelegation(Selectable element) {
        this.selectableElement = element;
    }

    public void setIconMapperClass(Class clazz) {
        this.iconMapper = clazz;
    }

    public void setSearchAlgorithm(SearchFieldSearchAlgorithm<?, T> algo) {
        this.searchAlgorithm = algo;
        if (this.doNotMerge != null) {
            this.searchAlgorithm.setNotMergeDTOs(this.doNotMerge);
        }
    }

    public SearchFieldSearchAlgorithm<?, T> getSearchAlgorithm() {
        return this.searchAlgorithm;
    }

    public void setDefaultViewConverter(Converter con) {
        this.defaultViewConverter = con;
    }

    public void resetText() {
        if (this.textField != null && this.getNode() != null) {
            this.resetText(this.getNode());
        } else {
            this.setText("");
        }
    }

    public void setDefaultEntryConverter(Converter con) {
        this.defaultEntryConverter = con;
    }

    public void setAdditionalSearchField(Object ... o) {
        this.additionalSearchFields = o;
    }

    @Override
    public void setValid() {
        if (this.state == Button.ButtonState.ERROR) {
            if (this.textField.hasFocus()) {
                this.setState(Button.ButtonState.FOCUS);
            } else {
                this.setState(Button.ButtonState.UP);
            }
        }
    }

    public void setInValid() {
        this.setState(Button.ButtonState.ERROR);
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void valueChanged(Node<?> node) {
        this.resetText(node);
    }

    private void resetText(Node node) {
        if (node != null && node.getValue() != null && this.textField != null) {
            this.textField.getDocument().removeDocumentListener(this);
            String t = "";
            try {
                t = this.defaultViewConverter != null ? (String)this.defaultViewConverter.convert(node.getValue(), node, new Object[0]) : (this.defaultEntryConverter != null ? (String)this.defaultEntryConverter.convert(node.getValue(), node, new Object[0]) : t + node.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.defaultActivationAdapter != null) {
                ActivationAdapter.ActivationType value = this.defaultActivationAdapter.isElementActive(node.getValue());
                this.deletedItemSelected(value);
            } else if (node.getValue() instanceof ADeletableDTO) {
                if (((IDeletableDTO)node.getValue()).getIsDeleted().booleanValue()) {
                    this.deletedItemSelected(ActivationAdapter.ActivationType.FATAL);
                } else {
                    this.deletedItemSelected(ActivationAdapter.ActivationType.OK);
                }
            }
            this.textField.setText(t);
            this.textField.getDocument().addDocumentListener(this);
        } else if (this.textField != null) {
            this.textField.getDocument().removeDocumentListener(this);
            this.textField.setText("");
            this.textField.getDocument().addDocumentListener(this);
        }
    }

    public void addSearchTextFieldListener(SearchTextField2Listener l) {
        this.listeners.add(l);
    }

    public void removeSearchTextFieldListener(SearchTextField2Listener l) {
        this.listeners.remove(l);
    }

    private void fireSelectionEvent() {
        for (SearchTextField2Listener l : this.listeners) {
            try {
                l.newValueSelected(this, this.node);
            }
            catch (ClientServerCallException e) {
                e.printStackTrace();
            }
        }
        if (this.ignoreEmptySearch && this.popUp != null) {
            this.popUp.hidePopUp(new Object[0]);
        }
    }

    @Override
    public boolean isInnerComponent(Component c) {
        if (c == this) {
            return true;
        }
        if (c == this.textField) {
            return true;
        }
        if (this.popUp != null) {
            if (c == this.popUp) {
                return true;
            }
            if (this.popUp.isInnerComponent(c)) {
                return true;
            }
        }
        return false;
    }

    public void clearValues() {
        if (this.possibleValues == null) {
            return;
        }
        this.possibleValues.removeAllChilds();
    }

    public void remoteObjectLoaded(Node<?> node) {
        List l;
        IDTO selectedValue;
        if (this.keepCurrentValue && (selectedValue = (IDTO)this.getNode().getValue()) != null) {
            SearchResult s;
            if (node.getValue() instanceof SearchResult && !(s = (SearchResult)node.getValue()).getResults().contains(selectedValue)) {
                s.getResults().add(0, selectedValue);
            }
            if (node.getValue() instanceof List && !(l = (List)node.getValue()).contains(selectedValue)) {
                l.add(0, selectedValue);
            }
        }
        if (this.isTrySelectOne) {
            List poses;
            if (node.getValue() instanceof SearchResult && (poses = ((SearchResult)node.getValue()).getResults()).size() >= 1) {
                l = (IDTO)poses.get(0);
                if (this.isProxy) {
                    this.getNode().setValue((Object)l, System.currentTimeMillis());
                } else {
                    Node nStorePos = INodeCreator.getDefaultImpl().getNode4DTO((Object)l, false, false);
                    this.setNode(nStorePos);
                }
                this.fireSelectionEvent();
            }
            this.stopAnimation();
            if (!this.ignoreEmptySearch) {
                this.isTrySelectOne = false;
            }
        } else {
            List ret;
            if (this.possibleValues == null) {
                this.possibleValues = new ListNode();
            }
            if (node.getValue() instanceof List) {
                ret = (List)node.getValue();
                ret.removeAll(this.ignoreValues);
                this.searchAlgorithm.mergeValues(this.possibleValues, ret);
            } else {
                ret = node.getValue() != null ? ((SearchResult)node.getValue()).getResults() : new ArrayList();
                ret.removeAll(this.ignoreValues);
                this.searchAlgorithm.mergeValues(this.possibleValues, ret);
                if (this.popUp == null) {
                    List poses;
                    List list = poses = node.getValue() != null ? ((SearchResult)node.getValue()).getResults() : new ArrayList();
                    if (poses.size() >= 1) {
                        IDTO l2 = (IDTO)poses.get(0);
                        if (this.isProxy) {
                            this.getNode().setValue((Object)l2, System.currentTimeMillis());
                        } else {
                            Node nStorePos = INodeCreator.getDefaultImpl().getNode4DTO((Object)l2, false, this.node instanceof ProxyNode);
                            this.setNode(nStorePos);
                        }
                        if (!this.isKilled()) {
                            this.fireSelectionEvent();
                        }
                    }
                }
            }
            if (this.nextPattern != null) {
                this.sendSearch(this.nextPattern);
                this.nextPattern = null;
            } else {
                this.stopAnimation();
            }
        }
    }

    public void errorOccurred(ClientException exception) {
        this.stopAnimation();
        InnerPopupFactory.showErrorDialog((Exception)((Object)exception), (Component)this);
    }

    protected void filterValueChanged(String t) {
        if (this.popUp == null) {
            if (this.textField.hasFocus() && t.length() >= 0) {
                this.openPopUp();
            } else if (t.length() >= 0) {
                int i = t.indexOf("-");
                if (i != -1) {
                    String tt = t.substring(0, i - 1);
                    this.sendSearch(tt);
                } else {
                    i = t.indexOf("(");
                    if (i != -1) {
                        String tt = t.substring(0, i).trim();
                        this.sendSearch(tt);
                    } else {
                        this.sendSearch(t);
                    }
                }
            }
        }
        if (this.popUp != null && this.searchAlgorithm != null) {
            if (this.isSearchActiv) {
                if (this.ignoreEmptySearch && StringUtil.isBlank((String)t)) {
                    return;
                }
                this.nextPattern = t;
            } else {
                this.startAnimation();
                this.sendSearch(t);
            }
        }
    }

    private void startAnimation() {
        if (!this.isSearchActiv) {
            this.isSearchActiv = true;
            if (this.loaderAnimation == null) {
                this.loaderAnimation = new AsynchronLoaderAnimation();
                this.loaderAnimation.getFader().setPermanent(true);
                this.isSearchActiv = true;
                this.loaderAnimation.setProgress(0.0f);
                this.add((Component)this.loaderAnimation, 0);
            }
            this.loaderAnimation.startAnimation();
        }
    }

    public void createEvents() {
        this.fireSelectionEvent();
    }

    public void setUseProxy(boolean isProxy) {
        this.isProxy = isProxy;
    }

    public void tryToSelectOne(boolean isProxy) {
        this.isTrySelectOne = true;
        this.setUseProxy(isProxy);
        this.sendSearch("");
    }

    private void stopAnimation() {
        if (this.isSearchActiv) {
            if (this.loaderAnimation != null) {
                this.loaderAnimation.stopAnimation();
            }
            this.isSearchActiv = false;
        }
    }

    private void sendSearch(final String t) {
        if (this.ignoreEmptySearch && StringUtil.isBlank((String)t)) {
            return;
        }
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ViewNode n;
                try {
                    ASearchConfiguration searchParameters;
                    String tt = t;
                    if (tt.trim().equals("\"")) {
                        tt = "";
                    }
                    n = (searchParameters = SearchTextField2.this.searchAlgorithm.getSearchParameters(tt, SearchTextField2.this.additionalSearchFields)) != null ? SearchTextField2.this.searchAlgorithm.search(searchParameters) : SearchTextField2.this.searchAlgorithm.search(null);
                    SearchResult search = (SearchResult)n.getValue();
                    if (SearchTextField2.this.filter != null) {
                        TransactionType type = SearchTextField2.this.filter.getType();
                        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                        UserComplete currentUser = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
                        if (settings != null && currentUser != null) {
                            Iterator iterator = search.getResults().iterator();
                            while (iterator.hasNext()) {
                                StoreLight store;
                                Object o = iterator.next();
                                if (!(o instanceof StoreLight) || StoreToolkit.isAllowed((StoreLight)(store = (StoreLight)o), (TransactionType)type, (UserComplete)currentUser, (SystemSettingsComplete)settings)) continue;
                                iterator.remove();
                            }
                        }
                    }
                }
                catch (SearchException e) {
                    n = new ViewNode("");
                    ArrayList<ScreenValidationObject> l = new ArrayList<ScreenValidationObject>();
                    l.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, e.getEmbeddedException().getMessage()));
                    n.setValue(l, 0L);
                }
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return SearchTextField2.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.filterValueChanged(this.textField.getText());
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.filterValueChanged(this.textField.getText());
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.filterValueChanged(this.textField.getText());
    }

    public void setAutoCompletion(boolean isActiv) {
        if (this.isAutoCompletion != isActiv) {
            if (!this.isAutoCompletion && isActiv) {
                this.textField.addKeyListener(this);
                this.textField.getDocument().addDocumentListener(this);
            } else if (this.isAutoCompletion && !isActiv) {
                this.textField.removeKeyListener(this);
                this.textField.getDocument().removeDocumentListener(this);
            }
            this.isAutoCompletion = isActiv;
        }
    }

    public void setNode(Node n) {
        if (this.node != null) {
            this.node.removeNodeListener((NodeListener)this);
        }
        this.node = n;
        if (this.node != null) {
            this.setUseProxy(this.node instanceof ProxyNode);
            this.node.addNodeListener((NodeListener)this);
            this.valueChanged(this.node);
        }
    }

    public Node<T> getNode() {
        return this.node;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 38) {
            if (this.popUp != null) {
                ((DefaultListViewPopupInsert)this.popUp.getView()).selectUpperItem();
                e.consume();
            } else {
                this.filterValueChanged(this.getText());
            }
        } else if (e.getKeyCode() == 40) {
            if (this.popUp != null) {
                ((DefaultListViewPopupInsert)this.popUp.getView()).selectLowerItem();
                e.consume();
            } else {
                this.filterValueChanged(this.getText());
            }
        } else if (e.getKeyCode() == 10 && this.popUp != null) {
            ((DefaultListViewPopupInsert)this.popUp.getView()).createSelectionEvent();
            e.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.searchAlgorithm != null) {
            this.searchAlgorithm.setNotMergeDTOs(null);
        }
        this.remove(this.textField);
        this.textField.removeMouseListener(this);
        this.textField.removeFocusListener(this);
        this.textField.getDocument().removeDocumentListener(this);
        this.textField = null;
        if (this.node != null) {
            this.node.removeNodeListener((NodeListener)this);
            this.node.removeNodeListenerRecursively((NodeListener)this);
        }
        if (this.possibleValues != null) {
            this.possibleValues.removeNodeListener((NodeListener)this);
            this.possibleValues.kill();
        }
        this.skin = null;
        this.removeMouseListener(this);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.textField.setEnabled(isEnabled);
        if (!isEnabled) {
            this.setState(Button.ButtonState.DISABLED);
        } else {
            this.setState(Button.ButtonState.UP);
        }
        if (this.deleteSearchButton != null) {
            this.deleteSearchButton.setEnabled(isEnabled);
        }
        this.repaint(32L);
    }

    public String getDefaultText() {
        return this.defaultText;
    }

    public void setDefaultText(String defaultText) {
        this.defaultText = defaultText;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void setID(String id) {
        this.id = id;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        this.skin.paint(g2, 0, 0, this.getWidth(), this.paintState);
        this.paintChildren(g2);
    }

    @Override
    public void setSize(int w, int h) {
        super.setSize(w, this.skin.getImageLeft(Button.ButtonState.DISABLED).getHeight());
    }

    private void deletedItemSelected(ActivationAdapter.ActivationType type) {
        switch (type) {
            case DEACTIVATED: 
            case CAN_NOT_CREATE_TRANSACTION: {
                this.textField.setDisabledTextColor(this.deactivatedForeground);
                this.textField.setForeground(this.deactivatedForeground);
                this.setSelectedTextColor(this.deactivatedForeground);
                this.setSelectionColor(this.selectedTextNotOkBackground);
                break;
            }
            case FATAL: {
                this.textField.setDisabledTextColor(this.deletedForeground);
                this.textField.setForeground(this.deletedForeground);
                this.setSelectedTextColor(this.deletedForeground);
                this.setSelectionColor(this.selectedTextNotOkBackground);
                break;
            }
            case OK: {
                this.textField.setDisabledTextColor(this.deactivatedForeground);
                this.textField.setForeground(this.okForeground);
                this.setSelectedTextColor(this.selectedTextOkForeground);
                this.setSelectionColor(this.selectedTextOkBackground);
                break;
            }
            case ALLERGEN_WARNING: {
                this.textField.setDisabledTextColor(this.warningForeground);
                this.textField.setForeground(this.warningForeground);
                this.setSelectedTextColor(this.warningForeground);
                this.setSelectionColor(this.selectedTextNotOkBackground);
                break;
            }
            case STATE_WARNING: {
                this.textField.setDisabledTextColor(this.stateWarningForeground);
                this.textField.setForeground(this.stateWarningForeground);
                this.setSelectedTextColor(this.stateWarningForeground);
                this.setSelectionColor(this.selectedTextNotOkBackground);
                break;
            }
            case HALAL_WARNING: {
                this.textField.setDisabledTextColor(this.halalWarningForeground);
                this.textField.setForeground(this.halalWarningForeground);
                this.setSelectedTextColor(this.halalWarningForeground);
                this.setSelectionColor(this.selectedTextNotOkBackground);
                break;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
        if (this.popUp == null) return;
        this.popUp = null;
        if (xargs != null && xargs.length > 0) {
            Node n = (Node)xargs[0];
            if (n == null || this.node == null) return;
            boolean isInvoke = false;
            if (this.node instanceof ProxyNode) {
                this.node.removeExistingValues();
                ProxyNode pln = (ProxyNode)this.node;
                if (pln.getRefNode() != n) {
                    this.node.setValue(n.getValue(), System.currentTimeMillis());
                    isInvoke = true;
                }
            } else if (!(this.node != n || this.node.getValue() != null && n.getValue() != null && ((IDTO)this.node.getValue()).equals(n.getValue()))) {
                this.node.removeExistingValues();
                long id = System.currentTimeMillis();
                this.node.setValue(n.getValue(), id);
                this.node.updateNode();
                isInvoke = true;
            } else if (n != this.node && this.node.getValue() != null && n.getValue() != null && ((IDTO)this.node.getValue()).equals(n.getValue())) {
                this.node.removeExistingValues();
                long id = System.currentTimeMillis();
                this.node.setValue(n.getValue(), id);
                this.node.updateNode();
                isInvoke = true;
            } else {
                this.node.removeExistingValues();
                long id = System.currentTimeMillis();
                this.node.setValue(n.getValue(), id);
                this.node.updateNode();
                isInvoke = true;
                this.node.commit();
            }
            if (isInvoke) {
                if (this.node.getListenerCount() == 0) {
                    this.node.addNodeListener((NodeListener)this);
                    this.valueChanged(this.node);
                }
                this.fireSelectionEvent();
            } else {
                this.resetText(this.node);
            }
            if (!this.isWithALL) return;
        }
        if (this.textField == null) return;
        if (this.node != null && this.node.getValue() == null) {
            this.textField.getDocument().removeDocumentListener(this);
            this.setText("");
            this.textField.getDocument().addDocumentListener(this);
            return;
        } else {
            this.resetText(this.node);
        }
    }

    @Override
    public void lafAttributeChanged(String att) {
        this.okForeground = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("combobox.popup.foreground.ok.color"));
        this.deactivatedForeground = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_disabled_color"));
        this.warningForeground = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("combobox.popup.foreground.warning.color"));
        this.stateWarningForeground = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_state_waring_string_color"));
        this.halalWarningForeground = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_halal_waring_string_color"));
        this.deletedForeground = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("combobox.popup.foreground.fatal.color"));
        this.selectedTextOkForeground = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("combobox.popup.foreground.selected.ok.color"));
        this.selectedTextNotOkBackground = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("combobox.popup.background.selected.notok.color"));
        this.selectedTextOkBackground = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("combobox.popup.background.selected.ok.color"));
        this.textField.setDisabledTextColor(this.deactivatedForeground);
        this.setForeground(this.okForeground);
        this.setSelectedTextColor(this.selectedTextOkForeground);
        this.setSelectionColor(this.selectedTextOkBackground);
        this.setCaretColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_searchTextField_caret_color")));
        this.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_searchTextField_font_size"), LafLoader.getLafLoader().getAttribute("default_searchTextField_font_type")));
    }

    @Override
    public void setForeground(Color fg) {
        if (this.textField != null) {
            this.textField.setForeground(fg);
        }
    }

    @Override
    public void setBackground(Color bg) {
        if (this.textField != null) {
            this.textField.setBackground(bg);
        }
    }

    private void setText(String text) {
        this.textField.removeFocusListener(this);
        this.textField.setText(text);
        this.textField.addFocusListener(this);
    }

    public String getText() {
        return this.textField.getText();
    }

    @Override
    public void setFont(Font font) {
        if (this.textField != null) {
            this.textField.setFont(font);
        }
    }

    public void setCaretColor(Color cc) {
        this.textField.setCaretColor(cc);
    }

    public void setSelectedTextColor(Color c) {
        this.textField.setSelectedTextColor(c);
    }

    public void setSelectionColor(Color c) {
        this.textField.setSelectionColor(c);
    }

    public void setSelectionStart(int selectionStart) {
        this.textField.setSelectionStart(selectionStart);
    }

    public void setSelectionEnd(int selectionEnd) {
        this.textField.setSelectionEnd(selectionEnd);
    }

    public void addDocumentListener(DocumentListener listener) {
        this.textField.getDocument().addDocumentListener(listener);
    }

    public void removeDocumentListener(DocumentListener listener) {
        this.textField.getDocument().removeDocumentListener(listener);
    }

    public Document getDocument() {
        return this.textField.getDocument();
    }

    public JTextField getTextField() {
        return this.textField;
    }

    protected void setState(Button.ButtonState state) {
        this.paintState = state;
        this.state = state;
        this.repaint(32L);
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.state != Button.ButtonState.DISABLED && this.state != Button.ButtonState.ERROR) {
            SelectionManager.getSelectionManager().focusGained(this);
            this.textField.setSelectionStart(0);
            this.textField.setSelectionEnd(this.textField.getText().length());
            this.setState(Button.ButtonState.FOCUS);
            if (!this.isDown && this.visibleContainer != null) {
                this.visibleContainer.scrollTo(this);
            }
        }
    }

    private void openPopUp() {
        if (this.popUp == null) {
            this.popUp = InnerPopUp2.getInnerPopUp(PopupType.SEARCHBOX);
        }
        if (this.possibleValues == null) {
            this.possibleValues = new ListNode();
        }
        DefaultListViewPopupInsert pp = new DefaultListViewPopupInsert(this.possibleValues, this.defaultEntryConverter, this);
        pp.setIgnoreSorting(true);
        pp.setWithALL(this.isWithALL);
        pp.setAlwaysSelected(true);
        pp.setActivationAdapter(this.defaultActivationAdapter);
        if (this.iconMapper != null) {
            pp.setIconMapper(IconMapperController.getIconMapper(this.iconMapper));
        }
        this.popUp.setView(pp);
        this.popUp.setAttributes(this, false, false, "");
        int dw = this.getWidth() - 30;
        if (dw < 200) {
            dw = 200;
        }
        Container top = this;
        while (top.getParent() != null) {
            top = top.getParent();
        }
        int aMaxWidth = 500;
        int aMinWidth = 300;
        Point t = SwingUtilities.convertPoint(this, new Point(this.skin.getImageLeft(this.state).getWidth() + 2, 2), top);
        int dx = -(this.skin.getImageLeft(this.state).getWidth() + 2);
        dw = (this.skin.getImageLeft(this.state).getWidth() + 2) * 2 + this.getWidth();
        if (t.getX() + (double)aMaxWidth < (double)top.getWidth()) {
            dw = aMaxWidth;
        } else {
            int d = (int)((double)top.getWidth() - (t.getX() + (double)aMaxWidth));
            if (t.getX() + (double)d > 0.0) {
                dx += d;
                dx -= 10;
                dw = aMaxWidth;
            } else {
                dw = aMinWidth;
            }
        }
        this.cachedTopParentPosition = new Point(dx, 2);
        this.popUp.setDoRequestFocus(false);
        this.popUp.showPopUp(dx, 2, dw, 200, this, this, PopupType.SEARCHBOX);
    }

    public int getCachedPopupOffset() {
        return this.cachedPopupOffset;
    }

    public Point getCachedTopParentPoint() {
        return this.cachedTopParentPosition;
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.state != Button.ButtonState.DISABLED) {
            int offset = this.textField.getScrollOffset();
            this.setState(Button.ButtonState.UP);
            if (this.popUp != null) {
                this.popUp.hidePopUp(new Object[0]);
            }
            this.textField.scrollRectToVisible(new Rectangle(-offset, 0, this.textField.getWidth(), this.textField.getHeight()));
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.state != Button.ButtonState.DISABLED && (Button.pressedItem == null || Button.pressedItem == this)) {
            if (this.state != Button.ButtonState.FOCUS && this.state != Button.ButtonState.ERROR) {
                this.setState(Button.ButtonState.OVER);
            }
            this.setCursor(new Cursor(2));
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.state != Button.ButtonState.DISABLED) {
            if (this.state != Button.ButtonState.FOCUS && this.state != Button.ButtonState.ERROR) {
                this.setState(Button.ButtonState.UP);
            }
            this.setCursor(new Cursor(0));
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.state != Button.ButtonState.DISABLED) {
            Button.pressedItem = this;
            this.isDown = true;
            if (e.getSource() == this) {
                this.textField.requestFocusInWindow();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.state != Button.ButtonState.DISABLED) {
            this.isDown = false;
            Button.pressedItem = null;
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        a.add(this.textField);
        return a;
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public boolean isItemSelected() {
        return this.node != null && this.node.getValue() != null;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        this.visibleContainer = pane;
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return this.selectableElement;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.deleteSearchButton && this.node != null) {
            this.node.setValue(null, System.currentTimeMillis());
            this.fireSelectionEvent();
            this.deleteSearchButton.fadeOut(false);
        }
    }

    @Override
    public void requestFocusInWindowNow() {
        this.textField.requestFocusInWindow();
    }

    public void requestFocusOnSearchField() {
        this.textField.requestFocusInWindow();
    }

    @Override
    public boolean shouldPersist() {
        return this.isPersistable;
    }

    @Override
    public void setShouldPersist(boolean isPersisting) {
        this.isPersistable = isPersisting;
    }

    @Override
    public void setInvalid() {
        this.setInValid();
    }

    @Override
    public void setWarning() {
    }

    public boolean isSwingOnly() {
        return true;
    }

    @Override
    public void setPermanent(boolean isPermantent) {
    }

    public List<T> getIgnoreValues() {
        return this.ignoreValues;
    }

    public void setIgnoreValues(List<T> ignoreValues) {
        this.ignoreValues = ignoreValues;
    }

    private class SearchTextFieldLayout
    extends DefaultLayout {
        private SearchTextFieldLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int tailing = 0;
            if (SearchTextField2.this.isSearchActiv) {
                SearchTextField2.this.loaderAnimation.setLocation((int)((double)SearchTextField2.this.getWidth() - (SearchTextField2.this.loaderAnimation.getPreferredSize().getWidth() + 3.0)), (int)(((double)parent.getHeight() - SearchTextField2.this.loaderAnimation.getPreferredSize().getHeight()) / 2.0));
                SearchTextField2.this.loaderAnimation.setSize(SearchTextField2.this.loaderAnimation.getPreferredSize());
                tailing = SearchTextField2.this.loaderAnimation.getWidth() + 5;
            } else if (SearchTextField2.this.deleteSearchButton != null && SearchTextField2.this.node != null && SearchTextField2.this.node.getValue() != null) {
                SearchTextField2.this.deleteSearchButton.setVisible(true);
                SearchTextField2.this.deleteSearchButton.setLocation((int)((double)SearchTextField2.this.getWidth() - (SearchTextField2.this.deleteSearchButton.getPreferredSize().getWidth() + 3.0)), (int)(((double)parent.getHeight() - SearchTextField2.this.deleteSearchButton.getPreferredSize().getHeight()) / 2.0));
                SearchTextField2.this.deleteSearchButton.setSize(SearchTextField2.this.deleteSearchButton.getPreferredSize());
                tailing = SearchTextField2.this.deleteSearchButton.getWidth();
            } else if (SearchTextField2.this.deleteSearchButton != null) {
                SearchTextField2.this.deleteSearchButton.setVisible(false);
            }
            SearchTextField2.this.textField.setLocation(SearchTextField2.this.skin.getImageLeft(Button.ButtonState.DISABLED).getWidth() + 2 + SearchTextField2.this.xOffset, 3);
            SearchTextField2.this.textField.setSize(parent.getWidth() - (SearchTextField2.this.skin.getImageLeft(Button.ButtonState.DISABLED).getWidth() + SearchTextField2.this.skin.getImageRight(Button.ButtonState.DISABLED).getWidth() + 2 + tailing - 15), SearchTextField2.this.skin.getImageMiddle(Button.ButtonState.DISABLED).getHeight() - 6);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            if (SearchTextField2.this.skin == null) {
                SearchTextField2.this.skin = (Skin3Field)DefaultSkins.SearchFieldTexture.createDynamicSkin();
            }
            return new Dimension(SearchTextField2.this.minWidth, SearchTextField2.this.skin.getImageLeft(Button.ButtonState.DISABLED).getHeight());
        }
    }
}

