/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tables;

import ch.icit.pegasus.client.converter.CabinClassConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.dataexchange.AutoReportingCabinClassToCBaseMappingComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.AutoReportingCabinClassToCBaseMappingComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ClassCbaseMappingEditTable
extends Table2 {
    private static final long serialVersionUID = 1L;

    public ClassCbaseMappingEditTable() {
        super(true, Words.ADD, true, true, Words.CLASS_CBASE);
        this.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                ClassCbaseMappingEditTable.this.revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                ClassCbaseMappingEditTable.this.getModel().getNode().addChild(ClassCbaseMappingEditTable.this.createNewNode(), 0L);
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.SOURCE, null, null, null, "", 40, 40, 40));
        columns.add(new TableColumnInfo(Words.TARGET, null, null, null, "", 40, 40, 40));
        int dw = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + this.getCellPadding() * 2;
        columns.add(new TableColumnInfo("", null, null, null, "", dw, dw, dw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
    }

    public Node createNewNode() {
        AutoReportingCabinClassToCBaseMappingComplete s = new AutoReportingCabinClassToCBaseMappingComplete();
        s.setClientOId(Long.valueOf(ADTO.getNextId()));
        return INodeCreator.getDefaultImpl().getNode4DTO((Object)s, true, false);
    }

    public Map<CabinClassComplete, String> createCabinClassMap() {
        Node nn = this.getModel().getNode();
        LinkedHashMap<CabinClassComplete, String> ret = new LinkedHashMap<CabinClassComplete, String>();
        Iterator it = nn.getFailSafeChildIterator();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            String target = (String)n.getChildNamed(new String[]{"target"}).getValue();
            CabinClassComplete source = (CabinClassComplete)n.getChildNamed(new String[]{"source"}).getValue();
            ret.put(source, target);
        }
        return ret;
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private ComboBox source;
        private TextField target;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.source = new ComboBox(m.getNode().getChildNamed(AutoReportingCabinClassToCBaseMappingComplete_.cabinClass), NodeToolkit.getAffixList(CabinClassComplete.class), ConverterRegistry.getConverter(CabinClassConverter.class), true, true);
            this.target = new TextField(m.getNode().getChildNamed(AutoReportingCabinClassToCBaseMappingComplete_.cbaseClassName));
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.setLayout(new Layout3());
            this.add(this.source);
            this.add(this.target);
            this.add(this.delete);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), 0L);
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.target.kill();
            this.delete.kill();
            this.source.kill();
            this.target = null;
            this.delete = null;
            this.source = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.source);
            CheckedListAdder.addToList(a, this.target);
            CheckedListAdder.addToList(a, this.delete);
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        private class Layout3
        extends DefaultLayout {
            private Layout3() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.source.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.source.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.source.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.source.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.target.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.target.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.target.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.target.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }
}

