/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tables;

import ch.icit.pegasus.client.converter.TaxRate2Converter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.product.TaxRateComplete;
import ch.icit.pegasus.server.core.dtos.product.TaxRateVariantComplete;
import ch.icit.pegasus.server.core.dtos.product.TaxRateVariantComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class TaxRateVariantTable
extends Table2 {
    private static final long serialVersionUID = 1L;

    public TaxRateVariantTable() {
        super(true, Words.ADD, true, true, Words.DEFAULT_RETAIL_TAX);
        this.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                TaxRateVariantTable.this.getParent().revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                TaxRateVariantComplete variantComplete = new TaxRateVariantComplete();
                variantComplete.setClientOId(Long.valueOf(ADTO.getNextId()));
                variantComplete.setValidityPeriod(new PeriodComplete());
                variantComplete.getValidityPeriod().setStartDate(new Date(System.currentTimeMillis()));
                variantComplete.getValidityPeriod().setEndDate(new Date(System.currentTimeMillis()));
                Node node = INodeCreator.getDefaultImpl().getNode4DTO((Object)variantComplete, false, false);
                TaxRateVariantTable.this.getModel().getNode().addChild(node, 0L);
                TaxRateVariantTable.this.getParent().revalidate();
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.TAX_RATE, null, null, null, "", 10, Integer.MAX_VALUE, 10));
        columns.add(new TableColumnInfo(Words.FROM, null, null, null, "", TableColumnInfo.dateColumnWidth * 2, TableColumnInfo.dateColumnWidth * 2, TableColumnInfo.dateColumnWidth * 2));
        columns.add(new TableColumnInfo(Words.TO, null, null, null, "", TableColumnInfo.dateColumnWidth * 2, TableColumnInfo.dateColumnWidth * 2, TableColumnInfo.dateColumnWidth * 2));
        int tw = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM) + 2 * this.getCellPadding();
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
    }

    public void setNode(Node<List<TaxRateVariantComplete>> node) {
        this.getModel().setNode(node);
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private ComboBox taxRateSelection;
        private DateChooser startDate;
        private DateChooser endDate;
        private DeleteButton deleteButton;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            this.taxRateSelection = new ComboBox(m.getNode().getChildNamed(TaxRateVariantComplete_.taxRate), NodeToolkit.getAffixList(TaxRateComplete.class), ConverterRegistry.getConverter(TaxRate2Converter.class));
            this.startDate = new DateChooser(m.getNode().getChildNamed(new DtoField[]{TaxRateVariantComplete_.validityPeriod, PeriodComplete_.startDate}));
            this.endDate = new DateChooser(m.getNode().getChildNamed(new DtoField[]{TaxRateVariantComplete_.validityPeriod, PeriodComplete_.endDate}));
            this.deleteButton = new DeleteButton();
            this.deleteButton.addButtonListener(this);
            this.setLayout(new Layout());
            this.add(this.taxRateSelection);
            this.add(this.startDate);
            this.add(this.endDate);
            this.add(this.deleteButton);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.taxRateSelection.kill();
            this.startDate.kill();
            this.endDate.kill();
            this.deleteButton.kill();
            this.taxRateSelection = null;
            this.startDate = null;
            this.endDate = null;
            this.deleteButton = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusComponent = new ArrayList<Component>();
            CheckedListAdder.addToList(focusComponent, this.taxRateSelection);
            CheckedListAdder.addToList(focusComponent, this.startDate);
            CheckedListAdder.addToList(focusComponent, this.endDate);
            CheckedListAdder.addToList(focusComponent, this.deleteButton);
            return focusComponent;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.taxRateSelection.setEnabled(isEnabled);
            this.startDate.setEnabled(isEnabled);
            this.endDate.setEnabled(isEnabled);
            this.deleteButton.setEnabled(isEnabled);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.deleteButton) {
                TaxRateVariantTable.this.getModel().getNode().removeChild(this.model.getNode(), 0L);
            }
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.taxRateSelection.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.taxRateSelection.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.taxRateSelection.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.taxRateSelection.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.startDate.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.startDate.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.startDate.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.startDate.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.endDate.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.endDate.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.endDate.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.endDate.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.deleteButton.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.deleteButton.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.deleteButton.setSize(TableRowImpl.this.deleteButton.getPreferredSize());
            }
        }
    }
}

